package ai_util;

// import java.util.*;
import java.text.*;

//import arimaa3.MaterialInconsistencyException;

public class Util {

	// Returns a nicely formatted string showing hash hit stats
	public static String ProbStats(String description, long total_probes,
			long total_hits) {
		String result = "";

		// Description of type of move
		result += Util.LeftJustify(10, description);

		String percent_any_cuts = " XX.XX";
		if (total_probes != 0) {
			double percent = ((double) total_hits) * 100
					/ ((double) total_probes);
			percent_any_cuts = Util.format("#00.00", percent);
			percent_any_cuts = Util.RightJustify(6, percent_any_cuts);
		}

		result += percent_any_cuts + " ";
		result += Util.Pad(10, total_hits);
		result += Util.Pad(10, total_probes);

		result += "\n";

		return result;
	}

	private static final int hiBitSetTab[] = { 0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4,
			4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8 };

	private static final long hashBit = 0x043151c966d3d77eL;
	private static final long hashMask = 0x3F;
	//0b0000|0100|0011|0001|0101|0001|1100|1001|0110|0110|1101|0011|1101|0111|0111|1110|00000
	//  0123|4567|89ab|cdef|0123|4567|89ab|cdef|0123|4567|89ab|cdef|0123|4567|89ab|cdef|01234
	private static byte bit2hashInd(long one_bb) {
		return (byte) (((hashBit*one_bb)>>58) & hashMask);
	}
	
	private static final int hashInd2Ind[]=new int[64];
	static {
		for (int i=0;i<64;i++) {
			//System.out.println(bit2hashInd(1L<<i));
			hashInd2Ind[bit2hashInd(1L<<i)]=i;
		}
	}
	
	public static int bit2ind(long one_bb) {
		// if one_bb contains more than one bit, returned index points to either 1 or 0 ;)
		// if one_bb contains one bit returned index points to this bit
		// if one_bb contains 0 returned index is 63
		return Long.numberOfTrailingZeros(one_bb);
		//return hashInd2Ind[bit2hashInd(one_bb)];
	}
	
	public static int ind2trap(int trap_ind) {
		return (trap_ind>>2)&3;
	}

	//public static int bit2ind(long one_bb) {
	// return PopCnt(one_bb-1);
	// this should be used on hardware with PopCnt instruction!
	//}
	
	public static void bitSum(long l1, long l2, long l3, long l4, long[] counts) {
		long l1o2, l3o4, l1a2, l3a4;
		assert (counts.length == 5);
		counts[0] = 0xffffffff; // constant
		counts[1] = (l1o2 = l1 | l2) | (l3o4 = l3 | l4);
		counts[4] = (l1a2 = l1 & l2) & (l3a4 = l3 & l4);
		counts[2] = (l1a2 | l3a4) | (l1o2 & l3o4);
		counts[3] = (l1o2 & l3a4) | (l1a2 & l3o4);
	}

	// returns most significant set bit
	// if all zero returns -1
	public static int FirstOne(long val) {

		// Check the high32 bits
		int tmp = (int) (val >> 32);
		if (tmp != 0) {
			return FirstOne(tmp) + 32;
		}

		// Check the low 32 bits
		return FirstOne((int) (val & 0xffffffff));
	}

	// returns most significant set bit
	// if all zero returns -1
	public static int FirstOne(int val) {
		int tmp;

		tmp = (val >> 24) & 0xff;
		if (tmp != 0) {
			return hiBitSetTab[tmp] + 23;
		}

		tmp = (val >> 16) & 0xff;
		if (tmp != 0) {
			return hiBitSetTab[tmp] + 15;
		}

		tmp = (val >> 8) & 0xff;
		if (tmp != 0) {
			return hiBitSetTab[tmp] + 7;
		}

		return hiBitSetTab[val & 0xff] - 1;
	}

	public static int LowPopCnt(long val) {
		return Long.bitCount(val);
	}
	// Population count for cases the population is known to be low
	//public static int LowPopCnt(long val) {
	//	int count = 0;
    // 
	//	while (val != 0) {
	//		count++;
	//		val &= val - 1;
	//	}
    //
	//	return (count);
	//}

	public static int PopCnt(long val) {
		return Long.bitCount(val);
	}
	// Population count
	//public static int PopCnt(long val) {
	//	val -= (0xaaaaaaaaaaaaaaaaL & val) >>> 1;
	//	val = (val & 0x3333333333333333L) + ((val >>> 2) & 0x3333333333333333L);
	//	val = (val + (val >>> 4)) & 0x0f0f0f0f0f0f0f0fL; // max
	//														// 0x0808080808080808
	//	val += val >>> 8; // & 0x00ff00ff00ff00ff 0x0dff0dff0dff0dff max
	//						// 0x0810081008100810
	//	val += val >>> 16; // & 0x0000ffff0000ffff 0x0dddfdff0dddfdff max
	//						// 0x0810102010201020
	//	val += val >>> 32; // & 0x00000000ffffffff 0x0dddfdff0dddfdff max
	//						// 0x0dddfd200dddf040
	//	return (int) (val & 0xffL);
	//}

	// Population count
	//public static int PopCnt(int val) {
	//	val -= (0xaaaaaaaa & val) >>> 1;
	//	val = (val & 0x33333333) + ((val >>> 2) & 0x33333333);
	//	val = (val + (val >>> 4)) & 0x0f0f0f0f;
	//	val += val >>> 8;
	//	val += val >>> 16;
	//	return val & 0xff;
	//}

	public static long LastBit(long val) {
		return val & (-val);
	}

	public static int LastBit(int val) {
		return val & (-val);
	}
	
	// Converts time to a nicely formatted text string
	public static String toTimeString(long time_in_milliseconds) {

		String result = "";

		// Handle negative(?) length of time
		if (time_in_milliseconds < 0) {
			result += "-";
			time_in_milliseconds = -time_in_milliseconds;
		}

		long hours = time_in_milliseconds / 1000 / 60 / 60;
		long minutes = time_in_milliseconds / 1000 / 60 % 60;
		long seconds = time_in_milliseconds / 1000 % 60;
		long centiseconds = time_in_milliseconds / 10 % 100;

		if (hours > 0)
			result += Util.format("00", hours) + ":"
					+ Util.format("00", minutes) + ":"
					+ Util.format("00", seconds);
		else
			result += Util.format("00", minutes) + ":"
					+ Util.format("00", seconds) + "."
					+ Util.format("00", centiseconds);

		return result;
	}

	public static String format(String format_string, double number) {
		DecimalFormat df = new DecimalFormat(format_string);
		String result = df.format(number);
		return result;
	}

	public static String format(String format_string, long number) {
		DecimalFormat df = new DecimalFormat(format_string);
		String result = df.format(number);
		return result;
	}

	// right justifies a number in a fixed width field
	public static String Pad(int width, long value) {
		String temp = (new Long(value)).toString();

		String result = "";
		for (int i = temp.length(); i < width; i++)
			result += " ";

		result += temp;

		return result;
	}

	// Left justifies a text string in a fixed width field
	// String is truncated to fit in field
	public static String LeftJustify(int width, String text) {
		String result = text;
		for (int i = text.length(); i < width; i++)
			result += " ";
		result = result.substring(0, width);
		return result;
	}

	// Right justifies a text string in a fixed width field
	// String is truncated to fit in field
	public static String RightJustify(int width, String text) {
		String result = "";
		for (int i = text.length(); i < width; i++)
			result += " ";
		result += text;
		result = result.substring(0, width);
		return result;
	}

	/**
	 * Lists all the subsets of the given set!!!!!!
	 * 
	 * @param d
	 *            long
	 */
	public static void enumsets(long d) {
		long n = 0;
		do {
			System.out.println(n);
			n = (n - d) & d;
		} while (n != 0);
	}

	public static long mirrorBB(long bb) {
		bb = (bb<<0x20 & 0xFFFFFFFF00000000L)|(bb>>0x20 & 0x00000000FFFFFFFFL);
		bb = (bb<<0x10 & 0xFFFF0000FFFF0000L)|(bb>>0x10 & 0x0000FFFF0000FFFFL);
		bb = (bb<<0x08 & 0xFF00FF00FF00FF00L)|(bb>>0x08 & 0x00FF00FF00FF00FFL);
		return bb;
	}
	
	public static long rotationBB(long bb) {
		bb = mirrorBB(bb);
		bb = (bb<<0x04 & 0xF0F0F0F0F0F0F0F0L)|(bb>>0x04 & 0x0F0F0F0F0F0F0F0FL);
		bb = (bb<<0x02 & 0xCCCCCCCCCCCCCCCCL)|(bb>>0x02 & 0x3333333333333333L);
		bb = (bb<<0x01 & 0xAAAAAAAAAAAAAAAAL)|(bb>>0x01 & 0x5555555555555555L);
		return bb;
	}

	public static void main(String args[]) {
		long starttime=System.currentTimeMillis();long sum=0;
		for(int i=100000000;i<200000000;i++) {
			sum+=Long.bitCount(i);
		}
		long firsttime=System.currentTimeMillis();
		System.out.println("After "+(firsttime-starttime)+"ms obtained "+sum);
		sum=0;
		for(int i=100000000;i<200000000;i++) {
			sum+=PopCnt((long) i);
		}
		long secondtime=System.currentTimeMillis();
		System.out.println("After "+(secondtime-firsttime)+"ms obtained "+sum);
		sum=0;
		for(int i=100000000;i<200000000;i++) {
			sum+=LowPopCnt((long) i);
		}
		long thirdtime=System.currentTimeMillis();
		System.out.println("After "+(thirdtime-secondtime)+"ms obtained "+sum);
		sum=0;
		for(int j=0;j<100000000;j++) {
			for(int i=0;i<64;i++) {
				sum+=bit2ind(1L<<i);
			}
		}
		long fourthtime=System.currentTimeMillis();
		System.out.println("After "+(fourthtime-thirdtime)+"ms obtained "+sum);
		sum=0;
		for(int j=0;j<100000000;j++) {
			for(int i=0;i<64;i++) {
				sum+=Long.bitCount((1L<<i)-1);
			}
		}
		long fifthtime=System.currentTimeMillis();
		System.out.println("After "+(fifthtime-fourthtime)+"ms obtained "+sum);
		sum=0;
		for(int j=0;j<100000000;j++) {
			for(int i=0;i<64;i++) {
				sum+=Long.numberOfTrailingZeros(1L<<i);
			}
		}
		long sixthtime=System.currentTimeMillis();
		System.out.println("After "+(sixthtime-fifthtime)+"ms obtained "+sum);
		sum=0;
		for(int j=0;j<1000000;j++) {
			for(int k=0;k<64;k++) {
				for(int i=0;i<64;i++) {
					sum+=Long.bitCount((1L<<i)+(1L<<k));
				}
			}
		}
		long seventhtime=System.currentTimeMillis();
		System.out.println("After "+(seventhtime-sixthtime)+"ms obtained "+sum);
		sum=0;
		for(int j=0;j<1000000;j++) {
			for(int k=0;k<64;k++) {
				for(int i=0;i<64;i++) {
					sum+=LowPopCnt((1L<<i)+(1L<<k));
				}
			}
		}		//enumsets(0x131);
		long eighttime=System.currentTimeMillis();
		System.out.println("After "+(eighttime-seventhtime)+"ms obtained "+sum);
		//enumsets(0x131);
	}
}
