package arimaa3;

import java.util.Random;

import ai_util.Util;

/**
 * Utility functions that all arimaa classes can use
 */
public class ArimaaBaseClass implements Constants {
	protected ArimaaBaseClass() {
	}

	/**
	 * Returns set of all squares touching target squares
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static Random random = new Random(19730318);
	
	public static long touching_bb(long target) {
		return ((target & NOT_FILE_H) << 1) | ((target & NOT_FILE_A) >>> 1)
				| (target << 8) | (target >>> 8);
	}

	/**
	 * Returns set of all squares touching target squares
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static long touching_wne_bb(long target) {
		return ((target & NOT_FILE_H) << 1) | ((target & NOT_FILE_A) >>> 1)
				| (target << 8);
	}

	/**
	 * Returns set of all squares touching target squares
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static long touching_esw_bb(long target) {
		return ((target & NOT_FILE_H) << 1) | ((target & NOT_FILE_A) >>> 1)
				| (target >>> 8);
	}

	/**
	 * Returns set of all squares piece can potentially step to
	 * 
	 * @param target
	 *            long
	 * @param piece_type
	 *            int 0,1 rabbits, others are nonrabbits :)
	 * @return long
	 */
	public static long can_step_bb(long target, int piece_type) {
		long result = ((target & NOT_FILE_H) << 1)
				| ((target & NOT_FILE_A) >>> 1);
		result |= (piece_type == 0) ? 0 : (target >>> 8); // White rabbits can't
															// go south
		result |= (piece_type == 1) ? 0 : (target << 8); // Black rabbits can't
															// go north
		return result;
	}

	/**
	 * east_bb() Returns target bb shifted right one file
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static long right_bb(long target) {
		return (target & NOT_FILE_H) << 1;
	}

	/**
	 * west_bb() Returns target bb shifted left one file
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static long left_bb(long target) {
		return (target & NOT_FILE_A) >>> 1;

	}

	/**
	 * north_bb() Returns target bb shifted up one rank
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static long up_bb(long target) {
		return target << 8;
	}

	/**
	 * south_bb() Returns target bb shifted down one rank
	 * 
	 * @param target
	 *            long
	 * @return long
	 */
	public static long down_bb(long target) {
		return target >>> 8;
	}

	public static void neighbourSum(long bb, long [] counts) {
		Util.bitSum(left_bb(bb),up_bb(bb),right_bb(bb),down_bb(bb),counts);
	}	

	public static void print_bitboard(long value) {
		// display board
		System.out.println(bitboard(value));
	}

	public static String bitboard(long value) {
		String result="";
		result += "\n +-----------------+\n";
		for (int row = 7; row >= 0; row--) {
			result += (row + 1) + "|";

			for (int col = 0; col <= 7; col++) {
				int board_index = row * 8 + col;
				boolean is_set = (value & (1L << board_index)) == (1L << board_index);
				String piece_text = is_set ? "1" : "0";
				result += " " + piece_text;
			}
			result += " |\n";

		}
		result += " +-----------------+\n";
		result += "   a b c d e f g h\n";
		return result;
	}
	/**
	 * Returns a bitboard as a nicely formatted string
	 * 
	 * @param value
	 *            long
	 * @param text
	 *            String
	 * @return String
	 */
	public static void print_bitboard(long value, String text) {
		// display title and board
		System.out.println(text + bitboard(value));
	}

	public static boolean atMostTwoBitsSet(long test_bb) {
		return atMostOneBitSet(test_bb & (test_bb - 1));
	}

	/**
	 * Returns true iff exactly zero or one bits are set
	 * 
	 * @param test_bb
	 *            long
	 * @return boolean
	 */

	public static boolean atMostOneBitSet(long test_bb) {
		return ((test_bb & (test_bb - 1)) == 0);
	}

	public static boolean moreThanOneBitSet(long test_bb) {
		return !((test_bb & (test_bb - 1)) == 0);
	}

	/**
	 * Returns true iff exactly one bit is set
	 * 
	 * @param test_bb
	 *            long
	 * @return boolean
	 */
	public static boolean exactlyOneBitSet(long test_bb) {
		return (((test_bb & (test_bb - 1)) == 0) && (test_bb != 0));
	}

	// Test out some stuff
	public static void main(String args[]) {
		for (int i = -10; i <= 10; i++) {
			System.out.println(i + " " + atMostOneBitSet(i) + " "
					+ exactlyOneBitSet(i));
		}

		long test_bb = FULL_BB;
		print_bitboard(test_bb, "Start (FULL_BB)");
		print_bitboard(left_bb(test_bb), "Left");
		print_bitboard(right_bb(test_bb), "Right");
		print_bitboard(up_bb(test_bb), "Up");
		print_bitboard(down_bb(test_bb), "Down");
		print_bitboard(touching_bb(test_bb), "Touching");
		print_bitboard(touching_esw_bb(test_bb), "Touching_esw");
		print_bitboard(touching_wne_bb(test_bb), "Touching_wne");
		test_bb = TRAP_SQUARES;
		print_bitboard(test_bb, "Start (TRAP_SQUARES)");
		print_bitboard(left_bb(test_bb), "Left");
		print_bitboard(right_bb(test_bb), "Right");
		print_bitboard(up_bb(test_bb), "Up");
		print_bitboard(down_bb(test_bb), "Down");
		print_bitboard(touching_bb(test_bb), "Touching");
		print_bitboard(touching_esw_bb(test_bb), "Touching_esw");
		print_bitboard(touching_wne_bb(test_bb), "Touching_wne");
		int sum=0;long t0=System.currentTimeMillis();
		for (int i=0;i<1000000;i++) {
			for(int j=0;j<64;j++) {
				if (atMostOneBitSet(1L<<j)) {
					sum++;
				}
			}
		}
		long t1=System.currentTimeMillis();
		System.out.println("After "+(t1-t0)+"ms obtained "+sum);
		sum=0;
		for (int i=0;i<1000000;i++) {
			for(int j=0;j<64;j++) {
				if (Long.bitCount(1L<<j)<=1) {
					sum++;
				}
			}
		}		
		long t2=System.currentTimeMillis();
		System.out.println("After "+(t2-t1)+"ms obtained "+sum);
		sum=0;
		for (int i=0;i<1000000;i++) {
			for(int j=0;j<64;j++) {
				if (exactlyOneBitSet(1L<<j)) {
					sum++;
				}
			}
		}
		long t3=System.currentTimeMillis();
		System.out.println("After "+(t3-t2)+"ms obtained "+sum);
		sum=0;
		for (int i=0;i<1000000;i++) {
			for(int j=0;j<64;j++) {
				if (Long.bitCount(1L<<j)==1) {
					sum++;
				}
			}
		}		
		long t4=System.currentTimeMillis();
		System.out.println("After "+(t4-t3)+"ms obtained "+sum);
	}
}
