package arimaa3;

import ai_util.*;

public class ArimaaClockManager {

	// This function manages the time useage
	public ArimaaClockManager() {
	}

	/**
	 * Calculate time control for the search
	 * 
	 * @param info
	 *            ArimaaServerInfo
	 * @return SearchTimes
	 */
	public SearchTimes calculate(ArimaaServerInfo info) {

		SearchTimes result = new SearchTimes();

		// Log some info for debugging purposes
		LogFile.message("tc_move: " + info.tc_move);
		LogFile.message("tc_player_reserve: " + info.tc_reserve[info.side_to_move]);
		LogFile.message("tc_max_turn_time: " + info.tc_max_turn_time);
		LogFile.message("tc_max_reserve: " + info.tc_max_reserve);

		int internet_lag = 5;
		
		int move_time = info.tc_move - internet_lag;

		// Determine game pace ie. sec/move
		float game_moves_remaining = 8;
		float pace = move_time + ((float) info.tc_reserve[info.side_to_move])
				/ game_moves_remaining;

		// Calculate base search time
		float base_time = .49f * pace;

		if (info.tc_percent > 0) {
			// limited banking
			float reserve_build_time = (100 / info.tc_percent)
					* (info.tc_max_reserve - info.tc_reserve[info.side_to_move]);

			// If the reserve would be full, bank only to full reserve
			base_time = Math.max(base_time, move_time - reserve_build_time + internet_lag);
		} else {
			// for no reserve building games for small time per move,
			if (info.enemy_name.startsWith("bot_"))
				base_time = Math.max(base_time, 1);
			else
				base_time = Math.max(base_time, 5); // think a bit against
													// humans ... they spent
													// some time moving :)
		}
		// Don't overstep max time per move
		base_time = Math.min(base_time, info.tc_max_turn_time - internet_lag);

		// Calcluate panic search time
		// Use roughly 1/3 of reserve if in trouble
		int extra_time = Math.max(((info.tc_reserve[info.side_to_move] - 30) / 3), 0);
		int panic_time = move_time + extra_time;
		// Don't overstep max time per move
		panic_time = Math.min(panic_time, info.tc_max_turn_time - internet_lag);

		// Calculate mate search time
		// Use all available time except for internet lag
		int mate_time = move_time + info.tc_reserve[info.side_to_move] - internet_lag;
		// Don't overstep max time per move
		mate_time = Math.min(mate_time, info.tc_max_turn_time - internet_lag);

		// Copy data to result buffer
		result.base_time_sec = (int) base_time;
		result.panic_time_sec = panic_time;
		result.mate_time_sec = mate_time;

		return result;
	}
}