package arimaa3;

import java.io.*;
import java.util.*;
import ai_util.*;

public class ArimaaEngineInterface {
	public ArimaaEngineInterface() {
	}

	// compression of GameState should replace initial_position by last capture position and 
	// reduce the move_list to moves after the capture
	// repetition preprocess would be speeded up by this as well, even when it must expect a capture may resist in the list
	
	private EngineThread engine_thread = new EngineThread();
	private ArimaaServerInfo info = new ArimaaServerInfo();

	// All messages must by sent thru here so they get logged
	private static void send_message(String text) {
		text += "\n";
		LogFile.message("AEI s --> " + text);
		System.out.print(text);
		System.out.flush();
	}

	/** resending chat to AEI engine
	 * @param msg
	 */
	public static void chat(String msg) {
		send_message("chat "+msg);
	}
	
	private void control() {

		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));	

		while (true) {
			try {
				// Get the message
				String message = reader.readLine();

				// Write message to log file
				LogFile.message("AEI r--> " + message);

				// If connection broken, just shutdown
				if (message == null) {
					//info.engine.shutdown_search();
					return;
				}

				ArimaaEngineInterfaceCommand AEIcommand = new ArimaaEngineInterfaceCommand(message);

				// Figure out which command it is
				if (AEIcommand.command.equals("aei")) {
					send_message("protocol version 1");
					send_message("id name Hippo");
					send_message("id author Vladan Majerech");
					send_message("id version 2011");
					send_message("aeiok");
				}

				else if (AEIcommand.command.equals("isready")) {
					send_message("readyok");
				}

				else if (AEIcommand.command.equals("quit")) {
					info.engine.abort_search();
					return;
				}

				else if (AEIcommand.command.equals("stop")) {
					info.engine.abort_search();
				}

				else if (AEIcommand.command.equals("newgame")) {
					info.engine.abort_search();
					send_message("log starting new game");
					info.newGame();
				}

				else if (AEIcommand.command.equals("makemove")) {
					String move_text = AEIcommand.getRestOfCommand();
					info.makeMove(move_text);
					info.ShrinkRules();
				}

				else if (AEIcommand.command.equals("chat")) {
					String chatMessage = AEIcommand.getRestOfCommand();
					info.chat(chatMessage);
				}

				else if (AEIcommand.command.equals("setposition")) {
					String position_text = AEIcommand.getRestOfCommand();
					info.newStartPosition(position_text);
				}

				else if (AEIcommand.command.equals("setoption")) {
					String name = AEIcommand.arguments[2];
					String value = AEIcommand.arguments[4];
					set_option(name, value);
				}

				else if (AEIcommand.command.equals("go")) {
					if (AEIcommand.getRestOfCommand().equals("ponder")) {
						info.ShrinkRules();
					} else {
						send_message("log starting search");
						engine_thread.run();
					}
				}
				// Try sending command on to the engine
				else {
					// Unknown command received, just log it and ignore the
					// command
				}

			} // Loop forever

			// This should never happen!
			// We're sunk if we get here, just exit
			catch (Exception e) {
				StringWriter sw = new StringWriter();
				e.printStackTrace(new PrintWriter(sw));
				String stackTrace = sw.toString();
				LogFile.message("Exception " + e);
				LogFile.message(stackTrace);
			}
		}
	}

	private void set_option(String name, String value_text) {
		name = name.toLowerCase();
		LogFile.message("set option "+name+":"+value_text);
		if (name.equals("rated")) {
			info.is_rated = value_text.equals("1") ? true : false;
		} else if (name.equals("hash")) {
			info.allowed_hash_size = Integer.parseInt(value_text);
		} else if (name.equals("opponent")) {
			info.enemy_name = value_text;
			if (value_text.equals("hanzack")) {
				info.engine.resigning=true;
			}
			LogFile.setLogFileName(info.sid+info.enemy_name+".log");
		} else if (name.equals("tcmove")) {
			int value = Integer.parseInt(value_text);
			info.tc_move = value;
		} else if (name.equals("tcpercent")) {
			int value = Integer.parseInt(value_text);
			info.tc_percent = value;
		} else if (name.equals("tcmax")) {
			int value = Integer.parseInt(value_text);
			if (value == 0) {
				value = Integer.MAX_VALUE;
			}
			info.tc_max_reserve = value;
		} else if (name.equals("tcreserve")) {
			int value = Integer.parseInt(value_text);
			info.tc_reserve[0] = info.tc_reserve[1] = value;
		} else if (name.equals("tcturns")) {
			int value = Integer.parseInt(value_text);
			info.tc_turns = value;
		} else if (name.equals("rating")) {
			int value = Integer.parseInt(value_text);
			info.rating = value;
		} else if (name.equals("opponent_rating")) {
			int value = Integer.parseInt(value_text);
			info.opponent_rating = value;
		} else if (name.equals("tctotal")) {
			int value = Integer.parseInt(value_text);
			info.tc_total = value;
		} else if (name.equals("wused")) {
			//int value = Integer.parseInt(value_text);
			//info.used[0] = value;
		} else if (name.equals("bused")) {
			//int value = Integer.parseInt(value_text);
			//info.used[1] = value;
		} else if (name.equals("tclastmoveused")) {
			//int value = Integer.parseInt(value_text);
			//info.used[0] = value;
		} else if (name.equals("lastmoveused")) {
			//int value = Integer.parseInt(value_text);
			//info.used[0] = value;
		} else if (name.equals("moveused")) {
			int value = Integer.parseInt(value_text);
			info.moveused = value;
		} else if (name.equals("tcmoveused")) {
			int value = Integer.parseInt(value_text);
			info.tc_moveused = value;
		} else if (name.equals("tcturntime")) {
			int value = Integer.parseInt(value_text);
			if (value == 0) {
				value = Integer.MAX_VALUE;
			}
			info.tc_max_turn_time = value;
		} else if (name.equals("wreserve")) {
			int value = Integer.parseInt(value_text);
			info.tc_reserve[0] = value;
		} else if (name.equals("breserve")) {
			int value = Integer.parseInt(value_text);
			info.tc_reserve[1] = value;
		} else if (name.equals("sid")) {
			info.sid = value_text;
			LogFile.setLogFileName(info.sid+info.enemy_name+".log");
			if (value_text.equals("analyze")) {
				TimeControl.max_search_time = Long.MAX_VALUE;
				//info.engine.show_alphabeta_search_trace=true;
				//TestForGoal.use_debug=true;
			}
		} else if (name.equals("rootsteplimit")) {
			int value = Integer.parseInt(value_text);
			info.RootStepLimit = value;
		} else if (name.equals("oncerootsteplimit")) {
			int value = Integer.parseInt(value_text);
			info.OnceRootStepLimit = value;
		} else if (name.equals("forbidden")) {
			String movetext = value_text.replace("_", " ");		
			LogFile.message("forbidden "+value_text+">"+movetext);
			ArimaaMove move = new ArimaaMove(movetext);
			info.gs.playMove(move);
			long curr_hash = info.gs.getPositionHash();
			info.gs.unplayMoveFull(move);
			info.repetition_rules.positionMoves.put(curr_hash, "");
		} else {
			LogFile.message("unknown info "+name);
		}
	}

	// Separate thread to run the engine
	private class EngineThread implements Runnable {
		public void run() {
			long start_time = System.currentTimeMillis();

			MoveInfo move = info.engine.genMove(info);
			// remove any pass words, as arimaa-online doesn't want them
			String final_move = move.move_text.replaceAll(" pass", "");
			send_message("bestmove " + final_move);
			long elapsed_time = System.currentTimeMillis() - start_time;
			LogFile.message("Elapsed time: " + elapsed_time + " ms");
			ArimaaEngineInterface.chat(move.chat);
		}
	}

	public static void main(String args[]) {
		LogFile.setMessageDisplay(false);
		LogFile.message((new Date()).toString());

		ArimaaEngineInterface main = new ArimaaEngineInterface();
		main.control();
	}
}
