package arimaa3;

import ai_util.LogFile;
import ai_util.Util;

// TODO out of action penalties ... detect "fight zones" and pieces out of fight ... not fighting propper enemy pieces 
// (one smaller or equal, but well positioned) influence map
// advanced rabbits on side with high influence are good, advaned rabbits on side with small influence are bad.
// Deadlocked phants are counted to the "rabbit decission" influence, free elephants are not counted for it
// detection of lost trap controll ... the trap should be sacrified rather to lmminged

//import ai_util.*;
//import java.util.*;
/** evaluation to be used in search
 * 
 * @author hroch
 *
 */
public class ArimaaEvaluate extends ArimaaBaseClass {

	private TestForGoal goal_test = new TestForGoal();
	private static int scale = 10000;
	static int influence[][] = new int [4][64];
	static {
		for(int i=0;i<3;i++) {
			long curr_bb,prev_bb=TRAP[i];influence[i][TRAP_INDEX[i]]=scale;
			int inf = scale<<1;
			while(prev_bb!=FULL_BB) {
				curr_bb=touching_bb(prev_bb)&~(prev_bb);prev_bb|=curr_bb;inf>>=1;
				while (curr_bb!=0) {
					long lsb_bb=Util.LastBit(curr_bb);curr_bb^=lsb_bb;
					influence[i][Util.bit2ind(lsb_bb)]=inf;
				}
			}
		}
		for(int j=0;j<63;j++) {
			int sum=0;
			for(int i=0;i<4;i++) {
				sum+=influence[i][j];
			}
			if (sum>scale) {
				for(int i=0;i<4;i++) {
					influence[i][j]*=scale;
					influence[i][j]/=sum;
				}				
			}
		}
	}
	private long [] good_phant = {FILE_ED_TOUCH_TRAPS&RANK_6,FILE_ED_TOUCH_TRAPS&RANK_3};
	private long good_elephant_bb = 0x0000183C3C180000L;
	// [gold,silver]
	private long good_gold_horse_attack_bb = 0x0024420000000000L;		// good for gold attack = good for silver defense 
	private long good_silver_horse_attack_bb = 0x0000000000422400L;	// good for silver attack = good for gold defense
	private long good_silver_horse_defense_bb = 0x0000420000000000L;		// good for gold attack = good for silver defense 
	private long good_gold_horse_defense_bb = 0x0000000000420000L;	// good for silver attack = good for gold defense
	private long bad_silver_rabbit_bb = 0x000000005A000000L; // rabbits blocking touch trap square access are bad
	private long bad_gold_rabbit_bb   = 0x0000005A00000000L; // rabbits blocking touch trap square access are bad
	private int[] pass_step_evaluation = {0, -8, -50, -100};	// passing is usually bad used for move ordering only
	private int [] factors = {
		997,107, 568,52,  802,1, 8,1,   0,0, 0,0,  0,0, 0,0,
		//factors[0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07]=player_dominated_two_to_at_most_twice_guarded_trap_factor;
		//[passive=0/active=1][not guarded=0,once guarded=2][cleared_path=0,obstacles=4]
		201,116, 455,8,  187,14, 77,1,   0,0, 0,0,  0,0, 0,0,
		//factors[0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17]=enemy_dominated_two_to_at_most_twice_guarded_trap_factor;
		//[passive=0/active=1][not guarded=0,once guarded=2][cleared_path=0,obstacles=4]
		660,100, 0,0,  0,0, 0,0,   2545,5239, 0,0,  0,0, 0,200,
		//factors[0x20,0x21]=player_dominated_only_touch_trap_factor; [passive=0,active=1]
		//factors[0x28,0x29]=enemy_dominated_only_touch_trap_factor; [passive=0,active=1]
		//factors[0x2f]=bad rabbit pos factor (b5 blocks gold attacks ...)
		1837,3565, 4607,5314,  8300,8314, 300,100,   216,500, 300,600,  1571,830, 200,100,
		//factors[0x30,0x31,0x32,0x33,0x34,0x35]=pinned_factor
		// [enemy ed phant pin, other among trap phant pin, sideway phant pin, nonphant pin with stronger away, pinned with stronger nearby, pinned stronger than framers]
		//factors[0x36]=at least twice touched trap score
		//factors[0x37]=at least trice touched trap score
		//factors[0x38]=player_false_protect_factor;
		//factors[0x39]=good_horse_defense_factor;
		//factors[0x3a]=frozen_pieces_factor
		//factors[0x3b]=good_elephant_place_factor
		//factors[0x3c]=enemy_false_protect_factor;
		//factors[0x3d]=good_horse_attack_factor
		//factors[0x3e]=frozen_barely_dominated_factor;
		//factors[0x3f]=barely_dominated_factor;
		252,184, 122,127,  99,0, 0,0,   0,0, 0,0,  4000,7000, 9000,10000,
		//factors[0x40,0x41,0x42,0x43,0x44]=player_nondominated_capture_factor;
		//factors[0x4c, 0x4d, 0x4e, 0x4f] framed without phalanxes, framed with 1 phalanx, framed with 2 phalanxes
		// framed with 3phalanxes
		2682,3501, 1750,1129,  1252,0, 0,0,   0,0, 0,0,  3000,7000, 9000,10000,
		//factors[0x50,0x51,0x52,0x53,0x54]=enemy_nondominated_capture_factor;
		//factors[0x4c, 0x4d, 0x4e, 0x4f] phalanxes need 3 stronger or_eq, phalanxes need 2 stronger or_eq,
		//phalanxes need 1 stronger or_eq,phalanxes need 0 stronger or_eq
		50,100, 150,200,  250,300, 350,400,   0,0, 0,0,  0,0, 0,0,
		//factors[0x60,0x61,...,0x67]=gold on rank i, silver on rank 8-i [1,2,3...] factor
	};
	//private int [][] player_goal_danger_factor=
	//private int [][] enemy_goal_danger_factor=

	private int [] scaledScores = {
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
		0,0, 0,0,  0,0, 0,0,   0,0, 0,0,  0,0, 0,0,
	}; // factor x feature value
	// feature value ... value of pieces to be affected or 100 for boolean properties
	// to be used in reinforcement learning
	
	private int[] trap_fight = {0,0,0,0};
	
	/** switch to use frame scores
	 */
	public boolean use_frameScore=true;
	/** switch to use player hostage scores
	 */
	public boolean use_playerHostageScore=true;
	/** switch to use enemy hostage scores
	 */
	public boolean use_enemyHostageScore=true;
	/** switch to use player capture score of where attacker should touched the piece to capture
	 */
	public boolean use_playerNonDominatedCaptureScore=true;
	/** switch to use enemy capture score of where attacker should touched the piece to capture
	 */
	public boolean use_enemyNonDominatedCaptureScore=true;
	/** switch to use player false protection capture score
	 */
	public boolean use_playerFalseProtectionScore=true;
	/** switch to use enemy false protection capture score
	 */
	public boolean use_enemyFalseProtectionScore=true;
	/** switch to evaluate goal threats by player
	 */
	public boolean use_playerGoalDangerScore=true;
	/** switch to evaluate goal threats by enemy
	 */
	public boolean use_enemyGoalDangerScore=true;
	
	/** constructor using default factors
	 */
	public ArimaaEvaluate() {
	};
	
	/** constructor getting factors as a parameter
	 * @param factors_
	 */
	public ArimaaEvaluate(int [] factors_) {
		for(int i=0;i<Math.min(factors_.length,factors.length);i++) {
			factors[i]=factors_[i];
		}
	}
	
	/** factors export for evaluation learning purposes
	 * @return
	 */
	public int[] copyFactors() {
		int[] factors_ = new int[factors.length];
		System.arraycopy(factors, 0, factors_, 0, factors.length);
		return factors_;
	}

	/** factors export for evaluation learning purposes ... rewrite parameter format
	 * @param copyWhere
	 */
	public void copyFactors(int [] copyWhere) {//copyWhere.length==factors.length
		System.arraycopy(factors, 0, copyWhere, 0, factors.length);
	}

	/** scores export for evaluation learning purposes
	 * @return
	 */
	public int[] copyScores() {
		int[] scores_ = new int[scaledScores.length];
		System.arraycopy(scaledScores, 0, scores_, 0, scaledScores.length);
		return scores_;		
	}

	/** scores export for evaluation learning purposes ... rewrite parameter format
	 * @param copyWhere
	 */
	public void copyScores(int [] copyWhere) {//copyWhere.length==factors.length
		System.arraycopy(scaledScores, 0, copyWhere, 0, scaledScores.length);
	}

	// Globals used for statistics collection
	private static long eval_calls = 0;
	/** Returns some statistics on the eval function
	 * @return string of statistics
	 */
	public static String getStats() {
		String result = "";
		result += "EvCalls: " + eval_calls + " ";
		return result;
	}

	private String eval_text;
	private int score_offset;

	/** 
	 * @return string  short explanation of the eval for chat purposes
	 */
	public String getEvalText() {
		return eval_text;
	}

	/** move evaluation propagating more active moves
	 * @param steps
	 * @return
	 */
	public int PassEvaluate(int steps) {
		assert(steps>=0);
		assert(steps<=3);
		return pass_step_evaluation[steps];
	}
	
	/** Computes the evaluation text (calls drives asking for the text) the evaluation is done as well
	 * 
	 * @param pos
	 * @return score
	 */
	public int setEvalText(GameState pos) {
		int score = getPieceLocationEvaluation(pos);
		eval_text=(pos.mat.getHAME()==0)?"":"HAME "+pos.mat.getHAME();
		frameScore(pos,true);
		playerHostageScore(pos,true);
		enemyHostageScore(pos,true);
		playerNonDominatedCaptureScore(pos,true);
		enemyNonDominatedCaptureScore(pos,true);
		playerFalseProtectionScore(pos,true);
		enemyFalseProtectionScore(pos,true);
		evalElephantPlace(pos,true);
		evalHorsePlace(pos,true);
		evalRabbitPlaces(pos,true);
		evalFrozenPiecesScore(pos,true);
		evalBarelyDominatedScore(pos,true);
		evalFrozenBarelyDominatedScore(pos,true);
		evalTrapTouchScore(pos,true);
		evalSpaceScore(pos,true);
		if (!eval_text.equals("")) {
			eval_text="("+eval_text+")";
		}
		return score;
	}
	
	/**This must be called before any calls to evaluate It fills in a bunch of
	 * piece square tables based on the root position It is called by the
	 * search, with the root position before any searching is done.
	 * 
	 * @param info
	 * @return
	 */
	public int PreProcessRootPosition(ArimaaServerInfo info) {
		GameState root_gs = info.gs;
		root_gs.compute_tertiary_bitboards();
		getDynamicPieceValues(root_gs);
		getTrapFight(root_gs);
		if (info.talking) {
			score_offset = setEvalText(root_gs);
			ArimaaEngineInterface.chat("pre move score "+score_offset+" "+eval_text);
		} else {
			score_offset = getPieceLocationEvaluation(root_gs);			
		}
		return score_offset;
	}

	/**
	 * This function is called by the search whenever an eval is required
	 * @param gs GameState
	 * @return int
	 */
	public int Evaluate(GameState gs) {

		if (gs.isGameOver()) {
			int that_should_be_detected_earlier=0;that_should_be_detected_earlier++;
		}
		if (goal_test.test(gs)) {
			return SCORE_MATE-1;
		}
		gs.compute_tertiary_bitboards();// expecting the secondary were already computed by playfull
		eval_calls++;

		// Everything is evaluated from white's point of view (ie gold)
		// The score is negated at the end, if it's black's turn (ie silver)
		int score;
		score = getPieceLocationEvaluation(gs) - score_offset;

		// Pulls score back down to within mate bounds range
		// score_offset is computed in PreProcessRootPosition call
		// this just allows more effective range for eval values

		// Force score to be inside mate bounds
		// If we don't do this *HORRIBLE NASTY PROBLEMS* occur
		if (score >= 29990) {
			score = +29990;
		}
		if (score <= -29990) {
			score = -29990;
		}

		// Flip the score value if it's black's turn
		return (gs.player == PL_GOLD) ? score : -score;
	}

	private int dynamic_piece_value[][] = new int[2][6];

	/**
	 * Computes dynamic piece values based on given position A piece is worth
	 * what the relative change in HAME is if its captured.
	 * 
	 * @param gs GameState
	 */
	private void getDynamicPieceValues(GameState gs) {
		int initial_score = gs.mat.getHAME();
		for (int c = 0; c < 2; c++) {
			for (int s = 0; s < 6; s++) {
				if (Material.PieceCount[gs.mat.material_index[c]][s] == 0) {
					dynamic_piece_value[c][s] = 0;
				} else {
					try {
						dynamic_piece_value[c][s] = gs.mat.capture(c,s).getHAME() - initial_score;
					} catch (MaterialInconsistencyException b) {
						System.out.println("Material inconsistency in getDynamicPieceValues "+gs);
					}
				}
			}
		}
	}

	private void getTrapFight(GameState gs) {
		for(int i=0;i<4;i++) {
			trap_fight[i]=0;
		}
		for(int value,piece,j=0;j<64;j++) {
			if ((piece=gs.piece_at[j])>=0) {
				value=dynamic_piece_value[piece&1][piece>>1];
				for(int i=0;i<4;i++) {
					trap_fight[i]+=value*influence[i][j];
				}
			}
		}
		for(int i=0;i<4;i++) {
			trap_fight[i]/=scale;
		}
	}
	
	private int frameScore(GameState gs, boolean chat) {
		// TODO improve the evaluation of good/bad frame ... possible rotation ... 
		// rotating to the corner is as wrong as to phalanx?!
		int score=0;// nonlinear with coeficients :(
		//LogFile.message("frameScore at "+gs);
		try {
			for(int i=0x30;i<=0x35;i++) {
				scaledScores[i]=0;
			}
			for(int i=0x4c;i<=0x4f;i++) {
				scaledScores[i]=0;
			}
			for(int i=0x5c;i<=0x5f;i++) {
				scaledScores[i]=0;
			}
			for(int c=0;c<2;c++) {
				long frame_bb = TRAP_SQUARES & gs.player_bb[c] & gs.suicide_bb[c];
				// rabbit frames are not in crosses_bb !!
				long extra_block_bb=frame_bb&~gs.stronger_or_eq_bb[1];
				extra_block_bb=(c==0)?down_bb(extra_block_bb):up_bb(extra_block_bb);
				frame_bb &= ~touching_bb(gs.empty_bb & ~extra_block_bb);
				while (frame_bb>0) {
					//LogFile.write("Frame "+gs.toString()+bitboard(frame_bb)+"color "+c);
					long flsb_bb= Util.LastBit(frame_bb);
					frame_bb ^= flsb_bb;
					int frame_piece = gs.getPieceTypeOneSq(flsb_bb);
					int frame_strength = frame_piece>>1;
					long nophalanx_bb = can_step_bb(flsb_bb,frame_piece)&~(gs.trap_protect_bb|gs.crosses_bb);
					long escape_bb = nophalanx_bb&~(gs.stronger_or_eq_bb[frame_strength]);
					if (escape_bb!=0) {
						continue;
					}
					int trap_ind = Util.ind2trap(Util.bit2ind(flsb_bb));
					int pin_score=gs.mat.capture_piece(frame_piece).getHAME()-gs.mat.getHAME();
					int phalanx_index=0x4f-((frame_strength==0)?0:Util.LowPopCnt(nophalanx_bb));
					scaledScores[phalanx_index]+=pin_score;
					pin_score*=factors[phalanx_index];pin_score/=scale;
					int strong_enough=frame_strength+((frame_strength<2)?1:0);
					int strong_enough_cnt = Util.PopCnt(TRAP_PHALANXES[trap_ind] & 
							gs.player_bb[c^1] &
							gs.stronger_or_eq_bb[strong_enough]);
					int strong_index=0x5f-((strong_enough_cnt>3)?3:strong_enough_cnt);
					scaledScores[strong_index]+=pin_score;
					pin_score*=factors[strong_index];pin_score/=scale;
					long pin_square = TOUCH_TRAP[trap_ind] & gs.trap_protect_bb;
					int pinned_strength = gs.getPieceTypeOneSq(pin_square)>>1;
					
					//[0x30,0x31,0x32,0x33,0x34,0x35]
					//[enemy ed phant pin, other among trap phant pin, sideway phant pin, 
					// nonphant pin with stronger away, pinned with stronger nearby, pinned stronger than framers]
					int frame_ind;
					if (pinned_strength==GameState.Strongest) {
						if ((pin_square&good_phant[c])!=0) {
							frame_ind=0x30;
						} else if ((pin_square&AMONG_TRAPS)!=0) {
							frame_ind=0x31;
						} else {
							frame_ind=0x32;
						}
					} else {
						if ((touching_bb(touching_bb(pin_square)|pin_square) &
								gs.player_bb[c^1] &
								gs.stronger_or_eq_bb[pinned_strength+1])==0) {
							frame_ind=0x33;
						} else {
							frame_ind=0x34;							
						}
					}
					if ((TRAP_PHALANXES[trap_ind] &
							gs.player_bb[c^1] &
							gs.stronger_or_eq_bb[pinned_strength])==0) {
						frame_ind=0x35;
					}
					scaledScores[frame_ind]+=pin_score;
				}
			}
			for(int i=0x30;i<=0x35;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// finalize
			score /= scale;
			if (chat) {
				if (score!=0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Frame score "+score;
				}
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in frameScore");
		} 
		//if (score!=0) LogFile.write("Frame score "+score);
		return score;
	}
	
	private int playerHostageScore(GameState gs, boolean chat) {//evaluate pieces in 4 step captures expect the single trap guard
		int score=0;
		//LogFile.message("playerHostageScore at "+gs);
		try {
			int hame=gs.mat.getHAME();int p=gs.player,e=gs.enemy;
			// touching trap
			for(int i=0x20;i<=0x21;i++) {
				scaledScores[i]=0;
			}
			long dominatedOnlyGuardTrap_bb=gs.dominated_pieces_bb&gs.lone_defender_bb[p];
			// hmmm, must take trap controll into account
			for(long lsb_bb;dominatedOnlyGuardTrap_bb!=0;dominatedOnlyGuardTrap_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(dominatedOnlyGuardTrap_bb);
				int piece=gs.getPieceTypeOneSq(lsb_bb);
				int passive=(lsb_bb&gs.passive_pieces_bb)==0?1:0;
				scaledScores[0x20|passive]+=(gs.mat.capture_piece(piece).getHAME()-hame);
			}
			for(int i=0x20;i<=0x21;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// two steps to trap
			for(int i=0x00;i<=0x07;i++) {
				scaledScores[i]=0;
			}
			long twoToNotGuardedTrap_bb=touching_bb(touching_bb(TRAP_SQUARES & ~gs.count_touch_bb[p][1])) &	gs.player_bb[p];
			long dominatedTwoToNotTwiceGuardedTrap_bb=(touching_bb(touching_bb(gs.suicide_bb[p])) & gs.player_bb[p])
				& gs.dominated_pieces_bb & NON_TRAP_SQUARES;
			for(long lsb_bb;dominatedTwoToNotTwiceGuardedTrap_bb!=0;dominatedTwoToNotTwiceGuardedTrap_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(dominatedTwoToNotTwiceGuardedTrap_bb);
				int piece=gs.getPieceTypeOneSq(lsb_bb);
				long pass_bb=gs.empty_bb|(gs.player_bb[e] & gs.stronger_or_eq_bb[1+(piece>>1)]);
				long on_path_bb=touching_bb(lsb_bb)&TOUCH_TRAPS&pass_bb;
				int passive=(lsb_bb&gs.passive_pieces_bb)==0L?1:0;
				int obstacles=(touching_bb(on_path_bb)&TRAP_SQUARES&pass_bb)==0L?4:0;
				int onceGuarded=(lsb_bb&twoToNotGuardedTrap_bb)==0L?2:0;
				if (piece<0) {
					LogFile.message("dominatedTwoToNotTwiceGuardedTrap_bb"+bitboard((touching_bb(touching_bb(gs.suicide_bb[p])) & gs.player_bb[p])
							& gs.dominated_pieces_bb & NON_TRAP_SQUARES));
					LogFile.message("in position "+gs);
					LogFile.message("gold"+bitboard(gs.player_bb[0])+"silver"+bitboard(gs.player_bb[1]));
					for(int s=0;s<GameState.Strongest;s++) {
						LogFile.message("stronger_or_eq["+s+"]:\n"+bitboard(gs.stronger_or_eq_bb[s]));
					}
				}
				scaledScores[0x00|passive|onceGuarded|obstacles]+=(gs.mat.capture_piece(piece).getHAME()-hame);
				// are the flags OK? 
			}
			for(int i=0x00;i<=0x07;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// finalize
			score /= scale;
			if (chat) {
				if (score != 0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Player hostage score "+score;
				}
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in playerHostageScore");
		} 
		return score;
	}
	
	private int enemyHostageScore(GameState gs, boolean chat) {//evaluate pieces in 4 step captures expect the single trap guard
		int score = 0;
		//LogFile.message("enemyHostageScore at "+gs);
		try {
			int hame=gs.mat.getHAME();int p=gs.enemy,e=gs.player;
			// touching trap
			for(int i=0x28;i<=0x29;i++) {
				scaledScores[i]=0;
			}
			long dominatedOnlyGuardTrap_bb=gs.dominated_pieces_bb&gs.lone_defender_bb[p];
			// hmmm, must take trap controll into account
			for(long lsb_bb;dominatedOnlyGuardTrap_bb!=0;dominatedOnlyGuardTrap_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(dominatedOnlyGuardTrap_bb);
				int piece=gs.getPieceTypeOneSq(lsb_bb);
				int passive=(lsb_bb&gs.passive_pieces_bb)==0?1:0;
				scaledScores[0x28|passive]+=(gs.mat.capture_piece(piece).getHAME()-hame);
			}
			for(int i=0x28;i<=0x29;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// two steps to trap
			for(int i=0x10;i<=0x17;i++) {
				scaledScores[i]=0;
			}
			long twoToNotGuardedTrap_bb=touching_bb(touching_bb(TRAP_SQUARES & ~gs.count_touch_bb[p][1]))&gs.player_bb[p];
			long dominatedTwoToNotTwiceGuardedTrap_bb= touching_bb(touching_bb(gs.suicide_bb[p])) & gs.player_bb[p]
				& gs.dominated_pieces_bb & NON_TRAP_SQUARES;
			for(long lsb_bb;dominatedTwoToNotTwiceGuardedTrap_bb!=0;dominatedTwoToNotTwiceGuardedTrap_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(dominatedTwoToNotTwiceGuardedTrap_bb);
				int piece=gs.getPieceTypeOneSq(lsb_bb);
				long pass_bb=gs.empty_bb|(gs.player_bb[e] & gs.stronger_or_eq_bb[1+(piece>>1)]);
				long on_path_bb=touching_bb(lsb_bb)&TOUCH_TRAPS&pass_bb;
				int passive=(lsb_bb&gs.passive_pieces_bb)==0?1:0;
				int obstacles=(touching_bb(on_path_bb)&TRAP_SQUARES&pass_bb)==0?4:0;
				int onceGuarded=(lsb_bb&twoToNotGuardedTrap_bb)==0?2:0;
				scaledScores[0x10|passive|onceGuarded|obstacles]+=(gs.mat.capture_piece(piece).getHAME()-hame);
			}
			for(int i=0x10;i<=0x17;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// finalize
			score /= scale;
			if (chat) {
				if (score != 0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Enemy hostage score "+score;
				}			
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in enemyHostageScore");
		} 
		return score;
	}
	
	private int playerNonDominatedCaptureScore(GameState gs, boolean chat) {//TODO evaluate captures by dragging nondominated pieces
		int score=0;
		//LogFile.message("playerNonDominatedCaptureScore at "+gs);
		try {
			for(int i=0x40;i<=0x44;i++) {
				scaledScores[i]=0;
			}
			long to_drag_bb=gs.lone_defender_bb[gs.player]&~gs.dominated_pieces_bb;
			for(long lsb_bb;to_drag_bb!=0;to_drag_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(to_drag_bb);
				int to_drag_ind=Util.bit2ind(lsb_bb);
				int capture_piece,piece,strength=(piece=gs.getPieceType(to_drag_ind))>>1;
				boolean enemy_in_trap=(gs.trap_protect_bb&lsb_bb)!=0;
				if (enemy_in_trap) {
					capture_piece=gs.getPieceTypeOneSq(touching_bb(lsb_bb)&TRAP_SQUARES);
				} else {
					capture_piece=piece;
				}
				int capture_score=gs.mat.capture_piece(capture_piece).getHAME()-gs.mat.getHAME();
				long attack_bb=gs.player_bb[gs.enemy] & gs.stronger_or_eq_bb[strength+1];
				long dist1_bb,dist2_bb,dist3_bb=touching_bb(dist2_bb=touching_bb(dist1_bb=touching_bb(lsb_bb)));
				if ((attack_bb&dist3_bb)!=0) {
					if ((attack_bb&dist2_bb)!=0) {
						//phalanx test
						long path_bb=(gs.empty_bb|~gs.crosses_bb)&touching_bb(attack_bb)&dist1_bb;
						if (path_bb!=0) {
							if ((path_bb&~TRAP_SQUARES)!=0) {// it may be unempty noncross with only one empty neighbour touching trap ...
								scaledScores[0x40]+=capture_score;
							} else {
								if ((path_bb&gs.empty_bb)!=0) {
									if ((attack_bb&gs.lone_defender_bb[gs.enemy])==0) {
										//capture by pulling to trap if not frozen
										scaledScores[0x42]+=capture_score;
									} else {
										// capture through trap if friend nearby or freezing
										scaledScores[0x43]+=capture_score;
									}
								} else if (!enemy_in_trap) {// capture in 4 possible except the capturing piece will become frozen
									scaledScores[0x41]+=capture_score;
								} // else capture impossible
							}
						}
					} else {//the path to lsb_bb must be clear otherwise no capture
						dist1_bb=touching_bb(lsb_bb)&gs.empty_bb&~gs.suicide_bb[gs.enemy];
						dist2_bb=touching_bb(dist1_bb)&gs.empty_bb;
						dist3_bb=touching_bb(dist2_bb);
						if ((attack_bb&dist3_bb)!=0) {
							scaledScores[0x44]+=capture_score;
						}
					}
				}
			}
			for(int i=0x40;i<=0x44;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// finalize
			score /= scale;
			if (chat) {
				if (score != 0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Player nondominated capture score "+score;
				}			
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in playerNonDominatedCaptureScore");
		} 
		return score;
	}

	private int enemyNonDominatedCaptureScore(GameState gs, boolean chat) {//TODO evaluate captures by dragging nondominated pieces
		int score=0;
		
		// gs.trap_protect_bb not OK!??
		
		try {
			for(int i=0x50;i<=0x54;i++) {
				scaledScores[i]=0;
			}
			long to_drag_bb=gs.lone_defender_bb[gs.enemy]&~gs.dominated_pieces_bb;
			for(long lsb_bb;to_drag_bb!=0;to_drag_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(to_drag_bb);
				int to_drag_ind=Util.bit2ind(lsb_bb);
				int capture_piece,piece,strength=(piece=gs.getPieceType(to_drag_ind))>>1;
				boolean enemy_in_trap=((gs.trap_protect_bb&lsb_bb)!=0);
				if (enemy_in_trap) {
					capture_piece=gs.getPieceTypeOneSq(touching_bb(lsb_bb)&TRAP_SQUARES);
					if (capture_piece == -1) {
						LogFile.message("enemyNonDominatedCaptureScore at "+gs+"index "+to_drag_ind+"piece "+piece+
								"trap_protect_bb\n"+bitboard(gs.trap_protect_bb)+"\ncapture_piece "+capture_piece);
						LogFile.message("Trap protecting empty trap"+bitboard(gs.player_bb[0])+bitboard(gs.player_bb[1]));
						for(int s=0;s<GameState.Strongest;s++) {
							LogFile.message("stronger_or_eq["+s+"]:\n"+bitboard(gs.stronger_or_eq_bb[s]));
						}
					}
				} else {
					capture_piece=piece;
				}
				int capture_score=gs.mat.capture_piece(capture_piece).getHAME()-gs.mat.getHAME();
				long attack_bb=gs.player_bb[gs.player] & gs.stronger_or_eq_bb[strength+1];
				long dist1_bb,dist2_bb,dist3_bb=touching_bb(dist2_bb=touching_bb(dist1_bb=touching_bb(lsb_bb)));
				if ((attack_bb&dist3_bb)!=0) {
					if ((attack_bb&dist2_bb)!=0) {
						//phalanx test
						long path_bb=(gs.empty_bb|~gs.crosses_bb)&touching_bb(attack_bb)&dist1_bb;
						if (path_bb!=0) {
							if ((path_bb&~TRAP_SQUARES)!=0) {// it may be unempty noncross with only one empty neighbour touching trap ...
								scaledScores[0x50]+=capture_score;
							} else {
								if ((path_bb&gs.empty_bb)!=0) {
									if ((attack_bb&gs.lone_defender_bb[gs.player])==0) {
										//capture by pulling to trap if not frozen
										scaledScores[0x52]+=capture_score;
									} else {
										// capture through trap if friend nearby or freezing
										scaledScores[0x53]+=capture_score;
									}
								} else if (!enemy_in_trap) {// capture in 4 possible except the capturing piece will become frozen
									scaledScores[0x51]+=capture_score;
								} // else capture impossible
							}
						}
					} else {//the path to lsb_bb must be clear otherwise no capture
						dist1_bb=touching_bb(lsb_bb)&gs.empty_bb&~gs.suicide_bb[gs.player];
						dist2_bb=touching_bb(dist1_bb)&gs.empty_bb;
						dist3_bb=touching_bb(dist2_bb);
						if ((attack_bb&dist3_bb)!=0) {
							scaledScores[0x54]+=capture_score;
						}
					}
				}
			}
			for(int i=0x50;i<=0x54;i++) {
				score+=scaledScores[i]*=factors[i];
			}
			// finalize
			score /= scale;
			if (chat) {
				if (score != 0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Enemy nondominated capture score "+score;
				}			
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in enemyNonDominatedCaptureScore");
		} 
		return score;
	}

	private int playerFalseProtectionScore(GameState gs, boolean chat) {
		int score=0;
		//LogFile.message("playerFalseProtectionScore at "+gs);
		try{
			scaledScores[0x38]=0;
			long trap_bb=TRAP_SQUARES&
			~gs.count_touch_bb[gs.player][3]&~gs.suicide_bb[gs.player];
			long to_drag_bb,def1_bb,def2_bb;
			int capture_piece,defender1,defender2;
			for(long lsb_bb;trap_bb!=0;trap_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(trap_bb);
				to_drag_bb=touching_bb(lsb_bb)&gs.dominated_pieces_bb&gs.player_bb[gs.player];
				def1_bb=Util.LastBit(to_drag_bb); def2_bb=to_drag_bb^def1_bb;
				if (Util.LowPopCnt(to_drag_bb)==2) {
					defender1=gs.getPieceTypeOneSq(def1_bb);
					defender2=gs.getPieceTypeOneSq(def2_bb);
					if ((lsb_bb&gs.player_bb[gs.enemy])!=0) {
						int trap_piece=gs.getPieceTypeOneSq(lsb_bb);
						if (trap_piece<Math.min(defender1, defender2)) {
							continue;// trap blocked
						}
					}
					if ((lsb_bb&gs.player_bb[gs.player])!=0) {
						capture_piece=gs.getPieceTypeOneSq(lsb_bb);
					} else {
						capture_piece=Math.max(defender1, defender2);
					}
					long touching_enemy_bb, 
						drag1_bb=(touching_enemy_bb=touching_bb(def1_bb) & gs.player_bb[gs.enemy]) 
							& gs.stronger_or_eq_bb[1+(defender1>>1)],
						drag2_bb=touching_enemy_bb & gs.stronger_or_eq_bb[1+(defender2>>1)];
					if (!atMostOneBitSet(drag1_bb|drag2_bb)) {
						scaledScores[0x38]+=(gs.mat.capture_piece(capture_piece).getHAME()-gs.mat.getHAME());
					} 
				}			
			}
			score+=scaledScores[0x38]*=factors[0x38];
			// finalize
			score /= scale;
			if (chat) {
				if (score != 0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Player false protection capture score "+score;
				}			
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in playerFalseProtectionScore");
		} 
		return score;
	}
	
	private int enemyFalseProtectionScore(GameState gs, boolean chat) {
		int score=0;
		//LogFile.message("enemyFalseProtectionScore at "+gs);
		try{
			scaledScores[0x3c]=0;
			long trap_bb=TRAP_SQUARES&
			~gs.count_touch_bb[gs.enemy][3]&~gs.suicide_bb[gs.enemy];
			long to_drag_bb,def1_bb,def2_bb;
			int capture_piece,defender1,defender2;
			for(long lsb_bb;trap_bb!=0;trap_bb^=lsb_bb) {
				lsb_bb=Util.LastBit(trap_bb);
				to_drag_bb=touching_bb(lsb_bb) & gs.dominated_pieces_bb & gs.player_bb[gs.enemy];
				def1_bb=Util.LastBit(to_drag_bb); def2_bb=to_drag_bb^def1_bb;
				if (Util.LowPopCnt(to_drag_bb)==2) {
					defender1=gs.getPieceTypeOneSq(def1_bb);
					defender2=gs.getPieceTypeOneSq(def2_bb);
					if ((lsb_bb&gs.player_bb[gs.player])!=0) {
						int trap_piece=gs.getPieceTypeOneSq(lsb_bb);
						if (trap_piece<Math.min(defender1, defender2)) {
							continue;// trap blocked
						}
					}					
					if ((lsb_bb&gs.player_bb[gs.enemy])!=0) {
						capture_piece=gs.getPieceTypeOneSq(lsb_bb);
					} else {
						capture_piece=Math.max(defender1, defender2);
					}
					long touching_player_bb, 
					drag1_bb=(touching_player_bb=touching_bb(def1_bb) & gs.player_bb[gs.player]) 
						& gs.stronger_or_eq_bb[1+(defender1>>1)],
					drag2_bb=touching_player_bb & gs.stronger_or_eq_bb[1+(defender2>>1)];
					if (!atMostOneBitSet(drag1_bb|drag2_bb)) {
						scaledScores[0x3c]+=(gs.mat.capture_piece(capture_piece).getHAME()-gs.mat.getHAME());
					} 
				}			
			}
			score+=scaledScores[0x3c]*=factors[0x3c];
			// finalize
			score /= scale;
			if (chat) {
				if (score != 0) {
					eval_text=(eval_text.equals("")?"":eval_text+" ")+"Enemy false protection capture score "+score;
				}			
			}
		} catch (MaterialInconsistencyException b) {
			LogFile.writeln("Material inconsistency in enemyFalseProtectionScore");
		} 
		return score;
	}

	private int playerGoalDangerScore(GameState gs, boolean chat) {// TODO evaluate goal danger (not immediate goal)
		return 0;
	}

	private int enemyGoalDangerScore(GameState gs, boolean chat) {// TODO evaluate goal danger (not immediate goal)
		return 0;
	}

	private int evalElephantPlace(GameState gs, boolean chat) {	
		int score = 0;
		//LogFile.message("evalElephantPlace at "+gs);
		scaledScores[0x3b]=0;
		long scoring_elephant_bb=good_elephant_bb & gs.stronger_or_eq_bb[GameState.Strongest];
		scaledScores[0x3b] += Util.LowPopCnt(scoring_elephant_bb & gs.player_bb[0]);
		scaledScores[0x3b] -= Util.LowPopCnt(scoring_elephant_bb & gs.player_bb[1]);
		score += scaledScores[0x3b] *= 100 * factors[0x3b];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Elephant pieces position score "+score;
			}			
		}
		return score;
	}

	private int evalHorsePlace(GameState gs, boolean chat) {
		//TODO attacking horse is good there when opponent camel is not around or when our phant is around as well
		// defending horse just prevents attacking horse to reach good square, but b4/b5 could be good as well for it
		int score = 0;
		//LogFile.message("evalHorsePlace at "+gs);
		scaledScores[0x3d]=scaledScores[0x39]=0;
		if (GameState.Strongest<3) return 0;
		long horses_bb = gs.stronger_or_eq_bb[GameState.Strongest-2]^gs.stronger_or_eq_bb[GameState.Strongest-1];
		scaledScores[0x3d] += Util.LowPopCnt(good_gold_horse_attack_bb & gs.player_bb[0] & horses_bb);
		scaledScores[0x3d] -= Util.LowPopCnt(good_silver_horse_attack_bb & gs.player_bb[1] & horses_bb);
		scaledScores[0x39] += Util.LowPopCnt(good_gold_horse_defense_bb & gs.player_bb[0] & horses_bb);
		scaledScores[0x39] -= Util.LowPopCnt(good_silver_horse_defense_bb & gs.player_bb[1] & horses_bb);
		score += scaledScores[0x3d] *= 100 * factors[0x3d];
		score += scaledScores[0x39] *= 100 * factors[0x39];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Horse pieces position score "+score;
			}			
		}
		return score;
	}
	
	private int evalRabbitPlaces(GameState gs, boolean chat) {
		//TODO attacking horse is good there when opponent camel is not around or when our phant is around as well
		// defending horse just prevents attacking horse to reach good square, but b4/b5 could be good as well for it
		int score = 0;
		//LogFile.message("evalRabbitPlaces at "+gs);
		scaledScores[0x2f] = Util.LowPopCnt(bad_silver_rabbit_bb & gs.player_bb[1] & ~gs.stronger_or_eq_bb[1]);
		scaledScores[0x2f] -= Util.LowPopCnt(bad_gold_rabbit_bb & gs.player_bb[0] & ~gs.stronger_or_eq_bb[1]);
		score += scaledScores[0x2f] *= 100 * factors[0x2f];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Rabbits position score "+score;
			}			
		}
		return score;
	}
	
	private int evalFrozenPiecesScore(GameState gs, boolean chat) {	
		int score = 0;
		//LogFile.message("evalFrozenPiecesScore at "+gs);
		scaledScores[0x3a]=0;
		scaledScores[0x3a] += Util.PopCnt(gs.frozen_pieces_bb & gs.player_bb[1]);
		scaledScores[0x3a] -= Util.PopCnt(gs.frozen_pieces_bb & gs.player_bb[0]);
		score += scaledScores[0x3a] *= 100 * factors[0x3a];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Frozen pieces score "+score;
			}			
		}
		return score;
	}	

	private int evalBarelyDominatedScore(GameState gs, boolean chat) {	
		int score = 0;
		//LogFile.message("evalBarelyDominatedScore at "+gs);
		scaledScores[0x3f]=0;
		scaledScores[0x3f] += Util.PopCnt(gs.barely_dominated_pieces_bb & gs.player_bb[1]);
		scaledScores[0x3f] -= Util.PopCnt(gs.barely_dominated_pieces_bb & gs.player_bb[0]);
		score += scaledScores[0x3f] *= 100 * factors[0x3f];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Barely dominated score "+score;
			}			
		}
		return score;
	}	
	
	private int evalFrozenBarelyDominatedScore(GameState gs, boolean chat) {	
		int score = 0;
		//LogFile.message("evalFrozenBarelyDominatedScore at "+gs);
		scaledScores[0x3e]=0;
		scaledScores[0x3e] += Util.PopCnt(gs.frozen_pieces_bb & gs.barely_dominated_pieces_bb & gs.player_bb[1]);
		scaledScores[0x3e] -= Util.PopCnt(gs.frozen_pieces_bb & gs.barely_dominated_pieces_bb & gs.player_bb[0]);
		score += scaledScores[0x3e] *= 100 * factors[0x3e];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Frozen barely dominated score "+score;
			}			
		}
		return score;
	}	

	private int evalTrapTouchScore(GameState gs, boolean chat) {	
		int score = 0;
		//LogFile.message("evalTrapTouchScore at "+gs);
		scaledScores[0x36]=scaledScores[0x37]=0;
		scaledScores[0x36] += Util.LowPopCnt(TRAP_SQUARES & gs.count_touch_bb[0][2]);
		scaledScores[0x36] -= Util.LowPopCnt(TRAP_SQUARES & gs.count_touch_bb[1][2]);
		scaledScores[0x37] += Util.LowPopCnt(TRAP_SQUARES & gs.count_touch_bb[0][3]);
		scaledScores[0x37] -= Util.LowPopCnt(TRAP_SQUARES & gs.count_touch_bb[1][3]);
		score += scaledScores[0x36] *= 100 * factors[0x36];
		score += scaledScores[0x37] *= 100 * factors[0x37];
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Trap touch score "+score;
			}			
		}
		return score;
	}	

	private int evalSpaceScore(GameState gs, boolean chat) {
		//TODO advanced rabbits are good when controlling away trap(s), 
		// advanced rabbits are bad when the trap is not controlled
		// advanced rabbits on camel side are better than advanced rabbits on the other side
		// trap fight and trap control must be used as "mode switchers"
		//LogFile.message("evalSpaceScore at "+gs);
		int score = 0;
		for(int i=0x60;i<=0x67;i++) {
			scaledScores[i]=0;
		}
		long gold_bb=gs.player_bb[0], silver_bb=gs.player_bb[1];
		scaledScores[0x60] += Util.PopCnt(gold_bb & RANK_1)-Util.PopCnt(silver_bb & RANK_8);
		scaledScores[0x61] += Util.PopCnt(gold_bb & RANK_2)-Util.PopCnt(silver_bb & RANK_7);
		scaledScores[0x62] += Util.PopCnt(gold_bb & RANK_3)-Util.PopCnt(silver_bb & RANK_6);
		scaledScores[0x63] += Util.PopCnt(gold_bb & RANK_4)-Util.PopCnt(silver_bb & RANK_5);
		scaledScores[0x64] += Util.PopCnt(gold_bb & RANK_5)-Util.PopCnt(silver_bb & RANK_4);
		scaledScores[0x65] += Util.PopCnt(gold_bb & RANK_6)-Util.PopCnt(silver_bb & RANK_3);
		scaledScores[0x66] += Util.PopCnt(gold_bb & RANK_7)-Util.PopCnt(silver_bb & RANK_2);
		scaledScores[0x67] += Util.PopCnt(gold_bb & RANK_8)-Util.PopCnt(silver_bb & RANK_1);
		for(int i=0x60;i<=0x67;i++) {
			score += scaledScores[i] *= 100 * factors[i];
		}
		score /= scale;
		if (chat) {
			if (score != 0) {
				eval_text=(eval_text.equals("")?"":eval_text+" ")+"Space score "+score;
			}			
		}
		return score;
	}	

	
	/**
	 * For now just gets HAME value of position
	 * 
	 * @param gs
	 *            GameState
	 * @return int
	 */
	private int getPieceLocationEvaluation(GameState gs) {
		int score = gs.mat.getHAME() + gs.rand_score;
		if (gs.steps_remaining==4) {
			//long good_third_bb = 0x0024420000422400L;
			if (use_frameScore) score += frameScore(gs,false);
			if (use_playerHostageScore) score += playerHostageScore(gs,false);
			if (use_enemyHostageScore) score += enemyHostageScore(gs,false);
			if (use_playerNonDominatedCaptureScore) score += playerNonDominatedCaptureScore(gs,false);
			if (use_enemyNonDominatedCaptureScore) score += enemyNonDominatedCaptureScore(gs,false);
			if (use_playerFalseProtectionScore) score += playerFalseProtectionScore(gs,false);
			if (use_enemyFalseProtectionScore) score += enemyFalseProtectionScore(gs,false);
			if (use_playerGoalDangerScore) score += playerGoalDangerScore(gs,false);
			if (use_enemyGoalDangerScore) score += enemyGoalDangerScore(gs,false);
			score += evalElephantPlace(gs,false);
			score += evalHorsePlace(gs,false);
			score += evalRabbitPlaces(gs,false);
			score += evalFrozenPiecesScore(gs,false);
			score += evalBarelyDominatedScore(gs,false);
			score += evalFrozenBarelyDominatedScore(gs,false);
			score += evalTrapTouchScore(gs,false);
			score += evalSpaceScore(gs,false);
			// a bit of goal prevention security ...
		}
		return score;
		// negative to force sacrifices!
	}

	private static void testEval() {
		ArimaaEvaluate eval = new ArimaaEvaluate();
		for (String temp : text) {
			ArimaaServerInfo info = new ArimaaServerInfo();
			info.gs = new GameState(temp);
			info.gs.compute_tertiary_bitboards();
			LogFile.message(info.gs.toBoardString()+":"+eval.PreProcessRootPosition(info));
			//for(int i = 0;i<eval.scaledScores.length;i++)
			//	LogFile.message(eval.scaledScores[i]+",");
		}
	}
	
	private static String text[] = {
			"12w %13 +-----------------+%138|                 |%137|                 |%136|   R             |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"12w %13 +-----------------+%138|                 |%137| R               |%136|                 |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"12w %13 +-----------------+%138|                 |%137|   R             |%136|                 |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"6b %13 +-----------------+%138| r r r r r r r r |%137|     d     m     |%136| h c         h d |%135|                 |%134|           E     |%133|       D e c H   |%132| R   D   C C   R |%131| R R R M   R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"2w %13 +-----------------+%138| r r r r r r r r |%137| h d c e m c d h |%136|                 |%135|                 |%134|                 |%133|                 |%132| R H C D H C E R |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"4b %13 +-----------------+%138| r r r m   r r r |%137| r h d d c c   r |%136|       e     h   |%135|       E         |%134|                 |%133|   H         H   |%132| R D   M C D   R |%131| R R R C   R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"6w %13 +-----------------+%138| r r r r r r r r |%137|     h     d h   |%136|   c     m   c   |%135|                 |%134|     E           |%133| d H   e     H   |%132| R     C D C   R |%131| R R R D M R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"4b %13 +-----------------+%138| r r r   m r r r |%137|   r c d   d h r |%136|   h     E e H   |%135|         c       |%134|                 |%133|                 |%132| R H C M   C   R |%131| R R R D D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"4b %13 +-----------------+%138| r r r m d r r r |%137| r   c     c   r |%136|   h         h   |%135|                 |%134|       e E       |%133|         d   H   |%132| R H C M   C   R |%131| R R R D D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"36w %13 +-----------------+%138|   r r           |%137| r M r h   d r r |%136|   e R E c       |%135|                 |%134|                 |%133| D       H     R |%132|       C         |%131| R R     R R R   |%13 +-----------------+%13   a b c d e f g h%13",
			"36w %13 +-----------------+%138|     r           |%137| r M r h   d r r |%136|   e R E c       |%135|                 |%134|                 |%133| D       H     R |%132|       C         |%131| R R     R R R   |%13 +-----------------+%13   a b c d e f g h%13",
			"36w %13 +-----------------+%138|                 |%137| r M r h   d r r |%136|   e R E c       |%135|                 |%134|                 |%133| D       H     R |%132|       C         |%131| R R     R R R   |%13 +-----------------+%13   a b c d e f g h%13",
			"36w %13 +-----------------+%138|                 |%137| r M r     d r r |%136|   e R E c       |%135|                 |%134|                 |%133| D       H     R |%132|       C         |%131| R R     R R R   |%13 +-----------------+%13   a b c d e f g h%13",
			"2w %13 +-----------------+%138|   r r r r r r r |%137| h d c e m c d h |%136|                 |%135|                 |%134|                 |%133|                 |%132| R H C D H C E R |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"2w %13 +-----------------+%138| r r r r r r r r |%137| h d   e m c d h |%136|                 |%135|                 |%134|                 |%133|                 |%132| R H C D H C E R |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"2w %13 +-----------------+%138| r r r r r r r r |%137| h   c e m c d h |%136|                 |%135|                 |%134|                 |%133|                 |%132| R H C D H C E R |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"2w %13 +-----------------+%138| r e             |%137|                 |%136|                 |%135|                 |%134|                 |%133|                 |%132| R H C D H C E R |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"72b %13 +-----------------+%138| r   r c       r |%137|   r r   E       |%136|       r r       |%135| h               |%134|               d |%133|             C R |%132| H   e R   D   R |%131|   R             |%13 +-----------------+%13   a b c d e f g h%13",
			"6w %13 +-----------------+%138| r r r r r r r   |%137|   c d     h     |%136|   h   d E   c   |%135|             m r |%134|         e       |%133|   H         H   |%132| R D C     C R   |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"22b %13 +-----------------+%138| r r r m   r r r |%137| r   M   c c     |%136|   R   E         |%135|     d H d     r |%134| R C H h       D |%133|   e         h   |%132|     R       D   |%131| R R R       R   |%13 +-----------------+%13   a b c d e f g h%13",
			"22w %13 +-----------------+%138| r r r         r |%137|     d       r r |%136|       c E r e M |%135|     c   d H   C |%134|     r           |%133|   h   h     H   |%132|       m   D   R |%131| R   D R     R R |%13 +-----------------+%13   a b c d e f g h%13",
			"19b %13 +-----------------+%138| r r r   d   r r |%137| r   c     m r r |%136|       d E H h   |%135|           e R c |%134|     D         M |%133|   H         C   |%132| R     h   D     |%131| R R R C   R R R |%13 +-----------------+%13   a b c d e f g h%13",
			// Elephant blockade
			"20b %13 +-----------------+%138| r r   m r   r r |%137| r R E M r d   r |%136|   d   e D   h   |%135| D         H     |%134|                 |%133|   R         C   |%132|     R     H h   |%131|       R R   R R |%13 +-----------------+%13   a b c d e f g h%13",
			"28w %13 +-----------------+%138| r r r       r r |%137| C   c r       D |%136|       d M     R |%135| C R   R   E h   |%134| R       H e     |%133|       h         |%132|             R   |%131|           R     |%13 +-----------------+%13   a b c d e f g h%13",
			"10w %13 +-----------------+%138| r r r     r r r |%137| r   m c c h   r |%136|   d     E C d   |%135|     h       C   |%134|     D e D       |%133|                 |%132| H   M         H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"17b %13 +-----------------+%138| r r   c h r r r |%137|     m r       d |%136|   d         H   |%135|       r E D e C |%134|           H M h |%133|                 |%132| R D     R R   R |%131| R   R R     R   |%13 +-----------------+%13   a b c d e f g h%13",
			"9w %13 +-----------------+%138| r r r     r r r |%137|   r c d   h r   |%136| M     h d   c   |%135|                 |%134|             E m |%133|         H C C H |%132|         D D e   |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"9w %13 +-----------------+%138| r r r     r r r |%137|   r c d   h r   |%136| M     h d   c   |%135|                 |%134|             E m |%133|         H C C H |%132|     D     D e   |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"9w %13 +-----------------+%138| r r r r r r r r |%137| h M c m   E   d |%136|   e     d   h   |%135|     D     H     |%134|           c     |%133|   C             |%132|       H C     D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"13b %13 +-----------------+%138| r     r r   r r |%137|     r     r     |%136|   d   m E   h   |%135|         c   H   |%134|     r M         |%133|   h   e         |%132| C   H   D     C |%131| R R   R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"13b %13 +-----------------+%138| r     r r   r r |%137|     r     r     |%136|   d   m E   h   |%135|         c   H   |%134|     r M         |%133|   h   e         |%132| C H R   D     C |%131| R R   R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"13w %13 +-----------------+%138| r     r r   r r |%137|     r     r     |%136|   d   m E   h   |%135|         c   H   |%134|     r M         |%133|   h   e         |%132| C H     D     C |%131| R R   R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"20b %13 +-----------------+%138| r r r r   r r r |%137| d     r   c     |%136|   D c d     h   |%135| R h E m         |%134|     H e         |%133|   R   M H   C R |%132|         R       |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"20b %13 +-----------------+%138| r r r r   r r r |%137| d       r c     |%136|   D c d m   h   |%135| R h E e         |%134|     H           |%133|   R   M H   C R |%132|         R       |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"22w %13 +-----------------+%138| r   r     r     |%137|       r r d r   |%136|   h r c h       |%135|                 |%134|     e   E c     |%133|       d m   C r |%132|         R M H D |%131|         R R     |%13 +-----------------+%13   a b c d e f g h%13",
			"23w %13 +-----------------+%138| r   r     r     |%137|       r r d r   |%136|   h   c h       |%135|     r           |%134|     e   E c     |%133|       d   M C r |%132|       R   m H   |%131|         R R   D |%13 +-----------------+%13   a b c d e f g h%13",
			"23w %13 +-----------------+%138| r r H r r r r r |%137| c     m E d     |%136|   d     h   c   |%135|             H   |%134| r M e           |%133|   h             |%132| D   C         D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"22b %13 +-----------------+%138| r r H r r r r r |%137| c     m E d     |%136|   d     h   c   |%135|             H   |%134| r M e           |%133| h               |%132| D   C         D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"22w %13 +-----------------+%138| r r H r r r r r |%137| c   m E   d     |%136|   d     h   c   |%135|             H   |%134| r M e           |%133| h               |%132| D   C         D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"22b %13 +-----------------+%138| r r   c r r r r |%137|         h h d c |%136|   E             |%135|                 |%134|                 |%133| d D     M   D   |%132| H   C   e C     |%131| R R R R R   R R |%13 +-----------------+%13   a b c d e f g h%13",
			"5b %13 +-----------------+%138| r r r r r r r r |%137| d h c   d c h   |%136|   H             |%135|                 |%134|       E       D |%133|       m     e R |%132| D R C M   C H   |%131| R   R R R R R   |%13 +-----------------+%13   a b c d e f g h%13",
			"17b %13 +-----------------+%138| r h r r r r r r |%137|   H     d c h   |%136|   C   E         |%135|     R           |%134|         M d   D |%133| D       R r R R |%132| R e       H     |%131|     R     R     |%13 +-----------------+%13   a b c d e f g h%13",
			"21w %13 +-----------------+%138|                 |%137|   r r     r     |%136| r d   r c   E r |%135| R   h r R e     |%134|       R R   R   |%133|                 |%132|   H D     H   r |%131| C R           C |%13 +-----------------+%13   a b c d e f g h%13",
			"16b %13 +-----------------+%138| r r c   r     r |%137| h d   r m c h R |%136|       e   r     |%135|   r   r   C H   |%134|     H R E M d   |%133| C D         D   |%132| R R R     R R   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"37b %13 +-----------------+%138|       r r   r   |%137|                 |%136|             c   |%135| r             r |%134|       E   e     |%133| r               |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"24b %13 +-----------------+%138|     c r r   r C |%137| d R   r R c R m |%136| R r r         r |%135|   h H           |%134|   C e     E   h |%133|       H D     R |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"37b %13 +-----------------+%138|       r r   r   |%137|                 |%136|             c   |%135| r             r |%134|       E   e     |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"35b %13 +-----------------+%138|       r r   r   |%137|               r |%136|   d         c R |%135| r E             |%134|           e     |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"3b %13 +-----------------+%138| E       D       |%137| R R R           |%136| e           c c |%135| r r             |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"20w %13 +-----------------+%138|                 |%137|   r             |%136|   h   E M   r   |%135|   D d     H r   |%134|       H   c     |%133|       C     C   |%132| R r     D     R |%131| R R R     R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"3b %13 +-----------------+%138| r r r c m r r r |%137| r h c d   d   r |%136|         E       |%135|         h       |%134|             e   |%133|   D         H   |%132| R   H   M D   R |%131| R R R C C R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"4b %13 +-----------------+%138| r r r   m r r r |%137| r h c c       r |%136|       d     d   |%135|                 |%134|         E   e   |%133|   D     h   H   |%132| R   H   M D   R |%131| R R R C C R R R |%13 +-----------------+%13   a b c d e f g h%13",
			"5b %13 +-----------------+%138| r r r     r r r |%137| r h c c   m   r |%136|       d     d   |%135|                 |%134|   D   E         |%133|       h M H e   |%132| R   H     D   R |%131| R R R C C R R R |%13 +-----------------+%13   a b c d e f g h%13", 
			"12w %13 +-----------------+%138| r r             |%137| r c E       e   |%136| R           M   |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			"13w %13 +-----------------+%138| r r             |%137| r   E           |%136| R               |%135|           e     |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
			
			"18w %13 +-----------------+%138| r c     r   d r |%137|     r     r     |%136|             d   |%135|       r         |%134| c C   h   D     |%133| R h D H e   E m |%132| R R R r C H R R |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
			"18b %13 +-----------------+%138| r c     r   d r |%137|     r     r     |%136|             d   |%135|       r         |%134| c C   h   D     |%133| R h D H e   E m |%132| R R R r C H R R |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
			"16b %13 +-----------------+%138| r c     r   d r |%137|     r     r   d |%136|                 |%135|   h   r   h     |%134| c               |%133| R   H C e D E m |%132| R R D r   H   R |%131|     R R C   R R |%13 +-----------------+%13   a b c d e f g h%13",
		};

	// Test stub for eval function
	public static void main(String args[]) {
		LogFile.message("Evaluation tests:");
		testEval();
		//testFAME();
		ArimaaEvaluate eval = new ArimaaEvaluate();
	}
}
