package arimaa3;

import java.io.*;
import java.util.*;

import ai_util.LogFile;

// import ai_util.*;

/** I would prefer name convention with GameState containing root information and Position(s) been computed positions  
 * the convention here uses GameState for computed positions and ArimaaServerInfo root informations. Originally the root position was stored 
 * here just as the EPDstring, but maintaining it as bitboards increases effectiveness. 
 */
public class ArimaaServerInfo {

	public boolean is_rated = true;
	public String enemy_name = "";
	public String sid = "";
	public boolean talking = true;
	public boolean justABot = false;
	public int allowed_hash_size = 50;
	// ignored so far
	public int tc_move = -1;
	public int tc_moveused = -1; // not used variable
	public int moveused = -1; // not used variable
	// Perecentage of left over time transfered to reserve
	public int tc_percent = -1;
	public int tc_max_reserve = -1;
	public int tc_max_turn_time = -1;
	public int side_to_move = -1;
	public int rating=1400;
	public int opponent_rating=1400;
	public int RootStepLimit = 4;
	public int OnceRootStepLimit = 0;
	
	public String move_list = "";
	public String position = "";
	public GameState gs = null;
	// not to initialize after each turn
	public ThreeFoldRepetition repetition_rules = new ThreeFoldRepetition();
	public ArimaaTurnBasedEngine engine = new ArimaaTurnBasedEngine();
	//public ArimaaStepBasedEngine engine = new ArimaaStepBasedEngine();
	
	// All times are in seconds
	public int tc_reserve[] = {-1,-1}; // white, black

	public int tc_game_length = -1; // equals next one neither used
	public int tc_turns = -1;
	// maximal game turn number
	public int tc_total = -1;
	// maximal game total time

	public void newStartPosition(GameState pos) {
		gs = new GameState();
		gs.copy(pos);
		move_list="";
		side_to_move = gs.getSideToMove();
	}
	
	public void chat(String chatMsg) {
		LogFile.message("received chat "+chatMsg+"/"+side_to_move);
		if (chatMsg.startsWith("s")==(side_to_move==0)) {
			// ignore my chat ... does side_to_move = 0 represent silver??
			return;
		}
		chatMsg=chatMsg.substring(chatMsg.indexOf(":")+2);
		LogFile.message("received chat 2 "+chatMsg);
		if (chatMsg.equals("quiet")) {
			talking=false;
		} else if (chatMsg.equals("talk")) {
			talking=true;
		} else {
			if (!justABot) {
				ArimaaEngineInterface.chat("Sorry, I am just a bot. I understand only quiet/talk commands yet");
				justABot=true;
			}
		}
	}
	
	public void ShrinkRules() {
		if(gs.Compress()) {
			engine.init();
		}
	}
	
	public void makeMove(String move_text) {
		repetition_rules.makeMove(this,move_text);
	}
	
	public void newStartPosition(String EPD_position) {
		gs = new GameState(EPD_position);
		move_list="";
		side_to_move = gs.getSideToMove();
	}
	
	public void newGame() {
		gs = new GameState(0);
		move_list="";
		side_to_move = gs.getSideToMove();
	}
	
	public ArimaaServerInfo() {
		newGame();
	}
		/**
	 * Uses only provided position
	 * @param position GameState
	 */
	public ArimaaServerInfo(GameState pos) {
		newStartPosition(pos);
	}

	/**
	 * Uses a gamestate file from arimaa server
	 * @param file_name String
	 */
	public ArimaaServerInfo(String file_name) {
		try {

			// Process the gamestate file from the server
			BufferedInputStream file_reader = new BufferedInputStream(
					new FileInputStream(file_name));
			Properties gameData = new Properties();
			gameData.load(file_reader);

			// Debug purposes only
			// gameData.list(System.out);

			// Figure out who the opponent is
			String enemy_text = "unknown";
			String white_text = gameData.getProperty("wplayer").toLowerCase();
			String black_text = gameData.getProperty("bplayer").toLowerCase();
			String player_text = gameData.getProperty("turn").toLowerCase();

			// Get the name of the opponent
			enemy_text = player_text.equals("w") ? black_text : white_text;
			enemy_text = enemy_text.substring(2);

			enemy_name = enemy_text;
			// Get the position
			move_list = gameData.getProperty("moves");
			position = gameData.getProperty("position");

			// Get the time control info
			String side_to_move_text = gameData.getProperty("turn");
			side_to_move = gameData.getProperty(side_to_move_text)
				.equals("w") ? 0 : 1;
			tc_reserve[0] = Integer.parseInt("tcwreserve");
			tc_reserve[1] = Integer.parseInt("tcbreserve");

			tc_max_reserve = Integer.parseInt(gameData.getProperty("tcmax"));
			if (tc_max_reserve == 0) {
				tc_max_reserve = Integer.MAX_VALUE;
			}

			tc_move = Integer.parseInt(gameData.getProperty("tcmove"));
			tc_game_length = Integer.parseInt(gameData.getProperty(
				"tcgame", "0"));

			tc_total = Integer.parseInt(gameData.getProperty("tctotal"));
			if (tc_total == 0) {
				tc_total = Integer.MAX_VALUE;
			}

			tc_max_turn_time = Integer.parseInt(gameData.getProperty("tcturntime"));
			if (tc_max_turn_time == 0) {
				tc_max_turn_time = Integer.MAX_VALUE;
			}

			tc_percent = Integer.parseInt(gameData.getProperty("tcpercent"));

			// Get rated game info
			String rated = gameData.getProperty("rated");
			is_rated = rated.equals("0") ? false : true;

			// If there is a problem we are dead anyway
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}
}
