package arimaa3;

/**
 * Global constants used by arimaa3
 */
public interface Constants {

	public final int PL_GOLD = 0;
	public final int PL_SILVER = 1;

	public static final String COL_NAMES = "abcdefgh";
	public static final String ROW_NAMES = "12345678";
	public static final String DIR_NAMES = "nsewx";

	// Permissable piece types
	public final int PT_WHITE_RABBIT = 0;
	public final int PT_BLACK_RABBIT = 1;
	public final int PT_WHITE_CAT = 2;
	public final int PT_BLACK_CAT = 3;
	public final int PT_WHITE_DOG = 4;
	public final int PT_BLACK_DOG = 5;
	public final int PT_WHITE_HORSE = 6;
	public final int PT_BLACK_HORSE = 7;
	public final int PT_WHITE_CAMEL = 8;
	public final int PT_BLACK_CAMEL = 9;
	public final int PT_WHITE_ELEPHANT = 10;
	public final int PT_BLACK_ELEPHANT = 11;

	// A bunch of useful bitboards
	// Useful bitboards
	public static final long RANK_1 = 0x00000000000000FFL;
	public static final long RANK_2 = 0x000000000000FF00L;
	public static final long RANK_3 = 0x0000000000FF0000L;
	public static final long RANK_4 = 0x00000000FF000000L;
	public static final long RANK_5 = 0x000000FF00000000L;
	public static final long RANK_6 = 0x0000FF0000000000L;
	public static final long RANK_7 = 0x00FF000000000000L;
	public static final long RANK_8 = 0xFF00000000000000L;
	public static final long GOAL_RANKS = RANK_1 | RANK_8;
	public static final long FILE_A = 0x0101010101010101L;
	public static final long FILE_B = 0x0202020202020202L;
	public static final long FILE_C = 0x0404040404040404L;
	public static final long FILE_D = 0x0808080808080808L;
	public static final long FILE_E = 0x1010101010101010L;
	public static final long FILE_F = 0x2020202020202020L;
	public static final long FILE_G = 0x4040404040404040L;
	public static final long FILE_H = 0x8080808080808080L;
	public static final long RANKS_8765 = RANK_8|RANK_7|RANK_6|RANK_5;
	public static final long RANKS_1234 = RANK_1|RANK_2|RANK_3|RANK_4;
	public static final long RANKS_8743 = RANK_8|RANK_7|RANK_4|RANK_3;
	public static final long RANKS_1256 = RANK_1|RANK_2|RANK_5|RANK_6;
	public static final long RANKS_8642 = RANK_8|RANK_6|RANK_4|RANK_2;
	public static final long RANKS_1357 = RANK_1|RANK_3|RANK_5|RANK_7;

	// All kinds of stuff for the trap eval
	public static final long LL_TRAP = 0x0000000000040000L;
	public static final long UL_TRAP = 0x0000040000000000L;
	public static final long LR_TRAP = 0x0000000000200000L;
	public static final long UR_TRAP = 0x0000200000000000L;

	public static final long LL_TRAP_RING = 0x000000000E0A0E00L;
	public static final long UL_TRAP_RING = 0x000E0A0E00000000L;
	public static final long LR_TRAP_RING = 0x0000000070507000L;
	public static final long UR_TRAP_RING = 0x0070507000000000L;

	public static final long CORNERS = 0x8100000000000081L;
	public static final long TOUCH_CORNERS = ArimaaBaseClass
			.touching_bb(CORNERS);
	public static final long DOUBLE_CORNERS = CORNERS|TOUCH_CORNERS;
	
	public static final long LL_TOUCH1_TRAP = ArimaaBaseClass
			.touching_bb(LL_TRAP);
	public static final long UL_TOUCH1_TRAP = ArimaaBaseClass
			.touching_bb(UL_TRAP);
	public static final long LR_TOUCH1_TRAP = ArimaaBaseClass
			.touching_bb(LR_TRAP);
	public static final long UR_TOUCH1_TRAP = ArimaaBaseClass
			.touching_bb(UR_TRAP);

	public static final long LL_TOUCH2_TRAP = ArimaaBaseClass
			.touching_bb(LL_TOUCH1_TRAP) & ~LL_TRAP;
	public static final long UL_TOUCH2_TRAP = ArimaaBaseClass
			.touching_bb(UL_TOUCH1_TRAP) & ~UL_TRAP;
	public static final long LR_TOUCH2_TRAP = ArimaaBaseClass
			.touching_bb(LR_TOUCH1_TRAP) & ~LR_TRAP;
	public static final long UR_TOUCH2_TRAP = ArimaaBaseClass
			.touching_bb(UR_TOUCH1_TRAP) & ~UR_TRAP;

	public static final long LL_CONTROL = LL_TOUCH1_TRAP & ~UL_TOUCH2_TRAP;
	public static final long UL_CONTROL = UL_TOUCH1_TRAP & ~LL_TOUCH2_TRAP;
	public static final long LR_CONTROL = LR_TOUCH1_TRAP & ~UR_TOUCH2_TRAP;
	public static final long UR_CONTROL = UR_TOUCH1_TRAP & ~LR_TOUCH2_TRAP;

	public static final long LL_TOUCH3_TRAP = ArimaaBaseClass
			.touching_bb(LL_TOUCH2_TRAP) & ~LL_TOUCH1_TRAP;
	public static final long UL_TOUCH3_TRAP = ArimaaBaseClass
			.touching_bb(UL_TOUCH2_TRAP) & ~LL_TOUCH1_TRAP;
	public static final long LR_TOUCH3_TRAP = ArimaaBaseClass
			.touching_bb(LR_TOUCH2_TRAP) & ~LL_TOUCH1_TRAP;
	public static final long UR_TOUCH3_TRAP = ArimaaBaseClass
			.touching_bb(UR_TOUCH2_TRAP) & ~LL_TOUCH1_TRAP;

	public static final long LL_QUADRANT = 0x000000000F0F0F0FL;
	public static final long UL_QUADRANT = 0x0F0F0F0F00000000L;
	public static final long LR_QUADRANT = 0x00000000F0F0F0F0L;
	public static final long UR_QUADRANT = 0xF0F0F0F000000000L;

	public static final long TRAP[] = { LL_TRAP, LR_TRAP, UL_TRAP, UR_TRAP };
	public static final int TRAP_INDEX[] = { 18, 21, 42, 45 };// 010010, 010101, 101010, 101101
	public static final long TOUCH_TRAP[] = { LL_TOUCH1_TRAP, LR_TOUCH1_TRAP, UL_TOUCH1_TRAP, UR_TOUCH1_TRAP };
	public static final long TOUCH2_TRAP[] = { LL_TOUCH2_TRAP, LR_TOUCH2_TRAP, UL_TOUCH2_TRAP, UR_TOUCH2_TRAP };
	public static final long TRAP_PHALANXES[] = { LL_TOUCH1_TRAP|LL_TOUCH2_TRAP|(LL_QUADRANT&DOUBLE_CORNERS), 
		LR_TOUCH1_TRAP|LR_TOUCH2_TRAP|(LR_QUADRANT&DOUBLE_CORNERS), 
		UL_TOUCH1_TRAP|UL_TOUCH2_TRAP|(UL_QUADRANT&DOUBLE_CORNERS), 
		UR_TOUCH1_TRAP|UR_TOUCH2_TRAP|(UR_QUADRANT&DOUBLE_CORNERS)};
	public static final long TOUCH3_TRAP[] = { LL_TOUCH3_TRAP, LR_TOUCH3_TRAP, UL_TOUCH3_TRAP, UR_TOUCH3_TRAP };
	public static final long TRAP_RING[] = { LL_TRAP_RING, LR_TRAP_RING, UL_TRAP_RING, UR_TRAP_RING };
	public static final long QUADRANT[] = { LL_QUADRANT, LR_QUADRANT, UL_QUADRANT, UR_QUADRANT };
	public static final long CONTROL[] = { LL_CONTROL, LR_CONTROL, UL_CONTROL, UR_CONTROL };
	
	// Used to determine if a step can effect a trap square
	public static int trap_number[] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 00, -1, -1,
			01, -1, -1, -1, 00, -1, 00, 01, -1, 01, -1, -1, -1, 00, -1, -1, 01,
			-1, -1, -1, -1, 02, -1, -1, 03, -1, -1, -1, 02, -1, 02, 03, -1, 03,
			-1, -1, -1, 02, -1, -1, 03, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, };
	
	public static final long TRAP_SQUARES = 0x0000240000240000L;
	public static final long NON_TRAP_SQUARES = ~TRAP_SQUARES;
	public static final long TOUCH_TRAPS = ArimaaBaseClass.touching_bb(TRAP_SQUARES);
	public static final long TWO_TO_TRAPS =ArimaaBaseClass.touching_bb(TOUCH_TRAPS)&NON_TRAP_SQUARES; 
	public static final long FILE_ED_TOUCH_TRAPS = TOUCH_TRAPS & (FILE_D|FILE_E);
	public static final long AMONG_TRAPS = TOUCH_TRAPS & (FILE_D|FILE_E|RANK_3|RANK_4);
	public static final long NON_TOUCH_TRAPS = ~TOUCH_TRAPS;
	public static final long RANK_TOUCH_TRAPS = ArimaaBaseClass.right_bb(TRAP_SQUARES) | ArimaaBaseClass.left_bb(TRAP_SQUARES);
	public static final long NO_RANK_TOUCH_TRAPS = ~RANK_TOUCH_TRAPS;
	public static final long FILE_TOUCH_TRAPS = ArimaaBaseClass.up_bb(TRAP_SQUARES) | ArimaaBaseClass.down_bb(TRAP_SQUARES);
	public static final long TRAPS_TO_GOAL = TOUCH_TRAPS & (RANK_7 | RANK_2); 
	public static final long SMALL_CENTRE = 0x0000001818000000L;
	public static final long LARGE_CENTRE = 0x00003C3C3C3C0000L;
	public static final long OUTSIDE_EDGE = 0xFF818181818181FFL;

	public static final long NOT_FILE_A = ~FILE_A;
	public static final long NOT_FILE_H = ~FILE_H;
	public static final long NOT_RANK_1 = ~RANK_1;
	public static final long NOT_RANK_2 = ~RANK_2;
	public static final long NOT_RANK_3 = ~RANK_3;
	public static final long NOT_RANK_4 = ~RANK_4;
	public static final long NOT_RANK_5 = ~RANK_5;
	public static final long NOT_RANK_6 = ~RANK_6;
	public static final long NOT_RANK_7 = ~RANK_7;
	public static final long NOT_RANK_8 = ~RANK_8;
	public static final long NOT_GOAL_RANKS = ~GOAL_RANKS;

	public static final long FULL_BB = ~0L;

	// Saves typing
	public static final boolean TR = true;
	public static final boolean FL = false;

	// Values used in alpha/beta search
	public static final int SCORE_UNKNOWN = 11111111;
	public static final int SCORE_INFINITY = 100000;
	public static final int SCORE_MATE = 32767; // 32768 or higher breaks hash
												// table implementation
	public static final int SCORE_THREAT = 5000;
	public static final int SCORE_DRAW = 0;
	public static final int SCORE_FORCED_WIN = 30000;
	public static final int SCORE_FORCED_LOSS = -SCORE_FORCED_WIN;

	public static final int MAX_STEP_PLY = 100; // Maximum number of ply step engine will search
	public static final int MAX_TURN_PLY = 25; // Maximum number of ply step engine will search

}
