// create genetics algorithm to select optimal factors for evaluation
// using internal games of one evaluation parameters against others on 2 ply as a "gen quality test"
// logging the games in "genetics"
// crossing gens splitting in i-th parameter 
// mutation of masked parameters ... binary mask, binary number, random number 2<x<100
// parameters equal to binary_number except the binary mask are multiplied by Y={\root 5 \of x} or 1/Y 
// depending on the highest bit of the binary mask.
// mask adresses rows and cols in the "parameter file"
//
// generation size ...
// selection ...
//
// first try should be on P1 bots! ... P1 bots would be very low guided by evaluation
// test on P2 bots would be much more important, but much more slower
// Population of 20 gens
// Making random pairs and play P1 game lasting at most 150 turns. If a gen wins put it to parents.
// Repeat till 7-14 gens are selected. Pair sequentionaly the gens and for each pair make play a game and add the winner (if exists) 
// and replace the original gens with their crosses. If there is less then 20 gens continue by making random pairs.
// For each gen with prob 1/3 make mutation up and independendtly with prob 1/3 make mutation down.
package arimaa3;

import java.util.*;

import ai_util.LogFile;
import ai_util.MoveInfo;
import ai_util.Util;

//import ai_util.*;
//import java.util.*;
public class EvaluationGenetics {
	static int scale=10000;
	static int pop_size=20;//100;
	static int generation_cnt=0;
	public static ArimaaEvaluate baseEval = new ArimaaEvaluate();//the default one
	static int [][] population=new int[pop_size][baseEval.copyFactors().length];
	static int [][] parents=new int[pop_size][baseEval.copyFactors().length];
	static int KillerLength=1;
	static private Random random = new Random(44);
	static private TestForGoal goal = new TestForGoal();
	static private HashSet<Long> positionForbidden = new HashSet<Long>();
	static private int side_to_move=0;
	static private GenTurn gen_turn = new GenTurn();;
	static private MoveList turns=new MoveList(true);

	
	public static void init() {
		for (int i = 0; i < pop_size; i++) {
			parents[i]=baseEval.copyFactors();
		}
		mutatePopulation();
	}
	
	public static void copyGen(int [] sourceGen,int [] destGen) {
		System.arraycopy(sourceGen,0,destGen,0,sourceGen.length);
	}
	
	public static String array2BinString(int [] gen) {
		StringBuilder result=new StringBuilder();
		for(int i=0;i<gen.length;i++) {
			result.append(gen[i]+",");
			for(int j=Util.PopCnt(i^(i+1));j>1;j--) {
				result.append(" ");
			}
		}
		return result.toString();
	}
	
	public static int playPly1(ArimaaEvaluate[] eval) {//TODO repetition!! unplayMove !!!
		GameState gs=new GameState(0);
		MoveInfo moveI;
		String game="";
		while (gs.getTurnNumber()<=150) {
			side_to_move=gs.player;
			moveI = new MoveInfo();
			if (gs.getTurnNumber() <= 1) {
				FirstMove first_move = new FirstMove();
				moveI = new MoveInfo();
				long random_seed = System.currentTimeMillis();
				String text = first_move.getFirstMove(gs, random_seed);
				moveI.move_text = text;
			} else {
				int highestOrderingValue=-Constants.SCORE_INFINITY;
				ArimaaMove bestMove=null;
				turns.clear(); // Ply1 ... otherwise rather levelUp, levelDn
				gen_turn.genNonLosingTurns(gs, turns);
				for (turns.levelNext();turns.levelCont();turns.levelNext()) {
					ArimaaMove move = turns.getCurrentMove();
					gs.playMoveFull(move);
					if (gs.isGameOver()) {
						move.move_ordering_value = gs.getGameResult();
					}
					else if (positionForbidden.contains(gs.getPositionHash())) {
						move.move_ordering_value = -Constants.SCORE_MATE;
					}
					else if (goal.test(gs)) {
						move.move_ordering_value = -Constants.SCORE_MATE + 1;
					}
					else if (move.fasterRevertExists(gs)) {
						move.move_ordering_value = -Constants.SCORE_MATE + 2;
					}
					else {
						move.move_ordering_value = -eval[side_to_move].Evaluate(gs);
					}
					// moves.sort();
					if (move.move_ordering_value>highestOrderingValue) {
						highestOrderingValue=move.move_ordering_value;
						bestMove=move;
					}
				}
				if (bestMove==null) {
					moveI.move_text=" resign";
				} else {
					//LogFile.write(" "+bestMove);
					moveI.move_text = " "+gen_turn.getOfficialArimaaNotation(gs, bestMove);
				}
			}
			game+=" "+gs.getTurnNumber()+((gs.player==0)?"w":"b")+moveI.move_text;
			//LogFile.write(""+gs.getTurnNumber()+((gs.player==0)?"w":"b")+moveI.move_text);
			if (moveI.move_text.equals(" resign")) {
				LogFile.writeln(game);
				int result=(gs.player==0)?-1:1;
				return result;
			}
			ArimaaMove move=new ArimaaMove(moveI.move_text);
			gs.playMoveFull(move);
			side_to_move=gs.player;
			long curr_hash = gs.getPositionHash();
			if ((move.info_mask & (ArimaaMove.SETUP_MARK|ArimaaMove.CAPTURE_COUNTS))!=0) {
				positionForbidden = new HashSet<Long>();
			} else {
				positionForbidden.add(curr_hash);
			}
			if (gs.getTurnNumber() > 1) {
				if (gs.isGameOver()) {
					LogFile.writeln(game);
					int result=gs.getGameResult();
					return ((result>0)==(gs.player==1))?1:-1;// tried 2 options
				}
			}
		}
		LogFile.writeln(game);		
		return 0;
	}
	
	public static int playPly2(ArimaaEvaluate[] eval) {//TODO repetition!! unplayMove !!!
		GameState gs=new GameState(0),gs_re=new GameState();
		MoveInfo moveI;
		String game="";
		ArimaaMove turn,replyTurn=null;
		ArimaaMove [] Killers=new ArimaaMove[KillerLength];
		for(int i=0;i<Killers.length;i++) {
			Killers[i]=new ArimaaMove();
		}
		long prevTime=System.currentTimeMillis();
		while (gs.getTurnNumber()<=150) {
			side_to_move=gs.player;
			moveI = new MoveInfo();
			if (gs.getTurnNumber() <= 1) {
				FirstMove first_move = new FirstMove();
				moveI = new MoveInfo();
				long random_seed = System.currentTimeMillis();
				String text = first_move.getFirstMove(gs, random_seed);
				moveI.move_text = text;
			} else {
				ArimaaMove bestTurn=null;
				int alpha=-Constants.SCORE_INFINITY, beta=Constants.SCORE_INFINITY;
				turns.clear();
				gen_turn.genNonLosingTurns(gs, turns);
				int ini_list_length=turns.range_stack[turns.stack_ind];
				turns.levelReWrite();
				for (turns.levelFirst();turns.depth_ind[turns.stack_ind]<=ini_list_length;turns.levelNext()){ 
					turn = turns.getCurrentMove(); 
					gs.playMoveFull(turn);
					if (gs.isGameOver()) {
						turn.move_ordering_value = gs.getGameResult();
						turns.getMove().copy(turn);
					}
					else if (positionForbidden.contains(gs.getPositionHash())) {
						//turn.move_ordering_value = -Constants.SCORE_MATE;
					}
					else if (goal.test(gs)) {
						turn.move_ordering_value = -Constants.SCORE_MATE + 1;
						turns.getMove().copy(turn);
					}
					else if (turn.fasterRevertExists(gs)) {
						turn.move_ordering_value = -Constants.SCORE_MATE + 2;
						turns.getMove().copy(turn);
					}
					else {
						turn.move_ordering_value = -eval[side_to_move].Evaluate(gs);
						turns.getMove().copy(turn);
					}
				}
				for(int i=0;i<Killers.length;i++) {
					Killers[i].clear();
				}
				int killerIndex=0;
				turns.levelSort();
				int [] bestScores=null; int [] p1scores=null;
				int [] reinforcement=null;
				boolean killerAlphaCut,scoresKnown;
				for (turns.levelFirst();turns.levelCont();turns.levelNext()) {
					turn = turns.getCurrentMove();
					gs.playMoveFull(turn);
					scoresKnown=false;
					killerAlphaCut=false;
					for(int i=0;i<Killers.length;i++) {
						if ((replyTurn=Killers[i]).steps>0) {// already set
							if (gs.isKillerConsistent(replyTurn)) {
								gs.playMoveFull(replyTurn);
								if (gs.trapsOK()) {
									int b=-eval[side_to_move].Evaluate(gs);// hoping this is much faster than isTurnLegal
									if (b>-alpha) {
										if (gen_turn.isTurnLegal(gs,replyTurn)) {
											killerAlphaCut=true;
											break;
										}
									}
								}
							}
						}
					}
					if (killerAlphaCut) continue;
					int a = -gen_turn.getBestEvaluatedTurn(gs_re, replyTurn, eval[side_to_move], positionForbidden, -alpha);
					if (a<alpha) {
						if (Killers.length>0) {
							Killers[killerIndex++]=replyTurn;
							killerIndex%=Killers.length;
						}
					}
					if (a>alpha) {
						if (!scoresKnown) {
							eval[side_to_move].Evaluate(gs_re);
							p1scores=eval[side_to_move].copyScores();
							scoresKnown=true;
							if (bestScores==null) {
								bestScores=p1scores.clone();
								reinforcement=new int[bestScores.length];
								// filled with 0 by default
							} else {
								int [] difference=new int[bestScores.length];
								long abssum=0;
								for(int i=0;i<difference.length;i++) {
									difference[i]=bestScores[i]-p1scores[i];
									abssum += Math.abs(difference[i]);
								}
								if (abssum!=0) {
									long pick=random.nextLong()%abssum;
									pick+=(pick<0)?abssum:0;
									for(int i=0;i<difference.length;i++) {
										pick-=Math.abs(difference[i]);
										if (pick<0) {
											reinforcement[i]+=(difference[i]>0)?-1:1;
											break;
										}
									}
								}
							}
						}
						bestTurn=turn;alpha=a;
					}
				}
				if (bestTurn==null) {
					moveI.move_text=" resign";
				} else {
					long thisTime=System.currentTimeMillis();
					LogFile.writeln(" "+bestTurn+" "+(thisTime-prevTime)+"ms "+array2BinString(reinforcement));
					int [] fact = eval[side_to_move].copyFactors();
					for(int i=0;i<reinforcement.length;i++) {fact[i]+=reinforcement[i];}
					eval[side_to_move]=new ArimaaEvaluate(fact);
					prevTime=thisTime;
					moveI.move_text = " "+gen_turn.getOfficialArimaaNotation(gs, bestTurn);
				}
			}
			game+=" "+gs.getTurnNumber()+((gs.player==0)?"w":"b")+moveI.move_text;
			//LogFile.write(""+gs.getTurnNumber()+((gs.player==0)?"w":"b")+moveI.move_text);
			if (moveI.move_text.equals(" resign")) {
				LogFile.writeln(game);
				int result=(gs.player==0)?-1:1;
				return result;
			}
			ArimaaMove move=new ArimaaMove(moveI.move_text);
			gs.playMoveFull(move);
			side_to_move=gs.player;
			long curr_hash = gs.getPositionHash();
			if ((move.info_mask & (ArimaaMove.SETUP_MARK|ArimaaMove.CAPTURE_COUNTS))!=0) {
				positionForbidden = new HashSet<Long>();
			} else {
				positionForbidden.add(curr_hash);
			}
			if (gs.getTurnNumber() > 1) {
				if (gs.isGameOver()) {
					LogFile.writeln(game);
					int result=gs.getGameResult();
					return ((result>0)==(gs.player==1))?1:-1;// tried 2 options
				}
			}
		}
		LogFile.writeln(game);		
		return 0;
	}
	
	public static void crossParents(int fotherInd,int motherInd) {
		int crossOffs = random.nextInt()&0x7f; 
		LogFile.writeln("crossOffs="+crossOffs);
		for(int i=crossOffs;i<parents[fotherInd].length;i++) {
			int tmp = parents[fotherInd][i];
			parents[fotherInd][i]=parents[motherInd][i];
			parents[motherInd][i]=tmp;
		}
	}
	
	public static void mutate(int [] gen, int factor) {
		int muteFullMask = random.nextInt();
		int muteOffs = muteFullMask & 0x7f;  
		int muteMask = (muteFullMask >> 7) & 0x7f;
		LogFile.writeln("muteOffs="+muteOffs+", "+"muteMask="+muteMask+", factor="+factor);
		for(int i=0;i<gen.length;i++) {
			if (((i^muteOffs)&muteMask)==0) {
				gen[i] =(int) (((long)(gen[i])*factor)/scale);
				gen[i] = (gen[i]>scale?scale:gen[i]);
				gen[i] = (gen[i]==0?1:gen[i]);
			}
		}
	}
	
	public static void mutateUp(int [] gen) {
		int factor = random.nextInt()%(scale);
		factor+=(factor<=0)?scale:0;
		factor=(int) (Math.sqrt(factor*scale));
		for(int i=0;i*i<generation_cnt;i++) {
			factor=(int) (Math.sqrt(factor*scale));
		}
		mutate(gen,(scale*scale)/factor);
	}
	
	public static void mutateDn(int [] gen) {
		int factor = random.nextInt()%(scale);
		factor+=(factor<=0)?scale:0;
		factor=(int) (Math.sqrt(factor*scale));
		for(int i=0;i*i<generation_cnt;i++) {
			factor=(int) (Math.sqrt(factor*scale));
		}
		mutate(gen,factor);		
	}
	
	public static int getResult(int [] goldGen,int [] silverGen) {
		LogFile.writeln(""+generation_cnt);
		LogFile.writeln("gold:   "+array2BinString(goldGen));
		LogFile.writeln("silver: "+array2BinString(silverGen));
		ArimaaEvaluate [] evals = {new ArimaaEvaluate(goldGen), new ArimaaEvaluate(silverGen)}; 
		KillerLength=(1+KillerLength)%4;
		LogFile.writeln("Killer length: "+KillerLength);
		int result=playPly2(evals); // writes the movestring at the end
		LogFile.writeln("goldGen at start:"+array2BinString(goldGen));
		evals[0].copyFactors(goldGen);
		LogFile.writeln("goldGen at return:"+array2BinString(goldGen));
		LogFile.writeln("silverGen at start:"+array2BinString(silverGen));
		evals[1].copyFactors(silverGen);
		LogFile.writeln("silverGen at return:"+array2BinString(silverGen));
		//int result=playPly1(evals); // writes the movestring at the end
		LogFile.writeln("result: "+result);
		return result;
	}
	
	public static void testResult() {
		ArimaaEvaluate [] evals = {new ArimaaEvaluate(population[0]),baseEval};
		KillerLength=(1+KillerLength)%4;
		LogFile.writeln("Killer length: "+KillerLength);
		int result=playPly2(evals); // writes the movestring at the end
		LogFile.writeln("goldGen at start:"+array2BinString(population[0]));
		population[0]=evals[0].copyFactors();
		LogFile.writeln("goldGen at return:"+array2BinString(population[0]));
		//int result=playPly1(evals); // writes the movestring at the end
		LogFile.writeln("generation["+generation_cnt+"]/base test: "+result);		
	}
	
	public static void chooseParents() {
		int [] selection_cnt = new int [pop_size];
		for (int i=0;i<pop_size;i++) selection_cnt[i]=0;
		int sel_i=0,choices,choice,num_parents=0;
		int gold=0,silver=0;
		while (num_parents<pop_size/3) {
			choices=pop_size; // even
			while(choices>0) {
				choice=random.nextInt()%choices;
				choice+=(choice<0)?choices:0;
				choices--;
				for (int i=0;i<pop_size;i++) {
					if (selection_cnt[i]==sel_i) {
						if (choice==0) {
							gold=i;
							selection_cnt[i]=sel_i+1;
						}
						choice--;
					}
				}
				choice=random.nextInt()%choices;
				choice+=(choice<0)?choices:0;
				choices--;
				for (int i=0;i<pop_size;i++) {
					if (selection_cnt[i]==sel_i) {
						if (choice==0) {
							silver=i;
							selection_cnt[i]=sel_i+1;
						}
						choice--;
					}
				}
				LogFile.writeln("gold at getResult(1) call "+array2BinString(population[gold]));
				LogFile.writeln("silver at getResult(1) call "+array2BinString(population[silver]));
				int result=getResult(population[gold],population[silver]);
				LogFile.writeln("gold after getResult(1) return "+array2BinString(population[gold]));
				LogFile.writeln("silver after getResult(1) return "+array2BinString(population[silver]));
				if (result!=0) {
					if (result==1) {//gold wins
						copyGen(population[gold],parents[num_parents]);
					} else {// silver wins
						copyGen(population[silver],parents[num_parents]);
					}
					LogFile.writeln("parents["+num_parents+"]="+array2BinString(parents[num_parents]));
					num_parents++;
				}
			}
			sel_i++;
		}
		silver=num_parents&~1;gold=silver-1;
		while ((silver>0) && (num_parents<pop_size)) {
			LogFile.writeln("gold at getResult(2) call "+array2BinString(parents[gold]));
			LogFile.writeln("silver at getResult(2) call "+array2BinString(parents[silver]));
			int result=getResult(parents[gold],parents[silver]);
			LogFile.writeln("gold after getResult(2) return "+array2BinString(parents[gold]));
			LogFile.writeln("silver after getResult(2) return "+array2BinString(parents[silver]));
			if (result!=0) {
				if (result==1) {//gold wins
					copyGen(parents[gold],parents[num_parents]);
					LogFile.writeln("parents["+num_parents+"]="+array2BinString(parents[num_parents]));
				} else {// silver wins
					copyGen(parents[silver],parents[num_parents]);
					LogFile.writeln("parents["+num_parents+"]="+array2BinString(parents[num_parents]));
				}
				num_parents++;
			}
			crossParents(gold,silver);
			LogFile.writeln("parents["+gold+"]="+array2BinString(parents[gold]));
			LogFile.writeln("parents["+silver+"]="+array2BinString(parents[silver]));
			silver-=2;gold-=2;
		}
		while (num_parents<pop_size) {
			silver=random.nextInt()%num_parents;
			silver+=(silver<0)?num_parents:0;
			gold=random.nextInt()%num_parents;
			gold+=(gold<0)?num_parents:0;
			LogFile.writeln("gold at getResult(3) call "+array2BinString(parents[gold]));
			LogFile.writeln("silver at getResult(3) call "+array2BinString(parents[silver]));
			int result=getResult(parents[gold],parents[silver]);
			LogFile.writeln("gold after getResult(3) return "+array2BinString(parents[gold]));
			LogFile.writeln("silver after getResult(3) return "+array2BinString(parents[silver]));
			if (result!=0) {
				if (result==1) {//gold wins
					copyGen(parents[gold],parents[num_parents]);
					LogFile.writeln("parents["+num_parents+"]="+array2BinString(parents[num_parents]));
				} else {// silver wins
					copyGen(parents[silver],parents[num_parents]);
					LogFile.writeln("parents["+num_parents+"]="+array2BinString(parents[num_parents]));
				}
				num_parents++;
			}
			crossParents(gold,silver);
			LogFile.writeln("parents["+gold+"]="+array2BinString(parents[gold]));
			LogFile.writeln("parents["+silver+"]="+array2BinString(parents[silver]));
		}
	}

	public static void mutatePopulation() {
		for(int i=0;i<pop_size;i++) {
			LogFile.writeln("parents["+i+"]="+array2BinString(parents[i]));
			if ((random.nextInt()%3)==0) {
				mutateUp(parents[i]);
				LogFile.writeln("Up parents["+i+"]="+array2BinString(parents[i]));
			}
			if ((random.nextInt()%3)==0) {
				mutateDn(parents[i]);
				LogFile.writeln("Dn parents["+i+"]="+array2BinString(parents[i]));
			}
			copyGen(parents[i],population[i]);
			LogFile.writeln("population["+i+"]="+array2BinString(population[i]));
		}
	}	
	
	public static void main(String args[]) {
		init();
		while (true) {
			// to be interrrupted
			// getResult logs generation, gens and the game
			//for(int i=0;i<pop_size;i++) {
			//	LogFile.write(gen2String(population[i]));
			//}
			testResult();
			chooseParents();
			mutatePopulation();
			generation_cnt++;
		}
	}
}