package arimaa3;

import java.util.*;
import java.io.*;

import ai_util.LogFile;

//import ai_util.*;
//import java.util.*;
public class ExpertsLearning {

	static private HashMap<String,ArimaaEvaluate> genom = new HashMap<String,ArimaaEvaluate>();

	static ArimaaEvaluate gold, silver, general; 
	static String dirS="gens";
	static private Random random = new Random(44);
	static private TestForGoal goal = new TestForGoal();
	static private HashSet<Long> positionForbidden = new HashSet<Long>();
	static private int side_to_move=0;
	static private GenTurn gen_turn = new GenTurn();;
	static private MoveList turns=new MoveList(true);
	static int gamesPlayed=0;
	
	private static void readGens(){
		File dir = new File(dirS);
		String[] chld = dir.list();
		if(chld == null){
			dirS = "..\\gens";
			dir = new File(dirS);
		}
		if(chld == null){
			System.out.println("gens empty");
		} else {
			try {
				for(int i = 0; i < chld.length; i++){
					String [] genArray;
					String line,gen,fileName = chld[i];
					System.out.println(fileName);
					BufferedReader file_reader = 
						new BufferedReader(new FileReader(dirS+"\\"+fileName));
					gen="";
					while ((line = file_reader.readLine()) != null) {
						gen=line; // last line is the current gen to be used
					}
					gen = gen.trim();
					genArray = gen.split(",");
					general = new ArimaaEvaluate();
					int [] factors = general.copyFactors();
					for(int j=0;j<factors.length;j++) {
						if (j>=genArray.length) {
							break;
						}
						factors[i]=Integer.parseInt(genArray[i].trim());
					}
					general = new ArimaaEvaluate(factors);
					genom.put(fileName, general);
				}
			} catch (Exception ex) {
				System.err.println("ReadGens: Unknown error!");
				ex.printStackTrace();
			}
		}
	}
	
	private static void saveGens() {
		for (String key : genom.keySet()) {
			ArimaaEvaluate value = genom.get(key);
			LogFile.writeln(dirS+"\\"+key,EvaluationGenetics.array2BinString(value.copyFactors()));
		}
	}
	
	static void learning() {// TODO unplayMove not added yet !!!
		try {
			BufferedReader file_reader = new BufferedReader(new FileReader("\\arimaa\\movelist.txt"));
			String movelist_text = "";
			String data;
			String gold_key, silver_key;
			String [] fields;
			if (genom.containsKey("general")) {
				general = genom.get("general");
			} else {
				general = new ArimaaEvaluate();
				genom.put("general", general);
			}
			while ((data = file_reader.readLine()) != null) {
				data = data.replace('|', '#');
				fields = data.split("#");
				String game_number = fields[0];
				gold_key = fields[1];
				if (genom.containsKey(gold_key)) {
					gold = genom.get(gold_key);
				} else {
					gold = new ArimaaEvaluate();
					genom.put(gold_key, gold);
				}
				silver_key = fields[2];
				if (genom.containsKey(silver_key)) {
					silver = genom.get(silver_key);
				} else {
					silver = new ArimaaEvaluate();
					genom.put(silver_key, silver);
				}
				System.out.println();
				System.out.print(game_number+" "+gold_key+" x "+silver_key);
				movelist_text=fields[3]+"%13";
				String[] move_list=movelist_text.split("%13");
				GameState gs = new GameState();gs.steps_remaining=4;gs.turn=1;
				ArimaaEvaluate [] eval = {gold, silver};
				ArimaaMove bestPlayerTurn, bestGeneralTurn;
				for (String move_text_with_turn_number : move_list) {
					int pos_start = move_text_with_turn_number.indexOf(" ")+1;
					String move_text = move_text_with_turn_number.substring(pos_start);
					if (pos_start==0) break;
					int highestPlayerOrderingValue, highestGeneralOrderingValue 
						= highestPlayerOrderingValue = -Constants.SCORE_INFINITY;;
					bestGeneralTurn=bestPlayerTurn=null;
					ArimaaMove turn,chosenTurn = new ArimaaMove(move_text);
					if (gs.turn>1) {
						side_to_move=gs.player;
						turns.clear(); // Ply1 ... otherwise rather levelUp, levelDn
						gen_turn.genNonLosingTurns(gs, turns);
						for (turns.levelFirst();turns.levelCont();turns.levelNext()) {
							turn = turns.getCurrentMove();
							gs.playMoveFull(turn);
							boolean finiteOrder=false;
							if (gs.isGameOver()) {
								turn.move_ordering_value = gs.getGameResult();
							}
							else if (positionForbidden.contains(gs.getPositionHash())) {
								turn.move_ordering_value = -Constants.SCORE_MATE;
							}
							else if (goal.test(gs)) {
								turn.move_ordering_value = -Constants.SCORE_MATE + 1;
							}
							else if (turn.fasterRevertExists(gs)) {
								turn.move_ordering_value = -Constants.SCORE_MATE + 2;
							}
							else {
								finiteOrder=true;
								turn.move_ordering_value = -eval[side_to_move].Evaluate(gs);
							}
							// moves.sort();
							if (turn.move_ordering_value>highestPlayerOrderingValue) {
								highestPlayerOrderingValue=turn.move_ordering_value;
								bestPlayerTurn=turn;
							}
							if (finiteOrder) {
								turn.move_ordering_value = -general.Evaluate(gs);
							}
							if (turn.move_ordering_value>highestGeneralOrderingValue) {
								highestGeneralOrderingValue=turn.move_ordering_value;
								bestGeneralTurn=turn;
							}
						}
						if (bestPlayerTurn != null) {
							gs.playMoveFull(chosenTurn);
							eval[side_to_move].Evaluate(gs);
							int [] chosenScores = eval[side_to_move].copyScores(); 
							gs.playMoveFull(bestPlayerTurn);
							eval[side_to_move].Evaluate(gs);
							int [] playerScores = eval[side_to_move].copyScores(); 
							int [] difference=new int[chosenScores.length];
							long abssum=0;int difcnt=0;
							for(int i=0;i<difference.length;i++) {
								difference[i]=playerScores[i]-chosenScores[i];
								if (difference[i]!=0) {
								    abssum += Math.abs(difference[i]);
								    difcnt++;
								}
							}
							if (difcnt!=0) {
								long pick=random.nextLong()%(abssum+100*difcnt);
								pick+=(pick<0)?(abssum+100*difcnt):0;		
								long oripick=pick;
								for(int i=0;i<difference.length;i++) {
									pick-=difference[i]==0?0:100+Math.abs(difference[i]);
									if (pick<0) {
										int [] tmp_f = eval[side_to_move].copyFactors();
										tmp_f[i]+=(difference[i]>0)?-1:1;
										if (tmp_f[i]==0) {// rather -1 than 0!
											tmp_f[i]+=(difference[i]>0)?-1:1;											
										}
										System.out.print(" "+gs.turn+" "+side_to_move+" "+oripick+";"+abssum+"/"+difcnt+" "+i+((difference[i]>0)?"-":"+"));
										eval[side_to_move]=new ArimaaEvaluate(tmp_f);
										break;
									}
								}
							}
						}
						if (bestGeneralTurn != null) {
							gs.playMoveFull(chosenTurn);
							general.Evaluate(gs);
							int [] chosenScores = general.copyScores();
							gs.playMoveFull(bestGeneralTurn);
							general.Evaluate(gs);
							int [] generalScores = general.copyScores();
							int [] difference=new int[chosenScores.length];
							long abssum=0;int difcnt=0;
							for(int i=0;i<difference.length;i++) {
								difference[i]=generalScores[i]-chosenScores[i];
								if (difference[i]!=0) {
								    abssum += Math.abs(difference[i]);
								    difcnt++;
								}
							}
							if (abssum!=0) {
								long pick=random.nextLong()%(abssum+100*difcnt);
								pick+=(pick<0)?(abssum+100*difcnt):0;
								long oripick=pick;
								for(int i=0;i<difference.length;i++) {
									pick-=difference[i]==0?0:100+Math.abs(difference[i]);
									if (pick<0) {
										int [] tmp_f=general.copyFactors();
										tmp_f[i]+=(difference[i]>0)?-1:1;
										if (tmp_f[i]==0) {// rather -1 than 0!
											tmp_f[i]+=(difference[i]>0)?-1:1;											
										}
										System.out.print(" "+gs.turn+" "+oripick+";"+abssum+"/"+difcnt+" g"+i+((difference[i]>0)?"-":"+"));
										general=new ArimaaEvaluate(tmp_f);
										break;
									}
								}
							}
						}
					}
					gs.playMoveFull(chosenTurn);
					long curr_hash = gs.getPositionHash();
					if ((chosenTurn.info_mask & (ArimaaMove.SETUP_MARK|ArimaaMove.CAPTURE_COUNTS))!=0) {
						positionForbidden = new HashSet<Long>();
					} else {
						positionForbidden.add(curr_hash);
					}
				}
				genom.put("general", general);
				genom.put(gold_key, eval[0]);
				genom.put(silver_key, eval[1]);
				gamesPlayed++;
				if (gamesPlayed%100==0) {saveGens();}
			}
		} catch (FileNotFoundException ex) {
			System.err.println("File \\arimaa\\movelist.txt reading problems");
		} catch (IOException ex) {
			System.err.println("Learning: Unknown error!");
			ex.printStackTrace();
		}
	}
	
	public static void main(String args[]) {
		readGens();
		while (true) {
			// to be interrrupted
			learning();
		}
	}
}