package arimaa3;

import ai_util.*;

/** Class to generate capture moves to be used in quiesce search or just to process them in higher priority
 * 
 * @author hroch
 *
 */
public class GenCaptures extends ArimaaBaseClass {

	/** Constructor in two modes
	 * @param _preventRepetition specifies that no move is allowed to appear twice in the result
	 * the drawback is it requires it's own repetition hash table not to mess up with other processing
	 */
	public GenCaptures(boolean _preventRepetition) {
		preventRepetition = _preventRepetition;
	}

	/** talk allower for debugging purposes 
	 */
	public boolean createText = false;

	// Working variables for gen_moves
	private boolean preventRepetition = true;
	private MoveList step_list_stack = new MoveList(false);
	private ArimaaMove[] turn_sums = new ArimaaMove[5]; //
	{
		for(int i = 0; i < 5; i++) {
			turn_sums[i] = new ArimaaMove();
		}
		turn_sums[0].clear(); // never changed
}
	private int steps;
	private boolean complete_turn_requested;
	private MoveList turn_list_data;
	private RepetitionHashTable captures_repetition = new RepetitionHashTable();
	
	private GenSteps gen_steps = new GenSteps();
	private boolean exist_test;
	private boolean gen_stopped; // if found and exist_test

	/** generates list of moves ... possible shortest captures in given position
	 * @param position
	 * @param turn_list to be filled
	 * @param complete_turn ... should pass be added to fill unused steps?
	 */
	public void genCaptures(GameState position, MoveList turn_list,
			boolean complete_turn) {
		exist_test = false;
		gen_stopped = false;
		doCaptures_bb(position, turn_list, complete_turn, FULL_BB);
	}

	/** used in elimination testing ... just test if a capture is possible, no need to generate the moves
	 * 
	 * @param position
	 * @param to_capture_bb bitboard of the starting positions we want to capture piece at
	 * @return true if a capture from to_capture_bb exists
	 */
	public boolean testCaptures_bb(GameState position,
			long to_capture_bb) {
		exist_test = true;
		gen_stopped = false;
		doCaptures_bb(position, null, false, to_capture_bb);
		return gen_stopped;
	}

	/** generates list of moves ... possible shortest captures in given position 
	 * filtered by capturing pieces starting at to_capture_bb 
	 * 
	 * @param position 
	 * @param turn_list to be computed
	 * @param complete_turn should pass be added to fill unused steps?
	 * @param to_capture_bb specifies what to capture
	 */
	public void genCaptures_bb(GameState position, MoveList turn_list,
			boolean complete_turn, long to_capture_bb) {
		exist_test = false;
		gen_stopped = false;
		doCaptures_bb(position, turn_list, complete_turn, to_capture_bb);
	}

	/** driver called by both test and gen Captures_bb to find shortest captures in given position filtered
	 * by capturing pieces starting at to_capture_bb 
	 * 
	 * @param position
	 * @param turn_list to be computed (if exist_test is false)
	 * @param complete_turn should pass be added to fill unused steps?
	 * @param to_capture_bb specifies what to capture
	 */
	private void doCaptures_bb(GameState position, MoveList turn_list,
			boolean complete_turn, long to_capture_bb) {

		step_list_stack.clear();
		this.steps = position.steps_remaining;
		to_capture_bb &= position.player_bb[position.enemy]
			&~(position.stronger_or_eq_bb[GameState.Strongest]&~TRAP_SQUARES); 
		// pieces to capture

		complete_turn_requested = complete_turn;
		// Need the frozen/dominated bb's
		// expects ... initial_position.compute_secondary_bitboards() already
		// called

		// Setup working variables
		turn_list_data = turn_list;
		gen_capture_calls++;

		// Test each trap square individually
		for (int i = 0; i < 4; i++) {
			if (preventRepetition) {
				captures_repetition.increaseAge();
			}
			if (createText) {
				System.out.println("Trap Square: "
						+ Notation.Index2Name(TRAP_INDEX[i]) + "\n");
			}

			if (test_trap_precondition(position, i, to_capture_bb)) {
				test_trap(position, i, to_capture_bb);
			}
			if (gen_stopped) return;
		}
	}

	// Statistics collection stuff
	private long trap_precondition_calls = 0;
	private long trap_precondition_false = 0;
	private long gen_capture_calls = 0;

	/** Statistics of the module usage 
	 * 
	 * @return string of statistics
	 */
	public String getStats() {
		String result = "";
		result += "Gen capture calls: " + gen_capture_calls + "\n";
		result += Util.ProbStats("Trap Pre", trap_precondition_calls,
				trap_precondition_false);
		return result;
	}

	/** resets statistics
	 * 
	 */
	public void resetStats() {
		trap_precondition_calls = 0;
		trap_precondition_false = 0;
		gen_capture_calls = 0;
	}

	/**
	 * Performs some basics test to see if captures can be ruled out
	 * 
	 * @param position
	 * @param trap_id where the capture is tested
	 * @return boolean is capture in the trap possible?
	 */
	private boolean test_trap_precondition(GameState position, int trap_id,
			long to_capture_bb) {

		trap_precondition_calls++;

		// If enemy "elephant" is touching trap, NO CAPTURES POSSIBLE!
		if ((TOUCH_TRAP[trap_id] & position.player_bb[position.enemy] & position.stronger_or_eq_bb[GameState.Strongest]) != 0) {
			trap_precondition_false++;
			return false;
		}

		// If 3 e pieces touch trap, NO CAPTURES POSSIBLE
		long e_touch_bb = position.player_bb[position.enemy]
				& TOUCH_TRAP[trap_id];
		int e_touch = Util.LowPopCnt(e_touch_bb);
		if (e_touch >= 3) {
			trap_precondition_false++;
			return false;
		}

		// If 1 non dominated e piece touch trap
		// AND any other epiece touch trap, NO CAPTURE POSSIBLE
		long e_touch_non_dominated_bb = e_touch_bb & ~position.dominated_pieces_bb;
		if (e_touch_non_dominated_bb != 0 && e_touch >= 2) {
			trap_precondition_false++;
			return false;
		}

		if (position.steps_remaining <= 3) {
			// If no epieces touch trap, NO CAPTURES POSSIBLE
			if ((e_touch_bb & to_capture_bb) == 0) {
				trap_precondition_false++;
				return false;
			}

			// If two epieces touch trap, NO CAPTURES POSSIBLE
			if (e_touch >= 2) {
				trap_precondition_false++;
				return false;
			}
		}

		if (position.steps_remaining <= 2) {
			// If one non=dominated epiece touch trap, NO CAPTURES POSSIBLE
			if (e_touch_non_dominated_bb != 0) {
				trap_precondition_false++;
				return false;
			}
			if ((TRAP[trap_id]& position.player_bb[position.player])!=0) {// weaker piece blocking the trap
				if ((TRAP[trap_id]&position.player_bb[position.player]&position.stronger_or_eq_bb[1+position.getStrongest(e_touch_bb,position.enemy)])==0) {
					trap_precondition_false++;
					return false;
				}					
			}
		}

		if (((e_touch_bb & ~to_capture_bb) != 0)
				&& ((e_touch_bb & to_capture_bb) == 0)) {
			// nearest piece to capture in protected trap in distance > 1
			trap_precondition_false++;
			return false;
		}

		if (((to_capture_bb & TRAP[trap_id]) == 0)
				&& ((position.player_bb[position.enemy] & TRAP[trap_id]) != 0)) {
			// after trapping enemy piece piece would be in distance > 1
			trap_precondition_false++;
			return false;
		}

		if ((to_capture_bb & (TRAP[trap_id] | TOUCH_TRAP[trap_id])) == 0) {
			// distance at least 2
			if ((to_capture_bb & TOUCH2_TRAP[trap_id] & position.dominated_pieces_bb) == 0) {
				// piece too far away or not dominated at distance 2
				trap_precondition_false++;
				return false;
			}
		}

		return true;
	}

	/**Attempt to generate useful moves towards capturing an enemy piece
	 * 
	 * @param position
	 * @param trap_id where the capture is tested
	 * @param to_capture_bb specifies what to capture
	 */
	private void test_trap(GameState position, int trap_id, long to_capture_bb) {

		if (preventRepetition) {
			if (captures_repetition.isRepetition(position.getPositionHash())) { // Has side effects
				if (createText) {
					System.out.println("repeated position:");
					System.out.println(position);
				}
				return;
			}
		}

		// Get some working variables
		long enemy_bb = position.player_bb[position.enemy];
		long e_touch_bb = enemy_bb & TOUCH_TRAP[trap_id];
		int e_touch = Util.LowPopCnt(e_touch_bb);
		int steps_available = position.steps_remaining;
		int extra_steps = steps_available - 2 * e_touch;

		// Case 1: There is an epiece to_capture on the trap

		// I believe this case is complete!
		if ((enemy_bb & TRAP[trap_id]) != 0) {
			if ((TRAP[trap_id] & to_capture_bb) == 0) {// the only piece
				// which could be captured is not our target
				return;
			}
			// Try and drag the epieces away with an already touching piece
			if (steps_available >= e_touch * 2) {
				try_drag_moves(position, e_touch_bb, FULL_BB, trap_id, to_capture_bb);
				if (gen_stopped) return;
			}

			// Try and move a dominant piece next to the epiece touching the
			// trap
			if (extra_steps >= 1) {

				
				// Given: there is only 1 epiece touching the trap
				// Given: there is epiece on the trap
				// The precondition check catches 2 non dominant pieces touching
				// trap

				// Get the enemy piece strength
				int e_strength = position.getPieceTypeOneSq(e_touch_bb)>>1;
				long p_dest_bb = touching_bb(e_touch_bb);
				long p_stronger_bb = position.player_bb[position.player] & position.stronger_or_eq_bb[e_strength + 1];

				// Try moving a dominant piece next to the epiece
				if (p_stronger_bb != 0) {
					try_two_stepsNF(position, p_stronger_bb, p_dest_bb, trap_id, extra_steps, to_capture_bb);
					if (gen_stopped) return;
				}
			}
		}

		// Case 2: There is no epiece on the trap AND
		// there are epiece(s) touching the trap

		// I believe this case is complete!
		else if (e_touch_bb != 0) {
			// Try and drag an epiece onto the trap
			long e_start_bb = e_touch_bb & to_capture_bb;
			if (e_start_bb == 0) {// the only piece
				// which could be captured is not our target
				return;
			}
			// (precondition forced there was target so there was step already
			// so it would be lone defender)
			long e_dest_bb = TRAP[trap_id];
			try_drag_moves(position, e_start_bb, e_dest_bb, trap_id, to_capture_bb);
			if (gen_stopped) return;

			// ----- ----- capturing r requires dragging d away first and than
			//    |     | dragging r to trap
			//  H |  EH |
			// .d | MCd |
			// rC |  r  |
			//    |     | so if try as well pull the other
			if ((steps_available > 2) && (extra_steps==0)) {// false protection?
				e_start_bb = e_touch_bb;
				e_dest_bb = ~TRAP[trap_id];
				try_drag_moves(position, e_start_bb, e_dest_bb, trap_id, to_capture_bb);
				if (gen_stopped) return;
			}

			// Try and move a dominant piece next to the epiece touching the trap
			if (extra_steps >= 1) {

				// Given: there is only 1 epiece touching the trap
				// Given: there is no epiece on the trap
				// Get the enemy piece strength
				int e_strength = position.getPieceTypeOneSq(e_touch_bb)>>1;
				// must leave trap with weaker piece if present
				if ((TRAP[trap_id]&position.player_bb[position.player]&~position.stronger_or_eq_bb[e_strength+1])!=0){
					if (createText) {
						System.out.println("Leaving trap by 1 step\n");
					}
					try_two_steps(position, TRAP[trap_id], TOUCH_TRAP[trap_id], trap_id, 1, to_capture_bb);
					if (gen_stopped) return;
					if ((position.suicide_bb[position.player]&TRAP[trap_id])!=0) {
						if (createText) {
							System.out.println("suiciding trap\n");
						}
						try_two_steps(position, TOUCH_TRAP[trap_id], ~TOUCH_TRAP[trap_id], trap_id, extra_steps, to_capture_bb);
						return; // no chance to capture with weak piece still in trap 
					}
					if (createText) {
						System.out.println("leaving trap\n");
					}
					try_two_steps(position, TRAP[trap_id], TOUCH_TRAP[trap_id], trap_id, extra_steps, to_capture_bb);
					if (gen_stopped) return;
				}

				long p_dest_bb = touching_bb(e_touch_bb);
				long p_stronger_bb = position.player_bb[position.player] & position.stronger_or_eq_bb[e_strength + 1];

				// Try moving a dominant piece next to the epiece
				// Try piece on place at first
				if ((p_stronger_bb&p_dest_bb)!=0) {
					if (createText) {
						System.out.println("Unfreeze or prepare pull\n");
					}
					try_two_stepsNF(position, p_stronger_bb&p_dest_bb, (p_stronger_bb&p_dest_bb)|TRAP[trap_id], trap_id,
							extra_steps, to_capture_bb);
					if (gen_stopped) return;
				}
				
				// Try piece to touch next
				if ((p_stronger_bb&(~p_dest_bb))!=0) {
					if (createText) {
						System.out.println("To touch\n");
					}
					try_two_stepsNF(position, p_stronger_bb&(~p_dest_bb), p_dest_bb, trap_id,
							extra_steps, to_capture_bb);
					if (gen_stopped) return;
				}
			}
		}

		// Case 3: There is no epiece on the trap AND
		// there is no epiece touching the trap AND
		// there are epiece(s) 2 steps from the trap

		// THIS CASE IS COMPLETE!!!!!
		else if ((enemy_bb & TOUCH2_TRAP[trap_id] & to_capture_bb) != 0) {

			// Try and drag an epiece closer to the trap
			// Only works if there are at least 4 steps available
			if (steps_available >= 4) {
				long e_start_bb = TOUCH2_TRAP[trap_id] & to_capture_bb;
				long e_dest_bb = TOUCH_TRAP[trap_id];
				try_drag_moves(position, e_start_bb, e_dest_bb, trap_id, to_capture_bb);
				if (gen_stopped) return;
			}
		}
	}

	/** Tries to prepare capture by one or two steps
	 * 
	 * @param position
	 * @param p_start_bb
	 * @param p_dest_bb
	 * @param trap_id
	 * @param extra_steps
	 * @param to_capture_bb
	 */
	private void try_two_steps(GameState position, long p_start_bb,
			long p_dest_bb, int trap_id, int extra_steps, long to_capture_bb) {

		assert (position.steps_remaining >= 3);
		assert (extra_steps <= position.steps_remaining - 2);

		step_list_stack.levelClear();
		if (extra_steps == 2) {
			gen_steps.genTwoStep(position, step_list_stack, p_start_bb, p_dest_bb);
		} else {
			gen_steps.genOneStep(position, step_list_stack, p_start_bb, p_dest_bb);
		}

		for (step_list_stack.levelFirst();step_list_stack.levelCont();step_list_stack.levelNext()) {
			ArimaaMove move = step_list_stack.getCurrentMove();

			assert (move.steps == 2 || move.steps == 1);
			turn_sums[step_list_stack.stack_ind].add(turn_sums[step_list_stack.stack_ind-1], move);
			position.playMoveFull(move);
			step_list_stack.levelUp();

			if (createText) {
				System.out.println("2 Step\n");
				System.out.println(move+"\n");
				System.out.println(position);
				//print_bitboard(to_capture_bb,"To capture mask");
			}

			// Test the trap again, but with reduced steps
			// piece from to_capture_bb near the trap was not moved
			test_trap(position, trap_id, to_capture_bb);
			step_list_stack.levelDn();
			position.unplayMoveFull(move);
			if (gen_stopped) return;
		}
	}

	// Try a two step move
	private void try_two_stepsNF(GameState position, long p_start_bb,
			long p_dest_bb, int trap_id, int extra_steps, long to_capture_bb) {

		assert (position.steps_remaining >= 3);
		assert (extra_steps <= position.steps_remaining - 2);

		step_list_stack.levelClear();
		if (extra_steps == 2) {
			gen_steps.genTwoStepNF(position, step_list_stack, p_start_bb, p_dest_bb);
		} else {
			gen_steps.genOneStepNF(position, step_list_stack, p_start_bb, p_dest_bb);

		}

		for (step_list_stack.levelFirst();step_list_stack.levelCont();step_list_stack.levelNext()) {
			ArimaaMove move = step_list_stack.getCurrentMove();

			assert (move.steps == 2 || move.steps == 1);
			turn_sums[step_list_stack.stack_ind].add(turn_sums[step_list_stack.stack_ind-1], move);
			position.playMoveFull(move);
			step_list_stack.levelUp();

			if (createText) {
				System.out.println("2 Step\n");
				System.out.println(move+"\n");
				System.out.println(position);
				//print_bitboard(to_capture_bb,"To capture mask");
			}

			// Test the trap again, but with reduced steps
			// piece from to_capture_bb near the trap was not moved
			test_trap(position, trap_id, to_capture_bb);
			step_list_stack.levelDn();
			position.unplayMoveFull(move);
			if (gen_stopped) return;
		}
	}

	/** Try to drag a piece with given filter
	 * 
	 * @param position
	 * @param e_start_bb dragged enemy piece should start here
	 * @param e_dest_bb dragged enemy piece should end here
	 * @param trap_id we are testing captures in this trap
	 * @param to_capture_bb these pieces are tested for captures
	 */
	private void try_drag_moves(GameState position, long e_start_bb,
			long e_dest_bb, int trap_id, long to_capture_bb) {

		assert (position.steps_remaining >= 2);
		step_list_stack.levelClear();
		position.genDragMoves(step_list_stack, FULL_BB, FULL_BB, e_start_bb, e_dest_bb);

		for (step_list_stack.levelFirst();step_list_stack.levelCont();step_list_stack.levelNext()) {
			ArimaaMove drag = step_list_stack.getCurrentMove();

			assert (drag.steps == 2);
			turn_sums[step_list_stack.stack_ind].add(turn_sums[step_list_stack.stack_ind-1], drag);
			position.playMoveFull(drag);
			step_list_stack.levelUp();

			// If the move captured propper enemy piece, record the event

			long new_to_capture_bb = to_capture_bb;
			// filter to_capture_bb !!!
			if ((drag.enemy_from_bb & to_capture_bb) != 0) {
				if (drag.enemy_to_bb==0) {// piece dragged to trap
					record_move(position);
				}
				if (!gen_stopped) {
					if (!atMostOneBitSet(drag.enemy_from_bb)) {
						if ((drag.enemy_from_bb & to_capture_bb & TRAP_SQUARES)!=0) {
							record_move(position);
							long surv_from_bb = drag.enemy_from_bb & ~TRAP_SQUARES;
							if (surv_from_bb!=0) {
								new_to_capture_bb ^= surv_from_bb|drag.enemy_to_bb;													
							}
						}
					} else {// piece from to_capture_bb moved ... calculate the
							// modified to_capture_bb
						new_to_capture_bb ^= drag.enemy_from_bb|drag.enemy_to_bb;
					}
				}
			}
			if (!gen_stopped) {
				if (createText) {
					System.out.println("Drag\n" + position);
					System.out.println(drag);
					System.out.println(position);
					//print_bitboard(to_capture_bb,"To capture mask");
					//print_bitboard(enemy_slide_bb,"Enemy slide");
					//print_bitboard(new_to_capture_bb,"New to capture mask");
				}

				// Test the trap again, but with reduced steps
				int steps_remaining = position.steps_remaining;
				if (steps_remaining == 2) {
					test_trap(position, trap_id, new_to_capture_bb);
				}
			}
			step_list_stack.levelDn();
			position.unplayMoveFull(drag);
			if (gen_stopped) return;
		}
	}

	private void record_move(GameState position) {
		if (exist_test) {
			gen_stopped = true;
		} else {
			long hash_code = position.getPositionHash();
			if (preventRepetition) {
				if (captures_repetition.isRepetition(hash_code)) { // Has side effects
					return;
				}
			}
			ArimaaMove move = turn_list_data.getMove();
			if (createText) {
				//System.out.println("difference");
				//System.out.println(saved_initial_position);
				//System.out.println("Gold over strongest:"+saved_initial_position.stronger_or_eq_bb[0][GameState.Strongest+1]);
				//System.out.println("Silver over strongest:"+saved_initial_position.stronger_or_eq_bb[1][GameState.Strongest+1]);
				//System.out.println(new_position);
				//System.out.println("Gold over strongest:"+new_position.stronger_or_eq_bb[0][GameState.Strongest+1]);
				//System.out.println("Silver over strongest:"+new_position.stronger_or_eq_bb[1][GameState.Strongest+1]);
			}
			move.copy(turn_sums[step_list_stack.stack_ind-1]);
			assert (move.steps <= steps);
			if (complete_turn_requested) {
				move.steps = steps;
			}
			move.move_ordering_value = ArimaaTurnBasedEngine.ORDER_CAPTURE;
			if (createText) {
				System.out.println(move);
			}
		}
	}

	public static void main(String args[]) {

		String text[] = {
		"6|3w %13 +-----------------+%138| r   r c c   r r |%137| d r   d   r     |%136| M e         m   |%135| h               |%134|     r H   E     |%133|                 |%132| D   C   D h   H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"11|2b %13 +-----------------+%138|                 |%137|   C     D       |%136|   r r r         |%135|     R     R     |%134|     c     c     |%133|                 |%132|                 |%131| H       E   M   |%13 +-----------------+%13   a b c d e f g h%13",
		//"3|3b %13 +-----------------+%138| r   r c c   r r |%137| d r r d   r     |%136| M e   H     m   |%135| h               |%134|     r     E     |%133|                 |%132| D   C   D h   H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Naveed
		"4|2w %13 +-----------------+%138|                 |%137|                 |%136|   d r d         |%135|     R           |%134|     h H     h   |%133|           R E   |%132| M   D   D   m H |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		"23|4b %13 +-----------------+%138|                 |%137|                 |%136|   h r h         |%135|     R           |%134|     m H   E     |%133|                 |%132| M   D   D     H |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		"8|5b %13 +-----------------+%138|     c r r   r C |%137| d R   r R c R m |%136| R r r         r |%135|   h H           |%134|   C e     E   h |%133|       H D     R |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		// Naveed
		"8|4w %13 +-----------------+%138| r r r     r r r |%137| r         c     |%136|   C c d         |%135|   m E d         |%134|                 |%133|   D         r   |%132| R   D   R e     |%131|   R R R     R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Game 14129
		//"7|6b %13 +-----------------+%138| r   r c c   r r |%137| d r   d   r     |%136| M e   H     m   |%135| h               |%134|     r     E     |%133|                 |%132| D   C   D h   H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Naveed
		"3|7b %13 +-----------------+%138| r r r       r r |%137| C   c r       D |%136|   m   d M     R |%135| C     R   E h   |%134| R       H e     |%133|       h         |%132|             R   |%131|           R     |%13 +-----------------+%13   a b c d e f g h%13",
		"2|8b %13 +-----------------+%138| r r H r r r r r |%137| c   m E   d     |%136|   d     h   c   |%135|             H   |%134| r M e           |%133| h               |%132| D             D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"4|9b %13 +-----------------+%138|   r r   r r     |%137| r   d r   c     |%136|   H     c r h r |%135|     m   h       |%134|     E           |%133|                 |%132|         C D H C |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"4|10b %13 +-----------------+%138|   r r   r r     |%137| r   d r H c     |%136| h H E   c r h r |%135|     m   h       |%134|                 |%133|                 |%132|         C D H C |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"6|11b %13 +-----------------+%138|   r r   r r     |%137| r   d r H c     |%136| h M E   c r h r |%135|   m e           |%134|                 |%133|                 |%132|         C D H C |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"0|5w %13 +-----------------+%138| r     r r   r r |%137|     r m   r     |%136|     d   E H h   |%135|         c       |%134|   r   M         |%133|   h   e         |%132|   H           C |%131| C R     D R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"0|12b %13 +-----------------+%138| r r r r   r r r |%137| d       r c     |%136|   D c d m   h   |%135| R h E e         |%134|     H           |%133|   R   M H   C R |%132|         R       |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		"0|13w %13 +-----------------+%138| r r H r r r r r |%137| c   m     d c   |%136| d M r C h       |%135| h   E e         |%134|             H   |%133|                 |%132| D   C         D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"0|14w %13 +-----------------+%138| r r H r r r r r |%137| c   m     d c   |%136| d r     h       |%135| h M E C         |%134|     e           |%133|                 |%132| D   C       H D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"0|15b %13 +-----------------+%138| r r r r r r r r |%137| d h c   d c h   |%136|   H   E         |%135|       m         |%134|                 |%133|             e D |%132| D R C M   C H R |%131| R   R R R R R   |%13 +-----------------+%13   a b c d e f g h%13",
		"0|16b %13 +-----------------+%138| r h r r r r r r |%137|   H     d c h   |%136|   C   E   d     |%135|     R           |%134|         M     D |%133| D     R r   R R |%132| e         H     |%131| R   R     R     |%13 +-----------------+%13   a b c d e f g h%13",
		"0|17w %13 +-----------------+%138|                 |%137| r r r     H     |%136|   d     h   h R |%135| c   d   r r     |%134| r C       c r   |%133| D e   r   E C   |%132|     H M D m     |%131| R R R R R R R   |%13 +-----------------+%13   a b c d e f g h%13",
		"0|18b %13 +-----------------+%138|       r r   r   |%137|                 |%136|             c   |%135| r             r |%134|       E   e     |%133| r               |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		"0|19b %13 +-----------------+%138|       r r   r   |%137|                 |%136|             c   |%135| r             r |%134|       E   e     |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		"0|20w %13 +-----------------+%138|                 |%137|   r r     r     |%136| r d   r c   E r |%135| R   h r R e     |%134|       R R   R   |%133|                 |%132|   H D     H   r |%131| C R           C |%13 +-----------------+%13   a b c d e f g h%13",
		"0|21b %13 +-----------------+%138| r r c   r     r |%137| h d   r m c h R |%136|       e   r     |%135|   r   r   C H   |%134|     H R E M d   |%133| C D         D   |%132| R R R     R R   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		"1|23b %13 +-----------------+%138|       r r   r   |%137|               r |%136|   d         c R |%135| r E             |%134|           e     |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		//"11|24w %13 +-----------------+%138|         r     r |%137| h d   r r   R d |%136|     X   e X   h |%135|               r |%134|                 |%133|   c X E   X c   |%132| H D r M   C r H |%131| R R C R R       |%13 +-----------------+%13   a b c d e f g h%13",
		//"11|25w %13 +-----------------+%138|         r     r |%137| h d   r r   R d |%136|     X   e X   h |%135|               C |%134|                 |%133|   c X E   X c   |%132| H D r M   C r H |%131| R R C R R       |%13 +-----------------+%13   a b c d e f g h%13",
		"1|26w %13 +-----------------+%138|   r   d H r r r |%137| r   r c E R   r |%136|         h       |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Game 11697
		"2|27w %13 +-----------------+%138|   r   d H r r r |%137| r   r c   R   r |%136|         h   E   |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Game 11697
		"2|28b %13 +-----------------+%138|   r   d H r r r |%137| r   r c E R   r |%136|         h       |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Game 11697
		//"5|29w %13 +-----------------+%138| r   r c c   r r |%137| d r   d   r     |%136| M e         m   |%135| h               |%134|     r     E     |%133| R               |%132| D   C   D h   H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Naveed
		//"5|30w %13 +-----------------+%138| r   r c c   r r |%137| d r   d   r     |%136| M e         m   |%135| h               |%134|     r     E     |%133|   R             |%132| D   C   D h   H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Naveed
		//"7|31w %13 +-----------------+%138| r   r c c   r r |%137| d r   d   r     |%136| M e         m   |%135| h               |%134|     r     E     |%133|         H       |%132| D   C   D h   H |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13",
		// Naveed
		//"5|32b %13 +-----------------+%138| r r r c m r r r |%137| r h c d   d   r |%136|                 |%135|           e H   |%134|         E       |%133|   D     h       |%132| R   H   M D   R |%131| R R R C C R R R |%13 +-----------------+%13   a b c d e f g h%13",
		"6|33w %13 +-----------------+%138| r r r c m r r r |%137| r h c d   d   r |%136|                 |%135|           e H   |%134|         E       |%133|   D     h       |%132| R   H   M D   R |%131| R R R C C R R R |%13 +-----------------+%13   a b c d e f g h%13",
		//"1|34b %13 +-----------------+%138|   E m   r       |%137| R   H           |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
		//"1|35b %13 +-----------------+%138|     E m   r     |%137| R   H           |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13"
		};

//		GameState.Strongest = 5;
		// Create the result array
		// Run test positions
		for (String pos_text : text) {
			// Output the test position
			int pos_start = pos_text.indexOf("|")+1;
			int exp_num = Integer.parseInt(pos_text.substring(0,pos_start-1));
			pos_text = pos_text.substring(pos_start);
			GameState position = new GameState(pos_text);
			MoveList move_data = new MoveList(true); // expects GameState.Strongest set already
			GenCaptures test = new GenCaptures(true);
			//test.createText=true;
			if (test.createText){
				System.out.println(position);
			}
			System.out.println(position);
			test.genCaptures(position, move_data, false);
			boolean exist = test.testCaptures_bb(position, FULL_BB);
			if (exist == (move_data.levelSize()==0)) {
				System.out.println("Bug report");
				if (exist) {
					System.out.println("exists, but no capture generated");
				} else {
					System.out.println("does not exist, but "+move_data.levelSize()+" captures generated");
				}
			}
			// Output results
			if (move_data.levelSize()!=exp_num) {
				LogFile.message("Bug report");
				LogFile.message(""+position);
				LogFile.message("Expected: "+exp_num+" gained: " + move_data.levelSize());
				LogFile.message(""+move_data);
				for (move_data.levelFirst();move_data.levelCont();move_data.levelNext()) {
					ArimaaMove capture = move_data.getCurrentMove();
					LogFile.message(""+capture);
				}
				test.genCaptures(position, move_data, false);
			} else if (test.createText) {
				LogFile.message("Test OK");
				LogFile.message(""+position);
				LogFile.message("Total moves: " + move_data.levelSize());
				LogFile.message(""+move_data);
			} 
			System.out.println(test.getStats());
		}
	}
}