package arimaa3;

import java.util.*;

import ai_util.LogFile;
import ai_util.RepetitionHashTable;

public class MoveList{

	// there is also option to implement packed movelist and unpack the move
	// only when required ...
	// that would not need to know Strongest in advance ...
	
	// Hmmm, there could be problems with stack_ind when exceptions are invoked
	
	public ArimaaMove move_list[];
	public int [] range_stack; // not ready to search deeper than 100 turns
	public int [] depth_ind; // pointer on given depth
	public int stack_ind; // range_stack[stack_ind] denotes end of current movelist starting from 1 (0 is stopper)
	private int capture_ind; // on deepest level allowes to put in front of other moves (position of "last" switch
	private int goal_threat_ind; // on deepest level allowes to put in front of other moves (position of "last" switch
	
	public MoveList (boolean turnList) {
		if (turnList) {// turnlist for at most 100 half turns
			allocate(0x20000,100); // will be dynamically increased
		} else {// steplist
			allocate(184+185+185+57,5);
			// maximum 1 pass, 8*(4+3) sildes, 8*4*3 pushes and
			// 8*max(1*3,2*2,3*1) pulls = 1+8*(7+12+4)=1+8*23=185)
		}
	}
	
	public MoveList(int start_size, int start_depth) {
		allocate(start_size, start_depth);
	}

	private void allocate(int start_size, int start_depth) {
		// Expects GameState.Strongest is set to
		// upper bound of future use of
		// GameState.Strongest
		move_list = new ArimaaMove[start_size];
		range_stack = new int[start_depth];
		depth_ind = new int[start_depth];
		for (int i = 0; i < start_size; i++) {
			move_list[i] = new ArimaaMove(); // left to getCurrentMove ... no there is plenty of time on first move ...
		}
		clear();
	}
	
	public void resize() {
		ArimaaMove [] ori_move_list=move_list;
		move_list = new ArimaaMove[move_list.length+0x10000];
		for(int i=0;i<ori_move_list.length;i++) {
			move_list[i]=ori_move_list[i];
		}
		for(int i=ori_move_list.length;i<move_list.length;i++) {
			move_list[i] = new ArimaaMove(); // left to getCurrentMove ... no there is plenty of time on first move ...			
		}
	}
	
	public void clear() {
		goal_threat_ind=capture_ind = depth_ind[1] = range_stack[stack_ind=1] = range_stack[0] = -1;
		// depth_ind[] starts before the range ... to start with levelNext() before the read
	}	
	
	public void levelClear() {
		goal_threat_ind=capture_ind = depth_ind[stack_ind] = range_stack[stack_ind] = range_stack[stack_ind-1];  
		// depth_ind[] starts before the range ... to start with levelNext() before the read
	}
	
	public void levelReWrite() {
		goal_threat_ind=capture_ind = range_stack[stack_ind] = range_stack[stack_ind-1];
	}

	public void levelUp() {
		if (stack_ind+1>=depth_ind.length) {
			LogFile.writeln("Too deep in movelist stack "+toString());
			int [] new_range_stack = new int [1|stack_ind<<1]; // not ready to search deeper than 100 turns
			int [] new_depth_ind = new int [1|stack_ind<<1]; // pointer on given depth
			System.arraycopy(range_stack,0,new_range_stack,0,range_stack.length);
			System.arraycopy(depth_ind,0,new_depth_ind,0,depth_ind.length);
			range_stack=new_range_stack;
			depth_ind=new_depth_ind;
		}
		stack_ind++;
		levelClear();
	}
	
	public void levelDn() {
		// usually followed by depth_ind[stack_ind]++ and test depth_ind[stack_ind]<= range_stack[stack_ind] 
		stack_ind--;
	}
	
	public boolean levelCont() {
		return depth_ind[stack_ind]<=range_stack[stack_ind];
	}
	
	public void levelNext() {
		depth_ind[stack_ind]++;		
	}
	
	/**
	 * move is the item what was last on the list and the list is shortened
	 * @return move if the last level of the list is nonempty otherwise move is set to null
	 */
	public ArimaaMove levelPop() {
		ArimaaMove move;
		if (range_stack[stack_ind]==range_stack[stack_ind-1]) {
			return null;
		}
		move = move_list[range_stack[stack_ind]];
		range_stack[stack_ind]--;
		return move;
	}
	
	public int levelSize() {
		return range_stack[stack_ind]-range_stack[stack_ind-1];
	}

	public void levelReRead() {
		depth_ind[stack_ind] = range_stack[stack_ind-1];
	}
	
	public void levelFirst() {
		depth_ind[stack_ind] = range_stack[stack_ind-1]+1;
	}
	
	public int lastIndex() {
		return range_stack[stack_ind];		
	}
	/**Returns the current move on the current level
	 * @return ArimaaMove
	 */
	public ArimaaMove getCurrentMove() {// for traversal
		return move_list[depth_ind[stack_ind]];
	}
	public ArimaaMove getMove() {// move to be modified
		range_stack[stack_ind]++;
		if (range_stack[stack_ind]==move_list.length) {
			resize();
		}
		return move_list[range_stack[stack_ind]];
	}

	/* move to be modified positioned at front used in turn generation not interrupted by list manipulation
	 *on another level! The move was not noted as Capture yet!
	 */
	public void makeMoveGoalThreat() {
		makeMoveCapture();
		goal_threat_ind++;
		if (capture_ind!=goal_threat_ind) {
			ArimaaMove tmp = move_list[capture_ind];
			move_list[capture_ind]=move_list[goal_threat_ind];
			move_list[goal_threat_ind]=tmp;
		}
		return;
	}
	/* move to be modified positioned at front used in turn generation not interrupted by list manipulation
	 *on another level!
	 */
	public void makeMoveCapture() {
		capture_ind++;
		if (capture_ind!=range_stack[stack_ind]) {
			ArimaaMove tmp = move_list[range_stack[stack_ind]];
			move_list[range_stack[stack_ind]]=move_list[capture_ind];
			move_list[capture_ind]=tmp;
		}
		return;
	}
	
	public String getStackSequence() {
		String result="";
		for(int i=1;i<stack_ind;i++) {
			if (depth_ind[i]>=0) {
				result+=","+move_list[depth_ind[i]];
			} else {
				result+=",";
			}
		}
		return result;
	}

	public String toString() {
		String result = "";
		for (int sp=1;sp<=stack_ind;sp++) {
			result += "("+(range_stack[sp]-range_stack[sp-1])+")";
			if (depth_ind[sp]>range_stack[sp-1]+1) {result += "..";}
			result+=">";
			for(int j=depth_ind[sp];j<=depth_ind[sp]+5;j++) {
				result+= ((j>range_stack[sp-1])&&(j<=range_stack[sp]))?move_list[j]:"|";
			}
			if (depth_ind[sp]+5<range_stack[sp]) {result+="..";}
			result += "\n";
		}
		return result;
	}

	/*
	 * for MCTS like I would like not only sorting moves by weight but also
	 * picking moves by weight (some sort of tree with subtree weights would be
	 * required) ... picking often moves with higher weight with more than
	 * linear decay so moves with really small weight could be discarded at all.
	 * "Compressed version of the movelist should be stored in the MCTS expansion"
	 */
	public void levelSort() {
		Arrays.sort(move_list, range_stack[stack_ind-1]+1, range_stack[stack_ind]);
	}
	
	//static private RepetitionHashTable repetition = new RepetitionHashTable();
	
	//public void saveUniqueResult(ArimaaMove move) {
	//	long hash_code = move.zobr_hash;
	//	if (repetition.isRepetition(hash_code)) { // Has side effects
	//		return;
	//	}
	//	getMove().copy(move);
	//}

	//public void makeTopLevelUnique() {
	//	repetition.increaseAge(); //if new turn, but not on new step ... !?
	//	int last_ind=range_stack[stack_ind];
	//	levelClear();
	//	for (int j=range_stack[stack_ind-1]+1;j<=last_ind;j++) {
	//		saveUniqueResult(move_list[j]);
	//	}
	//}

	public void levelPruneLosing() {
		int last_ind=range_stack[stack_ind];
		levelClear();
		for (int j=range_stack[stack_ind-1]+1;j<=last_ind;j++) {
			if (move_list[j].move_ordering_value>Constants.SCORE_FORCED_LOSS) {
				getMove().copy(move_list[j]);
			}
		}
	}
	
	public static void main(String args[]) {
		MoveList pokus=new MoveList(false);
		pokus.getMove().move_ordering_value=100;
		pokus.getMove().move_ordering_value=0;
		pokus.getMove().move_ordering_value=200;
		pokus.getMove().move_ordering_value=-202;
		pokus.levelSort();
		for(pokus.levelFirst();pokus.levelCont();pokus.levelNext()) {
			ArimaaMove step=pokus.getCurrentMove();
			System.out.println("order:"+step.move_ordering_value);
		}
	}
}