package arimaa3;

public class Notation extends ArimaaBaseClass {

	public Notation() {
	}

	public static int Name2Col(String col_name) {
		return COL_NAMES.indexOf(col_name);
	}

	public static int Name2Row(String row_name) {
		return ROW_NAMES.indexOf(row_name);
	}

	public static String Col2Name(int col) {
		assert ((col & ~0x07) == 0);
		return COL_NAMES.substring(col, col + 1);
	}

	public static String Row2Name(int row) {
		assert ((row & ~0x07) == 0);
		return ROW_NAMES.substring(row, row + 1);
	}

	public static int Name2Dir(String dir_name) {
		return DIR_NAMES.indexOf(dir_name);
	}

	public static String Dir2Name(int dir) {
		assert (dir >= 0 && dir <= 4);
		return DIR_NAMES.substring(dir, dir + 1);
	}

	public static int Index2Row(int index) {
		assert ((index & ~0x03f) == 0);
		return index >>> 3;
	}

	public static int Index2Col(int index) {
		assert ((index & ~0x03f) == 0);
		return index & 0x07;
	}

	public static String Index2Name(int index) { // getStringIndex
		assert ((index & ~0x03f) == 0);
		int row = Index2Row(index);
		int col = Index2Col(index);
		return Col2Name(col) + Row2Name(row);
	}

	public static int RowCol2Index(int row, int col) {
		assert (((row | col) & ~0x07) == 0);
		return (row << 3) | col;
	}
}