package arimaa3;

import ai_util.LogFile;
import ai_util.MoveInfo;

public class PlayMoveList {

	ArimaaServerInfo info;
	
	public PlayMoveList(String move_list_txt){
		info = new ArimaaServerInfo();
		info.move_list = move_list_txt;
		String[] move_list=move_list_txt.split("%13");
		for (String move_text_with_turn_number : move_list) {
			int pos_start = move_text_with_turn_number.indexOf(" ")+1;
			String move_text = move_text_with_turn_number.substring(pos_start);
			ArimaaMove move = new ArimaaMove(move_text);
			info.makeMove(move_text);
			info.ShrinkRules();
			LogFile.message(move_text_with_turn_number);
			LogFile.message(move.toString());
			LogFile.message(""+info.gs);
		}
	}
	
	public static void main(String[] args) {
		// Get the current gamestate
		String move_list_txt[] = {
			//"1w Ee2 Mb2 Hg2 Hd2 Df2 Dc2 Cg1 Cf1 Rh2 Ra2 Rh1 Re1 Rd1 Rc1 Rb1 Ra1%131b rd7 ra8 rb8 rc8 rd8 re8 rg8 rh8 ce7 cf8 da7 dc7 hg7 hh7 mb7 ef7%132w Dc2n Dc3x Df2n Df3x Ee2n Ee3n%132b dc7s dc6x da7s da6e db6e dc6x"
			"hame test|1w Ra1 Ra2 Rb1 Rb2 Rc1 Rc2 Rd1 Rd2 Ce1 Ce2 Df1 Df2 Hg1 Hg2 Mh1 Eh2%131b ra8 ra7 rb8 rb7 rc8 rc7 rd8 rd7 ce8 ce7 hf8 df7 dg8 hg7 mh8 eh7%132w Rc2n Rc3x%132b hg7s hg6w df7e hf6x%133w Df2n Df3x%133b hf8s hf7s hf6x%134w Hg2n Hg3w Hf3x"
			//,  
			//"jdb 1a|1w Rc1 Cf1%131b rf7 rg8%132w pass" // 00:13.84 WON 7 rg8h5 generates bug for next puzzle
			//,
			//"jdb 1b|1w Rc1 Cf1%131b rf7 rg8%132w pass%132b rg8e rh8s rh7s rh6s" // 00:13.84 WON 7 rg8h5 generates bug for next puzzle
			//,
			//"jdb 1c|1w Rc1 Cf1%131b rf7 rg8%132w pass%132b rg8e rh8s rh7s rh6s%133w Cf1e Cg1n Cg2n Cg3n" // 00:13.84 WON 7 rg8h5 generates bug for next puzzle
			//,
			//"jdb 2|1w Ra1 Cd1%131b rb5 rd5" // 4 00:01.54 LOST 4 generates bug for next puzzle
			//,
			//"jdb 3|1w Rc2 Dh7%131b cg6 rc8%132w pass" // 00:23.53 WON 7 ce4
			//,
			//"jdb 4|1w Rg2 Hg4%131b ed3 rh5" // 02:39.53 WON 8 {4}Hh5 rh6
			//,
			//"jdb 5|1w Ca1 Ra3%131b ra6 da8" // 00:06.56 WON 6 Rd4
			//,
			//"jdb 6|1w Da1 Rb2%131b cd1 ca2 rb4" // 00:05.51 LOST 4
			//,
			//"jdb 7|1w Db1 Ra2 Ca5%131b da1 ra3%132w pass" // 00:06.45 LOST 8
			//,
			//"jdb 8|1w Rd3%131b rd7 rc8 rd8 re8" // 00:00.03 LOST 2
			//,
			//"jdb 9|1w Rd1 Re1 Rc2 Rd2%131b rb4" // 00:00.20 LOST 2
			//,
			//"jdb 10|1w Ra4 Dh4 Ca5%131b cb5 rd7%132w pass" // 00:13.98 LOST 5 
			//,
			//"jdb 11|1w Df2 Ra4 Ca5%131b rb4 cb5%132w Df2w De2w Dd2w Dc2w" //D:31 44:13.42 time expired
		};
		//String pos_txt[] = {
		//	"2w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135| r             d |%134| c C             |%133|                 |%132|       R         |%131|                 |%13 +-----------------+%13   a b c d e f g h%13"
		//	// won 6 Rc2d2 rb5a5
		//};
		MoveInfo move;
		ArimaaTurnBasedEngine engine = new ArimaaTurnBasedEngine();
		SearchTimes times = new SearchTimes();
		int fixed_search_time = 3000;
		times.base_time_sec = fixed_search_time;
		times.panic_time_sec = fixed_search_time;
		times.mate_time_sec = fixed_search_time;
		for (String move_list : move_list_txt) {
			int start = move_list.indexOf("|")+1;
			String name=move_list.substring(0,start-1);
			PlayMoveList pl=new PlayMoveList(move_list.substring(start));
			move = engine.genMove(pl.info,times);
			LogFile.message("Solution ("+name+"):"+move.move_text);
		}
		//ArimaaServerInfo info = new ArimaaServerInfo();
		//for (String pos : pos_txt) {
			//info.gs = new GameState(pos);
			//move = engine.genMove(info,times);
			//System.out.println(move.move_text);
		//}
	}
}
