package arimaa3;

import java.io.*;

import ai_util.*;

//this class takes a position and sees if a win is possible
//TODO ... gmt* speedup
//TODO ... setting goal_path_bb in all cases to allow goal defense filtering

public class TestForGoal extends ArimaaBaseClass {

	private int[][] goal_sq_order = new int[2][8];
	public TestForGoal() {
		for(int c=0;c<2;c++) {
			for(int i=0;i<8;i++) {
				goal_sq_order[c][i]=i;// initial permutation is not important
			}
		}
	}

	public long goal_path_bb;
	public static boolean use_debug = false;
	public static boolean use_hash = true; // for debug purposes
	
	private MoveList doublestep_list_stack = new MoveList(5000,15); // 15? probably less would suffice
	//private MoveList doublestep_list_stack] = new MoveList[15];
	private ArimaaMove step_stack[] = new ArimaaMove[4];
	// allocates stacks of local variables needed for goalTurn certificate
	{
		for (int i = 0; i < step_stack.length; i++) {
			step_stack[i] = new ArimaaMove();
			step_stack[i].clear();
		}
	}

	private GenCaptures captures = new GenCaptures(false);
	private int player, enemy;

	// If a win is possible, the location of the
	// winning rabbit and the goal are saved here
	private int saved_goal_index = -1; // 0-7 for silver, 0x39 - 0x3f for gold
	private int saved_rabbit_index = -1; // 8-0x37
	private int start_index;

	// ^ not required ... if one step goal, we have plenty of time to find it
	// if deeper, just the information there is a goal is needed
	// may be if use_debug ...
	// elimination test could help as well

	public int getGoalIndex() {
		return saved_goal_index;
	}

	public int getRabbitIndex() {
		return saved_rabbit_index;
	}

	// Hash table for storing repeated positions
	private static long hash_mask = 0xFFFFF;
	private static long hash_table[] = new long[0x100000];
	static {// to prevent false hits
		for (int i=0;i<hash_table.length;i++) {
			hash_table[i]=i+0x1000;
		}
	}

	// Create bitboards for goal patterns
	//private static long goal_pattern_bb[][][];
	private static long goal_dist_bb[][]=new long[2][5];
	private static long patt_goal_bb[][]=new long [2][8]; // 0
	private static long patt_rank_touch_goal_bb[][]=new long [2][8]; // 1
	private static long patt_gmt_bb[][]=new long [2][8]; // 2
	private static long patt_rank_touch_gmt_bb[][]=new long [2][8]; // 3
	private static long patt_file_touch_gmt_bb[][]=new long [2][8]; // 4
	private static long patt_three_step_bb[][]=new long [2][8]; // 5
	private static long patt_trap_guards_bb[][]=new long [2][8]; // 6
	private static long patt_goal_and_rank_touch_goal_bb[][]=new long [2][8]; //
	private static long patt_gmt_goal_bb[][]=new long [2][8]; //
	
	// from which dist rabbit can run in given number of steps
	static {
		long reached_bb = RANK_8;
		for (int steps = 0; steps <= 4; steps++) {
			goal_dist_bb[0][steps] = reached_bb;
			reached_bb |= down_bb(reached_bb);
		}
		reached_bb = RANK_1;
		for (int steps = 0; steps <= 4; steps++) {
			goal_dist_bb[1][steps] = reached_bb;
			reached_bb |= up_bb(reached_bb);
		}
		//goal_pattern_bb = new long[2][8][7];

		for (int c = 0; c < 2; c++) {
			for (int i = 0; i < 8; i++) {
				long goal_bb = patt_goal_bb[c][i] = 1L << (i + (1-c) * 0x38);

				// |  x  | goal_bb = Pattern 0 is the goal square

				// | x x | rank_touch_goal_bb = Pattern 1 touching the goal
				// on the same rank 
				patt_rank_touch_goal_bb[c][i] = left_bb(goal_bb) | right_bb(goal_bb);
				patt_goal_and_rank_touch_goal_bb[c][i]=patt_rank_touch_goal_bb[c][i] | goal_bb;
				// | xxx | goal_and_rank_touch_bb = goal_bb|rank_touch_goal_bb;

				// gmt_bb = Pattern 2 is touching squares on a different rank 
				// |     |
				// |  x  | ie this is the gmt square
				long gmt_bb = patt_gmt_bb[c][i] = (c == 0) ? down_bb(goal_bb) : up_bb(goal_bb);
				patt_gmt_goal_bb[c][i] = gmt_bb|goal_bb;
				// |  x  | gmtgoal_bb = goal_bb|gmt_bb;
				// |  x  |

				// |     | rank_touch_gmt_bb = Pattern 3 is touching gmt on the same
				// | x x | rank 
				patt_rank_touch_gmt_bb[c][i] = left_bb(gmt_bb) | right_bb(gmt_bb);

				// |     | file_touch_gmt_bb = Pattern 4 two steps to goal in the goal
				// |     | file
				// |  x  |
				patt_file_touch_gmt_bb[c][i] = (c == 0) ? down_bb(gmt_bb) : up_bb(gmt_bb);

				// |     | touch_gmt_bb = rank_touch_gmt_bb|file_touch_gmt_bb;
				// | x x | This is all squares exactly 2 steps from goal, not on goal
				// |  x  | line 
				long touch_gmt_bb = patt_rank_touch_gmt_bb[c][i] | patt_file_touch_gmt_bb[c][i];
				// |     | three_step_bb = Pattern 5 is all squares exactly 3 steps
				// |x   x| from goal, not on goal line
				// | x x |
				// |  x  |
				patt_three_step_bb[c][i] = touching_bb(touch_gmt_bb) & ~gmt_bb & NOT_GOAL_RANKS;

				// |     | trap_guards_bb = Pattern 6 three steps not on border 2
				// |     | ranks
				// | x x | Needed just for goal on trap files, so otherwise FULL_BB
				// |  x  |
				patt_trap_guards_bb[c][i] = ((patt_file_touch_gmt_bb[c][i] & TRAP_SQUARES) == 0) ? FULL_BB 
						:patt_three_step_bb[c][i] & ~(RANK_7 | RANK_2);
			}
		}
	}

	public String getStats() {
		String result = "";
		result += Util.ProbStats("Test HH", test_calls, test_hash_hits);
		return result;
	}

	public void resetStats() {
		test_calls = 0;
		test_hash_hits = 0;
	}

	// Statistics collection stuff
	static long test_calls = 0;
	static long test_hash_hits = 0;

	public boolean isGoalThreat(GameState game) {
		game.player^=1;
		game.enemy^=1;
		boolean result = test(game);
		game.player^=1;
		game.enemy^=1;
		return result;
	}
	
	public boolean test(GameState game) {
		assert (game.getStepsRemaining()== 4);
		// game.compute_secondary_bitboards(); expecting that was already called
		
		//use_debug=(game.turn==3);
		boolean result;
		player = game.player;
		enemy = game.enemy;
		start_index = (player == 0) ? 0x38 : 0;
		saved_goal_index = -1;
		saved_rabbit_index = -1;
		goal_path_bb = FULL_BB;// safa value for prunning when not implemented yet

		// zorb_hash not required in final position, just in initial position
		// ... so zorb_hash neednot be updated in the moves

		// Probe the hash table
		test_calls++;
		// zobr_hashing uses different bits on first 2 rows, last 2 rows and middle 4 rows
		// this makes zobr_hashing less random, but 2^19 for 13*16 points resp. 2^26 for 13*32 points should be enough
		// the bits are spread ... so hc=hash_code & mask; hc |= hc>>>2; 
		// uses well all low positions in 0xFFFFF 
		// unfortunately elimination must be hashed separately (resp. without such filtering)
		// so may be two entries per tested position would be used ... one for goal, one for elimination
		// Oops this is buggy
		// +--------+  +--------+
		// |        |  |        |
		// |Re      |  |Re      |
		// |  x  x  |  |  x  x  |
		// |Rm      |  |Rm      |
		// |        |  |        |
		// |Rhx  x  |  |Rhx  x  |
		// |       r|  |       r|
		// |R       |  | R      |
		// +--------+  +--------+ should give different results!
		//long elim_hash = game.getPositionHash();
		//int elim_index = (int) (elim_hash & hash_mask);
		//long goal_hash = elim_hash & ((player == PL_GOLD)?~GameState.ZorbGoldHomeMask:~GameState.ZorbSilverHomeMask);
		//goal_hash ^= goal_hash >> 2;
		//int goal_index = (int) (goal_hash & hash_mask);
		// See if high bits match
		long hash = game.getPositionHash();
		int index = (int) (hash & hash_mask);
		if (use_hash) {
			if ((hash_table[index] & 0xFFFFFFFFFFFFFC00L) == (hash & 0xFFFFFFFFFFFFFC00L)) {
			//if ((hash_table[goal_index] & 0xFFFFFFFFFFFFFC00L) == (goal_hash & 0xFFFFFFFFFFFFFC00L)) {
				test_hash_hits++;
				result = (hash_table[index] & 0x01L) == (0x01L) ? true : false;
				//result = (hash_table[goal_index] & 0x01L) == (0x01L) ? true : false;
				if (result && (use_debug)) {
					saved_goal_index = (int) ((hash_table[index] >>> 1) & 0x07)
					| ((player == 0) ? 0x38 : 0);
					saved_rabbit_index = (int) (hash_table[index] >>> 4) & 0x3f;
				}
				return result;
				//if (result) return true; // goal
				//if ((hash_table[elim_index] & ~0x01L) == (elim_hash & ~0x01L)) {
				//	result = (hash_table[elim_index] & 0x01L) == (0x01L) ? true : false;
				//	return result;
				//} else {
				//	result = test_elimination(game);
				//	hash_table[elim_index] = (result == true) ? ((elim_hash & 0xFFFFFFFFFFFFFFFEL)
				//			| 0x01L): elim_hash & 0xFFFFFFFFFFFFFFFEL;
				//	return result;
				//}
			}
		}
		// Check if rabbit can win unassissted
		result = can_rabbit_run(game, 4);
		if (result) {
			
		} else {
			result = ((game.player_bb[player]&~game.stronger_or_eq_bb[1]) & goal_dist_bb[player][3]) != 0;
			// If a rabbit may be able to reach goal with assistance
			if (result) {
				result = test_goal_squares(game);
			}
		}
		// result corresponds to goal possibility (saved* are not required for search, they could be helpful for debugging)
		//hash_table[goal_index] = (result == true) ? ((goal_hash & 0xFFFFFFFFFFFFFC00L)
		//		| 0x01L | (saved_rabbit_index << 4) | ((saved_goal_index & 0x07L) << 1))
		//		: goal_hash & 0xFFFFFFFFFFFFFFFEL;
		if (!result) {
			result = test_elimination(game);
		//	hash_table[elim_index] = (result == true) ? ((elim_hash & 0xFFFFFFFFFFFFFFFEL)
		//			| 0x01L)
		//			: elim_hash & 0xFFFFFFFFFFFFFFFEL;
		}
		hash_table[index] = (result == true) ? ((hash & 0xFFFFFFFFFFFFFC00L)
				| 0x01L | (saved_rabbit_index << 4) | ((saved_goal_index & 0x07L) << 1))
				: hash & 0xFFFFFFFFFFFFFFFEL;
		return result;
	}

	private boolean test_eliminationAfterMove(GameState game, ArimaaMove move) {
		game.playMoveFull(move);
		boolean result = test_elimination(game); 
		game.unplayMoveFull(move);
		return result;
	}

	private boolean test_elimination(GameState game) {
		// tests if the last enemy rabbit can be captured
		long enemy_r_bb = game.player_bb[enemy] & ~game.stronger_or_eq_bb[1];
		if (atMostTwoBitsSet(enemy_r_bb)) {
			if (atMostOneBitSet(enemy_r_bb)) {
				// test if the rabbit can be captured
				captures.createText = use_debug;
				return (captures.testCaptures_bb(game, enemy_r_bb)); 
				//return (enemy_r_bb==0)||(captures.testCaptures_bb(game, enemy_r_bb)); 
				// uses game.steps_remaining
			} 
			// two rabbits to be captured
			if (game.steps_remaining < 4) {// no time for double capture
				return false;
			}
			game.steps_remaining = 2;
			doublestep_list_stack.clear();
			captures.createText = use_debug;
			captures.genCaptures_bb(game, doublestep_list_stack,
					false, enemy_r_bb); 
			game.steps_remaining = 4;
			// a rabbit must be captured by first drag
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove capture_drag = doublestep_list_stack.getCurrentMove();
				if (test_eliminationAfterMove(game, capture_drag)) {
					return true;
				}
			}
			return false;
		} 
		// at most two enemy pieces could be captured in one turn
		return false;
	}

	/*
	 * can a piece (rabbit/nonrabbit) from start_bb reach dest_bb unassisted in
	 * given number of steps? the number of steps is less than 4! (to support
	 * goaling)
	 */
	private boolean can_run(GameState game, int steps, long start_bb,
			long dest_bb) {
		assert ((steps >= 1) && (steps <= 3));
		long empty_bb = game.empty_bb;

		long player_bb = game.player_bb[game.player];

		// find from where dest_bb could be reached expecting the piece is
		// strongest
		long help_need_bb = TRAP_SQUARES;
		start_bb &= player_bb & (~game.frozen_pieces_bb);
		dest_bb &= empty_bb;
		long crazy_bb = touching_bb(player_bb & game.suicide_bb[game.player]) &
		~game.count_touch_bb[game.player][2];
		// places guarded only when runner was not corresponding trap_defender

		if ((start_bb == 0) || (dest_bb == 0))
			return false;

		long good_sq_bb = ~help_need_bb | game.count_touch_bb[game.player][1];
		good_sq_bb &= empty_bb;

		long no_first_bb = help_need_bb & ~game.count_touch_bb[game.player][2]
				& ~dest_bb;
		// runner stepping by first step to no_first_bb would be frozen/suicided
		// there

		long reaching_bb = dest_bb;
		long to_reach_in2_bb=0L;
		long to_reach_in1_bb = dest_bb;
		long runner_bb;
		if (steps == 3) {
			reaching_bb |= touching_bb(reaching_bb) & good_sq_bb;
		}
		if (steps >= 2) {
			//to_reach_in2_bb = reaching_bb; later will be needed for losing supporter in trap hook
			reaching_bb |= touching_bb(reaching_bb) & good_sq_bb;
			to_reach_in1_bb = reaching_bb & ~no_first_bb;
		}
		reaching_bb = to_reach_in1_bb | touching_bb(to_reach_in1_bb);
		start_bb &= reaching_bb;
		// the pieces from start_bb which could reach dest_bb if not frozen on
		// the way by stronger enemy (rabbits could step back)
		int s=GameState.Strongest;;
		while (start_bb != 0) {
			s = game.getStrongestDn(start_bb, game.player, s);
			int backpiece = GameState.StrengthAndColor2InclPiece(s, game.enemy);
			// backward rabbits as enemy rabbits forward

			help_need_bb |= touching_bb(game.player_bb[game.enemy] & game.stronger_or_eq_bb[s + 1]);

			good_sq_bb = ~help_need_bb | game.count_touch_bb[game.player][1];
			good_sq_bb &= empty_bb;

			no_first_bb = help_need_bb & ~game.count_touch_bb[game.player][2]
					& ~dest_bb;

			reaching_bb = dest_bb;
			if (steps == 3) {
				reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
			}
			if (steps >= 2) {
				to_reach_in2_bb = reaching_bb;
				reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
				to_reach_in1_bb = reaching_bb & ~no_first_bb;
			}
			reaching_bb = to_reach_in1_bb | can_step_bb(to_reach_in1_bb, backpiece);
			start_bb &= reaching_bb;
			// frozing by strength higher than s incorporated, but the supporter lost in trap hook
			// is needed
			if ((runner_bb = start_bb & game.stronger_or_eq_bb[s]) != 0) {
				// cannot be frozen on the way except except for trap supporters
				if ((runner_bb & ~game.trap_protect_bb)!=0) {
					return true;
				}
				int piece = GameState.StrengthAndColor2InclPiece(s, game.player);
				while (runner_bb!=0) {// check trap supporters one by another
					long lsb_runner_bb = Util.LastBit(runner_bb);
					runner_bb ^= lsb_runner_bb;
					start_bb ^= lsb_runner_bb;
					if ((to_reach_in2_bb & can_step_bb(can_step_bb(lsb_runner_bb,piece)&to_reach_in1_bb,piece) &
						(~(crazy_bb & help_need_bb)))!=0) {
						// crazy squares at distance 2 are only of the guarded trap
						return true;
					}
				}
			}
		}
		// the purpose of this routine is usually to
		// unfreeze gmt rabbit, the number of phases would be lower.
		return false;
	}

	// Check for unassisted rabbit dashes
	private boolean can_rabbit_run(GameState game, int steps) {
		// TODO losing supporter in a trap bug
		// last step forward to goal!
		long player_bb = game.player_bb[game.player];
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long rabbits_bb = player_bb ^ player_nr_bb;

		if ((goal_dist_bb[game.player][0] & rabbits_bb) != 0) {
			return true;
		}
		
		long empty_bb = game.empty_bb;

		long start_bb = rabbits_bb & (~game.frozen_pieces_bb)
				& goal_dist_bb[game.player][steps];
		long dest_bb = goal_dist_bb[game.player][0] & empty_bb;

		if ((start_bb == 0) || (dest_bb == 0))
			return false;

		long help_need_bb = TRAP_SQUARES
				| touching_bb(game.player_bb[game.enemy]&game.stronger_or_eq_bb[1]);

		long good_sq_bb = ~help_need_bb | game.count_touch_bb[game.player][1];
		good_sq_bb &= empty_bb;

		long no_first_bb = help_need_bb & ~game.count_touch_bb[game.player][2]
				& ~dest_bb;
		// runner stepping by first step to no_first_bb would be frozen/suicided
		// there

		long danger_third_bb = no_first_bb & goal_dist_bb[player][1];
		// ------ ------ ------ ------
		// **r*** *r**r* **rc** **r***
		// c+Rr   +c++c+ d+ ++C c+ +c+
		//         dRRd   CRRc   R R  
		// R                          
		//                            
		long three_ok_bb = FULL_BB; 
		// used in (steps == 4) variant to denote safe squares
		// ----- see picture using by o the rabbit unfreezing it on third step would be
		//  *r*  problem as on 1st step 
		// co.oc but in this diagram rabbits can run through the other o
		//  R.R
		
		int backpiece = GameState.StrengthAndColor2InclPiece(0, game.enemy);
		// backward rabbits as enemy rabbits forward

		long crazy_bb = touching_bb(TRAP_SQUARES & player_bb & game.suicide_bb[game.player]) &
		~game.count_touch_bb[game.player][2] & help_need_bb;

		long reaching_bb = dest_bb;
		long to_reach_in1_bb = dest_bb;
		long to_reach_in2_bb = 0;// steps == 1 case
		if (steps >= 3) {
			reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
			// ------ ------ ------ ------
			// ++r+++ +r++r+ ++rc++ ++r+++
			// c+Rr++  c++c  d+  +C c+ +c+
			//         dRRd   CRRc   R R  
			// R                          
			//                            
		}
		if (steps == 4) {
			reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
			// ------ ------ ------ ------
			// ++r+++ +r++r+ ++rc++ ++r+++
			// c+Rr++  c++c  d++++C c+++c 
			//  +  ++  dRRd   CRRc   R R  
			// R                          
			//                            
			three_ok_bb = can_step_bb(reaching_bb & ~danger_third_bb, backpiece);
			// ------ ------ ------ ------
			// TTrTTT  rTTr  TTrcTT TTrTTT
			// cTRTTT  c  c  dT T C cT Tc 
			// T TTTT  dRRd   CTRc   RTR  
			// RT  TT                     
			//                            
		}
		if (steps >= 2) {
			to_reach_in2_bb = reaching_bb;
			// ------ ------ ------ ------
			// ++r+++ +r++r+ ++rc++ ++r+++
			// c+Rr++  c++c  d++++C c+++c 
			//  +  ++  dRRd   CRRc   R R  
			// R                          
			//                            
			reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
			// ------ ------ ------ ------
			// ++r+++ +r++r+ ++rc++ ++r+++
			// c+Rr++  c++c  d++++C c+++c 
			// ++++++  dRRd   CRRc   R+R  
			// R+  ++                     
			//                            
			to_reach_in1_bb = reaching_bb & ~no_first_bb;
			// ------ ------ ------ ------
			//  +r+++ +r++r+  +rc++  +r+ +
			// c Rr++  c  c  d +  C c + c 
			//  +++++  dRRd   CRRc   R+R  
			// R+  ++                     
			//                            
		}
		long reaching1_bb = reaching_bb;
		// ------ ------ ------ ------
		// ++r+++ +r++r+ ++rc++ ++r+++
		// c+Rr++  c++c  d++++C c+++c 
		// ++++++  dRRd   CRRc   R+R  
		// R+  ++                     
		//                            
		reaching_bb = to_reach_in1_bb | can_step_bb(to_reach_in1_bb, backpiece);
		// ------ ------ ------ ------
		// ++++++ ++++++ ++++++ ++++++
		// ++R+++ +c++c+ d+++++ c+++c+
		// ++++++  dRRd   C+Rc   +++  
		// ++++++                 +   
		//  +  ++                     
		start_bb &= reaching_bb;// if all pieces remain on the board and only one rabbit moves ...
		// frozing incorporated
		// ------ ------ ------ ------
		// **r*** *r**r* **rc** **r***
		// c Rr    c  c  d    C c   c 
		//         dRRd   C+Rc   + +  
		// +                          
		//                            
		if (start_bb == 0) {// frozen on the way
			return false;
		}
		// now solve the third step problem and losing support piece problem ... the runner could be the only trap supporter
		long start3ok_bb;
		if ((start3ok_bb=(start_bb & (three_ok_bb | (~((player == PL_GOLD) ? down_bb(danger_third_bb)
				: up_bb(danger_third_bb)))))) != 0) {
			// some rabbit could go through and not using third step "bug"
			// ------ --KO-- ------ ------
			// **r*** *r**r* **rc** **r***
			// c Rr    c  c  d    C c   c 
			//         dRRd   C+Rc   R R  
			// +                          
			//                            
			if ((start3ok_bb & ~game.trap_protect_bb)!=0) {
				// no losing support problem here
				set_run_indexes(game, start3ok_bb & ~game.trap_protect_bb);
				return true;
			}
			int piece = game.player;
			if ((to_reach_in2_bb & can_step_bb(can_step_bb(start3ok_bb,piece)&to_reach_in1_bb,piece) &
					~crazy_bb)!=0) {// in two steps crazy_bb cannot belong to another trap
				while (start3ok_bb!=0) {// check trap supporters one by another to set_run_indexes!
					long lsb_runner_bb = Util.LastBit(start3ok_bb);
					start3ok_bb ^= lsb_runner_bb;
					if ((to_reach_in2_bb & can_step_bb(can_step_bb(lsb_runner_bb,piece)&to_reach_in1_bb,piece) &
							~crazy_bb)!=0) {
					// crazy squares at distance 2 are only of the guarded trap
						set_run_indexes(game, lsb_runner_bb);
						return true;
					}
				}
			}
		}
		// now whole start_bb two steps from goal where first step wents to
		// danger_third_bb and goal cannot be reached by 3 steps not starting
		// by no_first_bb
		three_ok_bb &= empty_bb; // could we go through tests now
		// --OK-- --KO-- --OK-- ------
		// TTrTTT  rTTr  TTrcTT TTrTTT
		// cTRrTT  c  c  dT T C cT Tc 
		// T TTTT  dRRd   CRRc   RTR  
		// RT  TT                     
		//                            
		long shift_twice_reaching1_bb = left_bb(left_bb(reaching1_bb));
		//   ------ ------ ------ ------
		// ++r+++ +r++r+ ++rc++ ++r+++
		// c+Rr++  c++c  d++++C c+++c 
		// ++++++  dRRd   CRRc   R+R  
		// R+  ++                     
		//                            
		long start_l_run_bb = start_bb
				& ((player == 0) ? down_bb(shift_twice_reaching1_bb)
						: up_bb(shift_twice_reaching1_bb))
				& left_bb(three_ok_bb);
		//  --OK-- --KO-- --OK-- ------
		//   r     r  r    rc     r   
		// c Rr    c  c  d    C c   c 
		//         dRRd   CRRc   + R  
		// R                          
		//                            
		if (start_l_run_bb != 0) {
			// there is path through three_ok_bb and
			// reaching1_bb different from the neighbour.
			// there is no interference with losing support piece
			set_run_indexes(game, start_l_run_bb);
			return true;
		}
		shift_twice_reaching1_bb = right_bb(right_bb(reaching1_bb));
		start_l_run_bb = start_bb
				& ((player == 0) ? down_bb(shift_twice_reaching1_bb)
						: up_bb(shift_twice_reaching1_bb))
				& right_bb(three_ok_bb);
		if (start_l_run_bb != 0) {
			// there is path through three_ok_bb and
			// reaching1_bb different from the neighbour.
			// there is no interference with losing support piece
			set_run_indexes(game, start_l_run_bb);
			return true;
		}
		return false;
	}

	private boolean can_rabbit_run_bb(GameState game, int steps, long goal_bb,
			long vanishing_bb, long helped_bb, long blocked_bb) {
		// TODO losing supporter in a trap bug
		// last step forward!
		// can a rabbit reached goal_bb without other piece moved where
		// vanishing_bb is considered to be empty (originally our single non rabbit (or empty board))
		// vanishing_bb is part of gmtgoal_bb
		// helped_bb supported by a friend
		// blocked_bb ... no more empty and cannot run!

		assert (atMostOneBitSet(vanishing_bb));
		assert (steps >= 1);
		assert (steps <= 3);

		long empty_bb = (game.empty_bb | vanishing_bb) & ~blocked_bb;
		long player_bb = game.player_bb[game.player]
				& (~vanishing_bb);
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long rabbits_bb = player_bb ^ player_nr_bb;
		long supported_bb = helped_bb | touching_bb(player_bb);

		long help_need_bb = touching_bb(game.player_bb[enemy] & game.stronger_or_eq_bb[1]) | TRAP_SQUARES;
		long good_sq_bb = supported_bb | (~help_need_bb);

		long start_bb = ~blocked_bb & rabbits_bb & good_sq_bb & goal_dist_bb[game.player][steps];
		long dest_bb = goal_bb & empty_bb;

		if ((start_bb == 0) || (dest_bb == 0)) {
			// quick test to prevent the search
			return false;
		}
		good_sq_bb &= empty_bb; // just places where to go through
		long enough_supported_bb = helped_bb |
			game.count_touch_bb[game.player][3] |
			((game.count_touch_bb[game.player][2]) & ~touching_bb(vanishing_bb));
	
		long no_first_bb = help_need_bb
				& ~dest_bb
				& ~enough_supported_bb;

		// runner stepping by first step to no_first_bb would be frozen/suicided
		// runner from crazy_rabbits_bb must have path not using crazy_bb to goal
		// as the path length is at most 3, it had no time to run around the trap so 
		// the problem is only on last 3 ranks. Rabbit on second last row does not
		// need support from trap except the starting place so the problem is only on
		// the trap rank.

		int backpiece = GameState.StrengthAndColor2InclPiece(0, game.enemy);
		// backward rabbits as enemy rabbits forward

		long reaching_bb = dest_bb;
		long to_reach_in1_bb = dest_bb;
		long to_reach_in2_bb=0;
		if (steps == 3) {
			reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
			to_reach_in2_bb=reaching_bb;
		}
		if (steps >= 2) {
			reaching_bb |= can_step_bb(reaching_bb, backpiece) & good_sq_bb;
			to_reach_in1_bb = reaching_bb & (~no_first_bb);		
		}
		reaching_bb = to_reach_in1_bb | can_step_bb(to_reach_in1_bb, backpiece);
		start_bb &= reaching_bb; // contains rabbits able to run to goal_bb
		// check losing supporter in a trap bug
		if (steps<=2) {// no interaction with lost supporter
			saved_rabbit_index = Util.bit2ind(Util.LastBit(start_bb));
			return (start_bb != 0);
		}
		if (start_bb==0) {
			return false;
		}
		// could there be problem with vanishing piece being 2nd trap protector except the runner?
		// no in that case its place would be helped
		// therefore trap_protect_bb could be used.
		// vanishing (gmt's) piece's help in protecting trap could not help in reaching gmt in 2 steps
		long start_ok_bb = start_bb & ((~game.trap_protect_bb)|goal_dist_bb[game.player][1]);
		if (start_ok_bb!=0) {
			saved_rabbit_index = Util.bit2ind(Util.LastBit(start_ok_bb));
			return true;
		}
		to_reach_in2_bb &= NON_TOUCH_TRAPS;
		to_reach_in1_bb &= can_step_bb(to_reach_in2_bb,backpiece);
		start_bb &= (game.player==PL_GOLD? down_bb(start_bb):up_bb(start_bb));
		saved_rabbit_index = Util.bit2ind(Util.LastBit(start_bb));
		return (start_bb != 0);
	}

	private void set_run_indexes(GameState game, long goaler_bb) {
		// sets saved_rabbit_index and saved_goal_index
		if (!use_debug) {
			// required only for debug purposes we will need it for goal_path_bb decission!!
			return;
		}
		long rabbit_bb = Util.LastBit(goaler_bb);
		long helpers_bb = game.player_bb[game.player] ^ rabbit_bb;
		long help_need_bb = touching_bb(game.player_bb[game.enemy]&game.stronger_or_eq_bb[1])
				| TRAP_SQUARES;
		long good_sq_bb = (~help_need_bb | touching_bb(helpers_bb))
				& game.empty_bb;

		saved_rabbit_index = Util.bit2ind(rabbit_bb);
		goal_path_bb = 0;
		long reach1_bb = can_step_bb(rabbit_bb, game.player);
		if ((reach1_bb&GOAL_RANKS)==0) {
			long reach2_bb = can_step_bb(reach1_bb & good_sq_bb, game.player);
			if ((reach2_bb&GOAL_RANKS)==0) {
				long reach3_bb = can_step_bb(reach2_bb & good_sq_bb, game.player);
				if ((reach3_bb&GOAL_RANKS)==0) {
					long reach4_bb = can_step_bb(reach3_bb & good_sq_bb, game.player);
					reach4_bb = Util.LastBit(reach4_bb & GOAL_RANKS);
					assert(reach4_bb!=0);
					goal_path_bb|=reach4_bb;
					reach3_bb = Util.LastBit(can_step_bb(reach4_bb, game.enemy) & reach3_bb);
				} else {
					reach3_bb = Util.LastBit(reach3_bb & GOAL_RANKS);
				}
				goal_path_bb|=reach3_bb;
				reach2_bb = Util.LastBit(can_step_bb(reach3_bb, game.enemy) & reach2_bb);
			} else {
				reach2_bb = Util.LastBit(reach2_bb & GOAL_RANKS);
			}
			goal_path_bb|=reach2_bb;
			reach1_bb = Util.LastBit(can_step_bb(reach2_bb, game.enemy) & reach1_bb);
		} else {
			reach1_bb = Util.LastBit(reach1_bb & GOAL_RANKS);
		}
		goal_path_bb|=reach1_bb;
		saved_goal_index = Util.bit2ind(goal_path_bb & GOAL_RANKS);
	}

	// used for individual_goal_square_testing
	private int goal_index; // 0 .. 7
	private long goal_bb, rank_touch_goal_bb, goal_and_rank_touch_bb, gmt_bb,
			gmtgoal_bb, rank_touch_gmt_bb, file_touch_gmt_bb, touch_gmt_bb,
			three_step_bb, trap_guards_bb;

	// test all 8 goals squares sequentially
	private boolean test_goal_squares(GameState game) {
		for (int i=0;i<8;i++) {
			goal_index = goal_sq_order[game.player][i]; 
			saved_goal_index = start_index | goal_index; 
			boolean result = test_individual_goal_square(game);
			if (result) {
				// Save the winning goal location
				for(;i>0;i--) {// move goal square to front!
					goal_sq_order[game.player][i]=goal_sq_order[game.player][i-1];
				}
				goal_sq_order[game.player][0] = goal_index;
				return true;
			}
		}
		saved_goal_index = -1; 
		return false;
	}

	private int count_rabbit_steps_required(GameState game, long rabbit_bb) {
		int rabbit_steps_required = 5;
		// four step runs already tested, this is like an infinity
		if ((three_step_bb & rabbit_bb) != 0) rabbit_steps_required = 3;
		if ((touch_gmt_bb & rabbit_bb) != 0) rabbit_steps_required = 2;
		if ((gmt_bb & rabbit_bb) != 0) rabbit_steps_required = 1;
		return rabbit_steps_required;
	}

	private boolean test_individual_goal_square(GameState game) {//4 steps available
		// Test for impossible scoring patterns to filter calls to test_decide
		
		long enemy_bb = game.player_bb[enemy]; // all enemy pieces
		goal_and_rank_touch_bb = patt_goal_and_rank_touch_goal_bb[player][goal_index];
		// If these patterns are true NO goal possible
		// three enemy piece in a row centred on goal square
		if ((goal_and_rank_touch_bb & enemy_bb) == goal_and_rank_touch_bb) {
			return false;
		}

		// square from which the goal should be reached
		gmtgoal_bb = patt_gmt_goal_bb[player][goal_index];
		// If enemy 'elephant' on gmt or goal square, No goal possible
		if ((gmtgoal_bb & enemy_bb & game.stronger_or_eq_bb[GameState.Strongest]) != 0) {
			return false;
		}

		goal_bb = patt_goal_bb[player][goal_index];
		gmt_bb = patt_gmt_bb[player][goal_index]; 
		rank_touch_goal_bb = patt_rank_touch_goal_bb[player][goal_index];
		rank_touch_gmt_bb = patt_rank_touch_gmt_bb[player][goal_index];
		file_touch_gmt_bb = patt_file_touch_gmt_bb[player][goal_index];
		touch_gmt_bb = rank_touch_gmt_bb | file_touch_gmt_bb;
		three_step_bb = patt_three_step_bb[player][goal_index];
		trap_guards_bb = patt_trap_guards_bb[player][goal_index];

		// Any rabbit needs help to goal, since we already tested for unassisted
		// wins
		// Compute minimum number of rabbit steps required for a goal
		long player_bb = game.player_bb[player]; // all player pieces
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long rabbit_bb = player_bb ^ player_nr_bb;
		long empty_bb = game.empty_bb;

		int rabbit_steps_required = count_rabbit_steps_required(game, rabbit_bb);
		if (rabbit_steps_required > 4) {
			return false;
		}
		// Compute minimum piece steps required for a goal
		// This can be wrong if dual purpose move is possible, but in that case
		// no goal is possible anyway.
		int piece_steps_required = 0; 
		// min steps required to clear goal and gmt squares

		if ((goal_bb & enemy_bb) != 0) {
			// enemy on goal square
			piece_steps_required += 2;
			// To remove enemy
			if ((rank_touch_goal_bb & player_nr_bb) == 0) {
				// no adj player piece
				piece_steps_required += 1;
				// To touch enemy piece
			}
			if (rabbit_steps_required + piece_steps_required > 4) {
				return false;
			}			
		}

		if ((gmt_bb & enemy_bb) != 0) {
			// enemy piece on gmt square
			piece_steps_required += 2;
			// To remove enemy;
			if ((touch_gmt_bb & player_nr_bb) == 0) {
				// no adj player piece
				piece_steps_required += 1;
			}
			if (rabbit_steps_required + piece_steps_required > 4) {
				return false;
			}			
		}

		if ((goal_bb & player_nr_bb) != 0) { // player piece on goal square
			piece_steps_required += 1; // To remove player piece
			if ((rank_touch_goal_bb & empty_bb) == 0) {
				// adj squares occupied
				piece_steps_required += 1; // To clear square for player piece
			}
			if (rabbit_steps_required + piece_steps_required > 4) {
				return false;
			}			
		}

		if ((gmt_bb & player_nr_bb) != 0) {
			// player piece on gmt square
			piece_steps_required += 1;
			// To remove player piece
			if ((touch_gmt_bb & empty_bb) == 0) {
				// adj squares occupied
				piece_steps_required += 1;
				// To clear square for player piece
			}
			if (rabbit_steps_required + piece_steps_required > 4) {
				return false;
			}			
		}

		// We know a rabbit can't win unassisted,
		// so at least one piece step is required
		if (piece_steps_required == 0) {
			piece_steps_required = 1;
		}

		if (use_debug) {// sorry thanks speedup attempts ... this mainly informs when goal seems possible
			LogFile.message(" " + goal_index + "4 steps Avail:"
					+ " RReq: " + rabbit_steps_required
					+ " PReq:" + piece_steps_required);
		}

		// Determine if there are enough steps available
		if (rabbit_steps_required + piece_steps_required > 4) {
			return false;
		}

		// There are enough steps, perform a detailed analysis
		doublestep_list_stack.clear();
		return test_decide(game, 4);
	}

	private boolean test_decideAfterMove(GameState game, int steps, ArimaaMove move) {
		game.playMoveFull(move);
		doublestep_list_stack.levelUp();
		boolean result = test_decide(game, steps - move.steps); 
		doublestep_list_stack.levelDn();
		game.unplayMoveFull(move);
		return result;
	}
	
	/**
	 * Decides which function to call based on provided gamestate
	 * 
	 * @param game
	 *            GameState
	 * @param goal_index
	 *            int
	 * @param total_steps_available
	 *            int
	 * @return boolean
	 */
	private boolean test_decide(GameState game, int steps) {
		// assert no goal yet :)
		// game could be changed from test_individual_goal_square (reflected in
		// steps)
		long player_bb = game.player_bb[player]; // all player pieces
		long rabbit_bb = player_bb & ~game.stronger_or_eq_bb[1];
		long empty_bb = game.empty_bb;

		int rabbit_steps_required = count_rabbit_steps_required(game, rabbit_bb);
		if (rabbit_steps_required == 1) {
			if ((goal_bb & empty_bb) == 0) {
				if (test_GmtRabbit_GoalNotEmpty(game, steps)) {
					saved_rabbit_index = Util.bit2ind(gmt_bb);
					return true;
				} else {
					return false;
				}
			} else {
				if (test_GmtRabbit_GoalEmpty(game, steps)) {
					saved_rabbit_index = Util.bit2ind(gmt_bb);
					return true;
				} else {
					return false;
				}
			}
		}

		int help_steps_allowed = steps - rabbit_steps_required; // <= 4 - 2
		if (help_steps_allowed == 1) {
			return test_atMost1P(game, steps); // at most one help step
		}
		if (help_steps_allowed == 2) {
			return test_atMost2P(game, steps); // at most two help steps
		}
		if (help_steps_allowed == 0) {
			return test_atMost0P(game, steps); // no help step
		}
		return false;
	}

	// Try a two step move
	// Play out all sample moves
	private GenSteps gen_steps = new GenSteps();
	private ArimaaMove temp_move1 = new ArimaaMove();

	private boolean test_atMost0P(GameState game, int total_steps_available) {
		// at least 2 rabbit stes required
		assert (total_steps_available < 4);

		if (use_debug) {
			LogFile.message("test_atMost0P " + goal_index + " "
					+ total_steps_available + "\n" + game);
		}

		return can_rabbit_run(game, total_steps_available);
	}

	// Rabbit on touch_gmt or on three_step
	// At most one piece step to assist remaining steps rabbit needs to reach
	// the goal
	// rabbit could run unassisted (in case steps <= 3)
	private boolean test_atMost1P(GameState game, int total_steps_available) {
		// at least 2 rabbit stes required
		// when goal found the doublestep_list_stack.stack_ind is not decreased
		
		if (use_debug) {
			LogFile.message("test_atMost1P " + goal_index + " "
					+ total_steps_available + "\n" + game);
		}

		long enemy_bb = game.player_bb[enemy]; // all enemy pieces
		long player_bb = game.player_bb[player]; // all player pieces
		long empty_bb = game.empty_bb;
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long rabbit_bb = player_bb ^ player_nr_bb;
		long enemy_nr_bb = enemy_bb & game.stronger_or_eq_bb[1];
		long twice_slide_to_touch_gmt_bb = 0;
		// these places require special treatement as they are
		// affected by step order the step order affects mutual
		// pieces protection ...
		if ((file_touch_gmt_bb & empty_bb) != 0) {
			twice_slide_to_touch_gmt_bb = (player == PL_GOLD) 
					? down_bb(rank_touch_gmt_bb & empty_bb)
					: up_bb(rank_touch_gmt_bb & empty_bb);
		}

		assert (total_steps_available >= 3);

		// If enemy on path
		if (((gmtgoal_bb) & enemy_bb) != 0) {
			return false;
		}

		long blocking_bb = gmtgoal_bb & player_bb;
		// nonrabbit here, otherwise gmt* routine would be called
		// If both goal and gmt occupied ... (for 3 steps test_decide called
		// rather than test_individual_goal_square)
		if (blocking_bb == gmtgoal_bb) {// 2 non_rabbit steps required
			return false;
		}

		if (blocking_bb != 0) {// piece to use the one step localised so we can
								// reduce the problem to rabbit run decision
			if ((goal_and_rank_touch_bb & empty_bb) == 0) {
				return false; // no time to free it
			}
			if ((rank_touch_gmt_bb & enemy_nr_bb) != 0) {
				// frozen gmt under trap guarded just from gmt does not
				// allow slip around
				if ((game.lone_defender_bb[player] & gmt_bb) != 0) {
					// otherwise blocking_bb remains unfrozen if piece steps away
					return false; 
				}
			}
			long vanishing_bb = blocking_bb; // to be updated
			long helped_bb = blocking_bb; // to be updated
			long blocked_bb = 0L; // to be updated
			// there could be two empty places touching the blocking_bb or a
			// runner touching it with just one empty square
			if (blocking_bb == gmt_bb) {
				if (atMostOneBitSet(touch_gmt_bb & (empty_bb | rabbit_bb))) {
					// no space for rotation
					return false;
				}
				long step_to_bb = touch_gmt_bb & empty_bb;
				if (atMostOneBitSet(step_to_bb)) {
					// ----- -----
					// rr cr|rr cr
					//  dCRR| rCRR
					//   .  |     
					if (step_to_bb == 0) {// no escape path
						return false;
					}
					blocked_bb = (~(touch_gmt_bb|gmtgoal_bb)) | step_to_bb;
					// there is no path for rabbit other than on touch_gmt
				} else {// two empty places around gmt so piece could step away
						// when required
					if ((game.frozen_pieces_bb & gmt_bb) == 0) {
						// the piece could unfroze (and not block) rabbit first
						helped_bb |= twice_slide_to_touch_gmt_bb;
					}
					if ((rank_touch_gmt_bb & enemy_nr_bb) != 0) {
						// must guarantee gmt does not become frozen due to suicide
						if (atMostOneBitSet(trap_guards_bb & player_bb)) {
							// the only guard could not slip around the piece unfrozen
							blocked_bb = trap_guards_bb & player_bb;
							// ----- ----- only h7 rabbit could score here
							// rr rr|rr rd| trap_guards = FULL_BB for
							//  cC R| cC R|((file_touch_gmt_bb & TRAP_SQUARES) == 0)
							//   .R |  .R | so this is invoked only for traps
							//      |     | there is a guard otherwise the suicide was
							// already detected and branch rejected
						}
					}
				}
			} else { // blocking_bb = goal_bb
				long step_to_bb = rank_touch_goal_bb & empty_bb;
				if ((game.frozen_pieces_bb & goal_bb) == 0) {
					// the piece could unfroze rabbit first
					helped_bb = (player == 0) ? down_bb(step_to_bb) : up_bb(step_to_bb);
					// can unfreeze wherever required
				}
			}
			return can_rabbit_run_bb(game, total_steps_available - 1, goal_bb,
					vanishing_bb, helped_bb, blocked_bb);
		} // blocking_bb != 0

		// gmt_bb and goal_bb empty now
		long help_need_bb = touching_bb(enemy_nr_bb) | TRAP_SQUARES;
		if (((help_need_bb & gmt_bb) != 0) && (touch_gmt_bb & player_bb) == 0) {
			// gmt must be unfrozen ... the piece step localised
			// it's difficult to preprocess for single can_rabbit_run_bb call
			// ... this is why separate solution seems better
			long cut_bb = touch_gmt_bb & empty_bb;
			long start_bb = touching_bb(cut_bb) & (~game.frozen_pieces_bb)
					& player_bb;
			long runners_bb = rabbit_bb & start_bb;

			if (atMostOneBitSet(start_bb)) {
				// two_slide_to_touch_gmt_bb trick is the only hope for goal
				// first two steps are forced ...
				// 1) start_bb to touch_gmt_bb
				// 2) (another!) piece form two_slide_to_touch_gmt_bb to the
				// other touch_gmt_bb
				// 3) rabbit step from touch_gmt_bb to gmt_bb
				// 4) rabbit step from gmt_bb to goal_bb
				long moved_bb = start_bb | twice_slide_to_touch_gmt_bb;
				if (atMostOneBitSet(player_bb & moved_bb)) {
					// just one piece could reach touch_gmt
					return false;
				} // 2) could be performed
				if ((rabbit_bb & moved_bb) == 0) {
					// no rabbit can run to touch_gmt
					return false;
				} // so we have a rabbit and piece on touch_gmt but piece on
					// trap could be lost and the rabit could be frozen
				if ((TRAP_SQUARES & file_touch_gmt_bb) != 0) {
					// check for the suicide
					// if player has last two pieces false suicide could be
					// detected by following test therefore both tests are
					// needed
					if ((trap_guards_bb & player_bb & (~moved_bb)) == 0) {
						// suicide prevents gmt unfreeze (even when hepled by phant)
						return false;
					}
				}
				// so gmt is unfrozen, but the rabbit could be still frozen on
				// touch_gmt
				long helpers_bb = player_bb ^ moved_bb;
				long good_sq_bb = (~help_need_bb) | touching_bb(helpers_bb);
				long good_cut_bb = good_sq_bb & cut_bb;
				if (atMostOneBitSet(good_cut_bb)) {
					// at most one safe path (through good_cut_bb)
					if (atMostOneBitSet(touching_bb(good_cut_bb) & moved_bb)) {
						// piece from two_slide_to_touch_gmt_bb would go through good_cut_bb
						// if good_cut_bb is nonempty!
						if (((rabbit_bb & twice_slide_to_touch_gmt_bb) != 0)
								&& (good_cut_bb != 0)) {
							saved_rabbit_index = Util.bit2ind(Util.LastBit(twice_slide_to_touch_gmt_bb));
							return true;
						} else { 
							// each rabbit ends frozen on touch_gmt_bb
							return false;
						}
					} else {
						// piece from start_bb would go through good_cut_bb
						if ((rabbit_bb & start_bb) != 0) {
							saved_rabbit_index = Util.bit2ind(Util.LastBit(start_bb));
							return true;
						} else {
							// the rabbit ends frozen on touch_gmt_bb
							return false;
						}
					}
				} else {
					// both paths are safe
					saved_rabbit_index = Util.bit2ind(Util.LastBit(moved_bb & rabbit_bb));
				}
			} else if (runners_bb == 0) {
				// two_slide_to_touch_gmt_bb rabbit trick is the only hope for goal
				// first step is a nonrabbit step to touch_gmt next three steps
				// are with rabbit from two_slide_to_touch_gmt_bb
				// there are at least 2 pieces able to step to touch_gmt
				// if they can step to both places, we could choose non trap
				// place,
				// rabbit goes unfrozen through the other place, the gmt and
				// goal
				// if they can step to only one place, the supporting piece
				// cannot suicide so we can use
				// "rabbit" good_sq_bb to test if the rabbit could score
				// (through the other touch_gmt)
				// the occupied place is surely good_sq, so goal exactly when
				// good_sq_bb has 2 places
				if ((rabbit_bb & twice_slide_to_touch_gmt_bb) == 0) {
					// no rabbit to go
					return false;
				}
				// TODO check for "3step bug!!!"
				long helpers_bb = player_bb ^ twice_slide_to_touch_gmt_bb;
				long good_sq_bb = (~help_need_bb) | touching_bb(helpers_bb);
				long good_cut_bb = good_sq_bb & cut_bb;
				if (atMostOneBitSet(good_cut_bb)) {
					// rabbit frozen/suicided on the "bad" cut_bb
					return false;
				} else {
					saved_rabbit_index = Util.bit2ind(Util.LastBit(twice_slide_to_touch_gmt_bb));
				}
			} else {
				// there is runner touching touch_gmt and it can be unfrozen
				// on gmt so the only question is
				// whether it suicides/frozes on touch_gmt the supporting piece
				// is not frozen so rabbit could make first two steps
				// (if possible) and than the piece unfrozes it
				long helped_bb = gmt_bb; // to be checked

				return can_rabbit_run_bb(game, total_steps_available - 1,
						goal_bb, 0L, helped_bb, 0L);
			}
		} // gmt needs help, no friend around

		// gmt is not frozen so last step by rabbit would be OK so find path
		// through touch_gmt
		// long near_rabbit_bb = touch_gmt & rabits_bb;
		// if (near_rabbit_bb != 0) {
		// ////////////////// TODO ////////////////
		// // rabbit could be frozen on gmt if it is the only one player piece
		// on touch_gmt
		// // rabbit could start frozen
		// // another rabbit can goal
		// // number of steps could be 3
		// if (((help_need_bb & gmt_bb) != 0) && atMostOneBitSet(touch_gmt &
		// player_bb)) {// the rabbit from touch_gmt needs support from
		// touch_gmt
		// if ((game.frozen_pieces_bb & near_rabbit_bb) != 0) {// the rabbit
		// needs a piece to unfreeze and it would be frozen on
		// // gmt so another help step would be required therefore this rabbit
		// cannot goal using at most 1 other piece step
		// // but another rabbit can goal using just one help step
		// } else {// the rabbit can step to gmt so if a piece can unfreeze gmt
		// by one step this rabbit goals (in 2+1 steps)
		// // another rabbit can goal as well (in 3+1 steps)
		// // test if a piece can unfreeze it on touch gmt is complicated by
		// fact the rabbit could be the only friend of
		// // the newly frozen piece
		// long unfrozer_bb = player_bb & touching_bb(touch_gmt_bb &
		// (~enemy_bb)) & (~frozen_pieces_bb);
		// // unfrozer could be frozen by rabbit leaving touch_gmt !!
		// // ----- -----
		// // rr rr|rr rr
		// // c c | c Rc
		// // dCRCd| Cd
		// // | dR
		// }
		// }
		// }

		long path_bb = gmt_bb;
		long touch_path_bb = touch_gmt_bb & ~enemy_bb;

		if (total_steps_available == 4) {
			path_bb |= touch_path_bb; // tree?!
			touch_path_bb |= touching_bb(touch_path_bb) & ~enemy_bb
					& ~gmtgoal_bb;
		}

		long near_rabbit_bb = touch_path_bb & rabbit_bb;
		if (near_rabbit_bb == 0) {
			// no rabbit can reach goal in steps-1 even when everything unfrozen
			return false;
		}

		long helpers_bb = player_bb ^ near_rabbit_bb;
		long helped_bb = touching_bb(helpers_bb); 
		// support of already helped place does not help 
		// as the other helper remains helping

		// now there are too many branches not easy forcing such search, but try to
		// minimise the search width
		// try destinations which could somehow help
		// if total_steps_available >= 3
		// first try supporter step first (excluding near rabbit supporter
		// steps, which would be included in the rabbit first step)?
		// Case 1) supporter step away from path to help to go through
		// trap/frozen place (try most usefull case first)

		// find places needing support will be narrowed place sufficiently
		// supported could gain another supporter
		long dest_bb = touching_bb(path_bb & help_need_bb & (~helped_bb))
				& ~(gmtgoal_bb);
		long frozen_near_rabbit_bb = near_rabbit_bb & game.frozen_pieces_bb;
		if (frozen_near_rabbit_bb == near_rabbit_bb) {
			// all candidates frozen, unfreeze step needed
			dest_bb = touching_bb(frozen_near_rabbit_bb) & ~gmt_bb;
			// a) b) c) in the case c) the goaling move is to go away with C to
			// clear path for R
			// xx xx xx xx xC xx this is not to touching_bb(path_bb &
			// help_need_bb & (~helped_bb)) these moves
			// C c C c C c would be tried in the 2nd phase!
			// cR. cRr rR.
			// C C

		} else if (frozen_near_rabbit_bb != 0) {
			// If rabbit is frozen, try and unfreeze
			dest_bb |= touching_bb(frozen_near_rabbit_bb) & ~gmt_bb;
		}

		long start_bb = helpers_bb & path_bb;
		if (use_debug) {
			LogFile.message("Case 1) Try moving away piece supporting path");
			print_bitboard(start_bb, "start_bb");
			print_bitboard(dest_bb, "dest_bb");
		}

		if ((start_bb != 0) && (dest_bb != 0)) {
			doublestep_list_stack.levelReWrite();
			game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}
		}

		// Case 2) supporter step to help to go through trap/frozen place not
		// starting on path

		start_bb ^= helpers_bb;
		// = helpers_bb ^ ~path_bb
		if (use_debug) {
			LogFile.message("Case 2) Try moving piece supporting path");
			print_bitboard(start_bb, "start_bb");
			print_bitboard(dest_bb, "dest_bb");
		}

		if ((start_bb != 0) && (dest_bb != 0)) {
			doublestep_list_stack.levelReWrite();
			game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}
		}

		// Case 3) supporter step away not to block the path ... the supporting
		// steps were already considered so nonsupporting steps to be tested
		start_bb ^= helpers_bb; // = helpers_bb & path_bb
		dest_bb = ~dest_bb;
		if (use_debug) {
			LogFile.message("Case 3) Try step away piece");
			print_bitboard(start_bb, "start_bb");
			print_bitboard(dest_bb, "dest_bb");
		}

		if (start_bb != 0) {
			doublestep_list_stack.levelReWrite();
			game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}
		}
		// could a near_rabbit step not leading to path_bb help?
		// not as step away, but could it unfreeze the path? ... if on
		// three_steps_bb step out of the path does not unfreeze the path
		// if on rank_touch_gmt step away could not help
		// if on file_touch_gmt side step unfreezes rank_touch_gmt, but if
		// another rabbit A can goal this way, the rabbit A can step to
		// file_touch_gmt and file_touch_gmt rabbit could goal so if rabbit step
		// away could help goaling, another goal by step to path would be
		// detected

		// rr cr
		// c R
		// R

		// Case 4) Try moving a rabbit towards the goal
		start_bb = near_rabbit_bb ^ frozen_near_rabbit_bb;
		dest_bb = path_bb & empty_bb;

		if (use_debug) {
			LogFile.message("Case 4) Try moving rabbit towards goal");
			print_bitboard(start_bb, "start_bb");
			print_bitboard(dest_bb, "dest_bb");
		}

		if ((start_bb != 0) && (dest_bb != 0)) {
			doublestep_list_stack.levelReWrite();
			game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}
		}
		return false;
	}

	// Tries all remove protection moves at enemy traps
	private boolean test_remove_protection(GameState game,
			int total_steps_available) {
		// at most 3 steps available for removing protection
		if (use_debug) {
			LogFile.message("test_remove_protection " + goal_index + " "
					+ total_steps_available + "\n" + game);
		}

		long enemy_bb = game.player_bb[enemy];
		// all enemy pieces
		long player_bb = game.player_bb[player];
		// all player pieces

		long goal_trap_protect = game.trap_protect_bb & goal_dist_bb[player][3];
		if (goal_trap_protect == 0) {
			// nothing to suicide/capture
			return false;
		}

		// Try remove protection captures for both enemy traps
		// I hope 3 steps for sacrifying piece on trap could not help in goaling
		long start_bb = goal_trap_protect & player_bb;
		if (start_bb != 0) {
			doublestep_list_stack.levelReWrite();
			game.genSlideMoves(doublestep_list_stack, start_bb, FULL_BB);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}
		}

		// Check for enemy piece
		long estart_bb = goal_trap_protect & enemy_bb;
		// drag protecting piece away
		if (estart_bb != 0) {
			if (use_debug) {
				LogFile.message("test_remove_protection dragging\n");
			}
			doublestep_list_stack.levelReWrite();
			game.genDragMoves(doublestep_list_stack, FULL_BB, FULL_BB,
					estart_bb, FULL_BB);

			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove drag = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, drag)) {
					return true;
				}
			}
			long dragger_bb = touching_bb(estart_bb) & ~enemy_bb;
			if (use_debug) {
				LogFile.message("test_remove_protection preparing drag\n");
			}
			doublestep_list_stack.levelReWrite();
			gen_steps.genSlideMovesF(game,doublestep_list_stack, FULL_BB, dragger_bb,false);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}
		}
		return false;
	}

	// Rabbit on touch_gmt, 2 piece steps to assist
	private boolean test_atMost2P(GameState game, int total_steps_available) {
		// at least 2 rabbit stes required

		if (use_debug) {
			LogFile.message("test_2R2P " + goal_index + " "
					+ total_steps_available + "\n" + game);
		}

		long enemy_bb = game.player_bb[enemy]; // all enemy pieces
		long player_bb = game.player_bb[player]; // all player pieces
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long enemy_nr_bb = enemy_bb & game.stronger_or_eq_bb[1];
		long rabbit_bb = player_bb ^ player_nr_bb;
		long near_rabbit_bb = touch_gmt_bb & rabbit_bb;
		long frozen_near_rabbit_bb = near_rabbit_bb & game.frozen_pieces_bb;
		long empty_bb = game.empty_bb;

		assert (total_steps_available == 4);
		assert (near_rabbit_bb != 0); // Rabbit on Touch GMT

		// Case 1) Try using only one piece step
		if (test_atMost1P(game, total_steps_available)) {
			return true;
		}

		// Case 1) Try remove protection plays
		if (test_remove_protection(game, total_steps_available)) {
			return true;
		}

		// Case 2) Try unfreezing a rabbit by putting player piece beside rabbit
		// Case 3) Try Unfreezing GMT square by putting player piece beside GMT
		long start_bb = FULL_BB;
		long dest_bb = touching_bb(frozen_near_rabbit_bb);
		dest_bb |= touch_gmt_bb;
		if (use_debug) {
			LogFile.message("test_2R2P unfreeze rabbit or gmt");
		}
		doublestep_list_stack.levelReWrite();
		gen_steps.genTwoStep(game, doublestep_list_stack, start_bb, dest_bb);
		for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
			ArimaaMove twoSteps = doublestep_list_stack.getCurrentMove();
			if (test_decideAfterMove(game, total_steps_available, twoSteps)) {
				return true;
			}
		}
		// Case 4) If player on Goal, move it
		// Case 5) If player on GMT, move it
		start_bb = gmtgoal_bb & player_nr_bb;
		dest_bb = ~gmtgoal_bb;

		if (start_bb != 0) {

			if (use_debug) {
				LogFile.message("test_2R2P leave gmtgoal");
			}
			doublestep_list_stack.levelReWrite();
			gen_steps.genTwoStep(game, doublestep_list_stack, start_bb, dest_bb);
			// (1 or 2 steps)
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove twoSteps = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, twoSteps)) {
					return true;
				}
			}
		}

		// Case 6) Pull enemy piece off goal
		// Case 7) Pull enemy piece off gmt
		// Case 8) Pull enemy piece off gmt_freezer
		// Case 9) Pull enemy piece off rabbit freezer

		// NEW CASE) Pull enemy protection piece away from trap
		// This can work for case 8 or case 9 ... already done by
		// remove_protecton test

		long e_start_bb = 0;

		// Case 6 and 7
		e_start_bb |= gmtgoal_bb & enemy_bb;
		// Case 8 and 9
		long e_possible_bb = (touch_gmt_bb & enemy_nr_bb);
		e_possible_bb |= touching_bb(frozen_near_rabbit_bb) & enemy_nr_bb;
		e_start_bb |= e_possible_bb;

		long e_dest_bb = ~gmtgoal_bb;
		dest_bb = ~gmtgoal_bb;
		start_bb = FULL_BB;

		if (e_start_bb != 0) {
			if (use_debug) {
				LogFile.message("test_2R2P pull enemy out");
			}
			doublestep_list_stack.levelReWrite();
			game.genDragMoves(doublestep_list_stack, start_bb, dest_bb,
					e_start_bb, e_dest_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove drag = doublestep_list_stack.getCurrentMove();
				if (test_decideAfterMove(game, total_steps_available, drag)) {
					return true;
				}
			}
		}

		// Support runner, so another piece can move away!!
		dest_bb = touching_bb(near_rabbit_bb) & empty_bb & (~gmtgoal_bb);
		start_bb = FULL_BB & ~touch_gmt_bb;
		if (use_debug) {
			LogFile.message("test_2R2P support runner");
		}
		doublestep_list_stack.levelReWrite();
		game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
		for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
			ArimaaMove slide = doublestep_list_stack.getCurrentMove();
			if (test_decideAfterMove(game, total_steps_available, slide)) {
				return true;
			}
		}

		// .... Support piece so rabbit can move away and be unfrozen next
		// h..h if piece not on trap, the rabbit step first would work as well
		// eRCm and would be tested
		long danger_bb = touching_bb(near_rabbit_bb & game.trap_protect_bb)
				& player_bb;
		dest_bb = touching_bb(danger_bb) & empty_bb;
		start_bb = ~danger_bb;
		if (use_debug) {
			LogFile.message("test_2R2P support supporter");
		}
		doublestep_list_stack.levelReWrite();
		game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
		for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
			ArimaaMove slide = doublestep_list_stack.getCurrentMove();
			if (test_decideAfterMove(game, total_steps_available, slide)) {
				return true;
			}
		}

		// Case 2) Try moving a rabbit towards the goal
		start_bb = near_rabbit_bb ^ frozen_near_rabbit_bb;
		dest_bb = gmt_bb;
		if (use_debug) {
			LogFile.message("test_2R2P run");
		}
		doublestep_list_stack.levelReWrite();
		game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
		for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
			ArimaaMove slide = doublestep_list_stack.getCurrentMove();
			if (test_decideAfterMove(game, total_steps_available, slide)) {
				return true;
			}
		}
		return false;
	}

	
	private boolean test_GmtRabbit_GoalNotEmpty(GameState game,
			int total_steps_available) {

		if (use_debug) {
			LogFile.message("test_GmtRabbit_GoalNotEmpty " + goal_index
					+ " " + total_steps_available + "\n" + game);
		}

		int piece_steps_available = total_steps_available - 1;

		long player_bb = game.player_bb[player]; // all player pieces
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long rabbit_bb = player_bb & ~player_nr_bb;
		long enemy_bb = game.player_bb[enemy]; // all enemy pieces
		long enemy_nr_bb = enemy_bb & game.stronger_or_eq_bb[1];
		long empty_bb = game.empty_bb;

		assert ((goal_bb & empty_bb) == 0); // Goal NOT empty
		assert ((rabbit_bb & gmt_bb) != 0); // Rabbit on GMT

		// Not enough steps to goal!
		if (total_steps_available < 2) {
			return false;
		}

		if (piece_steps_available == 1) {
			// Only Case!! Slide player piece off goal
			if ((goal_bb & player_bb) != 0) {// time to remove piece
				if ((rank_touch_goal_bb & empty_bb) != 0) {// where to step away
					if ((touch_gmt_bb & enemy_nr_bb) == 0
							|| (touch_gmt_bb & player_bb) != 0) {
						// gmt rabbit not frozen
						saved_rabbit_index = Util.bit2ind(gmt_bb);
						return true;
					}
				}
			}
			return false;
		}

		if (piece_steps_available == 2) {
			// Case A: Unassisted Slide
			// Case B: Assisted Slide
			// Case C: Push Out

			if ((goal_bb & player_bb) != 0) {

				long escape_bb = rank_touch_goal_bb;
				while (escape_bb != 0) {
					long lsb_bb = Util.LastBit(escape_bb);
					escape_bb ^= lsb_bb; // Remove the piece

					// Case 1) Escape_bb is empty
					if ((lsb_bb & empty_bb) != 0) {

						// Test if gmt rabbit is frozen
						if ((touch_gmt_bb & enemy_nr_bb) == 0
								|| (touch_gmt_bb & player_bb) != 0) {
							return true;
						}

						// One step left to free rabbit
						// Rabbit still frozen
						// Make new gamestate and send on to empty goal tester
						// no zorb required
						temp_move1.clear();
						int goal_piece = game.getPieceType(saved_goal_index)>>1;
						temp_move1.from_bb[goal_piece] = goal_bb;
						temp_move1.to_bb[goal_piece] = lsb_bb;
						temp_move1.steps = 1;
						temp_move1.info_mask |= (player == PL_GOLD) ? 0
								: ArimaaMove.SILVER_MARK;
						if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, temp_move1)) {
							return true;
						}
					}

					// Case 2) Escape_bb contains player
					if ((lsb_bb & player_bb) != 0) {
						long dest_bb = touching_bb(lsb_bb) & empty_bb;

						// 1a) Slide out and slide goal (lsb2 == empty) 2 steps
						if (dest_bb != 0) {
							// Test if gmt rabbit is frozen
							if (((dest_bb & touch_gmt_bb) != 0)
									|| ((touch_gmt_bb & enemy_nr_bb) == 0)
									|| ((touch_gmt_bb & player_bb) != 0)) {
								return true;
							}
						}
					}
					// Case 3 Escape_bb contains enemy
					if ((lsb_bb & enemy_bb) != 0) {
						long dest_bb = touching_bb(lsb_bb) & empty_bb;
						int pt = game.getPieceTypeOneSq(lsb_bb)>>1;

						// 3a) Push out (lsb2==empty) 2 steps
						if (dest_bb != 0) {
							// Check if goal piece is strong enough to push out
							if ((game.stronger_or_eq_bb[pt + 1] & goal_bb) != 0) {
								// Test if gmt rabbit is frozen

								// Enemy piece could be pushed onto touch_gmt
								// square!
								if ((touch_gmt_bb & enemy_nr_bb) == 0) {
									if ((lsb_bb & enemy_nr_bb) == 0
											|| (dest_bb & ~touch_gmt_bb) != 0) {
										return true;
									}
								}
								if ((touch_gmt_bb & player_bb) != 0) {
									return true;
								}
							}
						}
					}
				}
			}
			if ((goal_bb & enemy_bb) != 0) {

				// Only Case: Pull enemy piece off goal
				int pt = game.getPieceType(saved_goal_index)>>1;
				long escape_bb = player_bb & rank_touch_goal_bb
						& game.stronger_or_eq_bb[pt + 1]
						& ~game.frozen_pieces_bb & touching_bb(empty_bb);
				if (escape_bb != 0) { // goal can be cleaned
					if ((gmt_bb & game.frozen_pieces_bb) == 0) {
						// and the rabbit is not frozen
						return true;
					}
					if ((touching_bb(escape_bb) & touch_gmt_bb & empty_bb) != 0) {
						// and the rabbit could be unfrozen
						return true;
					}
				}
			}
		}

		if (piece_steps_available == 3) {
			// Player piece on goal square
			if ((goal_bb & player_bb) != 0) {

				// process empty neighbours, than player neighbours and enemy
				// neighbours last could be better TODO

				long escape_bb = rank_touch_goal_bb;
				while (escape_bb != 0) {
					long lsb_bb = Util.LastBit(escape_bb);
					escape_bb ^= lsb_bb; // Remove the piece

					// Case 1) Escape_bb is empty
					if ((lsb_bb & empty_bb) != 0) {

						// Test if gmt rabbit is frozen
						if ((touch_gmt_bb & enemy_nr_bb) == 0
								|| (touch_gmt_bb & player_bb) != 0) {
							// not frozen so immediate goal in 2 steps
							return true;
						}

						// Two steps left to free rabbit
						// Rabbit still frozen
						// Make new gamestate and send on to empty goal tester
						// no zorb required
						temp_move1.clear();
						int goal_piece = game.getPieceType(saved_goal_index)>>1;
						temp_move1.from_bb[goal_piece] = goal_bb;
						temp_move1.to_bb[goal_piece] = lsb_bb;
						temp_move1.steps = 1;
						temp_move1.info_mask |= (player == PL_GOLD) ? 0
								: ArimaaMove.SILVER_MARK;
						if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, temp_move1)) {
							return true;
						}
					}

					// Case 2) Escape_bb contains player
					if ((lsb_bb & player_bb) != 0) {

						long dest_bb = touching_bb(lsb_bb) & ~goal_bb;
						if ((dest_bb & empty_bb) != 0) {
							// Test if gmt rabbit is frozen
							if ((dest_bb & touch_gmt_bb & empty_bb) != 0
									|| (touch_gmt_bb & enemy_nr_bb) == 0
									|| (touch_gmt_bb & player_bb) != 0) {
								// not frozen so immediate goal (in 3 steps)
								return true;
							}
						}

						while (dest_bb != 0) {
							long lsb2_bb = Util.LastBit(dest_bb);
							dest_bb ^= lsb2_bb; // Remove the piece

							// 1a) Slide out and slide goal (lsb2 == empty) 2
							// steps
							if ((lsb2_bb & empty_bb) != 0) {

								// One step left to free rabbit
								// Goal is clear, but rabbit still frozen
								// Make new gamestate and send on to empty goal
								// tester
								// no need of zorb
								temp_move1.clear();
								int lsb_piece = game.getPieceTypeOneSq(lsb_bb)>>1;
								temp_move1.from_bb[lsb_piece] = lsb_bb;
								temp_move1.to_bb[lsb_piece] = lsb2_bb;
								int goal_piece = game.getPieceType(saved_goal_index)>>1;
								temp_move1.from_bb[goal_piece] |= goal_bb;
								temp_move1.to_bb[goal_piece] |= lsb_bb;
								temp_move1.steps = 2;
								temp_move1.info_mask |= (player == PL_GOLD) ? 0
										: ArimaaMove.SILVER_MARK;
								if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, temp_move1)) {
									return true;
								}
							}

							// 1b) Push Out and slide goal (lsb2 == enemy) 3
							// steps
							if ((lsb2_bb & enemy_bb) != 0) {

								// Check if lsb can push out
								int pt = game.getPieceTypeOneSq(lsb2_bb)>>1;
								// comparison the other way would be better as
								// it could call just one getStrength
								if ((game.stronger_or_eq_bb[pt + 1] & lsb_bb) != 0) {
									long far_dest_bb = touching_bb(lsb2_bb)
											& empty_bb;
									if (far_dest_bb != 0) {
										// Test if gmt rabbit is frozen
										if ((lsb2_bb & touch_gmt_bb) != 0
												|| (touch_gmt_bb & enemy_nr_bb) == 0
												|| (touch_gmt_bb & player_bb) != 0) {
											return true; // goal in 4 steps
										}
									}
								}
								// All steps used up
							}
							// 1c) Vacate with slide and slide and slide goal
							// (lsb2 == player) 3 steps
							if ((lsb2_bb & player_bb) != 0) {
								// Check for final flight square

								long far_dest_bb = can_step_bb(lsb2_bb,
										game.getPieceTypeOneSq(lsb2_bb))
										& empty_bb;
								if (far_dest_bb != 0) {
									// Test if GMT rabbit is frozen
									// friend->friend replacement does not
									// change status
									if ((touch_gmt_bb & enemy_nr_bb) == 0
											|| (touch_gmt_bb & player_bb) != 0) {
										return true; // goal in 4 steps
									}
								}
								// All steps used up
							}
						}
					}

					// Case 3 Escape_bb contains enemy
					if ((lsb_bb & enemy_bb) != 0) {
						long dest_bb = touching_bb(lsb_bb) & ~goal_bb;
						int pt = game.getPieceTypeOneSq(lsb_bb)>>1;
						while (dest_bb != 0) {
							long lsb2_bb = Util.LastBit(dest_bb);
							dest_bb ^= lsb2_bb; // Remove the piece

							// 2a) Push out (lsb2==empty) 2 steps
							if ((lsb2_bb & empty_bb) != 0) {
								// Check if goal piece is strong enough to push
								// out
								if ((game.stronger_or_eq_bb[pt + 1] & goal_bb) != 0) {
									// Test if gmt rabbit is frozen
									if ((touch_gmt_bb & player_bb) != 0) {
										return true; // goal in 3 steps
									}

									// Enemy piece could be pushed onto
									// touch_gmt square!
									if ((touch_gmt_bb & enemy_nr_bb) == 0) {
										if ((lsb_bb & enemy_nr_bb) == 0
												|| (lsb2_bb & touch_gmt_bb) == 0) {
											return true; // goal in 3 steps
										}
									}

									// Rabbit is frozen but one step remains to
									// try and free it
									// Make new gamestate and send on to empty
									// goal tester
									temp_move1.clear();
									int goal_piece = game.getPieceType(saved_goal_index)>>1;
									temp_move1.from_bb[goal_piece] = goal_bb;
									temp_move1.to_bb[goal_piece] = lsb_bb;
									temp_move1.enemy_from_bb = temp_move1.from_bb[pt] = lsb_bb;
									temp_move1.enemy_to_bb = temp_move1.to_bb[pt] = lsb2_bb;
									temp_move1.steps = 2;
									temp_move1.info_mask |= ((player == PL_GOLD) ? 0
													: ArimaaMove.SILVER_MARK);
									if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, temp_move1)) {
										return true;
									}
								}
							}

							if ((lsb2_bb & player_bb) != 0) {

								// 2b) Vacate escape with pull, and slide goal
								// (lsb2==player) 3steps
								// 2c) Vacate push dest with slide, push out
								// goal (lsb2==player) 3 steps

								// Check if piece is not frozen
								if ((lsb2_bb & game.frozen_pieces_bb) == 0) {
									// Check if piece has empty square to move
									// to
									if ((can_step_bb(lsb2_bb,
											game.getPieceTypeOneSq(lsb2_bb)) & empty_bb) != 0) {
										// Check if one of the player pieces is
										// strong enough to drag
										if ((game.stronger_or_eq_bb[pt + 1] & (goal_bb | lsb2_bb)) != 0) {

											// Test if gmt rabbit is frozen
											// Player piece on lsb2_bb leaves
											// touch_gmt square!
											if (((touch_gmt_bb & ~lsb2_bb) & player_bb) != 0) {
												return true; // goal in 4 steps
											}

											// Enemy piece could be pushed onto
											// touch_gmt square!
											if ((touch_gmt_bb & enemy_nr_bb) == 0) {
												if ((lsb_bb & enemy_nr_bb) == 0
														|| (lsb2_bb & touch_gmt_bb) == 0) {
													return true; // goal in 4
																	// steps
												}
											}

										}
									}
								}
							}
							// NOTE: (lsb2==enemy) Not possible to clear goal
						}
					}
				}
			}

			// Enemy piece on goal square
			if ((goal_bb & enemy_bb) != 0) {
				int pt = game.getPieceType(saved_goal_index)>>1;

				long escape_bb = rank_touch_goal_bb;
				while (escape_bb != 0) {
					long lsb_bb = Util.LastBit(escape_bb);
					escape_bb ^= lsb_bb; // Remove the piece

					// Escape square is empty
					if ((lsb_bb & empty_bb) != 0) {
						long dest_bb = touching_bb(lsb_bb) & ~goal_bb & 
							player_bb & game.stronger_or_eq_bb[pt + 1] & ~game.frozen_pieces_bb;

						while (dest_bb != 0) {
							long lsb2_bb = Util.LastBit(dest_bb);
							dest_bb ^= lsb2_bb; // Remove the piece

							// then slide and pull back 3 steps (2 options for
							// slide back!)
							// lsb2 is stronger unfrozen player

							// Test for lsb refreeze
							int pt2 = game.getPieceTypeOneSq(lsb2_bb)>>1;
							if ((enemy_bb & game.stronger_or_eq_bb[pt2+1] & touching_bb(lsb_bb)) == 0) {
								// Check if gmt rabbit is frozen
								if ((touch_gmt_bb & enemy_nr_bb) == 0
										|| (touch_gmt_bb & player_bb) != 0) {
									return true; // goal in 4 steps
								}
								// Slide back can be to different square!
								if ((touching_bb(lsb_bb) & empty_bb & touch_gmt_bb) != 0) {
									return true; // goal in 4 steps
								}
							}
						}
					}

					// Player piece on escape square
					if ((lsb_bb & player_bb) != 0) {

						// Check if player piece is strong enough to drag
						// Check if player piece is frozen
						if ((player_bb & game.stronger_or_eq_bb[pt + 1] & lsb_bb & (~game.frozen_pieces_bb)) != 0) {
							long dest_bb = touching_bb(lsb_bb) & ~goal_bb;

							while (dest_bb != 0) {
								long lsb2_bb = Util.LastBit(dest_bb);
								dest_bb ^= lsb2_bb; // Remove the piece

								// lsb2 == player lsb2 slide away, lsb pull
								// 3steps, check for lsb refreeze
								if ((lsb2_bb & player_bb) != 0) {
									if ((can_step_bb(lsb2_bb,
											game.getPieceTypeOneSq(lsb2_bb)) & empty_bb) != 0) {
										// Test for lsb refreeze
										int pt2 = game.getPieceTypeOneSq(lsb_bb)>>1;
										if ((enemy_bb & game.stronger_or_eq_bb[pt2 + 1] & touching_bb(lsb_bb)) == 0) {
											// Test if gmt rabbit is frozen
											// friend->friend replacement does
											// not change the status
											if ((touch_gmt_bb & enemy_nr_bb) == 0
													|| (touch_gmt_bb & player_bb) != 0) {
												return true;// goal on 4th step
											}
										}
									}
								}

								// lsb2 == empty lsb pull 2 steps, 1 step to
								// free rabbit
								if ((lsb2_bb & empty_bb) != 0) {
									// Test if gmt rabbit is frozen
									if ((lsb2_bb & touch_gmt_bb) != 0
											|| (touch_gmt_bb & enemy_nr_bb) == 0
											|| (touch_gmt_bb & player_bb) != 0) {
										return true; // goal in 3 steps
									}

									// Rabbit still frozen one step left to free
									// rabbit
									// Make new gamestate and send on to empty
									// goal tester
									// no need for zorb
									temp_move1.clear();
									int lsb_piece = game.getPieceTypeOneSq(lsb_bb)>>1;
									temp_move1.from_bb[lsb_piece] = lsb_bb;
									temp_move1.to_bb[lsb_piece]	= lsb2_bb;
									temp_move1.enemy_from_bb = temp_move1.from_bb[pt] = goal_bb;
									temp_move1.enemy_to_bb = temp_move1.to_bb[pt] = lsb_bb;
									temp_move1.info_mask |= ((player == PL_GOLD) ? 0
													: ArimaaMove.SILVER_MARK);
									temp_move1.steps = 2;
									if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, temp_move1)) {
										return true;
									}
								}
								// NOTE: (lsb2==enemy) Not possible to clear
								// goal by pull to lsb2
							}

							// Case B) if other escape square empty, push and
							// retreat 3 steps
							long other_escape_bb = rank_touch_goal_bb & ~lsb_bb;
							if ((other_escape_bb & empty_bb) != 0) {
								// Test if GMT rabbit is frozen
								if ((touch_gmt_bb & enemy_nr_bb) == 0
										|| (touch_gmt_bb & player_bb) != 0) {
									return true; // goal in 4 steps
								}
							}
						}
					}
					// NOTE: (lsb==enemy) Not possible to clear goal from this
					// side
				}
			}
		}
		return false;
	}

	private boolean test_GmtRabbit_GoalEmptyAfterMove(GameState game, int steps, 
			ArimaaMove move) {
		game.playMoveFull(move);
		if((goal_bb & game.empty_bb) == 0) {
			game.unplayMoveFull(move);
			return false;
		}
		doublestep_list_stack.levelUp();				
		boolean result = test_GmtRabbit_GoalEmpty(game, steps - move.steps); 
		doublestep_list_stack.levelDn();
		game.unplayMoveFull(move);
		return result;
	}
	/**
	 * Tests for goals with rabbit on gmt and goal square empty Currently only
	 * handles <=3 steps TODO add 4 step case
	 * 
	 * @param game
	 *            GameState
	 * @param total_steps_available
	 *            int
	 * @return boolean
	 */
	private boolean test_GmtRabbit_GoalEmpty(GameState game,
			int total_steps_available) {

		if (use_debug) {
			LogFile.message("test_GmtRabbit_GoalEmpty " + goal_index + " "
					+ total_steps_available + "\n" + game);
		}

		int piece_steps_available = total_steps_available - 1;

		long empty_bb = game.empty_bb;
		long enemy_bb = game.player_bb[enemy]; // all enemy pieces
		long enemy_nr_bb = enemy_bb & game.stronger_or_eq_bb[1];
		long player_bb = game.player_bb[player]; // all player pieces
		long player_nr_bb = player_bb & game.stronger_or_eq_bb[1];
		long rabbit_bb = player_bb ^ player_nr_bb;

		assert ((goal_bb & empty_bb) != 0); // Goal empty
		assert ((rabbit_bb & gmt_bb) != 0); // Rabbit on GMT
		assert (total_steps_available >= 1);

		// Check if gmt rabbit can goal on its own
		if ((gmt_bb & game.frozen_pieces_bb) == 0) {
			return true;
		}

		if (piece_steps_available>0) {
			if (can_run(game, piece_steps_available, FULL_BB, touch_gmt_bb)) {// unassisted help
				return true;
			}
		}

		if (piece_steps_available >= 2) {

			// Try remove protection plays
			if (test_remove_protection(game, total_steps_available)) {
				return true;
			}

			// Rabbit is frozen on the gmt, try to remove freezer
			// OR push in to unfreeze
			long gmt_freeze_bb = touch_gmt_bb & enemy_nr_bb;

			if (use_debug) {
				print_bitboard(gmt_freeze_bb, "GMT_freeze");
			}
			boolean only_one_freezer = atMostOneBitSet(gmt_freeze_bb);

			// Determine targets for dragging
			// Any epiece touching gmt is a target, since any push will do
			long target_bb = touch_gmt_bb & enemy_bb;

			if (use_debug) {
				print_bitboard(target_bb, "Target");
			}
			// If only_one_freezer then pull moves work
			// Push moves will always work

			while (target_bb != 0) {
				long lsb_bb = Util.LastBit(target_bb);
				target_bb ^= lsb_bb; // Remove the piece

				int pt = game.getPieceTypeOneSq(lsb_bb)>>1;

				// Need to actually move the piece
				if (piece_steps_available >= 3) {
					// Slide in a stronger piece, to attempt a push/pull
					long dest_bb = touching_bb(lsb_bb) & empty_bb;
					long start_bb = touching_bb(dest_bb)
							& player_bb & game.stronger_or_eq_bb[pt + 1]
							& (~game.frozen_pieces_bb);
					doublestep_list_stack.levelReWrite();
					gen_steps.genOneStep(game, doublestep_list_stack, start_bb, dest_bb);
					for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
						ArimaaMove slide = doublestep_list_stack.getCurrentMove();
						if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, slide)) {
							return true;
						}
					}

					// Frozen stronger piece already touching
					// Slide a support piece to unfreeze it
					long stronger_bb = player_bb & game.stronger_or_eq_bb[pt + 1]
							& touching_bb(lsb_bb);

					dest_bb = touching_bb(stronger_bb & game.frozen_pieces_bb)
							& empty_bb & ~goal_bb;
					doublestep_list_stack.levelReWrite();
					gen_steps.genOneStep(game, doublestep_list_stack,
							FULL_BB, dest_bb);
					for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
						ArimaaMove slide = doublestep_list_stack.getCurrentMove();
						if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, slide)) {
							return true;
						}
					}

					// Stronger piece already touching (freeze status could
					// change!)
					// Vacate pull dest (if only_one_freezer)
					if (only_one_freezer
							&& (touching_bb(stronger_bb
									& ~game.frozen_pieces_bb)
									& empty_bb & ~goal_bb) == 0) {
						start_bb = touching_bb(stronger_bb) & player_bb;
						dest_bb = touching_bb(start_bb) & empty_bb & ~goal_bb;

						if (use_debug) {
							LogFile.message("Vacate pull dest");
							print_bitboard(start_bb, "Start_bb");
							print_bitboard(dest_bb, "dest_bb");
						}
						doublestep_list_stack.levelReWrite();
						game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
						for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
							ArimaaMove slide = doublestep_list_stack.getCurrentMove();
							if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, slide)) {
								return true;
							}
						}
					}

					// Vacate push dest
					if ((touching_bb(lsb_bb) & empty_bb) == 0) {
						start_bb = touching_bb(lsb_bb) & player_bb;
						dest_bb = touching_bb(start_bb) & empty_bb & ~goal_bb;

						if (use_debug) {
							LogFile.message("Vacate push dest");
							print_bitboard(start_bb, "Start_bb");
							print_bitboard(dest_bb, "dest_bb");
						}
						doublestep_list_stack.levelReWrite();
						game.genSlideMoves(doublestep_list_stack, start_bb, dest_bb);
						for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
							ArimaaMove slide = doublestep_list_stack.getCurrentMove();
							if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, slide)) {
								return true;
							}
						}
					}
				}

				// Test if piece can push/pull unassisted
				long stronger_bb = player_bb & game.stronger_or_eq_bb[pt + 1]
						& touching_bb(lsb_bb) & ~game.frozen_pieces_bb;
				if (stronger_bb != 0) {

					// Can only push, if its not the freezer or multiple
					// freezers
					long pdest_bb = FULL_BB;
					if (((lsb_bb & gmt_freeze_bb) == 0) || !only_one_freezer) {
						// piece required to unfreeze
						if (piece_steps_available == 2) {
							pdest_bb = lsb_bb;
						}
					}
					doublestep_list_stack.levelReWrite();
					game.genDragMoves(doublestep_list_stack, FULL_BB, pdest_bb, lsb_bb, FULL_BB);
					for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
						ArimaaMove drag = doublestep_list_stack.getCurrentMove();
						if (test_decideAfterMove(game, total_steps_available, drag)) {
							return true;
						}
					}
				}
			}

			// Try to unfreeze frozen piece, that then slides to unfreeze rabbit
			long frozen_sup_bb = touching_bb(touch_gmt_bb & empty_bb) & ~gmt_bb
					& game.frozen_pieces_bb & player_bb;

			if (game.existSlideMove(FULL_BB, touching_bb(frozen_sup_bb))) {
				return true; // goal in 3 steps
			}

			// Try assisted two step slide
			// ------
			// p |
			// Er ip|
			// pi ip |
			// pip |
			// p |
			long inbetween_bb = touching_bb(touch_gmt_bb & empty_bb) & empty_bb;
			long potential_bb = touching_bb(inbetween_bb)
					& ~game.frozen_pieces_bb & player_bb;

			if (gen_steps.existTwoStep(game, FULL_BB, touch_gmt_bb)) {
				return true; // goal in 3 steps
			}

			while (potential_bb != 0) {
				long lsb_bb = Util.LastBit(potential_bb);
				potential_bb ^= lsb_bb; // Remove the piece

				// Try assisted two step slide
				if (piece_steps_available >= 3) {
					long dest_bb = touching_bb(inbetween_bb) & empty_bb;
					doublestep_list_stack.levelReWrite();
					gen_steps.genOneStep(game, doublestep_list_stack, FULL_BB, dest_bb);
					for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
						ArimaaMove slide = doublestep_list_stack.getCurrentMove();
						if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, slide)) {
							return true;
						}
					}
				}
			}
		}

		if (piece_steps_available >= 3) {
			// Try slide/push combo
			long dest_bb = touching_bb(touch_gmt_bb & enemy_bb) & empty_bb;
			long start_bb = touching_bb(dest_bb) & player_nr_bb;
			doublestep_list_stack.levelReWrite();
			gen_steps.genOneStep(game, doublestep_list_stack, start_bb, dest_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove slide = doublestep_list_stack.getCurrentMove();
				if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, slide)) {
					return true;
				}
			}

			// Try 2step/slide combo
			long inbetween_bb = touching_bb(touch_gmt_bb & empty_bb) & ~gmt_bb;
			doublestep_list_stack.levelReWrite();
			gen_steps.genTwoStep(game, doublestep_list_stack, FULL_BB, inbetween_bb);
			for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
				ArimaaMove twoSteps = doublestep_list_stack.getCurrentMove();
				if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, twoSteps)) {
					return true;
				}
			}

			// TODO: try assisted two step slide
			// Move support piece from touching_piece to touching
			// inbetween_square
			// Is this the only case???? I think so!

			// Try assisted 1 step slide
			long potential_bb = touching_bb(touch_gmt_bb) & ~gmt_bb & player_bb;
			if (use_debug) {
				print_bitboard(potential_bb, "Ass 1 step slide");
			}

			while (potential_bb != 0) {
				long lsb_bb = Util.LastBit(potential_bb);
				potential_bb ^= lsb_bb; // Remove the piece

				// Case a) Piece is frozen, try to touch with player piece
				dest_bb = touching_bb(lsb_bb) & ~touch_gmt_bb;
				if (use_debug) {
					print_bitboard(dest_bb, "dest_bb");
				}
				doublestep_list_stack.levelReWrite();
				gen_steps.genTwoStep(game, doublestep_list_stack, FULL_BB & ~lsb_bb, dest_bb);
				for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
					ArimaaMove twoSteps = doublestep_list_stack.getCurrentMove();
					if (test_GmtRabbit_GoalEmptyAfterMove(game, total_steps_available, twoSteps)) {
						return true;
					}
				}

				// Case b) Try to remove freezer
				long freeze_bb = touching_bb(lsb_bb)
						& enemy_bb & game.stronger_or_eq_bb[(game.getPieceTypeOneSq(lsb_bb)>>1) + 1];
				if (atMostOneBitSet(freeze_bb)) {
					// Check for loss of protection captures
					long estart_bb = freeze_bb;
					doublestep_list_stack.levelReWrite();
					game.genDragMoves(doublestep_list_stack, FULL_BB, FULL_BB, estart_bb, FULL_BB);
					for(doublestep_list_stack.levelFirst();doublestep_list_stack.levelCont();doublestep_list_stack.levelNext()) {
						ArimaaMove drag = doublestep_list_stack.getCurrentMove();
						if (test_decideAfterMove(game, total_steps_available, drag)) {
							return true;
						}
					}
				}
			}
		}

		// No goal possible
		return false;
	}

	private static void test_position(GameState position, TestForGoal test,
			ArimaaTurnBasedEngine engine) {
		// Run test positions
		LogFile.setMessageDisplay(true);

		LogFile.message(position.toBoardString());
		LogFile.message(position.toEPDString());
		LogFile.message(position.toSetupString());
		LogFile.message(position.toBoardString());

		boolean result = test.test(position);
		engine.resetStats();
		boolean result2 = engine.can_player_goal(position);
		LogFile.message("FINAL: " + result + " Engine: " + result2);
		LogFile.message(engine.getStats());
	}

	public static void main(String args[]) {
		String text[] = {
				"Y|01s %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|     D           |%133| C r   C         |%132| R R c r R       |%131|     D R         |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|08s %13 +-----------------+%138| r               |%137|                 |%136| r E             |%135|                 |%134| r M             |%133|                 |%132| r H             |%131|               R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|32w %13 +-----------------+%138|     r   h r D   |%137|     H     M r R |%136|   r     c   h d |%135| r E H c C R   R |%134|   m   C         |%133| R               |%132|   R e     R     |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|09w %13 +-----------------+%138|     r           |%137| c   R r         |%136|                 |%135| R               |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|10w %13 +-----------------+%138|   r     r       |%137|   c     c       |%136|   d R R d       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|11w %13 +-----------------+%138|     r c         |%137| d         C     |%136|   C R R c       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|12w %13 +-----------------+%138|     r           |%137| c       c       |%136|   R   R         |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|13w %13 +-----------------+%138|     r c r       |%137| d         C     |%136|   C R R c       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|14w %13 +-----------------+%138|       r c r     |%137|   d         C   |%136|     C R R c     |%135|           d     |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|28b %13 +-----------------+%138|         h r     |%137|   r     M r e   |%136|   d   c     R   |%135|       c   E   R |%134| r   H         r |%133| D h R   d   r C |%132| r D m   C       |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|16b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|         r c     |%132|       r         |%131| R R R R R C     |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|10w %13 +-----------------+%138|                 |%137|       C         |%136|       r r       |%135|                 |%134|                 |%133|                 |%132|                 |%131|               R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|11w %13 +-----------------+%138|                 |%137|   C r           |%136|         r C D   |%135|                 |%134|                 |%133|                 |%132|                 |%131|               R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|12w %13 +-----------------+%138|                 |%137|                 |%136|         r C D   |%135|                 |%134|           r     |%133|                 |%132|                 |%131|               R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|13w %13 +-----------------+%138|                 |%137|                 |%136|         r C D   |%135|           r     |%134|                 |%133|                 |%132|                 |%131|               R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|14w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|     r           |%133|   D C   r       |%132|                 |%131|               R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|32b %13 +-----------------+%138|     r r r r M r |%137| r         c r   |%136|       d d       |%135| h D c m         |%134|     E   e       |%133|     r           |%132|   R h         H |%131| R R   H R R R R |%13 +-----------------+%13   a b c d e f g h%13",
				// Belbo
				//"Y|22b %13 +-----------------+%138| r r   c c r   r |%137|     r     d     |%136| r H             |%135|                 |%134|           E r   |%133| R H       R M d |%132|           e R r |%131|   R   R C h   R |%13 +-----------------+%13   a b c d e f g h%13",
				// Belbo
				//"Y|23w %13 +-----------------+%138|   r r d H r r r |%137| r     c E R   r |%136|   h             |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13",
				// 99of9 vs RonWeasley Test position
				//"Y|68w %13 +-----------------+%138| r r r r D H r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|40w %13 +-----------------+%138| r r r r r r E   |%137|               d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|32b %13 +-----------------+%138|     r r r r M r |%137| r         c r   |%136|       d d       |%135| h D c m         |%134|     E e         |%133|     r           |%132|   R h         H |%131| R R   H R R R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|10b %13 +-----------------+%138|   c   d     c   |%137|         d r     |%136|               C |%135|   r             |%134|             r h |%133|   M   R   r r R |%132| R h   m E e H   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|96w %13 +-----------------+%138| r r E D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|93w %13 +-----------------+%138| r r   D D d r r |%137|       h R   H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|91w %13 +-----------------+%138| r r r   D d r r |%137|       h R     H |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|90w %13 +-----------------+%138| r r r   D d r r |%137|       h R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|87w %13 +-----------------+%138| r r r r D   r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|86w %13 +-----------------+%138| r r r r d H r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|83w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|         D       |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|82w %13 +-----------------+%138| r r r r   r r r |%137|     E d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|81w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|             D   |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|79w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|43w %13 +-----------------+%138| r r r   r r r r |%137|         d H     |%136|       R         |%135|                 |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|42w %13 +-----------------+%138| r r r   r r r r |%137|                 |%136|       R d       |%135|                 |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|40w %13 +-----------------+%138| r r r   r r r r |%137|     R   e       |%136|                 |%135|                 |%134|       C         |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|39w %13 +-----------------+%138| r r r   r r r r |%137|       R e       |%136|                 |%135|                 |%134|         C       |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|38w %13 +-----------------+%138| r r r   r r r r |%137|                 |%136|       R e       |%135|                 |%134|         C       |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|12b %13 +-----------------+%138|     r r r r M r |%137| r         c r   |%136|       d d       |%135| h D c m         |%134|     E           |%133|     r           |%132|   R h         H |%131| R R   H R R R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|11w %13 +-----------------+%138|               H |%137| r         M e   |%136|   d   c     R   |%135|       c     E R |%134| r   H         r |%133| D h R   d   r C |%132| r D m         C |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|13w %13 +-----------------+%138|                 |%137| r r r       H   |%136|   d     h   h R |%135| c   d   r r     |%134| r C     c   r   |%133| D e   r   E C   |%132|     H M D m     |%131| R R R R R R R   |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|14w %13 +-----------------+%138| r r r   r r r r |%137| D   c R         |%136|       e m       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|15w %13 +-----------------+%138| r r r   r r r r |%137| D   c R c       |%136|       e m       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|16w %13 +-----------------+%138| r r r   r r r r |%137|   D c R c       |%136|       e m       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|21w %13 +-----------------+%138| r r r   r r r r |%137|     R   m       |%136|                 |%135|       C e       |%134|                 |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|60w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|64w %13 +-----------------+%138| r r r r   r r r |%137|       d R     e |%136|             C   |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|65w %13 +-----------------+%138| r r   H d r r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|69w %13 +-----------------+%138| r r r r D d r r |%137|       r R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|74w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|75w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|17w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|       R   m     |%134|     d R         |%133|         h   h   |%132| E               |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|31w %13 +-----------------+%138|               H |%137| r         M e   |%136|   d   c     R   |%135|       c     E R |%134| r   H         r |%133| D h R   d   r C |%132| r D m         C |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|33w %13 +-----------------+%138|                 |%137| r r r       H   |%136|   d     h   h R |%135| c   d   r r     |%134| r C     c   r   |%133| D e   r   E C   |%132|     H M D m     |%131| R R R R R R R   |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|60w %13 +-----------------+%138| r r r r r r E   |%137|               d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|80w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|84w %13 +-----------------+%138| r r r r   r r r |%137|       d R     e |%136|             C   |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|85w %13 +-----------------+%138| r r   H d r r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|89w %13 +-----------------+%138| r r r r D d r r |%137|       r R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|94w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|95w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|11w %13 +-----------------+%138| r r   r r r r r |%137|     R           |%136|   r h           |%135|                 |%134|   C   d         |%133|           c   e |%132|     R           |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|101w %13 +-----------------+%138| h   H           |%137| R   h           |%136| R r             |%135| m r             |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|102w %13 +-----------------+%138|       c r       |%137|   c C R R d     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|103w %13 +-----------------+%138|         r       |%137|       c R   c   |%136|       d   C     |%135|           H     |%134|           m     |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|104w %13 +-----------------+%138|   r r d r       |%137|       R     d   |%136|         D D     |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|105w %13 +-----------------+%138|                 |%137| R   r   d E r r |%136| e   D     R   m |%135| M   R h       R |%134|                 |%133|                 |%132|   h     R       |%131|             R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|106b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|     r H         |%132| r r h C H       |%131| R R     D R R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"Y|107b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|     r H         |%132| r r h C C       |%131| R H     D R R R |%13 +-----------------+%13   a b c d e f g h%13",
				//"N|108w %13 +-----------------+%138|     h           |%137| R   r   d E r r |%136| e   D     R   m |%135| M   R h       R |%134|                 |%133|                 |%132|   d     R       |%131|             R R |%13 +-----------------+%13   a b c d e f g h%13",
		};
//		ArimaaEngine engine = new ArimaaEngine();

		// testing TimeControl ... everything OK
		// TimeControl time_control = new TimeControl();
		// time_control.setSearchDepthThreshold(4);`
		LogFile.message("pokus");
		try {
			BufferedReader file_reader = new BufferedReader(new FileReader("c:\\arimaa\\movelist.txt"));
			// Get the movelist from the file
			String movelist_text = "";
			String data;
			String goal_txt="";
			Long zerotime=System.currentTimeMillis()-10000000000L;
			while ((data = file_reader.readLine()) != null) {
				ArimaaServerInfo info = new ArimaaServerInfo();
				int pos_start = 0; 
				pos_start = data.indexOf("|", pos_start)+1; // game no 
				pos_start = data.indexOf("|", pos_start)+1; // gold
				pos_start = data.indexOf("|", pos_start)+1; // silver
				movelist_text = data.substring(pos_start)+"%13";
				goal_txt = System.currentTimeMillis()-zerotime + " " + data.substring(0,pos_start-1);
				String[] move_list=movelist_text.split("%13");
				for (String move_text_with_turn_number : move_list) {
					pos_start = move_text_with_turn_number.indexOf(" ")+1;
					String move_text = move_text_with_turn_number.substring(pos_start);
					//TODO
					if (info.gs.turn>3) {
						TestForGoal test = new TestForGoal();
						ArimaaTurnBasedEngine engine = new ArimaaTurnBasedEngine();	
						boolean result, result2; 
						result = result2 = test.test(info.gs);
						result2 = engine.can_player_goal(info.gs); // to be commentet out
						if (result!=result2) {
							if (move_text.length()>3) {
								goal_txt += info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+"# ";
								LogFile.message("Bug in goal detection"+info.gs+result+"#"+result2);
								use_hash=false;use_debug=true;
								result = test.test(info.gs); // breakpoint for debug
								use_hash=true;use_debug=false;
							}
						} else if (result) {
							if (move_text.length()>3) {
								goal_txt += info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+" ";
							} else {
								goal_txt += "("+info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+")";
							}
						}
					}
					if (pos_start==0) break;
					info.makeMove(move_text);
					info.ShrinkRules();
				}
				LogFile.writeln("c:\\arimaa\\goal.txt", goal_txt);
			}
			file_reader.close();
		} catch (FileNotFoundException ex) {
			for (String pos_text : text) {
				int pos_start = pos_text.indexOf("|")+1;
				boolean exp_res = (pos_text.substring(0,pos_start-1).indexOf("Y")>=0);
				String position_text = pos_text.substring(pos_start);
				GameState position = new GameState(position_text);
				TestForGoal test = new TestForGoal();
				TestForGoal.use_debug = true;
				boolean result = test.test(position);
				if (result!=exp_res) {
					LogFile.message("Bug report (" + pos_text.substring(0,pos_start-1)+"):");
					LogFile.message(""+position);
					LogFile.message("Expected: "+exp_res+" gained: " + result);
					LogFile.message("goal: "+test.saved_rabbit_index+" "+test.saved_goal_index);
				} else {
					LogFile.message("OK: "+exp_res+"goal: "+test.saved_rabbit_index+" "+test.saved_goal_index);
					LogFile.message(""+position);				
				}
				ArimaaTurnBasedEngine engine = new ArimaaTurnBasedEngine();	
				ArimaaTurnBasedEngine.show_alphabeta_search_trace=use_debug;
				test_position(position, test, engine);
			}
		} catch (Exception ex) {
			System.err.println("LogFile: Unknown error!");
			ex.printStackTrace();
		}
	}
}
