package arimaa3;

import java.util.*;
//import ai_util.*;

import ai_util.LogFile;

public class ThreeFoldRepetition {
	
	// IMPLEMENTED better way to deal with 3 times repetition for bot is to make it's own rules reducing to 2 times repetition
	// each position encountered after the last capture is banned. Whenever opponent plays banned move, response immediately by
	// repeating the response. (This is the only case when bot repeats position, but it cannot repeat t-times before opponent did.)
	// When opponent played nonbanned position, our search is restricted to positions without ban. If there is no such legal move, 
	// we could write "congrats to immobilisation by 3 repetition rule" and resign. Problem of this method would be when playing in
	// games started not using the "follow repetition" rule. In that case third time repetition should be used instead.
	
	// This method very thins our search depth. We cannot avoid loss on repetition miscalculations when using transposition tables.
	// If we reach the position in transposition table other way the result could be affected by banning. So probably the best way 
	// is to search without banning for transposition table updates and remember for the search whether the best move is banned?!?
	// grrr, this is difficult.

	public boolean follow_repetition[] = {true,true}; 
	// never repeat position, but if opponent repeated position, play what was played
	// usually bot plays only one side, but it should be prepared to be used even on weird games when 
	// for example 3 bots play and the sides are switched every 1,5 turns, so let us remember which side could play follow_repetition 
	// strategy [gold,silver]
	public String forced_move = ""; 
	// the move forced by the strategy
	public Hashtable<Long, String> positionMoves = new Hashtable<Long, String>(); 
	// moves played at given hashcodes, used in follow_repetition. Maintained while follow_repetition[] contains true. 
	public HashSet<Long> positionForbidden = new HashSet<Long>(); 
	//used for follow_repetition[player] = false, set of positions which appeared twice
	
	public ThreeFoldRepetition() {
	}
	
	public void makeMove(ArimaaServerInfo info, String move_text) {
		boolean done = false;
		ArimaaMove move = new ArimaaMove(move_text);
		long prev_hash = info.gs.getPositionHash();
		info.gs.playMoveFull(move); // this is the only move not to be unplayed ... real game progress
		LogFile.message("New position:\n"+info.gs);
		long curr_hash = info.gs.getPositionHash();
		info.position = info.gs.toEPDString();
		info.move_list += " "+move_text+"%13";
		forced_move = "";
		if ((move.info_mask & (ArimaaMove.SETUP_MARK|ArimaaMove.CAPTURE_COUNTS))!=0) {
			follow_repetition[0]=follow_repetition[1]=true;
			positionMoves = new Hashtable<Long, String>();
			positionMoves.put(curr_hash, "");// last position blocked, but the move not recorded yet
			positionForbidden = new HashSet<Long>();
			done = true;
		}
		info.side_to_move = info.gs.getSideToMove();
		info.move_list +=info.gs.turn+((info.side_to_move == 0) ? "w" : "b");
		if (done) return;
		String original_move = positionMoves.put(prev_hash,move_text);
		if (positionMoves.containsKey(curr_hash)) {
			positionForbidden.add(curr_hash);
			if (follow_repetition[info.side_to_move]) {
				forced_move=positionMoves.get(curr_hash);
				follow_repetition[1^info.side_to_move]=false;
			} else if (!original_move.equals(move_text)) {
				follow_repetition[1^info.side_to_move]=false;			
			}
		}
	}
}	