/*
Prunning moves containing 3 steps reversible by 1 step.

Such move looks like at most 2 steps with at most one step by our piece.
And all opponent's moved pieces unfrozen (and opponent's rabbits not moved 'opponent's forward).
(And material is unchanged).

Oh 3 steps reversible by 1 could be OK if the fourth step was crucial.
So prune only turns fully revertible in 2 steps. ... is it OK in zug-zwangs?
No this prunning needs to be removed in zug-zwangs (don't prone the only possible moves).

As player's stone returns, the move could be revertible in at least 2 steps only when trajectories 
contains at most 3 squares alltogether. 
(It was push pull or push slide or push slide, slide to the emptied place. 
 Otherwise the players slide could not be undone by opponent returning to the original position.
 And if 2 opponent's pieces were moved ... it must be by push pull. Remaining case is 3 step revertible by 1)





Position evaluation:
1) Elephant mobility:
 Has the elephant an important job?
 Jobs: A) Pinned
       B) Hostage defender ... trap guarding preventing captures
       C) Hostager ... attacker makeing a capture threat
       D) Framer ... frame maintainer
       E) Elephant blocker
 Is the phant blocked ... where could it go?
       F) It cannot leave it's local neighbourhood
2) What is the cost of elephant imobility?
 A) the pinned piece + the most costed hostaged piece per move ... depends on strongest free piece
 B) the most costed hostaged piece per move ... depends on strongest free piece
 C) the most costed hostaged piece per move ... depends on strongest free piece
 D) the framed piece ... depends on strongest free piece
 E) ... mobility price ... depends on strongest free piece
 F) ... mobility price ... depends on strongest free piece
3) Are there prospects to improve the mobility?
 A) Is the frame by phalanx or by stronger or equal piece? Pulling one piece of phalanx would be sufficient, pulling stronger or equal piece.
    Which pieces are strong enough to break the frame? Are there unfreezers in the neighbourhood? Swarm is OK as the capture in the trap is prevented.
    But rabbits could block breaking piece path and could be used in frame phalanx. Rotation of framing pieces could be prevented by close contact of pieces.
 B) Swarm is the method to limit maneuvering, especially without space guarding lichpin. Hostage held by nonelephant could be broken, but it costs several turns.
    Another threat meanwhile would be a problem. Creating counterthreat would be better.
 C) Swarm is the method to limit maneuvering, especially without space guarding lichpin.
 D) Simillar as A, but opposite point of view. Having space guarding linchpin could help a lot.
 E) Replacement by phalanx could help, but it will be vulnerable to breaking. Replacement by opponent rabbit could be more effective. 
    Blockade in the middle is too expensive, but delaying blockade could be a tactical option.
 F) Blocked phant in one territory makes opponent camel strong at the rest of the board. Phalanx in the blockade could be broken by pulling. 
    Elephant under trap could be freed by piece stepping next to trap with phant pushing from the trap in the same turn.

Adding pieces to capture in 2 steps to the evaluation makes the bot play worse. 
The reason is it spents a lot of steps to make such threats 
even when the defense requires just one step.

The "step currency" must be essential part of the evaluation ... 
how many defense steps the threat requires. 
How strong piece defends permanently. Does it lead to phant overload ...

----------------------------
MCTS notes:
UCT formula:
using $\overline{X_i}+K\cdot\sqrt{\ln n\over n_i+c(b)}$ will support exploitation against exploration while converging to the same limit.

Where $c(b)$ is a function growing with the number of branches. I expect $c(b)$ be around $ln(b)$.
Suppose $X_i$ is bounded to $(-1,1)$. And static evaluation to $(-K,K)$, with root evaluation $e_\rho$.
Let $f_{e_\rho}:\RR\to(-1,1)$ be a normalisation function depending on $e_\rho$. 
Highest slope would be at $e_\rho/2$ for $e_\rho>0$ and at $0$ for $e_\rho\le 0$.
Possible choice is $f_{e_\rho}(e)=2/\pi\cdot\arctg (e-(e_\rho+|e_\rho|)/4)$.
So we could use $\overline{X_i}+K\cdot\sqrt{\ln n\over n_i+c(b)}+f_{e_\rho}(e_i)\cdot g(n_i)$
Simillar effect could be obtained by inicialisation by several artifical rounds ($c(b)$) with average $f_{e_\rho}(e_i)$ 
so with gain $c(b)\codt f_{e_\rho}(e_i)$.

Where $g(n)\to <0,1>$ with limit $0$. Converging to the same limit. The slower $g$ the evaluation is more important in selection.
We could use move evaluation term as well with $f_0(me)\cdot h(n_i)$ with $h(n)\to <0,1> with limit 0$ as well with the same note.
History heuristics in steps could be used with simillar weight ($K=1/sqrt{2}$ is a starting point).

Restarting/several paralel trees merged together could give better results!?

From the nonbots above 2000 in the tested set of games only 174765 (14s) was 3 for 1 allowing exchange. 
It was in game of Tuks against me on WC2011 and I understand why I did the exchange ... there was flipping threat needing 4 steps and stoling one step 
was sufficient to prevent it. My phant made a step in required direction meanwhile. Without the context of threat requiring full 4 steps turn it would not be OK.
So demerits highly dependent on 4 steps turn threat ...

*/
package arimaa3;

import java.io.*;

import ai_util.*;

// class for testing 

public class notes extends ArimaaBaseClass {

	public static void main(String args[]) {
		try {
			BufferedReader file_reader = new BufferedReader(new FileReader("c:\\arimaa\\movelist.txt"));
			// Get the movelist from the file
			String movelist_text = "";
			String data;
			String revert_txt="";
			Long zerotime=System.currentTimeMillis()-10000000000L;
			while ((data = file_reader.readLine()) != null) {
				ArimaaServerInfo info = new ArimaaServerInfo();
				data = data.replace('|', '#');
				String [] fields = data.split("#");
				movelist_text = fields[3]+"%13";
				revert_txt = System.currentTimeMillis()-zerotime + " " + fields[0]+" "+fields[1]+" x "+fields[2];
				String[] move_list=movelist_text.split("%13");
				String game_pos_txt="";
				boolean isPrevWritten,writeThis=false;
				for (String move_text_with_turn_number : move_list) {
					isPrevWritten=writeThis;writeThis=false;
					int pos_start = move_text_with_turn_number.indexOf(" ")+1;
					String move_text = move_text_with_turn_number.substring(pos_start);
					if (pos_start==0) break;
					ArimaaMove move = new ArimaaMove(move_text);
					if (move.fasterRevertExists(info.gs)) {
						if (!isPrevWritten) {
							game_pos_txt=game_pos_txt+info.gs;
						}
						game_pos_txt=game_pos_txt+"\n"+info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+" "+move_text+"\n";
						revert_txt += info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+" ";
						writeThis=true;
					} else if (move.revert3In1Exists(info.gs)) {
						if (!isPrevWritten) {
							game_pos_txt=game_pos_txt+info.gs;
						}
						game_pos_txt=game_pos_txt+"\n"+info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+" "+move_text+"\n";
						revert_txt += "("+info.gs.turn+(info.gs.player==PL_GOLD?"g":"s")+") ";
						writeThis=true;
					}
					info.makeMove(move_text);
					if (writeThis) {
						game_pos_txt=game_pos_txt+info.gs;
					}
					info.ShrinkRules();
				}
				LogFile.writeln("c:\\arimaa\\revert.txt", revert_txt);
				LogFile.writeln("c:\\arimaa\\revert.txt", game_pos_txt);
			}
		} catch (Exception ex) {
			System.err.println("LogFile: Unknown error!");
			ex.printStackTrace();
		}
	}
}