/*
 * Decompiled with CFR 0.152.
 */
package ai_util;

import java.io.FileNotFoundException;
import java.io.FileWriter;

public class LogFile {
    private static String log_file_name = "game.log";
    private static boolean show_thinking = true;

    public static void setMessageDisplay(boolean status) {
        show_thinking = status;
    }

    public static void message(String text) {
        LogFile.write(text);
        if (show_thinking) {
            System.out.println(text);
        }
    }

    public static void println(String text) {
        System.out.println(text);
        System.out.flush();
        LogFile.write(log_file_name, text);
    }

    public static void write(String text) {
        LogFile.write(log_file_name, text);
    }

    public static void write(String log_file_name, String text) {
        try {
            FileWriter fw = new FileWriter(log_file_name, true);
            fw.write(text + System.getProperty("line.separator"));
            fw.flush();
            fw.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println("LogFile: File not found: " + log_file_name);
        }
        catch (Exception e) {
            System.err.println("LogFile: Unknown error!");
        }
    }

    public static void over_write(String log_file_name, String text) {
        try {
            FileWriter fw = new FileWriter(log_file_name, false);
            fw.write(text + System.getProperty("line.separator"));
            fw.flush();
            fw.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println("LogFile: File not found: " + log_file_name);
        }
        catch (Exception e) {
            System.err.println("LogFile: Unknown error!");
        }
    }
}

