/*
 * Decompiled with CFR 0.152.
 */
package ai_util;

import java.text.DecimalFormat;

public class Util {
    private static final int[] loBitSetTab = new int[]{0};
    private static final int[] hiBitSetTab = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    public static int LastOne(int val) {
        int tmp = val & 0xFF;
        if (tmp > 0) {
            return loBitSetTab[tmp];
        }
        tmp = val >> 8 & 0xFF;
        if (tmp > 0) {
            return loBitSetTab[tmp] + 7;
        }
        tmp = val >> 16 & 0xFF;
        if (tmp > 0) {
            return loBitSetTab[tmp] + 15;
        }
        tmp = val >> 24 & 0xFF;
        if (tmp > 0) {
            return loBitSetTab[tmp] + 23;
        }
        return -1;
    }

    public static String ProbStats(String description, long total_probes, long total_hits) {
        String result = "";
        result = result + Util.LeftJustify(10, description);
        String percent_any_cuts = " XX.XX";
        if (total_probes != 0L) {
            double percent = (double)total_hits * 100.0 / (double)total_probes;
            percent_any_cuts = Util.format("#00.00", percent);
            percent_any_cuts = Util.RightJustify(6, percent_any_cuts);
        }
        result = result + percent_any_cuts + " ";
        result = result + Util.Pad(10, total_hits);
        result = result + Util.Pad(10, total_probes);
        result = result + "\n";
        return result;
    }

    public static int FirstOne(long val) {
        int tmp = (int)(val >> 32);
        if (tmp != 0) {
            return Util.FirstOne(tmp) + 32;
        }
        return Util.FirstOne((int)(val & 0xFFFFFFFFFFFFFFFFL));
    }

    public static int FirstOne(int val) {
        int tmp = val >> 24 & 0xFF;
        if (tmp != 0) {
            return hiBitSetTab[tmp] + 23;
        }
        tmp = val >> 16 & 0xFF;
        if (tmp != 0) {
            return hiBitSetTab[tmp] + 15;
        }
        tmp = val >> 8 & 0xFF;
        if (tmp != 0) {
            return hiBitSetTab[tmp] + 7;
        }
        return hiBitSetTab[val & 0xFF] - 1;
    }

    public static int PopCnt(long val) {
        int count = 0;
        while (val != 0L) {
            ++count;
            val &= val - 1L;
        }
        return count;
    }

    public static int PopCnt(int val) {
        val -= (0xAAAAAAAA & val) >>> 1;
        val = (val & 0x33333333) + (val >>> 2 & 0x33333333);
        val = val + (val >>> 4) & 0xF0F0F0F;
        val += val >>> 8;
        val += val >>> 16;
        return val & 0xFF;
    }

    public static String toTimeString(long time_in_milliseconds) {
        String result = "";
        if (time_in_milliseconds < 0L) {
            result = result + "-";
            time_in_milliseconds = -time_in_milliseconds;
        }
        long hours = time_in_milliseconds / 1000L / 60L / 60L;
        long minutes = time_in_milliseconds / 1000L / 60L % 60L;
        long seconds = time_in_milliseconds / 1000L % 60L;
        long centiseconds = time_in_milliseconds / 10L % 100L;
        result = hours > 0L ? result + Util.format("00", hours) + ":" + Util.format("00", minutes) + ":" + Util.format("00", seconds) : result + Util.format("00", minutes) + ":" + Util.format("00", seconds) + "." + Util.format("00", centiseconds);
        return result;
    }

    public static String format(String format_string, double number) {
        DecimalFormat df = new DecimalFormat(format_string);
        String result = df.format(number);
        return result;
    }

    public static String format(String format_string, long number) {
        DecimalFormat df = new DecimalFormat(format_string);
        String result = df.format(number);
        return result;
    }

    public static String Pad(int width, long value) {
        String temp = new Long(value).toString();
        String result = "";
        for (int i = temp.length(); i < width; ++i) {
            result = result + " ";
        }
        result = result + temp;
        return result;
    }

    public static String LeftJustify(int width, String text) {
        String result = text;
        for (int i = text.length(); i < width; ++i) {
            result = result + " ";
        }
        result = result.substring(0, width);
        return result;
    }

    public static String RightJustify(int width, String text) {
        String result = "";
        for (int i = text.length(); i < width; ++i) {
            result = result + " ";
        }
        result = result + text;
        result = result.substring(0, width);
        return result;
    }

    public static void enumsets(long d) {
        long n = 0L;
        do {
            System.out.println(n);
        } while ((n = n - d & d) != 0L);
    }

    public static void main(String[] args) {
        long test = 17L;
        Util.enumsets(305L);
    }
}

