/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import arimaa3.Constants;

public class ArimaaBaseClass
implements Constants {
    protected static final String[] piece_text = new String[]{"R", "r", "C", "c", "D", "d", "H", "h", "M", "m", "E", "e"};
    protected static final String[] col_text = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};

    protected ArimaaBaseClass() {
    }

    public static long touching_bb(long target) {
        return (target & 0x7F7F7F7F7F7F7F7FL) << 1 | (target & 0xFEFEFEFEFEFEFEFEL) >>> 1 | target << 8 | target >>> 8;
    }

    public static long touching_bb(long target, int piece_type) {
        long result = (target & 0x7F7F7F7F7F7F7F7FL) << 1 | (target & 0xFEFEFEFEFEFEFEFEL) >>> 1;
        result |= piece_type == 0 ? 0L : target >>> 8;
        return result |= piece_type == 1 ? 0L : target << 8;
    }

    public static long right_bb(long target) {
        return (target & 0x7F7F7F7F7F7F7F7FL) << 1;
    }

    public static long left_bb(long target) {
        return (target & 0xFEFEFEFEFEFEFEFEL) >>> 1;
    }

    public static int getPieceType(String text) {
        int result = -1;
        for (int i = 0; i < 12; ++i) {
            if (!text.equals(piece_text[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    public static String getStringIndex(int index) {
        assert (index >= 0 && index <= 63);
        String result = "OB";
        if (index >= 0 && index <= 63) {
            int row = index / 8 + 1;
            int col = index % 8;
            result = col_text[col] + row;
        }
        return result;
    }

    public static void print_bitboard(long value) {
        ArimaaBaseClass.print_bitboard(value, "");
    }

    public static void print_bitboard(long value, String text) {
        String result = text;
        result = result + "\n +-----------------+\n";
        for (int row = 7; row >= 0; --row) {
            result = result + (row + 1) + "|";
            for (int col = 0; col <= 7; ++col) {
                int board_index = row * 8 + col;
                boolean is_set = (value & 1L << board_index) == 1L << board_index;
                String piece_text = is_set ? "1" : "0";
                result = result + " " + piece_text;
            }
            result = result + " |\n";
        }
        result = result + " +-----------------+\n";
        result = result + "   a b c d e f g h\n";
        System.out.println(result);
    }

    public static boolean atMostOneBitSet(long test_bb) {
        return (test_bb & test_bb - 1L) == 0L;
    }

    public static boolean moreThanOneBitSet(long test_bb) {
        return (test_bb & test_bb - 1L) != 0L;
    }

    public static boolean exactlyOneBitSet(long test_bb) {
        return (test_bb & test_bb - 1L) == 0L && test_bb != 0L;
    }

    public static void main(String[] args) {
        for (int i = -10; i <= 10; ++i) {
            System.out.println(i + " " + ArimaaBaseClass.atMostOneBitSet(i) + " " + ArimaaBaseClass.exactlyOneBitSet(i));
        }
        long test_bb = -1L;
        ArimaaBaseClass.print_bitboard(test_bb, "Start");
        ArimaaBaseClass.print_bitboard(ArimaaBaseClass.left_bb(test_bb), "Left");
        ArimaaBaseClass.print_bitboard(ArimaaBaseClass.right_bb(test_bb), "Right");
    }
}

