/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.LogFile;
import arimaa3.ArimaaServerInfo;
import arimaa3.SearchTimes;

public class ArimaaClockManager {
    public SearchTimes calculate(ArimaaServerInfo info) {
        SearchTimes result = new SearchTimes();
        LogFile.message("tc_move: " + info.tc_move);
        LogFile.message("tc_player_reserve: " + info.tc_player_reserve);
        LogFile.message("tc_max_turn_time: " + info.tc_max_turn_time);
        LogFile.message("tc_max_reserve: " + info.tc_max_reserve);
        int internet_lag = 5;
        int move_time = info.tc_move - internet_lag;
        float game_moves_remaining = 40.0f;
        float pace = (float)move_time + (float)info.tc_player_reserve / game_moves_remaining;
        float base_time = 0.75f * pace;
        float reserve_build_time = (float)move_time - base_time;
        if ((float)info.tc_max_reserve <= (float)info.tc_player_reserve + reserve_build_time) {
            base_time = info.tc_move;
        }
        base_time = Math.min(base_time, (float)(info.tc_max_turn_time - internet_lag));
        int extra_time = Math.max((info.tc_player_reserve - 30) / 3, 0);
        int panic_time = move_time + extra_time;
        panic_time = Math.min(panic_time, info.tc_max_turn_time - internet_lag);
        int mate_time = move_time + info.tc_player_reserve - 5;
        mate_time = Math.min(mate_time, info.tc_max_turn_time - internet_lag);
        result.base_time_sec = (int)base_time;
        result.panic_time_sec = panic_time;
        result.mate_time_sec = mate_time;
        if (info.enemy_name.equals("bot_shallowblue")) {
            result.base_time_sec = 10;
            result.panic_time_sec = 10;
            result.mate_time_sec = 10;
        }
        if (info.enemy_name.equals("bot_arimaazilla")) {
            result.base_time_sec = 10;
            result.panic_time_sec = 10;
            result.mate_time_sec = 10;
        }
        if (info.enemy_name.equals("bot_arimaalon")) {
            result.base_time_sec = 10;
            result.panic_time_sec = 10;
            result.mate_time_sec = 10;
        }
        if (info.enemy_name.equals("bot_arimaanator")) {
            result.base_time_sec = 60;
            result.panic_time_sec = 60;
            result.mate_time_sec = 60;
        }
        return result;
    }
}

