/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.LogFile;
import ai_util.MoveInfo;
import ai_util.TimeControl;
import ai_util.Util;
import arimaa3.ArimaaBaseClass;
import arimaa3.ArimaaClockManager;
import arimaa3.ArimaaEvaluate2;
import arimaa3.ArimaaMove;
import arimaa3.ArimaaServerInfo;
import arimaa3.FirstMove;
import arimaa3.GameState;
import arimaa3.GenCaptures;
import arimaa3.GenTurn;
import arimaa3.HashTable;
import arimaa3.MoveList;
import arimaa3.SearchTimes;
import arimaa3.TestForGoal;
import arimaa3.ThreeFoldRepetition;
import java.util.Date;
import java.util.Random;

public class ArimaaEngine
extends ArimaaBaseClass
implements Runnable {
    private int max_search_depth = 100;
    TimeControl time_control = new TimeControl();
    private long[] duplicate_positions = null;
    GameState thread_position;
    MoveInfo thread_mi;
    boolean engine_search_completed;
    private int initial_search_depth = 0;
    private int current_best_score = 0;
    private int current_search_depth = 0;
    private GameState initial_position;
    GenTurn gen_turn = new GenTurn();
    private static boolean use_tricks = true;
    private static final boolean use_futility_pruning = true;
    private static final boolean use_hash_table = true;
    private static final boolean use_defend_threat_search = true;
    private static final boolean use_null_move = true;
    private static final boolean use_quiesce = true;
    public static boolean show_alphabeta_search_trace = false;
    private static int trace_level = 5;
    private HashTable hash_table = new HashTable(500000);
    private ArimaaEvaluate2 eval = new ArimaaEvaluate2();
    private MoveList[] move_list_stack = new MoveList[100];
    private GameState[] gs_stack = new GameState[100];
    private ArimaaMove[] killer_move1 = new ArimaaMove[100];
    private ArimaaMove[] killer_move2 = new ArimaaMove[100];
    private static final int MAX_KILLERS = 10;
    private ArimaaMove[][][] killer_turn = new ArimaaMove[100][10][4];
    private int[][] killer_turn_length = new int[100][10];
    private GameState saved_initial_position;
    public long ab_nodes_searched;
    public long q_nodes_searched;
    private long initial_repeated_positions;
    private long hash_hits;
    private long hash_calls;
    private long goal_calls;
    private long goal_hits;
    private long eval_calls;
    private long enemy_goal_threats;
    private long futility_cuts;
    private long useless_cuts;
    private long defence_nodes_searched;
    private long null_move_calls;
    private long null_move_cuts;
    private boolean abort_search_flag;
    private TestForGoal goal;
    GenCaptures captures;
    private static final int ORDER_HASH = 1000;
    private static final int ORDER_KILLER_TURN = 1001;
    public static final int ORDER_CAPTURE = 1002;
    private static final int ORDER_KILLER_ONE = 1003;
    private static final int ORDER_KILLER_TWO = 1004;
    private GameState temp_gsk;
    private Random random;
    private static String[] tests = new String[]{"12w %13 +-----------------+%138|                 |%137|                 |%136|   R             |%135|                 |%134|                 |%133|         D   r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "12w %13 +-----------------+%138|                 |%137|                 |%136|   R             |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   d X     X     |%135|   d R M c       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13"};

    public ArimaaEngine() {
        int i;
        for (i = 0; i < this.gs_stack.length; ++i) {
            this.gs_stack[i] = new GameState();
        }
        for (i = 0; i < this.move_list_stack.length; ++i) {
            this.move_list_stack[i] = new MoveList(1000);
        }
        for (i = 0; i < this.killer_move1.length; ++i) {
            this.killer_move1[i] = new ArimaaMove();
            this.killer_move1[i].clear();
            this.killer_move2[i] = new ArimaaMove();
            this.killer_move2[i].clear();
        }
        for (i = 0; i < this.killer_turn.length; ++i) {
            for (int j = 0; j < this.killer_turn[i].length; ++j) {
                for (int k = 0; k < this.killer_turn[i][j].length; ++k) {
                    this.killer_turn[i][j][k] = new ArimaaMove();
                    this.killer_turn[i][j][k].clear();
                }
            }
        }
        this.saved_initial_position = null;
        this.ab_nodes_searched = 0L;
        this.q_nodes_searched = 0L;
        this.initial_repeated_positions = 0L;
        this.hash_hits = 0L;
        this.hash_calls = 0L;
        this.goal_calls = 0L;
        this.goal_hits = 0L;
        this.eval_calls = 0L;
        this.enemy_goal_threats = 0L;
        this.futility_cuts = 0L;
        this.useless_cuts = 0L;
        this.defence_nodes_searched = 0L;
        this.null_move_calls = 0L;
        this.null_move_cuts = 0L;
        this.goal = new TestForGoal();
        this.captures = new GenCaptures();
        this.temp_gsk = new GameState();
        this.random = new Random(19730318L);
    }

    public void setMaxSearchDepth(int max_depth) {
        this.max_search_depth = Math.min(max_depth, 100);
        this.max_search_depth = Math.max(0, this.max_search_depth);
    }

    public MoveInfo genMove(ArimaaServerInfo info) {
        ArimaaClockManager clock = new ArimaaClockManager();
        SearchTimes times = clock.calculate(info);
        return this.genMove(info, times);
    }

    public MoveInfo genMove(GameState gs, int fixed_search_time) {
        SearchTimes times = new SearchTimes();
        times.base_time_sec = fixed_search_time;
        times.panic_time_sec = fixed_search_time;
        times.mate_time_sec = fixed_search_time;
        ArimaaServerInfo info = new ArimaaServerInfo(gs);
        return this.genMove(info, times);
    }

    public MoveInfo genMove(ArimaaServerInfo info, SearchTimes times) {
        GameState gs = new GameState(info.position);
        this.resetStats();
        LogFile.message("Opponent: " + info.enemy_name);
        LogFile.message(new Date().toString());
        LogFile.message("\"" + gs.toEPDString() + "\",");
        LogFile.message(gs.toBoardString());
        LogFile.message(gs.toSetupString());
        LogFile.message("Max Search Depth: " + this.max_search_depth);
        LogFile.message("TC: " + times.base_time_sec + " " + times.panic_time_sec + " " + times.mate_time_sec);
        this.time_control.setNominalSearchTime(times.base_time_sec * 1000);
        this.time_control.setPanicSearchTime(times.panic_time_sec * 1000);
        this.time_control.setMateSearchTime(times.mate_time_sec * 1000);
        this.time_control.setThreshold(-1500);
        this.time_control.setSearchDepthThreshold(4);
        this.time_control.setSearchStartTime();
        this.duplicate_positions = ThreeFoldRepetition.setup(info.move_list);
        if (gs.getTurnNumber() == 1) {
            FirstMove first_move = new FirstMove();
            long random_seed = System.currentTimeMillis();
            LogFile.message("First move random seed: " + random_seed);
            String text = first_move.getFirstMove(gs, random_seed);
            MoveInfo move = new MoveInfo();
            move.move_text = text;
            return move;
        }
        return this.engine_control_code(gs);
    }

    private MoveInfo engine_control_code(GameState position) {
        this.thread_position = position;
        Thread engine_control_thread = new Thread(this);
        engine_control_thread.start();
        this.engine_search_completed = false;
        this.thread_mi = null;
        this.current_search_depth = -1;
        while (!this.time_control.isTimeExpired(this.current_best_score, this.current_search_depth) && !this.engine_search_completed || this.thread_mi == null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        LogFile.message("Time Expired");
        this.abort_search();
        LogFile.message(this.getStats());
        long start_time = System.currentTimeMillis();
        while (!this.engine_search_completed) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        long wait_time = System.currentTimeMillis() - start_time;
        LogFile.message("Wait Time: " + wait_time);
        return this.thread_mi;
    }

    public void run() {
        this.IterativeDeepeningRoot2(this.thread_position);
    }

    private MoveInfo IterativeDeepeningRoot2(GameState position) {
        this.current_best_score = -100000;
        this.current_search_depth = 0;
        ArimaaMove best_move = null;
        this.initial_position = position;
        GameState initial_gs = position;
        this.resetStats();
        this.enable_search();
        GameState new_position = new GameState();
        this.eval.PreProcessRootPosition(position);
        MoveList root_moves = this.genRootMoves(initial_gs);
        this.ProcessRootMoves(this.initial_position, root_moves);
        int offset = this.setup_search(initial_gs);
        LogFile.message("Score Offset: " + offset);
        try {
            for (int depth = this.initial_search_depth; depth <= this.max_search_depth; ++depth) {
                this.current_search_depth = depth;
                int iteration_best_score = -100000;
                int new_beta = 100000;
                root_moves.sort();
                for (ArimaaMove move : root_moves) {
                    int temp_score;
                    if (move.move_ordering_value >= 30000 || move.move_ordering_value <= -30000) {
                        temp_score = move.move_ordering_value;
                    } else {
                        new_position.play(move, this.initial_position);
                        temp_score = this.SearchPosition(new_position, depth, iteration_best_score, new_beta);
                    }
                    move.move_ordering_value = temp_score;
                    if (temp_score <= iteration_best_score) continue;
                    iteration_best_score = temp_score;
                    this.current_best_score = temp_score;
                    best_move = move;
                    this.hash_table.RecordHash(this.initial_position.getPositionHash(), depth, iteration_best_score, 2, move, false);
                    String text = "D:" + Util.Pad(2, depth);
                    text = text + " " + Util.toTimeString(this.time_control.getElapsedSearchTime());
                    text = text + " " + Util.LeftJustify(8, this.convertScore(iteration_best_score));
                    text = text + "     " + this.getPV(this.initial_position);
                    LogFile.message(text);
                    MoveInfo mi = new MoveInfo();
                    mi.eval_score = this.current_best_score;
                    mi.move_text = this.gen_turn.getOfficialArimaaNotation(this.initial_position, best_move);
                    mi.pv = this.getPV(position);
                    mi.nodes_searched = this.ab_nodes_searched;
                    mi.ply = depth;
                    mi.search_time_ms = this.time_control.getElapsedSearchTime();
                    this.thread_mi = mi;
                    if (iteration_best_score < 30000) continue;
                    break;
                }
                String text = "F:" + Util.Pad(2, depth);
                text = text + " " + Util.toTimeString(this.time_control.getElapsedSearchTime());
                text = text + " " + Util.LeftJustify(7, this.convertScore(this.current_best_score));
                text = text + "     ";
                text = text + " Nodes: " + this.ab_nodes_searched;
                text = text + " QNodes: " + this.q_nodes_searched;
                text = text + " kNPS: " + this.ab_nodes_searched / (this.time_control.getElapsedSearchTime() + 1L);
                LogFile.message(text);
                if (!ArimaaEngine.isMateScore(iteration_best_score)) {
                    continue;
                }
                break;
            }
        }
        catch (AbortSearchException ex) {
            LogFile.message("Search Aborted!");
        }
        this.engine_search_completed = true;
        return this.thread_mi;
    }

    public static boolean isMateScore(int score) {
        return Math.abs(score) > 30000;
    }

    private String convertScore(int score) {
        String result = score + "";
        if (score >= 30000) {
            result = "WON " + (Short.MAX_VALUE - score + 1);
        }
        if (score <= -30000) {
            result = "LOST " + (Short.MAX_VALUE + score + 1);
        }
        return result;
    }

    public MoveList genRootMoves(GameState root_position) {
        MoveList root_moves = new MoveList(400000);
        this.gen_turn.genAllTurns(root_position, root_moves);
        return root_moves;
    }

    public void ProcessRootMoves(GameState initial_position, MoveList root_moves) {
        int opponent_goals = 0;
        int normal_moves = 0;
        int game_over = 0;
        int repetition_banned = 0;
        GameState gs = new GameState();
        for (ArimaaMove move : root_moves) {
            gs.play(move, initial_position);
            if (gs.isGameOver()) {
                move.move_ordering_value = gs.getGameResult();
                ++game_over;
                continue;
            }
            if (this.isRepetitionBanned(gs.getPositionHash())) {
                move.move_ordering_value = -32767;
                ++repetition_banned;
                continue;
            }
            if (this.goal.test(gs)) {
                move.move_ordering_value = -32766;
                ++opponent_goals;
                continue;
            }
            move.move_ordering_value = -this.eval.Evaluate(gs, false);
            ++normal_moves;
        }
        LogFile.message("Root Moves: " + root_moves.size());
        LogFile.message("Game Over: " + game_over);
        LogFile.message("Repetition Banned: " + repetition_banned);
        LogFile.message("Opponent Goals: " + opponent_goals);
        LogFile.message("Normal Moves: " + normal_moves);
    }

    private boolean isRepetitionBanned(long hash_code) {
        for (long banned_hash : this.duplicate_positions) {
            if (banned_hash != hash_code) continue;
            return true;
        }
        return false;
    }

    private int SearchPosition(GameState position, int depth, int alpha, int beta) throws AbortSearchException {
        int score = this.AlphaBeta(depth, 0, alpha, beta, position, false, false, true);
        if (score > alpha) {
            score = this.AlphaBeta(depth, 0, alpha, beta, position, false, true, true);
        }
        return score;
    }

    public void resetStats() {
        this.ab_nodes_searched = 0L;
        this.initial_repeated_positions = 0L;
        this.hash_hits = 0L;
        this.goal_hits = 0L;
        this.eval_calls = 0L;
        this.goal_calls = 0L;
        this.hash_calls = 0L;
        this.enemy_goal_threats = 0L;
        this.futility_cuts = 0L;
        this.useless_cuts = 0L;
        this.defence_nodes_searched = 0L;
        this.null_move_calls = 0L;
        this.null_move_cuts = 0L;
    }

    public String getStats() {
        String result = "";
        result = result + "AB Nodes: " + this.ab_nodes_searched + "\n";
        result = result + "Q Nodes: " + this.q_nodes_searched + "\n";
        result = result + "Defence Nodes: " + this.defence_nodes_searched + "\n";
        result = result + "Init Repeated Positions: " + this.initial_repeated_positions + "\n";
        result = result + Util.ProbStats("Hash Table:", this.hash_calls, this.hash_hits);
        result = result + Util.ProbStats("Null Move:", this.null_move_calls, this.null_move_cuts);
        result = result + Util.ProbStats("Test Goal:", this.goal_calls, this.goal_hits);
        result = result + Util.ProbStats("E Goal Thr:", this.goal_calls, this.enemy_goal_threats);
        result = result + "Futility Cuts: " + this.futility_cuts + "\n";
        result = result + "Useless Cuts: " + this.useless_cuts + "\n";
        return result;
    }

    public boolean can_player_goal(GameState gs) {
        this.saved_initial_position = gs;
        int score = this.AlphaBetaTest(4, 0, -100000, 100000, gs);
        return score == Short.MAX_VALUE;
    }

    public void abort_search() {
        this.abort_search_flag = true;
    }

    public void enable_search() {
        this.abort_search_flag = false;
    }

    public int setup_search(GameState root_gs) {
        int score_offset = this.eval.PreProcessRootPosition(root_gs);
        return score_offset;
    }

    private int AlphaBetaTest(int depth, int ply, int alpha, int beta, GameState gs) {
        ++this.ab_nodes_searched;
        if (depth <= 0 || ply >= 100) {
            return 0;
        }
        int score = this.hash_table.ProbeHash(gs.getPositionHash(), depth, alpha, beta, false);
        ++this.hash_calls;
        if (score != -100024222 && use_tricks) {
            ++this.hash_hits;
            return score;
        }
        MoveList moves = this.move_list_stack[ply];
        moves.clear();
        long start_bb = -1L;
        long dest_bb = -1L;
        if (depth == 1 && use_tricks) {
            start_bb = gs.piece_bb[gs.player];
            dest_bb = gs.player == 0 ? -72057594037927936L : 255L;
        }
        gs.GENERATE_MOVES(moves, start_bb, dest_bb);
        GameState new_gs = this.gs_stack[ply];
        int moves_searched = 0;
        for (ArimaaMove move : moves) {
            new_gs.play(move, gs);
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, move.toString());
            }
            if (new_gs.equals(this.saved_initial_position)) {
                ++this.initial_repeated_positions;
                continue;
            }
            if (new_gs.isGameOver()) {
                score = new_gs.getGameResult();
                if (show_alphabeta_search_trace) {
                    this.SearchTrace(ply, "Game Over: " + score);
                }
            } else {
                int new_depth = depth - move.steps;
                int new_ply = ply + move.steps;
                score = new_gs.getStepsRemaining() == 4 ? -this.AlphaBetaTest(new_depth, new_ply, -beta, -alpha, new_gs) : this.AlphaBetaTest(new_depth, new_ply, alpha, beta, new_gs);
            }
            if (score > alpha) {
                if (score >= beta) {
                    this.hash_table.RecordHash(gs.getPositionHash(), depth, score, 2, null, false);
                    return score;
                }
                alpha = score;
            }
            ++moves_searched;
            if (score < 30000) continue;
            break;
        }
        if (moves_searched == 0) {
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, "No Moves!");
            }
            return -32767;
        }
        this.hash_table.RecordHash(gs.getPositionHash(), depth, alpha, 1, null, false);
        return alpha;
    }

    public void SearchTrace(int ply, int depth, int alpha, int beta, ArimaaMove move) {
        String result = "";
        if (move.move_ordering_value == 1000) {
            result = result + "HM";
        } else if (move.move_ordering_value == 1001) {
            result = result + "KT";
        } else if (move.move_ordering_value == 1002) {
            result = result + "CP";
        } else if (move.move_ordering_value == 1003) {
            result = result + "K1";
        } else if (move.move_ordering_value == 1004) {
            result = result + "K2";
        }
        result = result + move.toString() + " ";
        result = result + "[" + alpha + " " + beta + "] ";
        result = result + depth + " ";
        this.SearchTrace(ply, result);
    }

    protected void SearchTrace(int ply, String text) {
        if (ply < trace_level) {
            String result = Util.LeftJustify(3, ply + "");
            for (int i = 0; i < ply; ++i) {
                result = result + "  ";
            }
            result = result + text;
            LogFile.message(result);
            System.out.println(result);
            System.out.flush();
        }
    }

    int AlphaBeta(int depth, int ply, int alpha, int beta, GameState gs, boolean is_defend_threat_search, boolean is_verification_search, boolean ok_to_null) throws AbortSearchException {
        ++this.ab_nodes_searched;
        if (this.abort_search_flag) {
            throw new AbortSearchException();
        }
        if (gs.getStepsRemaining() == 4) {
            int new_beta;
            int new_alpha;
            if (alpha >= 32766) {
                return 32766;
            }
            if (beta <= -32766) {
                return -32766;
            }
            int n = alpha > 30000 ? alpha + 1 : (new_alpha = alpha < -30000 ? alpha - 1 : alpha);
            int n2 = beta > 30000 ? beta + 1 : (new_beta = beta < -30000 ? beta - 1 : beta);
            assert (new_alpha <= 32766);
            GameState temp_position = this.saved_initial_position;
            this.saved_initial_position = gs;
            int result = -this.AlphaBetaMain(depth, ply, -new_beta, -new_alpha, gs, true, is_defend_threat_search, is_verification_search, ok_to_null);
            this.saved_initial_position = temp_position;
            int new_result = result > 30000 ? result - 1 : (result < -30000 ? result + 1 : result);
            return new_result;
        }
        int result = this.AlphaBetaMain(depth, ply, alpha, beta, gs, false, is_defend_threat_search, is_verification_search, ok_to_null);
        return result;
    }

    private int AlphaBetaMain(int depth, int ply, int alpha, int beta, GameState gs, boolean is_first_step, boolean is_defend_threat_search, boolean is_verification_search, boolean ok_to_null) throws AbortSearchException {
        int static_score;
        int best_score = -110000;
        if (is_first_step) {
            ++this.goal_calls;
            if (this.goal.test(gs)) {
                ++this.goal_hits;
                return Short.MAX_VALUE;
            }
        }
        ++this.hash_calls;
        int result = this.hash_table.ProbeHash(gs.getPositionHash(), depth, alpha, beta, is_defend_threat_search);
        if (result != -100024222) {
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, "Hash Hit: " + result);
            }
            ++this.hash_hits;
            return result;
        }
        if (is_first_step && depth < 4 && !is_defend_threat_search) {
            this.gs_stack[ply].playPASS(gs);
            if (this.goal.test(this.gs_stack[ply])) {
                ++this.enemy_goal_threats;
                if (show_alphabeta_search_trace) {
                    this.SearchTrace(ply, "Enemy Goal Threat");
                }
                for (int def_depth = depth; def_depth <= 4; ++def_depth) {
                    int result2 = this.AlphaBetaMain(def_depth, ply, alpha, beta, gs, true, true, is_verification_search, false);
                    if (show_alphabeta_search_trace) {
                        this.SearchTrace(ply, "EGTd: " + def_depth + " Score: " + result2);
                    }
                    if (result2 <= alpha) continue;
                    if (result2 >= beta) {
                        return result2;
                    }
                    alpha = result2;
                }
                if (show_alphabeta_search_trace) {
                    this.SearchTrace(ply, "No Defence Found!");
                }
                return alpha;
            }
        }
        if (depth <= 0 || ply >= 100) {
            if (is_defend_threat_search) {
                this.gs_stack[ply].playPASS(gs);
                if (this.goal.test(this.gs_stack[ply])) {
                    if (show_alphabeta_search_trace) {
                        this.SearchTrace(ply, "Enemy can still goal!");
                    }
                    return -32767;
                }
                ++this.eval_calls;
                return this.eval.Evaluate(gs, false);
            }
            if (is_first_step) {
                result = this.Quiesce(ply, 2, alpha, beta, gs);
                if (show_alphabeta_search_trace) {
                    this.SearchTrace(ply, "Q result: " + result);
                }
                return result;
            }
            ++this.eval_calls;
            result = this.eval.Evaluate(gs, false);
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, "Eval: " + result);
            }
            return result;
        }
        GameState new_gs = this.gs_stack[ply];
        if (ok_to_null) {
            int new_depth = depth - 4;
            int new_ply = ply + gs.getStepsRemaining();
            new_gs.playPASS(gs);
            if (show_alphabeta_search_trace && ply <= trace_level) {
                this.SearchTrace(ply, "Trying Null move " + beta);
            }
            ++this.null_move_calls;
            int result3 = this.AlphaBeta(new_depth, new_ply, beta, beta + 1, new_gs, is_defend_threat_search, is_verification_search, false);
            if (show_alphabeta_search_trace && ply <= trace_level) {
                this.SearchTrace(ply, "Finished Null move " + result3);
            }
            if (result3 >= beta) {
                ++this.null_move_cuts;
                return result3;
            }
        }
        boolean gen_caps_only = false;
        if (!is_verification_search && !is_defend_threat_search && depth < gs.getStepsRemaining() + 4 && (static_score = this.eval.Evaluate(gs, false)) + 1500 < alpha) {
            ++this.futility_cuts;
            if (gs.getStepsRemaining() < 4) {
                ++this.useless_cuts;
                if (show_alphabeta_search_trace) {
                    this.SearchTrace(ply, "Useless cut " + static_score);
                }
                return alpha;
            }
            gen_caps_only = true;
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, "D2 futility: " + static_score);
            }
            best_score = alpha;
        }
        MoveList moves = this.move_list_stack[ply];
        moves.clear();
        this.gen_moves(ply, gs, moves, is_first_step, gen_caps_only);
        ArimaaMove best_move = null;
        int moves_searched = 0;
        for (ArimaaMove move : moves) {
            int score;
            new_gs.play(move, gs);
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, depth, alpha, beta, move);
            }
            if (new_gs.equals(this.saved_initial_position)) {
                ++this.initial_repeated_positions;
                if (!show_alphabeta_search_trace) continue;
                this.SearchTrace(ply, "Initial position repetition");
                continue;
            }
            if (new_gs.isGameOver()) {
                score = new_gs.getGameResult();
            } else {
                int new_depth = depth - move.steps;
                int new_ply = ply + move.steps;
                score = this.AlphaBeta(new_depth, new_ply, alpha, beta, new_gs, is_defend_threat_search, is_verification_search, ok_to_null);
                if (!is_verification_search && new_gs.getStepsRemaining() == 4 && new_depth >= 4 && score > alpha) {
                    score = this.AlphaBeta(new_depth, new_ply, alpha, beta, new_gs, is_defend_threat_search, true, ok_to_null);
                }
            }
            if (score > best_score) {
                best_score = score;
                best_move = move;
            }
            if (score > alpha) {
                if (score >= beta) {
                    this.hash_table.RecordHash(gs.getPositionHash(), depth, score, 2, move, is_defend_threat_search);
                    this.UpdateKillerMoves(ply, gs, move, false);
                    return score;
                }
                alpha = score;
            }
            ++moves_searched;
            if (score < 30000) continue;
            break;
        }
        if (moves_searched == 0 && !gen_caps_only) {
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, "No Moves!");
            }
            return Short.MIN_VALUE;
        }
        this.hash_table.RecordHash(gs.getPositionHash(), depth, alpha, 1, best_move, is_defend_threat_search);
        return best_score;
    }

    private int Quiesce(int ply, int depth, int alpha, int beta, GameState gs) throws AbortSearchException {
        assert (gs.getStepsRemaining() == 4);
        ++this.q_nodes_searched;
        ++this.goal_calls;
        if (this.goal.test(gs)) {
            ++this.goal_hits;
            return Short.MAX_VALUE;
        }
        int score = this.eval.Evaluate(gs, false);
        if (depth <= 0) {
            return score;
        }
        if (show_alphabeta_search_trace) {
            this.SearchTrace(ply, "QStand pat score: " + score);
        }
        if (score > alpha) {
            if (score >= beta) {
                return score;
            }
            alpha = score;
        }
        GameState new_gs = this.gs_stack[ply];
        MoveList moves = this.move_list_stack[ply];
        moves.clear();
        this.captures.genCaptures(gs, moves, true);
        moves.sort();
        Object best_move = null;
        for (ArimaaMove move : moves) {
            new_gs.play(move, gs);
            if (show_alphabeta_search_trace) {
                this.SearchTrace(ply, -1, alpha, beta, move);
            }
            if (new_gs.isGameOver()) {
                score = new_gs.getGameResult();
            } else {
                int new_ply = ply + move.steps;
                score = -this.Quiesce(new_ply, depth - 1, -beta, -alpha, new_gs);
            }
            if (score <= alpha) continue;
            if (score >= beta) {
                return score;
            }
            alpha = score;
        }
        return alpha;
    }

    private void gen_moves(int ply, GameState gs, MoveList moves, boolean is_first_step, boolean gen_caps_only) {
        ArimaaMove hash_move = this.hash_table.ProbeHashMove(gs.getPositionHash());
        if (hash_move != null) {
            ArimaaMove temp = moves.getMove();
            temp.copy(hash_move);
            temp.move_ordering_value = 1000;
        }
        if (gs.getStepsRemaining() == 4) {
            for (int cur_killer = 0; cur_killer <= 3; ++cur_killer) {
                ArimaaMove move;
                this.temp_gsk.copy(gs);
                ArimaaMove temp = null;
                for (int i = 0; i < this.killer_turn_length[ply][cur_killer] && this.temp_gsk.isLegalMove(move = this.killer_turn[ply][cur_killer][i]); ++i) {
                    this.temp_gsk.play(move, this.temp_gsk);
                    if (temp == null) {
                        temp = moves.getMove();
                        temp.clear();
                    }
                    temp.add(temp, move);
                    temp.move_ordering_value = 1001;
                }
            }
        }
        if (gs.getStepsRemaining() >= 3) {
            this.captures.genCaptures(gs, moves, false);
        }
        int start_index = moves.size();
        if (!gen_caps_only) {
            gs.GENERATE_MOVES(moves, -1L, -1L);
            int end_index = moves.size();
            for (int index = start_index; index < end_index; ++index) {
                ArimaaMove t2;
                ArimaaMove temp = moves.move_list[index];
                if (temp.equals(this.killer_move1[ply])) {
                    t2 = moves.move_list[index];
                    moves.move_list[index] = moves.move_list[start_index];
                    moves.move_list[start_index++] = t2;
                    t2.move_ordering_value = 1003;
                }
                if (!temp.equals(this.killer_move2[ply])) continue;
                t2 = moves.move_list[index];
                moves.move_list[index] = moves.move_list[start_index];
                moves.move_list[start_index++] = t2;
                t2.move_ordering_value = 1004;
            }
        }
    }

    public void UpdateKillerMoves(int ply, GameState gs, ArimaaMove move, boolean isCaptureMove) {
        if (!this.killer_move1[ply].equals(move) && !isCaptureMove && move.steps <= 2) {
            this.killer_move2[ply].copy(this.killer_move1[ply]);
            this.killer_move1[ply].copy(move);
        }
        if (gs.getStepsRemaining() == 4) {
            ArimaaMove hash_move;
            int count;
            int cur_killer = this.random.nextInt(3);
            cur_killer = 0;
            this.temp_gsk.copy(gs);
            for (count = 0; count <= 4 && (hash_move = this.hash_table.ProbeHashMove(this.temp_gsk.getPositionHash())) != null; ++count) {
                this.killer_turn[ply][cur_killer][count].copy(hash_move);
                this.temp_gsk.play(hash_move, this.temp_gsk);
                if (this.temp_gsk.getStepsRemaining() == 4) break;
            }
            this.killer_turn_length[ply][cur_killer] = count;
        }
    }

    public String getPV(GameState gs) {
        ArimaaMove hash_move;
        String result = "";
        int pv_moves = 0;
        this.temp_gsk.copy(gs);
        while ((hash_move = this.hash_table.ProbeHashMove(this.temp_gsk.getPositionHash())) != null) {
            result = result + hash_move.toString() + " ";
            this.temp_gsk.play(hash_move, this.temp_gsk);
            if (++pv_moves <= 50) continue;
            break;
        }
        return result;
    }

    public static void main(String[] args) {
        ArimaaEngine engine = new ArimaaEngine();
        engine.resetStats();
        LogFile.setMessageDisplay(true);
        for (String text : tests) {
            GameState position = new GameState(text);
            MoveInfo info = engine.genMove(position, 10000);
            System.out.println("*" + info.move_text + "*");
        }
    }

    public class AbortSearchException
    extends Exception {
    }
}

