/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.Util;
import arimaa3.ArimaaBaseClass;
import arimaa3.GameState;
import java.util.Arrays;

public class ArimaaEvaluate2
extends ArimaaBaseClass {
    private static long eval_calls = 0L;
    private String eval_text;
    private boolean createText;
    private int score_offset;
    private int[] dynamic_piece_value = new int[12];
    private int[] white_pieces = new int[16];
    private int[] black_pieces = new int[16];
    private static final int[] fame_value = new int[]{256, 85, 57, 38, 25, 17, 11, 7};
    private static String[] text = new String[]{"12w %13 +-----------------+%138|                 |%137|                 |%136|   R             |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "12w %13 +-----------------+%138|                 |%137| R               |%136|                 |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "12w %13 +-----------------+%138|                 |%137|   R             |%136|                 |%135|                 |%134|                 |%133|             r   |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "6b %13 +-----------------+%138| r r r r r r r r |%137|     d     m     |%136| h c         h d |%135|                 |%134|           E     |%133|       D e c H   |%132| R   D   C C   R |%131| R R R M   R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r r r |%137| h d c e m c d h |%136|                 |%135|                 |%134|                 |%133|                 |%132| R H C D H C E R |%131| R R R M D R R R |%13 +-----------------+%13   a b c d e f g h%13", "4b %13 +-----------------+%138| r r r m   r r r |%137| r h d d c c   r |%136|       e     h   |%135|       E         |%134|                 |%133|   H         H   |%132| R D   M C D   R |%131| R R R C   R R R |%13 +-----------------+%13   a b c d e f g h%13", "6w %13 +-----------------+%138| r r r r r r r r |%137|     h     d h   |%136|   c     m   c   |%135|                 |%134|     E           |%133| d H   e     H   |%132| R     C D C   R |%131| R R R D M R R R |%13 +-----------------+%13   a b c d e f g h%13", "4b %13 +-----------------+%138| r r r   m r r r |%137|   r c d   d h r |%136|   h     E e H   |%135|         c       |%134|                 |%133|                 |%132| R H C M   C   R |%131| R R R D D R R R |%13 +-----------------+%13   a b c d e f g h%13", "4b %13 +-----------------+%138| r r r m d r r r |%137| r   c     c   r |%136|   h         h   |%135|                 |%134|       e E       |%133|         d   H   |%132| R H C M   C   R |%131| R R R D D R R R |%13 +-----------------+%13   a b c d e f g h%13", "19b %13 +-----------------+%138| r r r   d   r r |%137| r   c     m r r |%136|       d E H h   |%135|           e R c |%134|     D         M |%133|   H         C   |%132| R     h   D     |%131| R R R C   R R R |%13 +-----------------+%13   a b c d e f g h%13", "20b %13 +-----------------+%138| r r   m r   r r |%137| r R E M r d   r |%136|   d   e D   h   |%135| D         H     |%134|                 |%133|   R         C   |%132|     R     H h   |%131|       R R   R R |%13 +-----------------+%13   a b c d e f g h%13"};

    public static String getStats() {
        String result = "";
        result = result + "EvCalls: " + eval_calls + " ";
        return result;
    }

    public String getEvalText() {
        return this.eval_text;
    }

    public int PreProcessRootPosition(GameState root_gs) {
        root_gs.compute_tertiary_bitboards();
        this.createText = false;
        this.getDynamicPieceValues(root_gs);
        this.score_offset = this.getPieceLocationEvaluation(root_gs);
        return this.score_offset;
    }

    public int Evaluate(GameState gs, boolean createText) {
        gs.compute_tertiary_bitboards();
        this.createText = createText;
        ++eval_calls;
        int score = 0;
        if (createText) {
            this.eval_text = "Position Evaluation Results\n";
            this.eval_text = this.eval_text + "Side to Move: " + gs.player + " \n";
        }
        score += this.getPieceLocationEvaluation(gs);
        if ((score -= this.score_offset) >= 29990) {
            score = 29990;
        }
        if (score <= -29990) {
            score = -29990;
        }
        if (createText) {
            this.eval_text = this.eval_text + "Score: " + score + " (White's POV)\n";
        }
        return gs.player == 0 ? score : -score;
    }

    private void getDynamicPieceValues(GameState gs) {
        int initial_score = this.getFAMEMaterialScore(gs, -1L);
        int i = 0;
        while (i < 12) {
            long lsb_bb = gs.piece_bb[i] & -gs.piece_bb[i];
            int n = i;
            gs.piece_bb[n] = gs.piece_bb[n] ^ lsb_bb;
            int final_score = this.getFAMEMaterialScore(gs, -1L);
            this.dynamic_piece_value[i] = final_score - initial_score;
            int n2 = i++;
            gs.piece_bb[n2] = gs.piece_bb[n2] ^ lsb_bb;
        }
        if (this.createText) {
            for (i = 0; i < 12; ++i) {
                this.eval_text = this.eval_text + "Piece value " + i + " = " + this.dynamic_piece_value[i] + "\n";
            }
        }
    }

    private int getFAMEMaterialScore(GameState gs, long mask_bb) {
        int score = 0;
        Arrays.fill(this.white_pieces, 0);
        Arrays.fill(this.black_pieces, 0);
        int white_men_count = 0;
        int black_men_count = 0;
        for (int piece_type = 6; piece_type >= 1; --piece_type) {
            int i;
            long temp_piece_bb = gs.piece_bb[piece_type * 2 - 2] & mask_bb;
            int count = Util.PopCnt(temp_piece_bb);
            for (i = 0; i < count; ++i) {
                this.white_pieces[white_men_count++] = piece_type;
            }
            temp_piece_bb = gs.piece_bb[piece_type * 2 - 1] & mask_bb;
            count = Util.PopCnt(temp_piece_bb);
            for (i = 0; i < count; ++i) {
                this.black_pieces[black_men_count++] = piece_type;
            }
        }
        int index = 0;
        while (this.white_pieces[index] > 1 || this.black_pieces[index] > 1) {
            if (this.white_pieces[index] > this.black_pieces[index]) {
                score += fame_value[index];
                if (this.createText) {
                    this.eval_text = this.eval_text + "Matchup: " + index + " Score: " + fame_value[index] + "\n";
                }
            }
            if (this.black_pieces[index] > this.white_pieces[index]) {
                score -= fame_value[index];
                if (this.createText) {
                    this.eval_text = this.eval_text + "Matchup: " + index + " Score: " + -fame_value[index] + "\n";
                }
            }
            ++index;
        }
        int actual_white_rabbit_count = Math.max(Util.PopCnt(gs.piece_bb[0]), 1);
        int actual_black_rabbit_count = Math.max(Util.PopCnt(gs.piece_bb[1]), 1);
        int white_piece_count = white_men_count - actual_white_rabbit_count;
        int black_piece_count = black_men_count - actual_black_rabbit_count;
        int white_rabbit_value = 600 / (2 * black_piece_count + actual_black_rabbit_count);
        int black_rabbit_value = 600 / (2 * white_piece_count + actual_white_rabbit_count);
        int white_rabbits = white_men_count - index;
        int black_rabbits = black_men_count - index;
        score += white_rabbits * white_rabbit_value;
        score -= black_rabbits * black_rabbit_value;
        if (this.createText) {
            this.eval_text = this.eval_text + "White Rabbits: " + white_rabbits + " Value: " + white_rabbit_value + "\n";
            this.eval_text = this.eval_text + "Black Rabbits: " + black_rabbits + " Value: " + black_rabbit_value + "\n";
            this.eval_text = this.eval_text + "FAME Score: " + score + "\n";
        }
        return score;
    }

    private int getPieceLocationEvaluation(GameState gs) {
        int score = 0;
        score += 80 * this.getFAMEMaterialScore(gs, -1L);
        if (this.createText) {
            this.eval_text = this.eval_text + "FAME Material Score: " + score + "\n";
        }
        return score;
    }

    public static void testFAME() {
        ArimaaEvaluate2 eval = new ArimaaEvaluate2();
        long total_start_time = System.currentTimeMillis();
        for (String temp : text) {
            GameState position = new GameState(temp);
            System.out.println(position.toBoardString());
            long start_time = System.currentTimeMillis();
            for (int i = 0; i < 1000000; ++i) {
                int score = eval.getFAMEMaterialScore(position, -1L);
            }
            long elapsed_time = System.currentTimeMillis() - start_time;
            System.out.println("Time: " + elapsed_time);
        }
        long total_elapsed_time = System.currentTimeMillis() - total_start_time;
        System.out.println("Time: " + total_elapsed_time);
    }

    private static void testEval() {
        ArimaaEvaluate2 eval = new ArimaaEvaluate2();
        for (String temp : text) {
            GameState position = new GameState(temp);
            System.out.println(position.toBoardString());
            eval.PreProcessRootPosition(position);
            int score = eval.Evaluate(position, true);
            System.out.println(eval.getEvalText());
            int score2 = eval.Evaluate(position, false);
            position.mirror();
            eval.PreProcessRootPosition(position);
            int score3 = eval.Evaluate(position, false);
            position.rotate();
            eval.PreProcessRootPosition(position);
            int score4 = eval.Evaluate(position, false);
            position.mirror();
            eval.PreProcessRootPosition(position);
            int score5 = eval.Evaluate(position, false);
            assert (score == score2);
            assert (score == score3);
            assert (score == score4);
            assert (score == score5);
            System.out.println("Returned: " + score);
        }
    }

    public static void main(String[] args) {
        ArimaaEvaluate2.testEval();
    }
}

