/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.LogFile;
import ai_util.MoveInfo;
import arimaa3.ArimaaEngine;
import arimaa3.ArimaaServerInfo;
import arimaa3.GameState;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Properties;

public class ArimaaMain {
    public static void main(String[] args) {
        if (args.length == 3) {
            ArimaaMain.execute(args[2]);
        }
        if (args.length == 5) {
            int search_time = Integer.parseInt(args[1]);
            ArimaaMain.fixed_match(args[2], search_time);
        }
    }

    private static void fixed_match(String pos_file_name, int search_time) {
        try {
            String data;
            BufferedReader file_reader = new BufferedReader(new FileReader(pos_file_name));
            String position_text = "";
            while ((data = file_reader.readLine()) != null) {
                position_text = position_text + data + "%13";
            }
            GameState position = new GameState(position_text);
            ArimaaEngine engine = new ArimaaEngine();
            LogFile.setMessageDisplay(false);
            engine.setMaxSearchDepth(99);
            MoveInfo move = engine.genMove(position, search_time);
            String final_move = move.move_text.replaceAll(" pass", "");
            LogFile.write("Engine Move: *" + final_move + "*");
            System.out.println(final_move);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void execute(String file_name) {
        long start_time = System.currentTimeMillis();
        int max_search_depth = 99;
        boolean rated_game_only_mode = false;
        try {
            BufferedInputStream file_reader = new BufferedInputStream(new FileInputStream("clueless.cfg"));
            Properties gameData = new Properties();
            gameData.load(file_reader);
            String text = gameData.getProperty("max_search_depth");
            max_search_depth = Integer.parseInt(text);
            String text2 = gameData.getProperty("rated_game_only_mode").toLowerCase();
            rated_game_only_mode = Boolean.parseBoolean(text2);
        }
        catch (Exception e) {
            max_search_depth = 99;
            rated_game_only_mode = false;
        }
        LogFile.write("Clueless.cfg Max Search Depth: " + max_search_depth);
        LogFile.write("Clueless.cfg Rated game only mode: " + rated_game_only_mode);
        try {
            ArimaaServerInfo info = new ArimaaServerInfo(file_name);
            if (rated_game_only_mode && !info.is_rated && info.tc_game_length > 60) {
                LogFile.write("Unrated game. I resign");
                System.out.println("resign");
                return;
            }
            ArimaaEngine engine = new ArimaaEngine();
            LogFile.setMessageDisplay(false);
            engine.setMaxSearchDepth(max_search_depth);
            MoveInfo move = engine.genMove(info);
            String final_move = move.move_text.replaceAll(" pass", "");
            LogFile.write("Engine Move: *" + final_move + "*");
            System.out.println(final_move);
            long elapsed_time = System.currentTimeMillis() - start_time;
            LogFile.write("Total Elapsed Time: " + elapsed_time + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

