/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.RepetitionHashTable;
import arimaa3.ArimaaMove;
import arimaa3.Constants;
import arimaa3.GameState;
import arimaa3.MoveList;

public class GenTurn
implements Constants {
    private MoveList[] move_list_stack = new MoveList[5];
    private GameState[] gs_stack = new GameState[5];
    private MoveList move_data;
    private GameState saved_initial_position;
    private RepetitionHashTable repetition;
    private boolean get_notation;
    private GameState desired_position;
    private String notation_result;
    private boolean debug_flag;
    private static long total_moves = 0L;
    private static long repeated_positions = 0L;
    private static long initial_repeated_positions = 0L;
    private static long gen_calls = 0L;

    public GenTurn() {
        int i;
        for (i = 0; i < this.gs_stack.length; ++i) {
            this.gs_stack[i] = new GameState();
        }
        for (i = 0; i < this.move_list_stack.length; ++i) {
            this.move_list_stack[i] = new MoveList(1000);
        }
        this.saved_initial_position = null;
        this.repetition = new RepetitionHashTable(19);
        this.desired_position = new GameState();
        this.notation_result = "";
    }

    public String getOfficialArimaaNotation(GameState initial_position, ArimaaMove move) {
        this.debug_flag = false;
        this.get_notation = true;
        this.saved_initial_position = initial_position;
        try {
            this.desired_position.play(move, initial_position);
            this.repetition.increaseAge();
            this.gen_moves(initial_position);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        assert (this.debug_flag);
        return this.notation_result;
    }

    public void calculate_notation() {
        GameState new_position;
        this.debug_flag = true;
        this.notation_result = "";
        GameState position = this.saved_initial_position;
        do {
            int steps_available = position.getStepsRemaining();
            ArimaaMove move = this.move_list_stack[steps_available].getCurrentMove();
            this.notation_result = this.notation_result + move.toOfficialArimaaNotation(position) + " ";
            new_position = this.gs_stack[steps_available];
            new_position.play(move, position);
        } while ((position = new_position).getStepsRemaining() != 4);
        this.notation_result = this.notation_result.trim();
    }

    public void genAllTurns(GameState initial_position, MoveList move_list) {
        move_list.clear();
        this.move_data = move_list;
        this.saved_initial_position = initial_position;
        ++gen_calls;
        this.get_notation = false;
        this.repetition.increaseAge();
        this.gen_moves(initial_position);
    }

    private void gen_moves(GameState initial_position) {
        int steps_available = initial_position.getStepsRemaining();
        this.move_list_stack[steps_available].clear();
        initial_position.GENERATE_MOVES(this.move_list_stack[steps_available], -1L, -1L);
        for (ArimaaMove move : this.move_list_stack[steps_available]) {
            GameState new_position = this.gs_stack[steps_available];
            new_position.play(move, initial_position);
            if (new_position.equals(this.saved_initial_position)) {
                ++initial_repeated_positions;
                continue;
            }
            long hash_code = new_position.getPositionHash();
            if (this.repetition.isRepetition(hash_code)) {
                ++repeated_positions;
                continue;
            }
            if (this.get_notation && new_position.full_equals(this.desired_position)) {
                this.calculate_notation();
                throw new ArrayIndexOutOfBoundsException();
            }
            if (new_position.getStepsRemaining() == 4) {
                if (this.get_notation) continue;
                ++total_moves;
                ArimaaMove result = this.move_data.getMove();
                result.difference(this.saved_initial_position, new_position);
                continue;
            }
            this.gen_moves(new_position);
        }
    }

    public String getStats() {
        String result = "";
        result = result + "GenTurn calls: " + gen_calls + "\n";
        result = result + "Total Moves: " + total_moves + "\n";
        result = result + "Initial Positions: " + initial_repeated_positions + "\n";
        result = result + "Repeated Positions: " + repeated_positions + "\n";
        return result;
    }

    public void resetStats() {
        total_moves = 0L;
        repeated_positions = 0L;
        initial_repeated_positions = 0L;
        gen_calls = 0L;
    }

    public static void main(String[] args) {
        String[] text = new String[]{"16w %13 +-----------------+%138|     e           |%137| R               |%136|                 |%135|           E     |%134|                 |%133|       R         |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16b %13 +-----------------+%138|     e           |%137|                 |%136|                 |%135|           E     |%134|                 |%133|       R         |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16w %13 +-----------------+%138|     e           |%137|                 |%136|                 |%135|           E     |%134|                 |%133|       R         |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13"};
        GenTurn test = new GenTurn();
        MoveList result = new MoveList(400000);
        for (String pos_text : text) {
            long start_time = System.currentTimeMillis();
            GameState position = new GameState(pos_text);
            System.out.println(position);
            System.out.println(position.toSetupString());
            test.genAllTurns(position, result);
            System.out.println("Total moves: " + result.size());
            long elapsed_time = System.currentTimeMillis() - start_time;
            System.out.println("Elapsed time: " + elapsed_time + "ms");
            int count = 0;
            for (ArimaaMove move : result) {
                System.out.println(count + " " + test.getOfficialArimaaNotation(position, move) + "*");
                ++count;
            }
        }
        System.out.println(test.getStats());
    }
}

