/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import arimaa3.ArimaaMove;
import arimaa3.Constants;

public class HashTable
implements Constants {
    public static final int NO_SCORE = -100024222;
    protected long[] hash_data;
    protected ArimaaMove[] move_data;
    protected int table_size;
    protected int global_age;
    private static final int entry_size = 4;
    public static final int NO_BOUND = 0;
    public static final int UPPER_BOUND = 1;
    public static final int LOWER_BOUND = 2;
    public static final int EXACT_BOUND = 3;
    private int hash_move_depth;

    public HashTable(int table_size) {
        this.hash_data = new long[table_size * 4];
        this.table_size = table_size;
        this.move_data = new ArimaaMove[table_size * 2];
        for (int i = 0; i < this.move_data.length; ++i) {
            this.move_data[i] = new ArimaaMove();
        }
        this.reset();
    }

    public int getSize() {
        return this.table_size;
    }

    public void reset() {
        int i;
        for (i = 0; i < this.hash_data.length; ++i) {
            this.hash_data[i] = 0L;
        }
        for (i = 0; i < this.move_data.length; ++i) {
            this.move_data[i].clear();
        }
        this.global_age = 0;
    }

    public void RecordHash(long hashKey, int depth, int value, int bound, ArimaaMove move, boolean is_defend_threat_search) {
        assert (value >= Short.MIN_VALUE);
        assert (value <= Short.MAX_VALUE);
        int index = this.getHashIndex(hashKey);
        long current_entry = this.hash_data[index + 1];
        int current_depth = (int)(current_entry >> 22 & 0xFFL);
        int current_age = (int)(current_entry >> 30 & 7L);
        if (current_age != this.global_age || depth >= current_depth) {
            long hashInfo = this.getHashInfo(depth, value, bound, move, is_defend_threat_search);
            this.hash_data[index] = hashKey;
            this.hash_data[index + 1] = hashInfo;
            if (move != null) {
                this.move_data[this.getMoveIndex(hashKey) + 0].copy(move);
            }
        } else {
            long hashInfo = this.getHashInfo(depth, value, bound, move, is_defend_threat_search);
            this.hash_data[index + 2] = hashKey;
            this.hash_data[index + 3] = hashInfo;
            if (move != null) {
                this.move_data[this.getMoveIndex(hashKey) + 1].copy(move);
            }
        }
    }

    private int getHashIndex(long hashKey) {
        int index = (int)(hashKey % (long)this.table_size);
        if (index < 0) {
            index += this.table_size;
        }
        return index *= 4;
    }

    private int getMoveIndex(long hashKey) {
        int index = (int)(hashKey % (long)this.table_size);
        if (index < 0) {
            index += this.table_size;
        }
        return index *= 2;
    }

    private long getHashInfo(int depth, int value, int bound, ArimaaMove move, boolean is_defend_threat_search) {
        long result = 0L;
        if (is_defend_threat_search) {
            result += 0x400000000L;
        }
        if (move != null) {
            result += 0x200000000L;
        }
        result += ((long)this.global_age & 7L) << 30;
        result += ((long)depth & 0xFFL) << 22;
        result += ((long)value & 0xFFFFFL) << 2;
        return result += (long)bound & 3L;
    }

    public boolean containsKey(long hashKey) {
        boolean result = false;
        int index = this.getHashIndex(hashKey);
        if (this.hash_data[index] == hashKey || this.hash_data[index + 2] == hashKey) {
            result = true;
        }
        return result;
    }

    public int ProbeHash(long hashKey2, int depth, int alpha, int beta, boolean is_defend_threat_search) {
        long hashInfo;
        int index = this.getHashIndex(hashKey2);
        int result = -100024222;
        if (this.hash_data[index] == hashKey2 && (result = this.test_for_cutoff(hashInfo = this.hash_data[index + 1], depth, alpha, beta, is_defend_threat_search)) != -100024222) {
            return result;
        }
        if (this.hash_data[index + 2] == hashKey2 && (result = this.test_for_cutoff(hashInfo = this.hash_data[index + 3], depth, alpha, beta, is_defend_threat_search)) != -100024222) {
            return result;
        }
        return result;
    }

    private int test_for_cutoff(long hashInfo, int depth, int alpha, int beta, boolean is_defend_threat_search) {
        boolean is_stored_threat_search;
        int hash_depth = (int)(hashInfo >> 22 & 0xFFL);
        short hash_value = (short)(hashInfo >> 2 & 0xFFFFFL);
        int hash_bound = (int)(hashInfo & 3L);
        boolean bl = is_stored_threat_search = (hashInfo >> 34 & 1L) == 1L;
        if (!is_stored_threat_search) {
            if (hash_value >= 30000 && (hash_bound == 2 || hash_bound == 3)) {
                hash_depth = Integer.MAX_VALUE;
            } else if (hash_value <= -30000 && (hash_bound == 1 || hash_bound == 3)) {
                hash_depth = Integer.MAX_VALUE;
            }
        }
        if (!is_defend_threat_search && is_stored_threat_search) {
            return -100024222;
        }
        if (hash_depth >= depth) {
            if (hash_bound == 3) {
                return hash_value;
            }
            if (hash_bound == 1 && hash_value <= alpha) {
                return hash_value;
            }
            if (hash_bound == 2 && hash_value >= beta) {
                return hash_value;
            }
        }
        return -100024222;
    }

    public void IncreaseHashAge() {
        ++this.global_age;
        if (this.global_age > 7) {
            this.global_age = 0;
        }
    }

    public int GetHashMoveDepth() {
        return this.hash_move_depth;
    }

    public ArimaaMove ProbeHashMove(long hashKey) {
        long hashInfo;
        int index = this.getHashIndex(hashKey);
        this.hash_move_depth = -1;
        if (this.hash_data[index] == hashKey && ((hashInfo = this.hash_data[index + 1]) >> 33 & 1L) != 0L) {
            this.hash_move_depth = (int)(hashInfo >> 22 & 0xFFL);
            return this.move_data[this.getMoveIndex(hashKey)];
        }
        if (this.hash_data[index + 2] == hashKey && ((hashInfo = this.hash_data[index + 3]) >> 33 & 1L) != 0L) {
            this.hash_move_depth = (int)(hashInfo >> 22 & 0xFFL);
            return this.move_data[this.getMoveIndex(hashKey) + 1];
        }
        return null;
    }
}

