/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import arimaa3.ArimaaEngine;
import arimaa3.ArimaaMove;
import arimaa3.Constants;
import arimaa3.GameState;
import arimaa3.MoveList;
import arimaa3.TestForGoal;
import java.util.Random;

public class TestGameState
implements Constants {
    private final int max_depth = 10;
    private final int max_moves = 100;
    private GameState[] stack = new GameState[10];
    private ArimaaMove[][] total_move_list;
    private MoveList[] total_move_list2;
    private long total_moves;
    String[] text2;
    String[] text;
    private long agree;
    private long disagree;
    private TestForGoal test;
    private ArimaaEngine engine;
    private boolean show_tests;

    public TestGameState() {
        int i;
        for (i = 0; i < this.stack.length; ++i) {
            this.stack[i] = new GameState();
        }
        this.total_move_list = new ArimaaMove[10][100];
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 100; ++j) {
                this.total_move_list[i][j] = new ArimaaMove();
            }
        }
        this.total_move_list2 = new MoveList[10];
        for (i = 0; i < 10; ++i) {
            this.total_move_list2[i] = new MoveList(100);
        }
        this.total_moves = 0L;
        this.text2 = new String[]{"30b  rc5e rc5e rc5e%13 +-----------------+%138| r   E c r h r r |%137| R               |%136| C r r           |%135|       D         |%134|   H e           |%133|       H r   C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13", "30b  rc5e rc5e rc5e%13 +-----------------+%138| r   E c r h r r |%137| R   r           |%136| C   r           |%135|       D         |%134|   H e           |%133|       H r   C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13", "30b  rc5e rc5e rc5e%13 +-----------------+%138| r   E c r h r r |%137| R   r           |%136| C   r           |%135|   e   D         |%134|   H             |%133|       H r   C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13", "30b  rc5e rc5e rc5e%13 +-----------------+%138| r   E c r h r r |%137| R               |%136| C r r           |%135|       D         |%134|   H e r         |%133|       H     C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13", "30b  rc5e rc5e rc5e%13 +-----------------+%138| r   E c r h r r |%137| R   r           |%136| C   r           |%135|       D         |%134|   H e r         |%133|       H     C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13", "30b  rc5e rc5e rc5e%13 +-----------------+%138| r   E c r h r r |%137| R   r           |%136| C   r           |%135|   e   D         |%134|   H   r         |%133|       H     C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13"};
        this.text = new String[]{"16b %13 +-----------------+%138|     e           |%137|                 |%136|                 |%135|           E     |%134|                 |%133|       R         |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16w %13 +-----------------+%138|     e           |%137|                 |%136|                 |%135|           E     |%134|                 |%133|       R         |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "30b %13 +-----------------+%138| r   E c r h r r |%137| R r             |%136| C   r           |%135|     e D         |%134|   H     r       |%133|       H     C   |%132|     R M R D   R |%131|     R   R R R   |%13 +-----------------+%13   a b c d e f g h%13", "35b %13 +-----------------+%138|           r r   |%137|               r |%136|           R E   |%135|   d             |%134|     r   r       |%133| r M     D   e   |%132| R h d     D R   |%131|     R R       m |%13 +-----------------+%13   a b c d e f g h%13", "41b %13 +-----------------+%138|                 |%137|         r       |%136|         e   r   |%135|   R         D r |%134|     r     E     |%133| r               |%132| R M d     m     |%131|   h R R     R   |%13 +-----------------+%13   a b c d e f g h%13", "45b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|     R           |%134|     e   r   r   |%133| r     r E   D r |%132| R M   R m       |%131|   h R         R |%13 +-----------------+%13   a b c d e f g h%13", "46b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|         r   r   |%133| r   r   E   D r |%132| R M e R m     R |%131|   h R           |%13 +-----------------+%13   a b c d e f g h%13", "38w %13 +-----------------+%138|   c   r r       |%137| r   r       r   |%136|   r   H       d |%135| R h   h       R |%134| R   e         r |%133|           E C   |%132|                 |%131| R       R R   R |%13 +-----------------+%13   a b c d e f g h%13", "34w %13 +-----------------+%138|                 |%137|     r   M     r |%136|       H e   r R |%135|   h R     R     |%134| r C       r     |%133|       D         |%132|           d E m |%131|     R       R R |%13 +-----------------+%13   a b c d e f g h%13", "40w %13 +-----------------+%138|         M       |%137|     r H e     r |%136|   h         r R |%135|                 |%134| r D     R d m   |%133|   C         E   |%132|             R   |%131| R             R |%13 +-----------------+%13   a b c d e f g h%13", "15w %13 +-----------------+%138|   c r r r       |%137| r   r     r     |%136|   h         d   |%135|         d E   r |%134|       R   h r c |%133|     H   e     H |%132| D   D M     m C |%131| R R R R R   R R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r r r r r r r |%137| d m c e h c h d |%136|                 |%135|       E         |%134|                 |%133|                 |%132| D H C M   C H D |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13"};
        this.agree = 0L;
        this.disagree = 0L;
        this.test = new TestForGoal();
        this.engine = new ArimaaEngine();
        this.show_tests = false;
    }

    void try_moves2(int ply, GameState gs) {
        if (ply == 0) {
            return;
        }
        MoveList move_list = this.total_move_list2[ply];
        GameState new_gs = this.stack[ply];
        gs.genAllMoves(move_list, -1L, -1L, -1L, -1L);
        for (ArimaaMove move : move_list) {
            ++this.total_moves;
            new_gs.play(move, gs);
            this.try_moves2(ply - 1, new_gs);
        }
    }

    private void test_movegen() {
        long s_time = System.currentTimeMillis();
        for (int i = 0; i < this.text.length; ++i) {
            String pos_text = this.text[i];
            System.out.println(pos_text);
            GameState initial_gs = new GameState(pos_text);
            System.out.println(initial_gs.toBoardString());
            long start_time = System.currentTimeMillis();
            for (int ply = 1; ply <= 6; ++ply) {
                this.total_moves = 0L;
                this.try_moves2(ply, initial_gs);
                long end_time = System.currentTimeMillis();
                String result = "Ply: " + ply;
                result = result + " Time: " + (end_time - start_time);
                result = result + " Moves: " + this.total_moves;
                result = result + " kNPS: " + this.total_moves / (end_time - start_time + 1L);
                System.out.println(result);
            }
        }
        long e_time = System.currentTimeMillis();
        System.out.println("Total Time: " + (e_time - s_time));
    }

    private void test_compress_move() {
        for (String pos_text : this.text) {
            GameState gs = new GameState(pos_text);
            System.out.println(gs);
            MoveList move_list = this.total_move_list2[0];
            move_list.clear();
            gs.GENERATE_MOVES(move_list, -1L, -1L);
            for (ArimaaMove move : move_list) {
                System.out.println(move);
            }
        }
    }

    private void test_GENERATE() {
        String[] text;
        for (String position_text : text = new String[]{"2w rc5e rc5e %13 +-----------------+%138| r r e H   r r r |%137|   e r R r   r   |%136| d e r   r       |%135|         e       |%134|       R         |%133|                 |%132|           r     |%131|       R h H   R |%13 +-----------------+%13   a b c d e f g h%13TS: 18%13", "2w rc5e rc5e %13 +-----------------+%138| r r e   H r r r |%137|   e r R r   r   |%136| d e r   r       |%135|         e       |%134|       R         |%133|                 |%132|           r     |%131|       R h H   R |%13 +-----------------+%13   a b c d e f g h%13TS: 18%13"}) {
            GameState position = new GameState(position_text);
            position.total_steps = 19;
            System.out.println(position);
            MoveList move_list = this.total_move_list2[0];
            move_list.clear();
            position.GENERATE_MOVES(move_list, -1L, -1L);
            for (ArimaaMove move : move_list) {
                System.out.println(move);
            }
        }
    }

    private void test_goal() {
        String[] text = new String[]{"2w %13 +-----------------+%138| r r   D D d e r |%137|     R h R   H   |%136|       R         |%135|                 |%134|         h     H |%133|   e             |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r r   r r r |%137| C   R d R   C e |%136|       R         |%135|                 |%134|                 |%133| C C     c       |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   r r r D |%137|       R e R   E |%136|         C     h |%135|               H |%134|         e       |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   M e |%137|     e R     H   |%136|   e     m m r C |%135|         m e   H |%134| h   d e     M   |%133| m     H       c |%132| H         R   H |%131|       C m     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r D   r r h r |%137| e e r R r   r   |%136|     R d H       |%135|   e R M e     e |%134|                 |%133|             M   |%132|             R   |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r D   r r h r |%137| e e r R r   r   |%136|   D R d H       |%135|   e R M e     e |%134|       R         |%133|             M   |%132|             R   |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   C m |%137|     e R     H   |%136|           m r H |%135| E   c c   c     |%134|     R e     M m |%133| m     H   M   e |%132|       r   R   C |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   C   |%137|     e R     H m |%136|           m r H |%135| E   c c   c     |%134|     R e     M m |%133| m     H   M   e |%132|       r   R   C |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138|   r r   e   M e |%137|     e R     H   |%136|   D     e m r D |%135| E   c R         |%134|     R e     M R |%133| m   D H       e |%132|       r   R   C |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|       R   m     |%134|     d R         |%133|         h   h   |%132| E               |%131|                 |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   D e |%137| d C e R     C   |%136|     e   h m r H |%135|         e       |%134|     R e   m M   |%133| m R   e   c   e |%132|           R   H |%131|       C h h   m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   D e |%137|     e R     H   |%136|         m m r C |%135| E   c           |%134|     R r     M R |%133| m     H   c h e |%132|       r d R   C |%131|       H h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   D e |%137| d C e R     C   |%136|     e   h m r H |%135|         e       |%134|     R e   m M   |%133| m R   e   c   e |%132|           R   H |%131|       C h h   m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   D e |%137|     e R     H   |%136|         m m r C |%135| E   c           |%134|     R r     M R |%133| m     H   c h e |%132|       r d R   C |%131|       H h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "17b %13 +-----------------+%138| r r   c c r   r |%137|     r     d     |%136| r H             |%135|                 |%134|           E r   |%133| R H       R M d |%132|           e R r |%131|   R   R C h   R |%13 +-----------------+%13   a b c d e f g h%13", "26w %13 +-----------------+%138|   r r d H r r r |%137| r     c E R   r |%136|   h             |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r         r   |%137| r R E   r   M r |%136| C m h     X E   |%135|   H   d c       |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137| e e r C r   r   |%136|   D R R   X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|         d r     |%137|   r     M r e   |%136|   d   c     R   |%135|       c   E   R |%134| r   H         r |%133| D h R   d   r C |%132| r D m   C       |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|         d r     |%137|   r     M r e   |%136|   d   c   R     |%135|       c   E   R |%134| r   H         r |%133| D h R   d   C   |%132| r D m   R   r C |%131| R R       R   R |%13 +-----------------+%13   a b c d e f g h%13", "31b %13 +-----------------+%138|   c   d     c   |%137|         d r     |%136|               C |%135|   r             |%134|             r h |%133|   M   R   r r R |%132| R h   m E e H   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "33w %13 +-----------------+%138|               H |%137| r         M e   |%136|   d   c     R   |%135|       c     E R |%134| r   H         r |%133| D h R   d   r C |%132| r D m         C |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|     r r r r M r |%137| r         c r   |%136|       d d       |%135| h D c m         |%134|     E e         |%133|     r           |%132|   R h         H |%131| R R   H R R R R |%13 +-----------------+%13   a b c d e f g h%13", "22w %13 +-----------------+%138|                 |%137| r r r       H   |%136|   d     h   h R |%135| c   d   r r     |%134| r C     c   r   |%133| D e   r   E C   |%132|     H M D m     |%131| R R R R R R R   |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137| D   c R         |%136|       e e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137| D   c R c       |%136|       e e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|   D c R c       |%136|       e e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     M   e       |%136|       R e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|                 |%136|       R e       |%135|                 |%134|         C        |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|       R e       |%136|                 |%135|                 |%134|         C        |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     R   e       |%136|                 |%135|                 |%134|       C         |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     R   e       |%136|                 |%135|       C e       |%134|                 |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|                 |%136|       R d       |%135|                 |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|         d H     |%136|       R         |%135|                 |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     r D R r r   |%136|     M R h r     |%135|   e R M r r     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     r r R r r   |%136|     M   h r     |%135|   e R M r r     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     r r R r r   |%136|       M h r     |%135|   e R M r r     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     r r R r r   |%136|     D M h r     |%135|   e R M   D     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   E r r r r |%137|     r e R e r   |%136|   D r R   X     |%135|   e R M   D     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r E r   r r |%137|     r e R e r   |%136|   D r R   X     |%135|   e R M         |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r C r r r r |%137|     r       r   |%136|   D r R r X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137|     r C r   r   |%136|   D r R r X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137|     r C r   r   |%136|   D R     X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r   H r r r |%137|     e   C r     |%136|     e           |%135|     e R M e     |%134|         R       |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r   H r r r |%137|     e   C r     |%136|     e           |%135|     e R M e     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|       R R     d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|   r   R r       |%133|     X r r X     |%132|       d R     r |%131| R R R R   R   R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|   r   R r       |%133|     X r r X   E |%132|       d R     r |%131| R R R R   R   R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|   r   R r       |%133|     X r r X     |%132|       d R R     |%131| R R R R   e   R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r r r |%137|   R   r r   r   |%136|     X     X     |%135|                 |%134|           D     |%133|     X     X e   |%132| R R R R R h     |%131|           c     |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|               d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r E r r E   |%137|     E         d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r r r r r r |%137|   R   r r   r   |%136|     X     X     |%135|                 |%134|                 |%133|     X     X     |%132|                 |%131|           c     |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r r r r r r |%137|     R r r   r   |%136|     X     X     |%135|                 |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X     X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X C   X     |%135|                 |%134|     R           |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|       R R       |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|       R R     r |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r d e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|     R           |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|     R           |%133|   r X   r X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   r   r   |%136|   e r   r X     |%135|       R R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   E   r   |%136|   e r   r X     |%135|       R R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   E   r   |%136|   e r   r X     |%135|       R R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e e   e   r   |%136|   e e R M X     |%135|         R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   r   r   |%136|   e r r   X     |%135|         R       |%134|       R         |%133|     X     X     |%132|                 |%131|     R         R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|             D   |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     E d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|         D       |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R     e |%136|             C   |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H d r r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r d H r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r D   r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r D H r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r D d r r |%137|       r R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   D d r r |%137|       h R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   D d r r |%137|       h R     H |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   D d r r |%137|       h R     H |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   D D d r r |%137|       h R   H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r E D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|   R     e       |%136|     h           |%135|     r C c       |%134|                 |%133| C     R   c r e |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     R   e       |%136| E   h           |%135|     r C c       |%134|                 |%133| C     R   c r e |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|     R           |%136|     h           |%135|     r C d       |%134|                 |%133| C     R   c r e |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|     R           |%136|     h           |%135|     r           |%134|     C d         |%133|           c r e |%132|     R           |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|     R           |%136|     h           |%135|     r           |%134|   C   d         |%133|           c r e |%132|     R           |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   C m |%137|     e R         |%136|           m r H |%135| E   c R   c     |%134|             M m |%133| m m m H       e |%132|                 |%131|       C       m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2b %13 +-----------------+%138| m r   H r d r r |%137|   e   C r C r   |%136|   e R           |%135|   e R M e       |%134|   r   R r   r   |%133|       E r     H |%132|       d R     r |%131| R R R R   R   R |%13 +-----------------+%13   a b c d e f g h%13TS: 20%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     R   e   h   |%136| E   h           |%135|     r R c       |%134|     R M         |%133| C     H   c d e |%132|               H |%131|       C       m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2b %13 +-----------------+%138| r r r H r r r r |%137|   e   C r   r   |%136|   e             |%135|   e R M e d     |%134|   r   c r       |%133|       r r r   E |%132|       d E     r |%131| R R R M   R   R |%13 +-----------------+%13   a b c d e f g h%13TS: 20%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C R   r   |%136| r e             |%135|   e D M e     c |%134|   r   R r       |%133|       R r r   E |%132|       E R H   r |%131| R R R R   R   R |%13 +-----------------+%13   a b c d e f g h%13TS: 20%13", "3b %13 +-----------------+%138|         d r     |%137|   r     M r r   |%136|   d   c     R c |%135|       c   E   c |%134| r   H         r |%133| D R R   D   r C |%132| r D m   e     r |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13TS: 268%13", "2w %13 +-----------------+%138| r r   r r r r r |%137| d R     e       |%136|       R         |%135|   m r C c       |%134| c               |%133| H     R   c c e |%132|                 |%131|   H   R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| e r   e r r r r |%137|       r R h r   |%136|       C     D   |%135| D   R h         |%134|         C       |%133|                 |%132|                 |%131|     m           |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| m r r   r r r r |%137|     R   e       |%136|       e         |%135|       R e       |%134|       M     c   |%133|       R H       |%132|     h           |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     R   e   h   |%136| E R   e         |%135|     r R c       |%134|     R M     M   |%133| m     H       e |%132|           R   H |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     e R         |%136|         D   r C |%135|                 |%134|     R e     M   |%133| m     H       e |%132|           R   H |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     e R r r r r |%136|         D   r C |%135|       r r E     |%134|     R e r   M   |%133| m     H       e |%132|           R   H |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     e R         |%136|         D   r C |%135|                 |%134|     R e     M   |%133| m     H       e |%132|           R   H |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r m e   r r |%137|     e R R       |%136|         D   r c |%135|         r       |%134|     R e     H   |%133| m     H       e |%132|     R     R   H |%131| e     C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137| r   e R     H   |%136|       m D   r C |%135|                 |%134|     R r     M   |%133| m     H h     e |%132|           R M   |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     e R     H   |%136|   e     D   r C |%135|         m     H |%134| h   d e     M   |%133| m     H       M |%132|           R   H |%131|       C m     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r r   E r r |%137| D   r r R r r   |%136|       h h   D   |%135|   d R M r r     |%134|                 |%133|                 |%132|                 |%131|       R     C R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|   C e R     C   |%136|         D   r H |%135|         e       |%134|     R e   m M   |%133| m R   M       e |%132|           R   H |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e r r r |%137|     e R     H   |%136|         D   c C |%135|         m       |%134|     R e   C M   |%133| m     H       e |%132|   H       R   H |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2b %13 +-----------------+%138| r r   C r r r r |%137|   e   C R   r   |%136| r e             |%135|   e D M e H   c |%134| C r   R r       |%133|       R C     E |%132|       E R H   r |%131| R R   R   E   R |%13 +-----------------+%13   a b c d e f g h%13TS: 20%13", "2w %13 +-----------------+%138| r r r h   r r r |%137|     r m R r r   |%136|       M h   d   |%135| h e R M e D     |%134|       R         |%133|                 |%132|                 |%131| e     R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     e R     C   |%136|         D   r C |%135|         m     E |%134|     R e     M   |%133| m     H       e |%132|         R R   H |%131|     D   h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   e   r r |%137|     e R     H   |%136|             r C |%135| E   c           |%134|     R e     M R |%133| m     H       e |%132|       r   R   C |%131|       C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2w %13 +-----------------+%138| r r r   r   r   |%137| e   e R     D   |%136|         D   r C |%135|         m M     |%134|     H e     M   |%133| m     H       e |%132|           R   H |%131|       C R     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "2b %13 +-----------------+%138| r r   C r r r r |%137|   e   C R   r   |%136| r e             |%135|   e D M e H   c |%134| C r   R r       |%133|       R C     E |%132|       E R H   r |%131| R R   R   E   R |%13 +-----------------+%13   a b c d e f g h%13TS: 20%13", "2w %13 +-----------------+%138| r r r m e   r r |%137|     e R R       |%136|         D   r c |%135|         r       |%134|     R e     H   |%133| m     H       e |%132|     R     R   H |%131| e     C h     m |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13"};
        TestForGoal.use_debug = false;
        long start_time = System.currentTimeMillis();
        for (int seed = 1; seed < 1000; ++seed) {
            Random random = new Random(seed);
            System.out.println("Seed: " + seed);
            for (String position_text : text) {
                for (int x = 0; x < 107; ++x) {
                    GameState position = new GameState(position_text);
                    for (int i = -1; i <= random.nextInt(14); ++i) {
                        int index = random.nextInt(64);
                        int piece_type = random.nextInt(13) - 1;
                        this.set_board(position, index, piece_type);
                    }
                    if (TestForGoal.use_debug) {
                        System.out.println("Bob\n" + position);
                        System.out.println("\"" + position.toEPDString() + "\",");
                    }
                    this.master_position(position);
                }
            }
        }
        System.out.println("Agree: " + this.agree);
        System.out.println("Disagree: " + this.disagree);
        System.out.println("Time: " + (System.currentTimeMillis() - start_time));
    }

    private void set_board(GameState position, int index, int piece_type) {
        if (index >= 0 && index <= 7 && piece_type == 1) {
            return;
        }
        if (index >= 56 && index <= 63 && piece_type == 0) {
            return;
        }
        position.setPieceType(index, piece_type);
    }

    private void master_position(GameState position) {
        boolean result = this.engine.can_player_goal(position);
        this.test_position(position, result);
    }

    private void test_position(GameState position, boolean result2) {
        if (this.show_tests) {
            System.out.println(position.toBoardString());
            System.out.println("\"" + position.toEPDString() + "\",");
        }
        boolean result = this.test.test(position);
        this.engine.resetStats();
        if (this.show_tests) {
            System.out.println("FINAL: " + result + " Engine: " + result2);
            System.out.println(this.engine.getStats());
            System.out.flush();
        }
        if (result == result2) {
            ++this.agree;
        } else {
            System.out.println("\"" + position.toEPDString() + "\",");
            System.out.println("\"" + position.toBoardString() + "\",");
            System.out.println("\"" + position.toSetupString() + "\",");
            System.out.println("Engine: " + result2 + "Code: " + result);
            ++this.disagree;
        }
    }

    private void test_engine() {
        String[] tests = new String[]{"2w %13 +-----------------+%138| r r D   r r h r |%137| e e r R r   r   |%136|   D R d H       |%135|   e R M e     e |%134|       R         |%133|             M   |%132|             R   |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13"};
        this.engine.resetStats();
        for (String text : tests) {
            GameState position = new GameState(text);
            boolean result = this.engine.can_player_goal(position);
            System.out.println("Engine: " + result);
        }
        System.out.println(this.engine.getStats());
    }

    public static void main(String[] args) {
        TestGameState test = new TestGameState();
        test.test_compress_move();
    }
}

