/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.Util;
import arimaa3.ArimaaBaseClass;
import arimaa3.ArimaaMove;
import arimaa3.MoveList;
import java.util.Random;
import java.util.StringTokenizer;

public class GameState
extends ArimaaBaseClass {
    public long[] piece_bb = new long[12];
    public long[] colour_bb = new long[2];
    public long[] stronger_enemy_bb = new long[12];
    public long empty_bb;
    public int total_steps;
    public int player;
    public int enemy;
    public long frozen_pieces_bb;
    public long dominated_pieces_bb;
    public long barely_dominated_pieces_bb;
    private static final boolean[] table_is_game_over = new boolean[]{false, false, false, false, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, true, true, true, true, true};
    private static int NA = 11111111;
    private static int WN = Short.MAX_VALUE;
    private static int LS = -32767;
    private static final int[] table_get_game_result = new int[]{NA, NA, NA, NA, NA, NA, NA, NA, WN, NA, NA, NA, LS, WN, WN, WN, LS, WN, WN, WN, WN, NA, NA, NA, WN, WN, WN, WN, WN, WN, WN, WN};
    private static final boolean use_no_rabbits_is_a_loss = true;
    private int[] TRAP_pt = new int[4];
    private long[] TRAP_protect = new long[4];
    private long player_suicide_bb;
    private long enemy_suicide_bb;
    private long[] temp_player_bb = new long[6];
    static long[] hash_steps = new long[8];
    private static MoveList m1;

    public GameState() {
    }

    public void copy(GameState orig) {
        for (int i = 0; i < 12; ++i) {
            this.piece_bb[i] = orig.piece_bb[i];
            this.stronger_enemy_bb[i] = orig.stronger_enemy_bb[i];
        }
        this.colour_bb[0] = orig.colour_bb[0];
        this.colour_bb[1] = orig.colour_bb[1];
        this.empty_bb = orig.empty_bb;
        this.total_steps = orig.total_steps;
        this.player = orig.player;
        this.enemy = orig.enemy;
        this.frozen_pieces_bb = orig.frozen_pieces_bb;
        this.dominated_pieces_bb = orig.dominated_pieces_bb;
    }

    public void playPASS(GameState orig) {
        this.copy(orig);
        this.total_steps += this.getStepsRemaining();
        this.player ^= 1;
        this.enemy ^= 1;
    }

    public void mirror() {
        for (int i = 0; i < 12; ++i) {
            long lsb_bb;
            this.piece_bb[i] = 0L;
            for (long temp_bb = this.piece_bb[i]; temp_bb != 0L; temp_bb ^= lsb_bb) {
                lsb_bb = temp_bb & -temp_bb;
                int index = Util.FirstOne(lsb_bb);
                int n = i;
                this.piece_bb[n] = this.piece_bb[n] | 1L << this.getMirrorIndex(index);
            }
        }
        this.compute_secondary_bitboards();
    }

    private int getMirrorIndex(int index) {
        assert (index >= 0 && index <= 63);
        int row = index >> 3;
        int col = index & 7;
        int result = row * 8 + (7 - col);
        return result;
    }

    private int getRotatedIndex(int index) {
        assert (index >= 0 && index <= 63);
        int row = index >> 3;
        int col = index & 7;
        int result = (7 - row) * 8 + (7 - col);
        return result;
    }

    public void rotate() {
        this.total_steps ^= 4;
        for (int i = 0; i < 12; i += 2) {
            int index;
            long lsb_bb;
            long temp2_bb = this.piece_bb[i + 1];
            this.piece_bb[i] = 0L;
            this.piece_bb[i + 1] = 0L;
            for (long temp_bb = this.piece_bb[i]; temp_bb != 0L; temp_bb ^= lsb_bb) {
                lsb_bb = temp_bb & -temp_bb;
                index = Util.FirstOne(lsb_bb);
                int n = i + 1;
                this.piece_bb[n] = this.piece_bb[n] | 1L << this.getRotatedIndex(index);
            }
            while (temp2_bb != 0L) {
                lsb_bb = temp2_bb & -temp2_bb;
                temp2_bb ^= lsb_bb;
                index = Util.FirstOne(lsb_bb);
                int n = i;
                this.piece_bb[n] = this.piece_bb[n] | 1L << this.getRotatedIndex(index);
            }
        }
        this.compute_secondary_bitboards();
    }

    public GameState(String white_setup_text, String black_setup_text) {
        this.total_steps = 16;
        for (int i = 0; i <= 11; ++i) {
            this.piece_bb[i] = 0L;
        }
        String full = white_setup_text + " " + black_setup_text;
        StringTokenizer tokenizer = new StringTokenizer(full);
        while (tokenizer.hasMoreTokens()) {
            String piece_token = tokenizer.nextToken();
            if (piece_token.equals("1w") || piece_token.equals("1b")) continue;
            int piece_type = GameState.getPieceType(piece_token.substring(0, 1));
            String col_text = "abcdefgh";
            int col = col_text.indexOf(piece_token.substring(1, 2));
            int row = Integer.parseInt(piece_token.substring(2, 3)) - 1;
            int bb_index = row * 8 + col;
            int n = piece_type;
            this.piece_bb[n] = this.piece_bb[n] ^ 1L << bb_index;
        }
        this.compute_secondary_bitboards();
    }

    public GameState(String text) {
        int space_pos = text.indexOf(" ", 0);
        int ppos = text.indexOf("%", 0);
        String turn_text = text.substring(0, space_pos - 1);
        String player_text = text.substring(space_pos - 1, space_pos);
        String move_text = text.substring(space_pos, ppos);
        String board_text = text.substring(ppos, text.length());
        int temp_turn = Integer.parseInt(turn_text);
        int temp_player = player_text.equals("w") ? 0 : 1;
        this.total_steps = temp_turn * 8 + temp_player * 4;
        for (int i = 0; i <= 11; ++i) {
            this.piece_bb[i] = 0L;
        }
        for (int row = 7; row >= 0; --row) {
            for (int col = 0; col <= 7; ++col) {
                int bb_index = row * 8 + col;
                int text_index = 29 + 2 * col + (7 - row) * 23;
                String letter = board_text.substring(text_index, text_index + 1);
                int piece_type = GameState.getPieceType(letter);
                if (piece_type == -1) continue;
                int n = piece_type;
                this.piece_bb[n] = this.piece_bb[n] ^ 1L << bb_index;
            }
        }
        this.compute_secondary_bitboards();
        assert (!this.clear_traps());
    }

    public int getIndex(int row, int col) {
        return row * 8 + col;
    }

    public void setPieceType(int index, int piece_type) {
        assert (index >= 0 && index <= 63);
        assert (piece_type >= -1 && piece_type <= 11);
        long index_bb = 1L << index;
        int i = 0;
        while (i <= 11) {
            int n = i++;
            this.piece_bb[n] = this.piece_bb[n] & (index_bb ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (piece_type != -1) {
            int n = piece_type;
            this.piece_bb[n] = this.piece_bb[n] | index_bb;
        }
        this.compute_secondary_bitboards();
        this.clear_trap_squares();
    }

    public void clear_trap_squares() {
        for (int i = 0; i < 4; ++i) {
            for (int c = 0; c < 2; ++c) {
                int pt;
                if ((TRAP[i] & this.colour_bb[c]) == 0L || (TOUCH_TRAP[i] & this.colour_bb[c]) != 0L) continue;
                int n = pt = this.getPieceType(TRAP[i]);
                this.piece_bb[n] = this.piece_bb[n] & (TRAP[i] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        this.compute_secondary_bitboards();
    }

    public int getPieceType(int index) {
        return this.getPieceType(1L << index);
    }

    public boolean isGameOver() {
        if ((this.piece_bb[0] | this.piece_bb[1]) == 0L) {
            return true;
        }
        int gold_goal = (this.piece_bb[0] & 0xFF00000000000000L) != 0L || this.piece_bb[1] == 0L ? 1 : 0;
        int silver_goal = (this.piece_bb[1] & 0xFFL) != 0L || this.piece_bb[0] == 0L ? 1 : 0;
        int steps = this.total_steps & 7;
        int index = steps + (gold_goal << 4) + (silver_goal << 3);
        return table_is_game_over[index];
    }

    public int getGameResult() {
        assert (this.isGameOver());
        int gold_goal = (this.piece_bb[0] & 0xFF00000000000000L) != 0L || this.piece_bb[1] == 0L ? 1 : 0;
        int silver_goal = (this.piece_bb[1] & 0xFFL) != 0L || this.piece_bb[0] == 0L ? 1 : 0;
        int steps = this.total_steps & 7;
        int index = steps + (gold_goal << 4) + (silver_goal << 3);
        assert (table_get_game_result[index] != NA);
        return table_get_game_result[index];
    }

    public int getSideToMove() {
        return this.player;
    }

    public int getTurnNumber() {
        return this.total_steps / 8;
    }

    public int getStepsRemaining() {
        return 4 - (this.total_steps & 3);
    }

    public void playFull(ArimaaMove move, GameState prev) {
        this.play(move, prev);
        this.compute_tertiary_bitboards();
    }

    public void playFullClear(ArimaaMove move, GameState prev) {
        this.play(move, prev);
        boolean is_capture = this.clear_traps();
        if (is_capture) {
            this.compute_secondary_bitboards();
        }
        this.compute_tertiary_bitboards();
    }

    public void playFullClear(ArimaaMove move, ArimaaMove move2, GameState prev) {
        this.play(move, prev);
        boolean is_capture = this.clear_traps();
        if (is_capture) {
            this.compute_secondary_bitboards();
        }
        this.play(move2, prev);
        is_capture = this.clear_traps();
        if (is_capture) {
            this.compute_secondary_bitboards();
        }
        this.compute_tertiary_bitboards();
    }

    private boolean clear_traps() {
        boolean result = false;
        for (int i = 0; i < 4; ++i) {
            for (int c = 0; c <= 1; ++c) {
                int pt;
                if ((TRAP[i] & this.colour_bb[c]) == 0L || (TOUCH_TRAP[i] & this.colour_bb[c]) != 0L) continue;
                result = true;
                int n = pt = this.getPieceType(TRAP[i]);
                this.piece_bb[n] = this.piece_bb[n] ^ TRAP[i];
            }
        }
        return result;
    }

    public void play(ArimaaMove move, GameState prev) {
        assert (prev.getStepsRemaining() >= move.steps);
        this.piece_bb[11] = prev.piece_bb[11] ^ move.piece_bb[11];
        this.piece_bb[10] = prev.piece_bb[10] ^ move.piece_bb[10];
        long c1 = this.piece_bb[11];
        long c0 = this.piece_bb[10];
        this.stronger_enemy_bb[8] = c1;
        this.stronger_enemy_bb[9] = c0;
        this.piece_bb[9] = prev.piece_bb[9] ^ move.piece_bb[9];
        this.piece_bb[8] = prev.piece_bb[8] ^ move.piece_bb[8];
        this.stronger_enemy_bb[6] = c1 |= this.piece_bb[9];
        this.stronger_enemy_bb[7] = c0 |= this.piece_bb[8];
        this.piece_bb[7] = prev.piece_bb[7] ^ move.piece_bb[7];
        this.piece_bb[6] = prev.piece_bb[6] ^ move.piece_bb[6];
        this.stronger_enemy_bb[4] = c1 |= this.piece_bb[7];
        this.stronger_enemy_bb[5] = c0 |= this.piece_bb[6];
        this.piece_bb[5] = prev.piece_bb[5] ^ move.piece_bb[5];
        this.piece_bb[4] = prev.piece_bb[4] ^ move.piece_bb[4];
        this.stronger_enemy_bb[2] = c1 |= this.piece_bb[5];
        this.stronger_enemy_bb[3] = c0 |= this.piece_bb[4];
        this.piece_bb[3] = prev.piece_bb[3] ^ move.piece_bb[3];
        this.piece_bb[2] = prev.piece_bb[2] ^ move.piece_bb[2];
        this.stronger_enemy_bb[0] = c1 |= this.piece_bb[3];
        this.stronger_enemy_bb[1] = c0 |= this.piece_bb[2];
        this.piece_bb[1] = prev.piece_bb[1] ^ move.piece_bb[1];
        this.piece_bb[0] = prev.piece_bb[0] ^ move.piece_bb[0];
        this.colour_bb[0] = c0 |= this.piece_bb[0];
        this.colour_bb[1] = c1 |= this.piece_bb[1];
        this.total_steps = prev.total_steps + move.steps;
        this.empty_bb = (c0 | c1) ^ 0xFFFFFFFFFFFFFFFFL;
        this.player = this.total_steps >> 2 & 1;
        this.enemy = this.player ^ 1;
    }

    private void compute_secondary_bitboards() {
        for (int i = 0; i <= 3; ++i) {
            this.TRAP_pt[i] = 0;
        }
        this.colour_bb[0] = this.piece_bb[0] | this.piece_bb[2] | this.piece_bb[4] | this.piece_bb[6] | this.piece_bb[8] | this.piece_bb[10];
        this.colour_bb[1] = this.piece_bb[1] | this.piece_bb[3] | this.piece_bb[5] | this.piece_bb[7] | this.piece_bb[9] | this.piece_bb[11];
        this.stronger_enemy_bb[10] = 0L;
        this.stronger_enemy_bb[8] = this.piece_bb[11];
        this.stronger_enemy_bb[6] = this.stronger_enemy_bb[8] | this.piece_bb[9];
        this.stronger_enemy_bb[4] = this.stronger_enemy_bb[6] | this.piece_bb[7];
        this.stronger_enemy_bb[2] = this.stronger_enemy_bb[4] | this.piece_bb[5];
        this.stronger_enemy_bb[0] = this.stronger_enemy_bb[2] | this.piece_bb[3];
        this.stronger_enemy_bb[11] = 0L;
        this.stronger_enemy_bb[9] = this.piece_bb[10];
        this.stronger_enemy_bb[7] = this.stronger_enemy_bb[9] | this.piece_bb[8];
        this.stronger_enemy_bb[5] = this.stronger_enemy_bb[7] | this.piece_bb[6];
        this.stronger_enemy_bb[3] = this.stronger_enemy_bb[5] | this.piece_bb[4];
        this.stronger_enemy_bb[1] = this.stronger_enemy_bb[3] | this.piece_bb[2];
        this.empty_bb = (this.colour_bb[0] | this.colour_bb[1]) ^ 0xFFFFFFFFFFFFFFFFL;
        this.player = this.total_steps >> 2 & 1;
        this.enemy = this.player ^ 1;
    }

    public void compute_tertiary_bitboards() {
        this.frozen_pieces_bb = 0L;
        this.dominated_pieces_bb = 0L;
        this.barely_dominated_pieces_bb = 0L;
        for (int i = 0; i <= 9; ++i) {
            int colour = i & 1;
            long dominated_sq_bb = GameState.touching_bb(this.stronger_enemy_bb[i]);
            long frozen_sq_bb = (GameState.touching_bb(this.colour_bb[colour]) ^ 0xFFFFFFFFFFFFFFFFL) & dominated_sq_bb;
            this.dominated_pieces_bb |= this.piece_bb[i] & dominated_sq_bb;
            this.frozen_pieces_bb |= this.piece_bb[i] & frozen_sq_bb;
            int pt = i + 3 - colour * 2;
            long barely_dominated_sq_bb = GameState.touching_bb(this.piece_bb[pt]);
            this.barely_dominated_pieces_bb |= this.piece_bb[i] & barely_dominated_sq_bb;
        }
    }

    public int getPieceStrength(long target_bb) {
        assert (GameState.atMostOneBitSet(target_bb));
        int piece_type = this.getPieceType(target_bb);
        return this.getPieceStrength(piece_type);
    }

    public int getPieceStrength(int piece_type) {
        assert (piece_type >= 0 && piece_type <= 11);
        return piece_type >> 1;
    }

    public int getWeakestPieceStrength(long target_bb) {
        int weakest_strength = 20;
        while (target_bb != 0L) {
            long lsb_bb = target_bb & -target_bb;
            target_bb ^= lsb_bb;
            int piece_strength = this.getPieceStrength(lsb_bb);
            if (piece_strength >= weakest_strength) continue;
            weakest_strength = piece_strength;
        }
        assert (weakest_strength != 20);
        return weakest_strength;
    }

    public int getPieceType(long target_bb) {
        for (int i = 0; i <= 11; ++i) {
            if ((this.piece_bb[i] & target_bb) == 0L) continue;
            return i;
        }
        return -1;
    }

    public int getPieceType(long target_bb, int colour) {
        for (int i = colour; i <= 11; i += 2) {
            if ((this.piece_bb[i] & target_bb) == 0L) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    void calculate_trap_info() {
        this.player_suicide_bb = 0L;
        this.enemy_suicide_bb = 0L;
        for (int i = 0; i <= 3; ++i) {
            long etest_bb;
            this.TRAP_protect[i] = 0L;
            long ptest_bb = TOUCH_TRAP[i] & this.colour_bb[this.player];
            if ((ptest_bb & ptest_bb - 1L) == 0L) {
                this.player_suicide_bb |= TRAP[i];
                if ((TRAP[i] & this.colour_bb[this.player]) != 0L) {
                    this.TRAP_pt[i] = this.getPieceType(TRAP[i], this.player);
                    this.TRAP_protect[i] = ptest_bb;
                }
            }
            if (((etest_bb = TOUCH_TRAP[i] & this.colour_bb[this.enemy]) & etest_bb - 1L) != 0L) continue;
            this.enemy_suicide_bb |= TRAP[i];
            if ((TRAP[i] & this.colour_bb[this.enemy]) == 0L) continue;
            this.TRAP_pt[i] = this.getPieceType(TRAP[i], this.enemy);
            this.TRAP_protect[i] = etest_bb;
        }
    }

    public void GENERATE_MOVES(MoveList result, long p_start_bb, long p_dest_bb) {
        int steps_remaining = this.getStepsRemaining();
        if (steps_remaining != 4) {
            ArimaaMove move = result.getMove();
            move.clear();
            move.steps = steps_remaining;
        }
        if (steps_remaining > 1) {
            this.genAllMoves(result, p_start_bb, p_dest_bb, -1L, -1L);
        } else {
            this.genSlideMoves(result, p_start_bb, p_dest_bb);
        }
    }

    public void genSlideMoves(MoveList result, long p_start_bb, long p_dest_bb) {
        this.temp_player_bb[0] = this.piece_bb[this.player + 0];
        this.temp_player_bb[1] = this.piece_bb[this.player + 2];
        this.temp_player_bb[2] = this.piece_bb[this.player + 4];
        this.temp_player_bb[3] = this.piece_bb[this.player + 6];
        this.temp_player_bb[4] = this.piece_bb[this.player + 8];
        this.temp_player_bb[5] = this.piece_bb[this.player + 10];
        this.player_suicide_bb = 0L;
        for (int i = 0; i <= 3; ++i) {
            long lsb2_bb;
            long ptest_bb = TOUCH_TRAP[i] & this.colour_bb[this.player];
            if ((ptest_bb & ptest_bb - 1L) != 0L || ptest_bb == 0L) continue;
            this.player_suicide_bb |= TRAP[i];
            if ((TRAP[i] & this.colour_bb[this.player]) == 0L || (ptest_bb & p_start_bb) == 0L) continue;
            int trap_pt = this.getPieceType(TRAP[i], this.player);
            int player_pt = this.getPieceType(ptest_bb, this.player);
            int n = player_pt >> 1;
            this.temp_player_bb[n] = this.temp_player_bb[n] ^ ptest_bb;
            for (long dest_bb = GameState.touching_bb(ptest_bb, player_pt) & this.empty_bb & p_dest_bb; dest_bb != 0L; dest_bb ^= lsb2_bb) {
                lsb2_bb = dest_bb & -dest_bb;
                ArimaaMove move = result.getMove();
                move.clear();
                move.piece_bb[player_pt] = ptest_bb | lsb2_bb;
                int n2 = trap_pt;
                move.piece_bb[n2] = move.piece_bb[n2] ^ TRAP[i];
                move.steps = 1;
            }
        }
        int pt = this.player;
        int et = this.enemy;
        while (pt <= 11) {
            long temp_bb = this.temp_player_bb[pt >> 1] & p_start_bb;
            long unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[pt]) ^ 0xFFFFFFFFFFFFFFFFL;
            long unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
            while (unfrozen_pieces_bb != 0L) {
                long lsb2_bb;
                long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
                unfrozen_pieces_bb ^= lsb_bb;
                for (long temp_to_bb = GameState.touching_bb(lsb_bb, pt) & this.empty_bb & p_dest_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb) {
                    lsb2_bb = temp_to_bb & -temp_to_bb;
                    ArimaaMove move = result.getMove();
                    move.clear();
                    move.piece_bb[pt] = lsb_bb | lsb2_bb;
                    int n = pt;
                    move.piece_bb[n] = move.piece_bb[n] ^ lsb2_bb & this.player_suicide_bb;
                    move.steps = 1;
                }
            }
            pt += 2;
            et += 2;
        }
    }

    private boolean is_dest_frozen(long dest_bb, int piece_type) {
        assert (GameState.exactlyOneBitSet(dest_bb));
        boolean is_frozen = false;
        long temp_bb = GameState.touching_bb(dest_bb);
        if (GameState.atMostOneBitSet(temp_bb & this.colour_bb[this.player]) && (temp_bb & this.stronger_enemy_bb[piece_type]) != 0L) {
            is_frozen = true;
        }
        return is_frozen;
    }

    public void genSlideMovesF(MoveList result, long p_start_bb, long p_dest_bb, boolean is_frozen) {
        this.temp_player_bb[0] = this.piece_bb[this.player + 0];
        this.temp_player_bb[1] = this.piece_bb[this.player + 2];
        this.temp_player_bb[2] = this.piece_bb[this.player + 4];
        this.temp_player_bb[3] = this.piece_bb[this.player + 6];
        this.temp_player_bb[4] = this.piece_bb[this.player + 8];
        this.temp_player_bb[5] = this.piece_bb[this.player + 10];
        this.player_suicide_bb = 0L;
        for (int i = 0; i <= 3; ++i) {
            long lsb2_bb;
            long ptest_bb = TOUCH_TRAP[i] & this.colour_bb[this.player];
            if ((ptest_bb & ptest_bb - 1L) != 0L || ptest_bb == 0L) continue;
            this.player_suicide_bb |= TRAP[i];
            if ((TRAP[i] & this.colour_bb[this.player]) == 0L || (ptest_bb & p_start_bb) == 0L) continue;
            int trap_pt = this.getPieceType(TRAP[i], this.player);
            int player_pt = this.getPieceType(ptest_bb, this.player);
            int n = player_pt >> 1;
            this.temp_player_bb[n] = this.temp_player_bb[n] ^ ptest_bb;
            for (long dest_bb = GameState.touching_bb(ptest_bb, player_pt) & this.empty_bb & p_dest_bb; dest_bb != 0L; dest_bb ^= lsb2_bb) {
                lsb2_bb = dest_bb & -dest_bb;
                if (is_frozen != this.is_dest_frozen(lsb2_bb, player_pt)) continue;
                ArimaaMove move = result.getMove();
                move.clear();
                move.piece_bb[player_pt] = ptest_bb | lsb2_bb;
                int n2 = trap_pt;
                move.piece_bb[n2] = move.piece_bb[n2] ^ TRAP[i];
                move.steps = 1;
            }
        }
        p_dest_bb &= this.player_suicide_bb ^ 0xFFFFFFFFFFFFFFFFL;
        int pt = this.player;
        int et = this.enemy;
        while (pt <= 11) {
            long temp_bb = this.temp_player_bb[pt >> 1] & p_start_bb;
            long unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[pt]) ^ 0xFFFFFFFFFFFFFFFFL;
            long unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
            while (unfrozen_pieces_bb != 0L) {
                long lsb2_bb;
                long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
                unfrozen_pieces_bb ^= lsb_bb;
                for (long temp_to_bb = GameState.touching_bb(lsb_bb, pt) & this.empty_bb & p_dest_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb) {
                    lsb2_bb = temp_to_bb & -temp_to_bb;
                    if (is_frozen != this.is_dest_frozen(lsb2_bb, pt)) continue;
                    ArimaaMove move = result.getMove();
                    move.clear();
                    move.piece_bb[pt] = lsb_bb | lsb2_bb;
                    move.steps = 1;
                }
            }
            pt += 2;
            et += 2;
        }
    }

    void do_protection_captures(ArimaaMove move, long lsb_bb) {
        if ((lsb_bb & this.TRAP_protect[0]) != 0L) {
            int n = this.TRAP_pt[0];
            move.piece_bb[n] = move.piece_bb[n] ^ TRAP[0];
        }
        if ((lsb_bb & this.TRAP_protect[1]) != 0L) {
            int n = this.TRAP_pt[1];
            move.piece_bb[n] = move.piece_bb[n] ^ TRAP[1];
        }
        if ((lsb_bb & this.TRAP_protect[2]) != 0L) {
            int n = this.TRAP_pt[2];
            move.piece_bb[n] = move.piece_bb[n] ^ TRAP[2];
        }
        if ((lsb_bb & this.TRAP_protect[3]) != 0L) {
            int n = this.TRAP_pt[3];
            move.piece_bb[n] = move.piece_bb[n] ^ TRAP[3];
        }
    }

    public void genAllMoves(MoveList result, long p_start_bb, long p_dest_bb, long e_start_bb, long e_dest_bb) {
        this.calculate_trap_info();
        long temp_bb = this.piece_bb[this.player] & p_start_bb;
        long unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[this.player]) ^ 0xFFFFFFFFFFFFFFFFL;
        long unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
        while (unfrozen_pieces_bb != 0L) {
            long lsb2_bb;
            long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
            unfrozen_pieces_bb ^= lsb_bb;
            for (long to_bb = GameState.touching_bb(lsb_bb, this.player) & this.empty_bb & p_dest_bb; to_bb != 0L; to_bb ^= lsb2_bb) {
                lsb2_bb = to_bb & -to_bb;
                ArimaaMove move = result.getMove();
                move.clear();
                move.piece_bb[this.player] = lsb_bb | lsb2_bb;
                int n = this.player;
                move.piece_bb[n] = move.piece_bb[n] ^ lsb2_bb & this.player_suicide_bb;
                this.do_protection_captures(move, lsb_bb);
                move.steps = 1;
            }
        }
        long weaker_enemy_bb = this.piece_bb[this.enemy];
        int pt = this.player + 2;
        int et = this.enemy + 2;
        while (pt <= 11) {
            temp_bb = this.piece_bb[pt] & p_start_bb;
            unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[pt]) ^ 0xFFFFFFFFFFFFFFFFL;
            unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
            while (unfrozen_pieces_bb != 0L) {
                long to_bb;
                long temp_to_bb;
                long lsb2_bb;
                long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
                unfrozen_pieces_bb ^= lsb_bb;
                for (temp_to_bb = to_bb = GameState.touching_bb(lsb_bb) & this.empty_bb & p_dest_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb) {
                    lsb2_bb = temp_to_bb & -temp_to_bb;
                    ArimaaMove move = result.getMove();
                    move.clear();
                    move.piece_bb[pt] = lsb_bb | lsb2_bb;
                    int n = pt;
                    move.piece_bb[n] = move.piece_bb[n] ^ lsb2_bb & this.player_suicide_bb;
                    this.do_protection_captures(move, lsb_bb);
                    move.steps = 1;
                }
                long victim_bb = weaker_enemy_bb & GameState.touching_bb(lsb_bb) & e_start_bb;
                while (victim_bb != 0L) {
                    long lsb4_bb;
                    long lsb3_bb = victim_bb & -victim_bb;
                    victim_bb ^= lsb3_bb;
                    int victim_pt = this.getPieceType(lsb3_bb, this.enemy);
                    if ((lsb_bb & e_dest_bb) != 0L) {
                        long lsb2_bb2;
                        for (temp_to_bb = to_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb2) {
                            lsb2_bb2 = temp_to_bb & -temp_to_bb;
                            ArimaaMove move = result.getMove();
                            move.clear();
                            move.piece_bb[pt] = lsb_bb | lsb2_bb2;
                            move.piece_bb[victim_pt] = lsb3_bb | lsb_bb;
                            int n = pt;
                            move.piece_bb[n] = move.piece_bb[n] ^ lsb2_bb2 & this.player_suicide_bb;
                            int n2 = victim_pt;
                            move.piece_bb[n2] = move.piece_bb[n2] ^ lsb_bb & this.enemy_suicide_bb;
                            this.do_protection_captures(move, lsb_bb | lsb3_bb);
                            move.steps = 2;
                        }
                    }
                    if ((lsb3_bb & p_dest_bb) == 0L) continue;
                    for (long victim_dest_bb = GameState.touching_bb(lsb3_bb) & this.empty_bb & e_dest_bb; victim_dest_bb != 0L; victim_dest_bb ^= lsb4_bb) {
                        lsb4_bb = victim_dest_bb & -victim_dest_bb;
                        ArimaaMove move = result.getMove();
                        move.clear();
                        move.piece_bb[pt] = lsb_bb | lsb3_bb;
                        move.piece_bb[victim_pt] = lsb3_bb | lsb4_bb;
                        int n = pt;
                        move.piece_bb[n] = move.piece_bb[n] ^ lsb3_bb & this.player_suicide_bb;
                        int n3 = victim_pt;
                        move.piece_bb[n3] = move.piece_bb[n3] ^ lsb4_bb & this.enemy_suicide_bb;
                        this.do_protection_captures(move, lsb_bb | lsb3_bb);
                        move.steps = 2;
                    }
                }
            }
            weaker_enemy_bb |= this.piece_bb[et];
            pt += 2;
            et += 2;
        }
    }

    public void genAllMovesF(MoveList result, long p_start_bb, long p_dest_bb, long e_start_bb, long e_dest_bb, boolean is_frozen) {
        this.calculate_trap_info();
        p_dest_bb &= this.player_suicide_bb ^ 0xFFFFFFFFFFFFFFFFL;
        long temp_bb = this.piece_bb[this.player] & p_start_bb;
        long unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[this.player]) ^ 0xFFFFFFFFFFFFFFFFL;
        long unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
        while (unfrozen_pieces_bb != 0L) {
            long lsb2_bb;
            long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
            unfrozen_pieces_bb ^= lsb_bb;
            for (long to_bb = GameState.touching_bb(lsb_bb, this.player) & this.empty_bb & p_dest_bb; to_bb != 0L; to_bb ^= lsb2_bb) {
                lsb2_bb = to_bb & -to_bb;
                if (is_frozen != this.is_dest_frozen(lsb2_bb, this.player)) continue;
                ArimaaMove move = result.getMove();
                move.clear();
                move.piece_bb[this.player] = lsb_bb | lsb2_bb;
                this.do_protection_captures(move, lsb_bb);
                move.steps = 1;
            }
        }
        long weaker_enemy_bb = this.piece_bb[this.enemy];
        int pt = this.player + 2;
        int et = this.enemy + 2;
        while (pt <= 11) {
            temp_bb = this.piece_bb[pt] & p_start_bb;
            unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[pt]) ^ 0xFFFFFFFFFFFFFFFFL;
            unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
            while (unfrozen_pieces_bb != 0L) {
                long to_bb;
                long temp_to_bb;
                long lsb2_bb;
                long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
                unfrozen_pieces_bb ^= lsb_bb;
                for (temp_to_bb = to_bb = GameState.touching_bb(lsb_bb) & this.empty_bb & p_dest_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb) {
                    lsb2_bb = temp_to_bb & -temp_to_bb;
                    if (is_frozen != this.is_dest_frozen(lsb2_bb, pt)) continue;
                    ArimaaMove move = result.getMove();
                    move.clear();
                    move.piece_bb[pt] = lsb_bb | lsb2_bb;
                    this.do_protection_captures(move, lsb_bb);
                    move.steps = 1;
                }
                long victim_bb = weaker_enemy_bb & GameState.touching_bb(lsb_bb) & e_start_bb;
                while (victim_bb != 0L) {
                    long lsb4_bb;
                    long lsb3_bb = victim_bb & -victim_bb;
                    victim_bb ^= lsb3_bb;
                    int victim_pt = this.getPieceType(lsb3_bb, this.enemy);
                    if ((lsb_bb & e_dest_bb) != 0L) {
                        long lsb2_bb2;
                        for (temp_to_bb = to_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb2) {
                            lsb2_bb2 = temp_to_bb & -temp_to_bb;
                            if (is_frozen != this.is_dest_frozen(lsb2_bb2, pt)) continue;
                            ArimaaMove move = result.getMove();
                            move.clear();
                            move.piece_bb[pt] = lsb_bb | lsb2_bb2;
                            move.piece_bb[victim_pt] = lsb3_bb | lsb_bb;
                            int n = victim_pt;
                            move.piece_bb[n] = move.piece_bb[n] ^ lsb_bb & this.enemy_suicide_bb;
                            this.do_protection_captures(move, lsb_bb | lsb3_bb);
                            move.steps = 2;
                        }
                    }
                    if ((lsb3_bb & p_dest_bb) == 0L) continue;
                    for (long victim_dest_bb = GameState.touching_bb(lsb3_bb) & this.empty_bb & e_dest_bb; victim_dest_bb != 0L; victim_dest_bb ^= lsb4_bb) {
                        lsb4_bb = victim_dest_bb & -victim_dest_bb;
                        if (is_frozen != this.is_dest_frozen(lsb3_bb, pt)) continue;
                        ArimaaMove move = result.getMove();
                        move.clear();
                        move.piece_bb[pt] = lsb_bb | lsb3_bb;
                        move.piece_bb[victim_pt] = lsb3_bb | lsb4_bb;
                        int n = victim_pt;
                        move.piece_bb[n] = move.piece_bb[n] ^ lsb4_bb & this.enemy_suicide_bb;
                        this.do_protection_captures(move, lsb_bb | lsb3_bb);
                        move.steps = 2;
                    }
                }
            }
            weaker_enemy_bb |= this.piece_bb[et];
            pt += 2;
            et += 2;
        }
    }

    public void genDragMoves(MoveList result, long p_start_bb, long p_dest_bb, long e_start_bb, long e_dest_bb) {
        this.calculate_trap_info();
        long weaker_enemy_bb = this.piece_bb[this.enemy];
        int pt = this.player + 2;
        int et = this.enemy + 2;
        while (pt <= 11) {
            long temp_bb = this.piece_bb[pt] & p_start_bb;
            long unfrozen_sq_bb = GameState.touching_bb(this.colour_bb[this.player]) | GameState.touching_bb(this.stronger_enemy_bb[pt]) ^ 0xFFFFFFFFFFFFFFFFL;
            long unfrozen_pieces_bb = temp_bb & unfrozen_sq_bb;
            while (unfrozen_pieces_bb != 0L) {
                long lsb_bb = unfrozen_pieces_bb & -unfrozen_pieces_bb;
                unfrozen_pieces_bb ^= lsb_bb;
                long to_bb = GameState.touching_bb(lsb_bb) & this.empty_bb & p_dest_bb;
                long victim_bb = weaker_enemy_bb & GameState.touching_bb(lsb_bb) & e_start_bb;
                while (victim_bb != 0L) {
                    long lsb4_bb;
                    ArimaaMove move;
                    long lsb3_bb = victim_bb & -victim_bb;
                    victim_bb ^= lsb3_bb;
                    int victim_pt = this.getPieceType(lsb3_bb, this.enemy);
                    if ((lsb_bb & e_dest_bb) != 0L) {
                        long lsb2_bb;
                        for (long temp_to_bb = to_bb; temp_to_bb != 0L; temp_to_bb ^= lsb2_bb) {
                            lsb2_bb = temp_to_bb & -temp_to_bb;
                            move = result.getMove();
                            move.clear();
                            move.piece_bb[pt] = lsb_bb | lsb2_bb;
                            move.piece_bb[victim_pt] = lsb3_bb | lsb_bb;
                            int n = pt;
                            move.piece_bb[n] = move.piece_bb[n] ^ lsb2_bb & this.player_suicide_bb;
                            int n2 = victim_pt;
                            move.piece_bb[n2] = move.piece_bb[n2] ^ lsb_bb & this.enemy_suicide_bb;
                            this.do_protection_captures(move, lsb_bb | lsb3_bb);
                            move.steps = 2;
                        }
                    }
                    if ((lsb3_bb & p_dest_bb) == 0L) continue;
                    for (long victim_dest_bb = GameState.touching_bb(lsb3_bb) & this.empty_bb & e_dest_bb; victim_dest_bb != 0L; victim_dest_bb ^= lsb4_bb) {
                        lsb4_bb = victim_dest_bb & -victim_dest_bb;
                        move = result.getMove();
                        move.clear();
                        move.piece_bb[pt] = lsb_bb | lsb3_bb;
                        move.piece_bb[victim_pt] = lsb3_bb | lsb4_bb;
                        int n = pt;
                        move.piece_bb[n] = move.piece_bb[n] ^ lsb3_bb & this.player_suicide_bb;
                        int n3 = victim_pt;
                        move.piece_bb[n3] = move.piece_bb[n3] ^ lsb4_bb & this.enemy_suicide_bb;
                        this.do_protection_captures(move, lsb_bb | lsb3_bb);
                        move.steps = 2;
                    }
                }
            }
            weaker_enemy_bb |= this.piece_bb[et];
            pt += 2;
            et += 2;
        }
    }

    public long getPositionHash() {
        long result = this.getPieceHash();
        return result ^= hash_steps[this.total_steps & 7];
    }

    public long getPieceHash() {
        long hash = 0L;
        for (int i = 0; i < 12; ++i) {
            hash = this.piece_bb[i] - (this.piece_bb[i] << 3) + (hash >> 13) + (hash >> 11) + (hash << 6) + (hash << 16) - hash;
        }
        return hash;
    }

    public boolean equals(GameState that) {
        for (int i = 0; i < 12; ++i) {
            if (this.piece_bb[i] == that.piece_bb[i]) continue;
            return false;
        }
        return true;
    }

    public boolean full_equals(GameState that) {
        for (int i = 0; i < 12; ++i) {
            if (this.piece_bb[i] == that.piece_bb[i]) continue;
            return false;
        }
        return this.total_steps == that.total_steps;
    }

    public String getPieceText(int index) {
        assert (index >= 0 && index <= 63);
        String result = " ";
        long piece_mask = 1L << index;
        for (int i = 0; i < 12; ++i) {
            if ((this.piece_bb[i] & piece_mask) != piece_mask) continue;
            result = piece_text[i];
            break;
        }
        return result;
    }

    public boolean is_enemy_piece_captured(GameState initial) {
        int initial_count = Util.PopCnt(initial.colour_bb[initial.enemy]);
        int current_count = Util.PopCnt(this.colour_bb[initial.enemy]);
        boolean result = current_count != initial_count;
        return result;
    }

    public long piece_can_reach(int piece_index, int steps) {
        long unfrozen_sq_bb;
        long piece_bb = 1L << piece_index;
        int piece_type = this.getPieceType(piece_bb);
        int piece_colour = piece_type & 1;
        long friend_bb = this.colour_bb[piece_colour] & (piece_bb ^ 0xFFFFFFFFFFFFFFFFL);
        int trap_num = trap_number[piece_index];
        if (trap_num != -1 && (TRAP[trap_num] & friend_bb) != 0L && (TOUCH_TRAP[trap_num] & this.colour_bb[piece_colour]) == piece_bb) {
            friend_bb ^= TRAP[trap_num];
        }
        if (((unfrozen_sq_bb = GameState.touching_bb(friend_bb) | GameState.touching_bb(this.colour_bb[this.player]) & piece_bb | GameState.touching_bb(this.stronger_enemy_bb[piece_type]) ^ 0xFFFFFFFFFFFFFFFFL) & piece_bb) == 0L) {
            return piece_bb;
        }
        long bad_trap_bb = 0L;
        for (int i = 0; i < 4; ++i) {
            if ((TOUCH_TRAP[i] & friend_bb) != 0L) continue;
            bad_trap_bb |= TRAP[i];
        }
        long good_sq_bb = unfrozen_sq_bb & this.empty_bb & (bad_trap_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long reached_bb = piece_bb;
        for (int i = 1; i < steps; ++i) {
            reached_bb |= GameState.touching_bb(reached_bb, piece_type) & good_sq_bb;
        }
        reached_bb |= GameState.touching_bb(reached_bb, piece_type) & this.empty_bb & (bad_trap_bb ^ 0xFFFFFFFFFFFFFFFFL);
        return reached_bb;
    }

    public boolean is_piece_a_hostage(int piece_index) {
        boolean result = false;
        long lsb_bb = 1L << piece_index;
        assert ((lsb_bb & this.empty_bb) == 0L);
        if ((this.dominated_pieces_bb & lsb_bb) == 0L) {
            return false;
        }
        int piece_type = this.getPieceType(piece_index);
        int piece_colour = piece_type & 1;
        long empty_touch_bb = GameState.touching_bb(lsb_bb) & this.empty_bb;
        long friend_touch_bb = GameState.touching_bb(lsb_bb) & this.colour_bb[piece_colour];
        if (GameState.atMostOneBitSet(empty_touch_bb)) {
            if (friend_touch_bb == 0L) {
                int n = piece_colour;
                this.piece_bb[n] = this.piece_bb[n] | empty_touch_bb;
            }
            boolean bl = result = !this.can_piece_move(piece_index);
            if (friend_touch_bb == 0L) {
                int n = piece_colour;
                this.piece_bb[n] = this.piece_bb[n] & (empty_touch_bb ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return result;
    }

    public boolean can_piece_move(int piece_index) {
        long lsb_bb = 1L << piece_index;
        return this.can_piece_move(lsb_bb);
    }

    public boolean can_piece_move(long lsb_bb) {
        assert ((lsb_bb & this.empty_bb) == 0L);
        if ((this.frozen_pieces_bb & lsb_bb) != 0L) {
            return false;
        }
        int piece_type = this.getPieceType(lsb_bb);
        int piece_colour = piece_type & 1;
        long player_bb = this.colour_bb[piece_colour] & (lsb_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long illegal_trap_bb = 0L;
        for (int i = 0; i < 4; ++i) {
            if ((TOUCH_TRAP[i] & player_bb) != 0L) continue;
            illegal_trap_bb |= TRAP[i];
        }
        long good_sq_bb = this.empty_bb & (illegal_trap_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long reach_bb = GameState.touching_bb(lsb_bb, piece_type);
        if ((reach_bb & good_sq_bb) != 0L) {
            return true;
        }
        long weaker_enemy_bb = this.colour_bb[piece_colour ^ 1] & (this.stronger_enemy_bb[piece_type] ^ 0xFFFFFFFFFFFFFFFFL) & (this.piece_bb[piece_type ^ 1] ^ 0xFFFFFFFFFFFFFFFFL);
        long target_bb = weaker_enemy_bb & reach_bb;
        return (GameState.touching_bb(target_bb &= illegal_trap_bb ^ 0xFFFFFFFFFFFFFFFFL) & this.empty_bb) != 0L;
    }

    public boolean is_elephant_blockaded(int colour) {
        long elephant_bb = this.piece_bb[colour + 10];
        long player_bb = this.colour_bb[colour] & (elephant_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long illegal_trap_bb = 0L;
        for (int i = 0; i < 4; ++i) {
            if ((TOUCH_TRAP[i] & player_bb) != 0L) continue;
            illegal_trap_bb |= TRAP[i];
        }
        long good_sq_bb = this.empty_bb & (illegal_trap_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long reach_bb = elephant_bb;
        reach_bb |= GameState.touching_bb(reach_bb) & good_sq_bb;
        reach_bb |= GameState.touching_bb(reach_bb) & good_sq_bb;
        long elephant_prison_bb = reach_bb;
        assert (Util.PopCnt(reach_bb) <= 3);
        long weaker_enemy_bb = this.colour_bb[colour ^ 1] & (this.piece_bb[colour ^ 0xB] ^ 0xFFFFFFFFFFFFFFFFL);
        long target_bb = weaker_enemy_bb & GameState.touching_bb(reach_bb);
        return (GameState.touching_bb(target_bb &= illegal_trap_bb ^ 0xFFFFFFFFFFFFFFFFL) & this.empty_bb & (elephant_prison_bb ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public String toString() {
        String result = "";
        result = result + this.getTurnNumber();
        result = result + (this.getSideToMove() == 0 ? "w" : "b");
        for (int i = 4; i > this.getStepsRemaining(); --i) {
            result = result + " rc5e";
        }
        result = result + " \n +-----------------+\n";
        for (int row = 7; row >= 0; --row) {
            result = result + (row + 1) + "|";
            for (int col = 0; col <= 7; ++col) {
                int board_index = row * 8 + col;
                result = result + " " + this.getPieceText(board_index);
            }
            result = result + " |\n";
        }
        result = result + " +-----------------+\n";
        result = result + "   a b c d e f g h\n";
        result = result + "TS: " + this.total_steps + "\n";
        return result;
    }

    public String toBoardString() {
        String text = this.toString();
        return text;
    }

    public String toEPDString() {
        String text = this.toString();
        text = text.replaceAll("\n", "%13");
        return text;
    }

    public String toSetupString() {
        int type;
        int i;
        String result = "";
        result = result + "1w ";
        for (i = 0; i < 64; ++i) {
            type = this.getPieceType(i);
            if (type % 2 != 0) continue;
            result = result + this.getPieceText(i);
            result = result + GameState.getStringIndex(i);
            result = result + " ";
        }
        result = result + "\n";
        result = result + "1b ";
        for (i = 0; i < 64; ++i) {
            type = this.getPieceType(i);
            if (type % 2 != 1) continue;
            result = result + this.getPieceText(i);
            result = result + GameState.getStringIndex(i);
            result = result + " ";
        }
        result = result + "\n";
        if (this.player == 1) {
            result = result + "2w pass\n";
        }
        return result;
    }

    public boolean isLegalMove(ArimaaMove move) {
        m1.clear();
        this.GENERATE_MOVES(m1, -1L, -1L);
        for (ArimaaMove temp : m1) {
            if (!temp.equals(move)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] text = new String[]{"2b %13 +-----------------+%138| r r   C r r r r |%137|   e   C R   r   |%136| r e             |%135|   e D M e H   c |%134| C r   R r       |%133|     h R C r   E |%132|       E R H   r |%131| R R   R   E   R |%13 +-----------------+%13   a b c d e f g h%13TS: 20%13", "5w %13 +-----------------+%138|                 |%137|     D           |%136|     C           |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "5w %13 +-----------------+%138|                 |%137|     D           |%136| e   C           |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "5w %13 +-----------------+%138|     m           |%137|     D           |%136| e   C           |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13"};
        String white = "1w Ee2 Me1 Hg2 Hb2 Df2 Dd1 Cc2 Cd2 Ra2 Rh2 Ra1 Rb1 Rc1 Rf1 Rg1 Rh1";
        String black = "1b ha7 db7 cc7 md7 ee7 cf7 dg7 hh7 ra8 rb8 rc8 rd8 re8 rf8 rg8 rh8";
        GameState gs = new GameState(white, black);
        System.out.println(gs.toBoardString());
        System.out.println(gs.toEPDString());
    }

    static {
        Random random = new Random(44L);
        for (int i = 0; i < hash_steps.length; ++i) {
            GameState.hash_steps[i] = random.nextLong();
        }
        m1 = new MoveList(1000);
    }
}

