/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.Util;
import arimaa3.ArimaaBaseClass;
import arimaa3.ArimaaEngine;
import arimaa3.ArimaaMove;
import arimaa3.GameState;
import arimaa3.GenSteps;
import arimaa3.MoveList;

public class TestForGoal
extends ArimaaBaseClass {
    public static boolean use_debug = false;
    private int stack_depth;
    private MoveList[] move_list_stack = new MoveList[15];
    private GameState[] gs_stack = new GameState[15];
    private static long hash_mask = 1048575L;
    private static long[] hash_table = new long[0x100000];
    static long test_calls = 0L;
    static long test_hash_hits = 0L;
    private int saved_goal_index;
    private int saved_rabbit_index;
    private GenSteps gen_steps;
    private GameState temp_gs1;
    private ArimaaMove temp_move1;
    private static long[][] goal_pattern_bb = new long[64][9];
    private static long agree;
    private static long disagree;

    public TestForGoal() {
        int i;
        for (i = 0; i < this.gs_stack.length; ++i) {
            this.gs_stack[i] = new GameState();
        }
        for (i = 0; i < this.move_list_stack.length; ++i) {
            this.move_list_stack[i] = new MoveList(1000);
        }
        this.gen_steps = new GenSteps();
        this.temp_gs1 = new GameState();
        this.temp_move1 = new ArimaaMove();
    }

    public String getStats() {
        String result = "";
        result = result + Util.ProbStats("Test HH", test_calls, test_hash_hits);
        return result;
    }

    public void resetStats() {
        test_calls = 0L;
        test_hash_hits = 0L;
    }

    public boolean test(GameState game) {
        boolean result;
        this.saved_goal_index = -1;
        this.saved_rabbit_index = -1;
        ++test_calls;
        long hash_code = game.getPositionHash();
        int index = (int)(hash_code & hash_mask);
        if ((hash_table[index] & (hash_mask ^ 0xFFFFFFFFFFFFFFFFL)) == (hash_code & (hash_mask ^ 0xFFFFFFFFFFFFFFFFL))) {
            ++test_hash_hits;
            boolean bl = result = (hash_table[index] & 1L) == 1L;
        }
        if (!(result = this.can_rabbit_run(game, 4))) {
            result = this.test_goal_squares(game);
        }
        TestForGoal.hash_table[index] = result ? hash_code | 1L : hash_code & 0xFFFFFFFFFFFFFFFEL;
        return result;
    }

    public int getGoalIndex() {
        return this.saved_goal_index;
    }

    public int getRabbitIndex() {
        return this.saved_rabbit_index;
    }

    private boolean test_goal_squares(GameState game) {
        int start_index;
        game.compute_tertiary_bitboards();
        for (int i = start_index = game.player == 0 ? 56 : 0; i < start_index + 8; ++i) {
            boolean result = this.test_individual_goal_square(game, i, 4);
            if (!result) continue;
            this.saved_goal_index = i;
            return true;
        }
        return false;
    }

    private boolean test_individual_goal_square(GameState game, int goal_index, int total_steps_available) {
        this.stack_depth = -1;
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long touch_goal_bb = goal_pattern_bb[goal_index][2];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long player_nr_bb = player_bb & (rabbit_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        boolean is_goal_empty = true;
        boolean is_gmt_empty = true;
        if ((goal_pattern_bb[goal_index][1] & enemy_bb) == goal_pattern_bb[goal_index][1]) {
            return false;
        }
        if (((gmt_bb | goal_bb) & game.piece_bb[game.enemy + 10]) != 0L) {
            return false;
        }
        int piece_steps_required = 0;
        if ((goal_bb & enemy_bb) != 0L) {
            is_goal_empty = false;
            piece_steps_required += 2;
            if ((touch_goal_bb & player_nr_bb) == 0L) {
                ++piece_steps_required;
            }
        }
        if ((gmt_bb & enemy_bb) != 0L) {
            is_gmt_empty = false;
            piece_steps_required += 2;
            if ((touch_gmt_bb & player_nr_bb) == 0L) {
                ++piece_steps_required;
            }
        }
        if ((goal_bb & player_nr_bb) != 0L) {
            is_goal_empty = false;
            ++piece_steps_required;
            if ((touch_goal_bb & (game.empty_bb ^ 0xFFFFFFFFFFFFFFFFL)) == touch_goal_bb) {
                ++piece_steps_required;
            }
        }
        if ((gmt_bb & player_nr_bb) != 0L) {
            is_gmt_empty = false;
            ++piece_steps_required;
            if ((touch_gmt_bb & (game.empty_bb ^ 0xFFFFFFFFFFFFFFFFL)) == touch_gmt_bb) {
                ++piece_steps_required;
            }
        }
        if (piece_steps_required == 0) {
            piece_steps_required = 1;
        }
        int rabbit_steps_required = 99;
        if ((goal_pattern_bb[goal_index][7] & rabbit_bb) != 0L) {
            rabbit_steps_required = 3;
            if ((goal_pattern_bb[goal_index][6] & rabbit_bb) != 0L) {
                rabbit_steps_required = 2;
                if ((gmt_bb & rabbit_bb) != 0L) {
                    rabbit_steps_required = 1;
                }
            }
        }
        if (use_debug) {
            System.out.println(" " + goal_index + "Steps Avail:" + total_steps_available + " RReq: " + rabbit_steps_required + " PReq:" + piece_steps_required);
        }
        if (rabbit_steps_required + piece_steps_required > total_steps_available) {
            return false;
        }
        boolean result = this.test_decide(game, goal_index, total_steps_available);
        return result;
    }

    private boolean test_2R1P_3R1P(GameState game, int goal_index, int total_steps_available) {
        GameState new_position;
        long frozen_helper_bb;
        if (use_debug) {
            System.out.println("test_2R1P_3R1P " + goal_index + " " + total_steps_available + "\n" + game);
        }
        int player = game.player;
        boolean piece_steps_available = true;
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long touch_goal_bb = goal_pattern_bb[goal_index][2];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long player_nr_bb = player_bb & (rabbit_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long enemy_nr_bb = game.stronger_enemy_bb[player];
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        assert (total_steps_available >= 3);
        if (((goal_bb | gmt_bb) & enemy_bb) != 0L) {
            return false;
        }
        if (((goal_bb | gmt_bb) & empty_bb) == 0L) {
            return false;
        }
        ++this.stack_depth;
        long path_bb = goal_bb | gmt_bb;
        long candidate_bb = touch_gmt_bb & rabbit_bb;
        if (total_steps_available == 4) {
            path_bb |= touch_gmt_bb;
            candidate_bb |= three_step_bb & rabbit_bb;
        }
        long frozen_rabbit_bb = candidate_bb & game.frozen_pieces_bb;
        long dest_bb = TestForGoal.touching_bb(path_bb);
        if (frozen_rabbit_bb != 0L) {
            dest_bb |= TestForGoal.touching_bb(frozen_rabbit_bb) & empty_bb & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if ((frozen_helper_bb = TestForGoal.touching_bb(candidate_bb) & player_bb) != 0L) {
            dest_bb |= TestForGoal.touching_bb(frozen_helper_bb) & empty_bb & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
        }
        long start_bb = -1L;
        if (((goal_bb | gmt_bb) & empty_bb) != (goal_bb | gmt_bb)) {
            start_bb = goal_bb | gmt_bb;
        }
        if (use_debug) {
            System.out.println("Case 1) Try moving piece");
            TestForGoal.print_bitboard(start_bb, "start_bb");
            TestForGoal.print_bitboard(dest_bb, "dest_bb");
        }
        this.move_list_stack[this.stack_depth].clear();
        game.genSlideMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            new_position = this.gs_stack[this.stack_depth];
            new_position.playFull(move, game);
            if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
            return true;
        }
        start_bb = candidate_bb;
        dest_bb = path_bb;
        if (use_debug) {
            System.out.println("Case 2) Try moving rabbit towards goal");
            TestForGoal.print_bitboard(start_bb, "start_bb");
            TestForGoal.print_bitboard(dest_bb, "dest_bb");
        }
        this.move_list_stack[this.stack_depth].clear();
        this.gen_steps.genOneStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            new_position = this.gs_stack[this.stack_depth];
            new_position.playFull(move, game);
            if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
            return true;
        }
        --this.stack_depth;
        return false;
    }

    private boolean test_2R2P(GameState game, int goal_index, int total_steps_available) {
        GameState new_position;
        GameState new_position2;
        GameState new_position3;
        if (use_debug) {
            System.out.println("test_2R2P " + goal_index + " " + total_steps_available + "\n" + game);
        }
        int player = game.player;
        boolean piece_steps_available = true;
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long touch_goal_bb = goal_pattern_bb[goal_index][2];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long player_nr_bb = player_bb & (rabbit_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long enemy_nr_bb = game.stronger_enemy_bb[player];
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        assert (total_steps_available == 4);
        assert ((rabbit_bb & touch_gmt_bb) != 0L);
        if (this.test_2R1P_3R1P(game, goal_index, total_steps_available)) {
            return true;
        }
        ++this.stack_depth;
        if (this.test_remove_protection(game, goal_index, total_steps_available)) {
            return true;
        }
        long start_bb = -1L;
        long dest_bb = TestForGoal.touching_bb(touch_gmt_bb & rabbit_bb & game.frozen_pieces_bb);
        this.move_list_stack[this.stack_depth].clear();
        this.gen_steps.genTwoStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb |= touch_gmt_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            new_position3 = this.gs_stack[this.stack_depth];
            new_position3.playFull(move, game);
            if (!this.test_decide(new_position3, goal_index, total_steps_available - move.steps)) continue;
            return true;
        }
        start_bb = (goal_bb | gmt_bb) & player_bb;
        dest_bb = -1L;
        if (start_bb != 0L) {
            this.move_list_stack[this.stack_depth].clear();
            this.gen_steps.genTwoStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
            for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                new_position3 = this.gs_stack[this.stack_depth];
                new_position3.playFull(move, game);
                if (!this.test_decide(new_position3, goal_index, total_steps_available - move.steps)) continue;
                return true;
            }
        }
        long e_start_bb = 0L;
        e_start_bb |= (goal_bb | gmt_bb) & enemy_bb;
        long e_possible_bb = touch_gmt_bb & enemy_nr_bb;
        e_start_bb |= (e_possible_bb |= TestForGoal.touching_bb(touch_gmt_bb & rabbit_bb & game.frozen_pieces_bb) & enemy_bb);
        for (int i = 0; i <= 3; ++i) {
            long etest_bb;
            if ((e_possible_bb & TRAP[i]) == 0L || !TestForGoal.atMostOneBitSet(etest_bb = TOUCH_TRAP[i] & enemy_bb)) continue;
            e_start_bb |= etest_bb;
        }
        long e_dest_bb = 0xFFFFFFFFFFFFFFFFL & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL) & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
        dest_bb = 0xFFFFFFFFFFFFFFFFL & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL) & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
        start_bb = -1L;
        if (e_start_bb != 0L) {
            this.move_list_stack[this.stack_depth].clear();
            game.genDragMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb, e_start_bb, e_dest_bb);
            for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                new_position2 = this.gs_stack[this.stack_depth];
                new_position2.playFull(move, game);
                if (!this.test_decide(new_position2, goal_index, total_steps_available - move.steps)) continue;
                return true;
            }
        }
        dest_bb = TestForGoal.touching_bb(touch_gmt_bb & rabbit_bb) & empty_bb;
        start_bb = 0xFFFFFFFFFFFFFFFFL & (touch_gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
        this.move_list_stack[this.stack_depth].clear();
        game.genSlideMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            new_position2 = this.gs_stack[this.stack_depth];
            new_position2.playFull(move, game);
            if (!this.test_decide(new_position2, goal_index, total_steps_available - move.steps)) continue;
            return true;
        }
        long danger_bb = TestForGoal.touching_bb(touch_gmt_bb & rabbit_bb) & 0x240000240000L & player_bb;
        dest_bb = TestForGoal.touching_bb(danger_bb);
        start_bb = 0xFFFFFFFFFFFFFFFFL & (danger_bb ^ 0xFFFFFFFFFFFFFFFFL);
        this.move_list_stack[this.stack_depth].clear();
        game.genSlideMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            new_position = this.gs_stack[this.stack_depth];
            new_position.playFull(move, game);
            if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
            return true;
        }
        start_bb = touch_gmt_bb & rabbit_bb & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL);
        dest_bb = gmt_bb;
        this.move_list_stack[this.stack_depth].clear();
        this.gen_steps.genOneStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            new_position = this.gs_stack[this.stack_depth];
            new_position.playFull(move, game);
            if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
            return true;
        }
        --this.stack_depth;
        return false;
    }

    private boolean test_decide(GameState game, int goal_index, int steps) {
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        if ((goal_bb & empty_bb) == 0L && (gmt_bb & rabbit_bb) != 0L) {
            return this.test_GmtRabbit_GoalNotEmpty(game, goal_index, steps);
        }
        if ((goal_bb & empty_bb) != 0L && (gmt_bb & rabbit_bb) != 0L) {
            return this.test_GmtRabbit_GoalEmpty(game, goal_index, steps);
        }
        if ((touch_gmt_bb & rabbit_bb) != 0L && steps == 3) {
            return this.test_2R1P_3R1P(game, goal_index, steps);
        }
        if ((touch_gmt_bb & rabbit_bb) == 0L && (three_step_bb & rabbit_bb) != 0L && steps == 4) {
            return this.test_2R1P_3R1P(game, goal_index, steps);
        }
        if ((touch_gmt_bb & rabbit_bb) != 0L && steps == 4) {
            return this.test_2R2P(game, goal_index, steps);
        }
        return this.test_4RP0(game, goal_index, steps);
    }

    private boolean test_4RP0(GameState game, int goal_index, int total_steps_available) {
        if (use_debug) {
            System.out.println("test_4RP0 " + goal_index + " " + total_steps_available + "\n" + game);
        }
        return this.can_rabbit_run(game, total_steps_available);
    }

    private boolean test_GmtRabbit_GoalNotEmpty(GameState game, int goal_index, int total_steps_available) {
        long dest_bb;
        long escape_bb;
        long lsb_bb;
        long dest_bb2;
        long lsb_bb2;
        long escape_bb2;
        if (use_debug) {
            System.out.println("test_GmtRabbit_GoalNotEmpty " + goal_index + " " + total_steps_available + "\n" + game);
        }
        int player = game.player;
        int piece_steps_available = total_steps_available - 1;
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long touch_goal_bb = goal_pattern_bb[goal_index][2];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long player_nr_bb = player_bb & (rabbit_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long enemy_nr_bb = game.stronger_enemy_bb[player];
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        ++this.stack_depth;
        assert ((goal_bb & empty_bb) == 0L);
        assert ((rabbit_bb & gmt_bb) != 0L);
        if (total_steps_available < 2) {
            return false;
        }
        if (piece_steps_available == 1 && (goal_bb & player_bb) != 0L && (touch_goal_bb & empty_bb) != 0L && ((touch_gmt_bb & enemy_nr_bb) == 0L || (touch_gmt_bb & player_bb) != 0L)) {
            return this.debug(true);
        }
        if (piece_steps_available == 2) {
            if ((goal_bb & player_bb) != 0L) {
                escape_bb2 = touch_goal_bb;
                while (escape_bb2 != 0L) {
                    lsb_bb2 = escape_bb2 & -escape_bb2;
                    escape_bb2 ^= lsb_bb2;
                    if ((lsb_bb2 & empty_bb) != 0L) {
                        if ((touch_gmt_bb & enemy_nr_bb) == 0L || (touch_gmt_bb & player_bb) != 0L) {
                            return this.debug(true);
                        }
                        this.temp_move1.clear();
                        int n = game.getPieceType(goal_bb);
                        this.temp_move1.piece_bb[n] = this.temp_move1.piece_bb[n] ^ (goal_bb | lsb_bb2);
                        this.temp_move1.steps = 1;
                        this.temp_gs1.playFull(this.temp_move1, game);
                        if (this.test_GmtRabbit_GoalEmpty(this.temp_gs1, goal_index, total_steps_available - 1)) {
                            return true;
                        }
                    }
                    if ((lsb_bb2 & player_bb) != 0L && (dest_bb2 = TestForGoal.touching_bb(lsb_bb2) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL) & empty_bb) != 0L && ((dest_bb2 & touch_gmt_bb) != 0L || (touch_gmt_bb & enemy_nr_bb) == 0L || (touch_gmt_bb & player_bb) != 0L)) {
                        return this.debug(true);
                    }
                    if ((lsb_bb2 & enemy_bb) == 0L) continue;
                    assert (piece_steps_available >= 2);
                    dest_bb2 = TestForGoal.touching_bb(lsb_bb2) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL) & empty_bb;
                    int pt = game.getPieceType(lsb_bb2);
                    if (dest_bb2 == 0L || (game.stronger_enemy_bb[pt] & goal_bb) == 0L) continue;
                    if ((touch_gmt_bb & enemy_nr_bb) == 0L && ((lsb_bb2 & enemy_nr_bb) == 0L || (dest_bb2 & (touch_gmt_bb ^ 0xFFFFFFFFFFFFFFFFL)) != 0L)) {
                        return this.debug(true);
                    }
                    if ((touch_gmt_bb & player_bb) == 0L) continue;
                    return this.debug(true);
                }
            }
            if ((goal_bb & enemy_bb) != 0L) {
                int pt = game.getPieceType(goal_bb);
                for (escape_bb = touch_goal_bb & player_bb; escape_bb != 0L; escape_bb ^= lsb_bb) {
                    lsb_bb = escape_bb & -escape_bb;
                    if ((game.stronger_enemy_bb[pt] & lsb_bb) == 0L || (lsb_bb & game.frozen_pieces_bb) != 0L || (dest_bb = TestForGoal.touching_bb(lsb_bb) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL) & empty_bb) == 0L || (dest_bb & touch_gmt_bb) == 0L && (touch_gmt_bb & enemy_nr_bb) != 0L && (touch_gmt_bb & player_bb) == 0L) continue;
                    return this.debug(true);
                }
            }
        }
        if (piece_steps_available == 3) {
            long lsb2_bb;
            if ((goal_bb & player_bb) != 0L) {
                escape_bb2 = touch_goal_bb;
                while (escape_bb2 != 0L) {
                    lsb_bb2 = escape_bb2 & -escape_bb2;
                    escape_bb2 ^= lsb_bb2;
                    if ((lsb_bb2 & empty_bb) != 0L) {
                        assert (piece_steps_available >= 1);
                        if ((touch_gmt_bb & enemy_nr_bb) == 0L || (touch_gmt_bb & player_bb) != 0L) {
                            return this.debug(true);
                        }
                        this.temp_move1.clear();
                        int n = game.getPieceType(goal_bb);
                        this.temp_move1.piece_bb[n] = this.temp_move1.piece_bb[n] ^ (goal_bb | lsb_bb2);
                        this.temp_move1.steps = 1;
                        this.temp_gs1.playFull(this.temp_move1, game);
                        if (this.test_GmtRabbit_GoalEmpty(this.temp_gs1, goal_index, total_steps_available - 1)) {
                            return true;
                        }
                    }
                    if ((lsb_bb2 & player_bb) != 0L) {
                        assert (piece_steps_available >= 2);
                        dest_bb2 = TestForGoal.touching_bb(lsb_bb2) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL);
                        while (dest_bb2 != 0L) {
                            long far_dest_bb;
                            long far_dest_bb2;
                            int pt;
                            long lsb2_bb2 = dest_bb2 & -dest_bb2;
                            dest_bb2 ^= lsb2_bb2;
                            if ((lsb2_bb2 & empty_bb) != 0L) {
                                if ((lsb2_bb2 & touch_gmt_bb) != 0L || (touch_gmt_bb & enemy_nr_bb) == 0L || (touch_gmt_bb & player_bb) != 0L) {
                                    return this.debug(true);
                                }
                                this.temp_move1.clear();
                                int n = game.getPieceType(goal_bb);
                                this.temp_move1.piece_bb[n] = this.temp_move1.piece_bb[n] ^ (goal_bb | lsb_bb2);
                                int n2 = game.getPieceType(lsb_bb2);
                                this.temp_move1.piece_bb[n2] = this.temp_move1.piece_bb[n2] ^ (lsb_bb2 | lsb2_bb2);
                                this.temp_move1.steps = 2;
                                this.temp_gs1.playFull(this.temp_move1, game);
                                if (this.test_GmtRabbit_GoalEmpty(this.temp_gs1, goal_index, total_steps_available - 2)) {
                                    return true;
                                }
                            }
                            if ((lsb2_bb2 & enemy_bb) != 0L && (game.stronger_enemy_bb[pt = game.getPieceType(lsb2_bb2)] & lsb_bb2) != 0L && (far_dest_bb2 = TestForGoal.touching_bb(lsb2_bb2) & empty_bb) != 0L && ((lsb2_bb2 & touch_gmt_bb) != 0L || (touch_gmt_bb & enemy_nr_bb) == 0L || (touch_gmt_bb & player_bb) != 0L)) {
                                return this.debug(true);
                            }
                            if ((lsb2_bb2 & player_bb) == 0L || (far_dest_bb = TestForGoal.touching_bb(lsb2_bb2, game.getPieceType(lsb2_bb2)) & empty_bb) == 0L || (touch_gmt_bb & enemy_nr_bb) != 0L && (touch_gmt_bb & player_bb) == 0L) continue;
                            return this.debug(true);
                        }
                    }
                    if ((lsb_bb2 & enemy_bb) == 0L) continue;
                    assert (piece_steps_available >= 2);
                    dest_bb2 = TestForGoal.touching_bb(lsb_bb2) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL);
                    int pt = game.getPieceType(lsb_bb2);
                    while (dest_bb2 != 0L) {
                        lsb2_bb = dest_bb2 & -dest_bb2;
                        dest_bb2 ^= lsb2_bb;
                        if ((lsb2_bb & empty_bb) != 0L && (game.stronger_enemy_bb[pt] & goal_bb) != 0L) {
                            if ((touch_gmt_bb & enemy_nr_bb) == 0L && ((lsb_bb2 & enemy_nr_bb) == 0L || (lsb2_bb & touch_gmt_bb) == 0L)) {
                                return this.debug(true);
                            }
                            if ((touch_gmt_bb & player_bb) != 0L) {
                                return this.debug(true);
                            }
                            this.temp_move1.clear();
                            int n = game.getPieceType(goal_bb);
                            this.temp_move1.piece_bb[n] = this.temp_move1.piece_bb[n] ^ (goal_bb | lsb_bb2);
                            int n3 = game.getPieceType(lsb_bb2);
                            this.temp_move1.piece_bb[n3] = this.temp_move1.piece_bb[n3] ^ (lsb_bb2 | lsb2_bb);
                            this.temp_move1.steps = 2;
                            this.temp_gs1.playFull(this.temp_move1, game);
                            if (this.test_GmtRabbit_GoalEmpty(this.temp_gs1, goal_index, total_steps_available - 2)) {
                                return true;
                            }
                        }
                        if ((lsb2_bb & player_bb) == 0L || (lsb2_bb & game.frozen_pieces_bb) != 0L || (TestForGoal.touching_bb(lsb2_bb, game.getPieceType(lsb2_bb)) & empty_bb) == 0L || (game.stronger_enemy_bb[pt] & (goal_bb | lsb2_bb)) == 0L) continue;
                        if ((touch_gmt_bb & enemy_nr_bb) == 0L && ((lsb_bb2 & enemy_nr_bb) == 0L || (lsb2_bb & touch_gmt_bb) == 0L)) {
                            return this.debug(true);
                        }
                        if ((touch_gmt_bb & (lsb2_bb ^ 0xFFFFFFFFFFFFFFFFL) & player_bb) == 0L) continue;
                        return this.debug(true);
                    }
                }
            }
            if ((goal_bb & enemy_bb) != 0L) {
                int pt = game.getPieceType(goal_bb);
                escape_bb = touch_goal_bb;
                while (escape_bb != 0L) {
                    int pt2;
                    lsb_bb = escape_bb & -escape_bb;
                    escape_bb ^= lsb_bb;
                    if ((lsb_bb & empty_bb) != 0L) {
                        assert (piece_steps_available >= 3);
                        for (dest_bb = TestForGoal.touching_bb(lsb_bb) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL); dest_bb != 0L; dest_bb ^= lsb2_bb) {
                            lsb2_bb = dest_bb & -dest_bb;
                            if ((game.stronger_enemy_bb[pt] & lsb2_bb) == 0L || (lsb2_bb & game.frozen_pieces_bb) != 0L || (game.stronger_enemy_bb[pt2 = game.getPieceType(lsb2_bb)] & TestForGoal.touching_bb(lsb_bb)) != 0L) continue;
                            if ((touch_gmt_bb & enemy_nr_bb) != 0L && (touch_gmt_bb & player_bb) == 0L) continue;
                            return this.debug(true);
                        }
                    }
                    if ((lsb_bb & player_bb) == 0L || (game.stronger_enemy_bb[pt] & lsb_bb) == 0L || (lsb_bb & game.frozen_pieces_bb) != 0L) continue;
                    assert (piece_steps_available >= 2);
                    for (dest_bb = TestForGoal.touching_bb(lsb_bb) & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL); dest_bb != 0L; dest_bb ^= lsb2_bb) {
                        lsb2_bb = dest_bb & -dest_bb;
                        if ((lsb2_bb & player_bb) == 0L || (TestForGoal.touching_bb(lsb2_bb, game.getPieceType(lsb2_bb)) & empty_bb) == 0L || (game.stronger_enemy_bb[pt2 = game.getPieceType(lsb_bb)] & TestForGoal.touching_bb(lsb_bb)) != 0L || (touch_gmt_bb & enemy_nr_bb) != 0L && (touch_gmt_bb & player_bb) == 0L) continue;
                        return this.debug(true);
                    }
                    long other_escape_bb = touch_goal_bb & (lsb_bb ^ 0xFFFFFFFFFFFFFFFFL);
                    if ((other_escape_bb & empty_bb) == 0L || (touch_gmt_bb & enemy_nr_bb) != 0L && (touch_gmt_bb & player_bb) == 0L) continue;
                    return this.debug(true);
                }
            }
        }
        --this.stack_depth;
        return false;
    }

    private boolean test_remove_protection(GameState game, int goal_index, int total_steps_available) {
        if (use_debug) {
            System.out.println("test_GmtRabbit_GoalEmpty " + goal_index + " " + total_steps_available + "\n" + game);
        }
        int piece_steps_available = total_steps_available - 1;
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long touch_goal_bb = goal_pattern_bb[goal_index][2];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long player_nr_bb = player_bb & (rabbit_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        ++this.stack_depth;
        for (int i = game.enemy; i <= 3; i += 2) {
            GameState new_position;
            if ((TRAP[i] & player_bb) != 0L && TestForGoal.atMostOneBitSet(TOUCH_TRAP[i] & player_bb)) {
                long start_bb = TOUCH_TRAP[i] & player_bb;
                long dest_bb = 0xFFFFFFFFFFFFFFFFL & (start_bb ^ 0xFFFFFFFFFFFFFFFFL);
                this.move_list_stack[this.stack_depth].clear();
                game.genSlideMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb);
                for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                    new_position = this.gs_stack[this.stack_depth];
                    new_position.playFull(move, game);
                    if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
                    return true;
                }
            }
            if ((TRAP[i] & enemy_bb) == 0L || !TestForGoal.atMostOneBitSet(TOUCH_TRAP[i] & enemy_bb)) continue;
            long estart_bb = TOUCH_TRAP[i] & enemy_bb;
            long edest_bb = 0xFFFFFFFFFFFFFFFFL & (estart_bb ^ 0xFFFFFFFFFFFFFFFFL);
            this.move_list_stack[this.stack_depth].clear();
            game.genDragMoves(this.move_list_stack[this.stack_depth], -1L, -1L, estart_bb, edest_bb);
            for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                new_position = this.gs_stack[this.stack_depth];
                new_position.playFull(move, game);
                if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
                return true;
            }
        }
        --this.stack_depth;
        return false;
    }

    private boolean test_GmtRabbit_GoalEmpty(GameState game, int goal_index, int total_steps_available) {
        long support_bb;
        if (use_debug) {
            System.out.println("test_GmtRabbit_GoalEmpty " + goal_index + " " + total_steps_available + "\n" + game);
        }
        int piece_steps_available = total_steps_available - 1;
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        long empty_bb = game.empty_bb;
        long goal_bb = goal_pattern_bb[goal_index][0];
        long touch_goal_bb = goal_pattern_bb[goal_index][2];
        long rabbit_bb = game.piece_bb[game.player];
        long gmt_bb = goal_pattern_bb[goal_index][4];
        long player_nr_bb = player_bb & (rabbit_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long touch_gmt_bb = goal_pattern_bb[goal_index][5];
        long three_step_bb = goal_pattern_bb[goal_index][8];
        assert ((goal_bb & empty_bb) != 0L);
        assert ((rabbit_bb & gmt_bb) != 0L);
        assert (total_steps_available >= 1);
        ++this.stack_depth;
        if ((gmt_bb & game.frozen_pieces_bb) == 0L) {
            return this.debug(true);
        }
        if (piece_steps_available >= 1 && ((game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL) & player_bb & (support_bb = TestForGoal.touching_bb(touch_gmt_bb & empty_bb) & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL))) != 0L) {
            return this.debug(true);
        }
        if (piece_steps_available >= 2) {
            if (this.test_remove_protection(game, goal_index, total_steps_available)) {
                return true;
            }
            long gmt_freeze_bb = touch_gmt_bb & game.stronger_enemy_bb[game.player];
            if (use_debug) {
                TestForGoal.print_bitboard(gmt_freeze_bb, "GMT_freeze");
            }
            boolean only_one_freezer = TestForGoal.atMostOneBitSet(gmt_freeze_bb);
            long target_bb = touch_gmt_bb & enemy_bb;
            for (int i = 0; i <= 3; ++i) {
                long etest_bb;
                if ((gmt_freeze_bb & TRAP[i]) == 0L || !TestForGoal.atMostOneBitSet(etest_bb = TOUCH_TRAP[i] & enemy_bb)) continue;
                target_bb |= etest_bb;
            }
            if (use_debug) {
                TestForGoal.print_bitboard(target_bb, "Target");
            }
            while (target_bb != 0L) {
                long stronger_bb;
                GameState new_position;
                long lsb_bb = target_bb & -target_bb;
                target_bb ^= lsb_bb;
                int pt = game.getPieceType(lsb_bb);
                if (piece_steps_available >= 3) {
                    boolean result;
                    int new_steps_available;
                    GameState new_position2;
                    long dest_bb = TestForGoal.touching_bb(lsb_bb) & empty_bb;
                    long start_bb = TestForGoal.touching_bb(dest_bb) & game.stronger_enemy_bb[pt];
                    this.move_list_stack[this.stack_depth].clear();
                    this.gen_steps.genOneStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
                    for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                        new_position = this.gs_stack[this.stack_depth];
                        new_position.playFull(move, game);
                        if (!this.test_GmtRabbit_GoalEmpty(new_position, goal_index, total_steps_available - move.steps)) continue;
                        return true;
                    }
                    long stronger_bb2 = game.stronger_enemy_bb[pt] & TestForGoal.touching_bb(lsb_bb);
                    dest_bb = TestForGoal.touching_bb(stronger_bb2 & game.frozen_pieces_bb) & empty_bb & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL);
                    start_bb = TestForGoal.touching_bb(dest_bb) & player_bb & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL);
                    this.move_list_stack[this.stack_depth].clear();
                    this.gen_steps.genOneStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
                    for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                        new_position2 = this.gs_stack[this.stack_depth];
                        new_position2.playFull(move, game);
                        new_steps_available = total_steps_available - move.steps;
                        result = this.test_GmtRabbit_GoalEmpty(new_position2, goal_index, new_steps_available);
                        if (!result) continue;
                        return true;
                    }
                    if (only_one_freezer && (TestForGoal.touching_bb(stronger_bb2 & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL)) & empty_bb & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                        start_bb = TestForGoal.touching_bb(stronger_bb2) & player_bb;
                        dest_bb = TestForGoal.touching_bb(start_bb) & empty_bb & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL);
                        if (use_debug) {
                            System.out.println("Vacate pull dest");
                            TestForGoal.print_bitboard(start_bb, "Start_bb");
                            TestForGoal.print_bitboard(dest_bb, "dest_bb");
                        }
                        this.move_list_stack[this.stack_depth].clear();
                        game.genSlideMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb);
                        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                            new_position2 = this.gs_stack[this.stack_depth];
                            new_position2.playFull(move, game);
                            new_steps_available = total_steps_available - move.steps;
                            result = this.test_GmtRabbit_GoalEmpty(new_position2, goal_index, new_steps_available);
                            if (!result) continue;
                            return true;
                        }
                    }
                    if ((TestForGoal.touching_bb(lsb_bb) & empty_bb) == 0L) {
                        start_bb = TestForGoal.touching_bb(lsb_bb) & player_bb;
                        dest_bb = TestForGoal.touching_bb(start_bb) & empty_bb & (goal_bb ^ 0xFFFFFFFFFFFFFFFFL);
                        if (use_debug) {
                            System.out.println("Vacate push dest");
                            TestForGoal.print_bitboard(start_bb, "Start_bb");
                            TestForGoal.print_bitboard(dest_bb, "dest_bb");
                        }
                        this.move_list_stack[this.stack_depth].clear();
                        game.genSlideMoves(this.move_list_stack[this.stack_depth], start_bb, dest_bb);
                        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                            new_position2 = this.gs_stack[this.stack_depth];
                            new_position2.playFull(move, game);
                            new_steps_available = total_steps_available - move.steps;
                            result = this.test_GmtRabbit_GoalEmpty(new_position2, goal_index, new_steps_available);
                            if (!result) continue;
                            return true;
                        }
                    }
                }
                if ((stronger_bb = game.stronger_enemy_bb[pt] & TestForGoal.touching_bb(lsb_bb) & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                long pdest_bb = -1L;
                if ((lsb_bb & gmt_freeze_bb) == 0L || !only_one_freezer) {
                    pdest_bb = lsb_bb;
                }
                this.move_list_stack[this.stack_depth].clear();
                game.genDragMoves(this.move_list_stack[this.stack_depth], -1L, -1L, lsb_bb, -1L);
                for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                    new_position = this.gs_stack[this.stack_depth];
                    new_position.playFull(move, game);
                    if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
                    return true;
                }
            }
            long frozen_sup = TestForGoal.touching_bb(touch_gmt_bb & empty_bb) & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL) & game.frozen_pieces_bb & player_bb;
            long unfreeze_sq = TestForGoal.touching_bb(frozen_sup) & empty_bb;
            long salvation_bb = TestForGoal.touching_bb(unfreeze_sq) & player_bb & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL);
            this.move_list_stack[this.stack_depth].clear();
            game.genSlideMoves(this.move_list_stack[this.stack_depth], salvation_bb, unfreeze_sq);
            if (this.move_list_stack[this.stack_depth].size() > 0) {
                return true;
            }
            long inbetween_bb = TestForGoal.touching_bb(touch_gmt_bb & empty_bb) & empty_bb;
            long potential_bb = TestForGoal.touching_bb(inbetween_bb) & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL) & player_bb;
            while (potential_bb != 0L) {
                long lsb_bb = potential_bb & -potential_bb;
                potential_bb ^= lsb_bb;
                int index = Util.FirstOne(lsb_bb);
                long reach_bb = game.piece_can_reach(index, 2);
                if ((reach_bb & touch_gmt_bb) != 0L) {
                    return this.debug(true);
                }
                if (piece_steps_available < 3) continue;
                long dest_bb = TestForGoal.touching_bb(inbetween_bb) & empty_bb;
                long start_bb = TestForGoal.touching_bb(lsb_bb) & player_bb;
                this.move_list_stack[this.stack_depth].clear();
                this.gen_steps.genOneStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
                for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                    GameState new_position = this.gs_stack[this.stack_depth];
                    new_position.playFull(move, game);
                    if (!this.test_GmtRabbit_GoalEmpty(new_position, goal_index, total_steps_available - move.steps)) continue;
                    return true;
                }
            }
        }
        if (piece_steps_available >= 3) {
            long potential_bb;
            long lsb_bb;
            long inbetween_bb = TestForGoal.touching_bb(touch_gmt_bb & empty_bb) & empty_bb;
            long inbetween2_bb = TestForGoal.touching_bb(inbetween_bb) & empty_bb;
            for (potential_bb = TestForGoal.touching_bb(inbetween2_bb) & (game.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL) & player_bb; potential_bb != 0L; potential_bb ^= lsb_bb) {
                lsb_bb = potential_bb & -potential_bb;
                int index = Util.FirstOne(lsb_bb);
                long reach_bb = game.piece_can_reach(index, 3);
                if ((reach_bb & touch_gmt_bb) == 0L) continue;
                return this.debug(true);
            }
            long dest_bb = TestForGoal.touching_bb(touch_gmt_bb & enemy_bb) & empty_bb;
            long start_bb = TestForGoal.touching_bb(dest_bb) & player_nr_bb;
            this.move_list_stack[this.stack_depth].clear();
            this.gen_steps.genOneStep(game, this.move_list_stack[this.stack_depth], start_bb, dest_bb);
            for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                GameState new_position = this.gs_stack[this.stack_depth];
                new_position.playFull(move, game);
                if (!this.test_GmtRabbit_GoalEmpty(new_position, goal_index, total_steps_available - move.steps)) continue;
                return true;
            }
            inbetween_bb = TestForGoal.touching_bb(touch_gmt_bb & empty_bb) & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
            this.move_list_stack[this.stack_depth].clear();
            this.gen_steps.genTwoStep(game, this.move_list_stack[this.stack_depth], -1L, inbetween_bb);
            for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                GameState new_position = this.gs_stack[this.stack_depth];
                new_position.playFull(move, game);
                if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
                return true;
            }
            potential_bb = TestForGoal.touching_bb(touch_gmt_bb) & (gmt_bb ^ 0xFFFFFFFFFFFFFFFFL) & player_bb;
            if (use_debug) {
                TestForGoal.print_bitboard(potential_bb, "Ass 1 step slide");
            }
            while (potential_bb != 0L) {
                long protection_bb;
                long lsb_bb2 = potential_bb & -potential_bb;
                potential_bb ^= lsb_bb2;
                dest_bb = TestForGoal.touching_bb(lsb_bb2) & (touch_gmt_bb ^ 0xFFFFFFFFFFFFFFFFL);
                if (use_debug) {
                    TestForGoal.print_bitboard(dest_bb, "dest_bb");
                }
                this.move_list_stack[this.stack_depth].clear();
                this.gen_steps.genTwoStep(game, this.move_list_stack[this.stack_depth], 0xFFFFFFFFFFFFFFFFL & (lsb_bb2 ^ 0xFFFFFFFFFFFFFFFFL), dest_bb);
                for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                    GameState new_position = this.gs_stack[this.stack_depth];
                    new_position.playFull(move, game);
                    if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
                    return true;
                }
                long freeze_bb = TestForGoal.touching_bb(lsb_bb2) & game.stronger_enemy_bb[game.getPieceType(lsb_bb2)];
                if (!TestForGoal.atMostOneBitSet(freeze_bb)) continue;
                long estart_bb = freeze_bb;
                if ((freeze_bb & 0x240000240000L) != 0L && TestForGoal.atMostOneBitSet(protection_bb = TestForGoal.touching_bb(freeze_bb) & TOUCH_TRAPS & enemy_bb)) {
                    estart_bb |= protection_bb;
                }
                if (use_debug) {
                    TestForGoal.print_bitboard(estart_bb, "estart_bb");
                }
                this.move_list_stack[this.stack_depth].clear();
                game.genDragMoves(this.move_list_stack[this.stack_depth], -1L, -1L, estart_bb, -1L);
                for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
                    GameState new_position = this.gs_stack[this.stack_depth];
                    new_position.playFull(move, game);
                    if (!this.test_decide(new_position, goal_index, total_steps_available - move.steps)) continue;
                    return true;
                }
            }
        }
        --this.stack_depth;
        return false;
    }

    boolean can_piece_reach(GameState game, long goal_bb, long origin_bb, int steps) {
        long reached_bb = goal_bb & game.empty_bb;
        for (int i = 1; i <= steps; ++i) {
            int piece_index;
            reached_bb = GameState.touching_bb(reached_bb & game.empty_bb);
            for (long test_bb = reached_bb & origin_bb; test_bb != 0L; test_bb ^= 1L << piece_index) {
                piece_index = Util.FirstOne(test_bb);
                long result = game.piece_can_reach(piece_index, i);
                if ((result & goal_bb) == 0L) continue;
                return true;
            }
        }
        return false;
    }

    boolean can_rabbit_run(GameState game, int steps) {
        int player = game.player;
        long goal_bb = player == 0 ? -72057594037927936L : 255L;
        long start_bb = game.empty_bb & goal_bb;
        long good_sq_bb = GameState.touching_bb(game.colour_bb[player]) | GameState.touching_bb(game.stronger_enemy_bb[player]) ^ 0xFFFFFFFFFFFFFFFFL;
        good_sq_bb &= game.empty_bb;
        good_sq_bb |= game.piece_bb[player];
        long reached_bb = start_bb;
        for (int i = 1; i <= steps; ++i) {
            int rabbit_index;
            reached_bb = GameState.touching_bb(reached_bb) & good_sq_bb;
            for (long test_bb = reached_bb & game.piece_bb[player]; test_bb != 0L; test_bb ^= 1L << rabbit_index) {
                rabbit_index = Util.FirstOne(test_bb);
                long result = game.piece_can_reach(rabbit_index, i);
                if ((result & goal_bb) == 0L) continue;
                this.saved_rabbit_index = rabbit_index;
                return true;
            }
        }
        return false;
    }

    private boolean debug(boolean result) {
        if (use_debug) {
            Thread.dumpStack();
            System.err.flush();
        }
        return result;
    }

    public static void main(String[] args) {
        String[] text = new String[]{"17b %13 +-----------------+%138| r r   c c r   r |%137|     r     d     |%136| r H             |%135|                 |%134|           E r   |%133| R H       R M d |%132|           e R r |%131|   R   R C h   R |%13 +-----------------+%13   a b c d e f g h%13", "26w %13 +-----------------+%138|   r r d H r r r |%137| r     c E R   r |%136|   h             |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r         r   |%137| r R E   r   M r |%136| C m h     X E   |%135|   H   d c       |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137| e e r C r   r   |%136|   D R R   X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|         d r     |%137|   r     M r e   |%136|   d   c     R   |%135|       c   E   R |%134| r   H         r |%133| D h R   d   r C |%132| r D m   C       |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|         d r     |%137|   r     M r e   |%136|   d   c   R     |%135|       c   E   R |%134| r   H         r |%133| D h R   d   C   |%132| r D m   R   r C |%131| R R       R   R |%13 +-----------------+%13   a b c d e f g h%13", "31b %13 +-----------------+%138|   c   d     c   |%137|         d r     |%136|               C |%135|   r             |%134|             r h |%133|   M   R   r r R |%132| R h   m E e H   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "33w %13 +-----------------+%138|               H |%137| r         M e   |%136|   d   c     R   |%135|       c     E R |%134| r   H         r |%133| D h R   d   r C |%132| r D m         C |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|     r r r r M r |%137| r         c r   |%136|       d d       |%135| h D c m         |%134|     E e         |%133|     r           |%132|   R h         H |%131| R R   H R R R R |%13 +-----------------+%13   a b c d e f g h%13", "22w %13 +-----------------+%138|                 |%137| r r r       H   |%136|   d     h   h R |%135| c   d   r r     |%134| r C     c   r   |%133| D e   r   E C   |%132|     H M D m     |%131| R R R R R R R   |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137| D   c R         |%136|       e e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137| D   c R c       |%136|       e e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|   D c R c       |%136|       e e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     M   e       |%136|       R e       |%135|                 |%134|                  |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|                 |%136|       R e       |%135|                 |%134|         C        |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|       R e       |%136|                 |%135|                 |%134|         C        |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     R   e       |%136|                 |%135|                 |%134|       C         |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     R   e       |%136|                 |%135|       C e       |%134|                 |%133|     X R   X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|                 |%136|       R d       |%135|                 |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|         d H     |%136|       R         |%135|                 |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   r r r r |%137|     r D R r r   |%136|     M R h r     |%135|   e R M r r     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     r r R r r   |%136|     M   h r     |%135|   e R M r r     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     r r R r r   |%136|       M h r     |%135|   e R M r r     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     r r R r r   |%136|     D M h r     |%135|   e R M   D     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   E r r r r |%137|     r e R e r   |%136|   D r R   X     |%135|   e R M   D     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r E r   r r |%137|     r e R e r   |%136|   D r R   X     |%135|   e R M         |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r C r r r r |%137|     r       r   |%136|   D r R r X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137|     r C r   r   |%136|   D r R r X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137|     r C r   r   |%136|   D R     X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r   H r r r |%137|     e   C r     |%136|     e           |%135|     e R M e     |%134|         R       |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r   H r r r |%137|     e   C r     |%136|     e           |%135|     e R M e     |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|       R R     d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|   r   R r       |%133|     X r r X     |%132|       d R     r |%131| R R R R   R   R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|   r   R r       |%133|     X r r X   E |%132|       d R     r |%131| R R R R   R   R |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|   r   R r       |%133|     X r r X     |%132|       d R R     |%131| R R R R   e   R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r r r |%137|   R   r r   r   |%136|     X     X     |%135|                 |%134|           D     |%133|     X     X e   |%132| R R R R R h     |%131|           c     |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|               d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r E r r E   |%137|     E         d |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r r r r r r |%137|   R   r r   r   |%136|     X     X     |%135|                 |%134|                 |%133|     X     X     |%132|                 |%131|           c     |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138|   r r r r r r r |%137|     R r r   r   |%136|     X     X     |%135|                 |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X     X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X C   X     |%135|                 |%134|     R           |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   r r r r r |%137|       r r   r   |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|       R R       |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r r r E   |%137|       R R     r |%136|     X C   X     |%135|                 |%134|     R           |%133|     X   r X     |%132|                 |%131| R R R   R R R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r d e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|     R           |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2b %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|     R           |%133|   r X   r X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   r   r   |%136|   e r   r X     |%135|       R R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   E   r   |%136|   e r   r X     |%135|       R R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   E   r   |%136|   e r   r X     |%135|       R R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e e   e   r   |%136|   e e R M X     |%135|         R       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r e H   r r r |%137|   e r   r   r   |%136|   e r r   X     |%135|         R       |%134|       R         |%133|     X     X     |%132|                 |%131|     R         R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|             D   |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|     E d R   C e |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R   C e |%136|                 |%135|                 |%134|         D       |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r   r r r |%137|       d R     e |%136|             C   |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H d r r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r d H r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r D   r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r D H r r |%137|       d R       |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r r D d r r |%137|       r R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   D d r r |%137|       h R H     |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   D d r r |%137|       h R     H |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r   D d r r |%137|       h R     H |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   D D d r r |%137|       h R   H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r r D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r E D c   r r |%137|       h R h H   |%136|         C       |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13"};
        String[] text2 = new String[]{"2w %13 +-----------------+%138| r r   E D   e r |%137|     R h R h H   |%136|       R         |%135|     r           |%134|         h     H |%133|   e e           |%132|         M       |%131| h               |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13"};
        TestForGoal test = new TestForGoal();
        ArimaaEngine engine = new ArimaaEngine();
        use_debug = true;
        for (String position_text : text2) {
            GameState position = new GameState(position_text);
            TestForGoal.test_position(position, test, engine);
        }
        System.out.println("Agree: " + agree);
        System.out.println("Disagree: " + disagree);
    }

    private static void test_position(GameState position, TestForGoal test, ArimaaEngine engine) {
        System.out.println(position.toBoardString());
        System.out.println(position.toEPDString());
        System.out.println(position.toSetupString());
        position.clear_trap_squares();
        System.out.println(position.toBoardString());
        boolean result = test.test(position);
        engine.resetStats();
        boolean result2 = engine.can_player_goal(position);
        System.out.println("FINAL: " + result + " Engine: " + result2);
        System.out.println(engine.getStats());
        System.out.flush();
        if (result == result2) {
            ++agree;
        } else {
            ++disagree;
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            long goal_bb;
            TestForGoal.goal_pattern_bb[i][0] = goal_bb = 1L << i;
            long result = goal_bb;
            result |= (goal_bb & 0x7F7F7F7F7F7F7F7FL) << 1;
            TestForGoal.goal_pattern_bb[i][1] = result |= (goal_bb & 0xFEFEFEFEFEFEFEFEL) >>> 1;
            TestForGoal.goal_pattern_bb[i][2] = result ^ goal_bb;
            result = goal_bb;
            result |= (goal_bb & 0xFFFFFFFFFFFFFFL) << 8;
            TestForGoal.goal_pattern_bb[i][3] = result |= (goal_bb & 0xFFFFFFFFFFFFFF00L) >>> 8;
            TestForGoal.goal_pattern_bb[i][4] = result ^ goal_bb;
            result = GameState.touching_bb(goal_pattern_bb[i][4]);
            TestForGoal.goal_pattern_bb[i][5] = result ^= goal_bb;
            TestForGoal.goal_pattern_bb[i][6] = goal_pattern_bb[i][4] | goal_pattern_bb[i][5];
            result = GameState.touching_bb(goal_pattern_bb[i][6]);
            result &= 0xFFFFFFFFFFFFFFL;
            TestForGoal.goal_pattern_bb[i][7] = result &= 0xFFFFFFFFFFFFFF00L;
            result = GameState.touching_bb(goal_pattern_bb[i][5]);
            TestForGoal.goal_pattern_bb[i][8] = result &= goal_pattern_bb[i][5] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        agree = 0L;
        disagree = 0L;
    }
}

