/*
 * Decompiled with CFR 0.152.
 */
package ai_util;

import java.util.Arrays;
import java.util.Random;

public class RepetitionHashTable {
    private static long hash_mask = 1048575L;
    private static long[] hash_table = new long[0x100000];
    private static long[] hash_age_table = new long[256];
    private static int hash_current_age = 0;

    public RepetitionHashTable(int size_in_bits) {
    }

    public void increaseAge() {
        if ((hash_current_age = (hash_current_age + 1) % hash_age_table.length) == 0) {
            Arrays.fill(hash_table, 0L);
            ++hash_current_age;
        }
    }

    public boolean isRepetition(long hash_code) {
        int index = (int)(hash_code % (hash_mask - 7L));
        if (index < 0) {
            index = (int)((long)index + hash_mask);
        }
        long age_mask = 255L;
        long target = hash_code & (age_mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)hash_current_age;
        boolean repeated = false;
        while ((long)hash_current_age == (hash_table[index] & age_mask)) {
            if (target == hash_table[index]) {
                return true;
            }
            index = (index + 1) % (int)hash_mask;
        }
        RepetitionHashTable.hash_table[index] = target;
        return false;
    }

    static {
        Random random = new Random(123456L);
        for (int i = 0; i < hash_age_table.length; ++i) {
            RepetitionHashTable.hash_age_table[i] = random.nextLong();
        }
    }
}

