/*
 * Decompiled with CFR 0.152.
 */
package ai_util;

import ai_util.Util;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TimeControl {
    private long nominal_search_time = Long.MAX_VALUE;
    private long panic_search_time = Long.MAX_VALUE;
    private long mate_search_time = Long.MAX_VALUE;
    private boolean isPonderSearch = false;
    private int score_threshold = -50;
    private int search_depth_threshold = 4;
    private long search_start_time = 0L;

    public void setThreshold(int threshold) {
        this.score_threshold = threshold;
    }

    public void setSearchDepthThreshold(int search_depth_threshold) {
        this.search_depth_threshold = search_depth_threshold;
    }

    public boolean isPonderSearch() {
        return this.isPonderSearch;
    }

    public void setPondering(boolean isPonderSearch) {
        this.isPonderSearch = isPonderSearch;
    }

    public void setFixedSearchTime(long time_ms) {
        this.nominal_search_time = time_ms;
        this.panic_search_time = time_ms;
        this.mate_search_time = time_ms;
    }

    public void setNominalSearchTime(long time_ms) {
        this.nominal_search_time = time_ms;
    }

    public void setPanicSearchTime(long time_ms) {
        this.panic_search_time = time_ms;
        this.mate_search_time = time_ms;
    }

    public void setMateSearchTime(long time_ms) {
        this.mate_search_time = time_ms;
    }

    public void setSearchStartTime() {
        this.search_start_time = System.currentTimeMillis();
    }

    public long getElapsedSearchTime() {
        long current_time = System.currentTimeMillis();
        return current_time - this.search_start_time;
    }

    public long nominalTimeLimit() {
        return this.nominal_search_time;
    }

    public long maxTimeLimit() {
        return this.panic_search_time;
    }

    public boolean isEasyMoveTimeOK() {
        return !this.isPonderSearch && this.getElapsedSearchTime() > this.nominal_search_time / 3L;
    }

    public boolean isTimeExpired(int score) {
        return this.isTimeExpired(score, 99999);
    }

    public boolean isTimeExpired(int score, int search_depth) {
        if (this.isPonderSearch) {
            return false;
        }
        long current_time_limit = this.nominal_search_time;
        if (score <= this.score_threshold || search_depth <= this.search_depth_threshold) {
            current_time_limit = this.panic_search_time;
        }
        if (score <= -30000) {
            current_time_limit = this.mate_search_time;
        }
        return this.getElapsedSearchTime() > current_time_limit;
    }

    public String command(String command) {
        String result = "time: unknown command";
        StringTokenizer tokenizer = new StringTokenizer(command, "= ", false);
        ArrayList<String> token_list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            token_list.add(tokenizer.nextToken().toLowerCase());
        }
        try {
            String temp;
            String token = (String)token_list.get(0);
            if (token.equals("status")) {
                result = this.toString();
            }
            if (token.equals("max_st")) {
                temp = (String)token_list.get(1);
                this.panic_search_time = Long.parseLong(temp);
                result = "Max Search Time: " + Util.toTimeString(this.panic_search_time);
            }
            if (token.equals("nom_st")) {
                temp = (String)token_list.get(1);
                this.nominal_search_time = Long.parseLong(temp);
                result = "Nominal Search Time: " + Util.toTimeString(this.nominal_search_time);
            }
        }
        catch (Exception e) {
            result = "time: invalid command syntax";
        }
        return result;
    }

    public String toString() {
        String result = "";
        result = result + "Time Control Status\n";
        result = result + "Nominal Search Time: " + Util.toTimeString(this.nominal_search_time) + "\n";
        result = result + "Max Search Time: " + Util.toTimeString(this.panic_search_time) + "\n";
        result = result + "isPonderSearch: " + this.isPonderSearch;
        return result;
    }
}

