/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.Util;
import arimaa3.ArimaaBaseClass;
import arimaa3.GameState;
import arimaa3.MoveList;
import java.util.StringTokenizer;

public class ArimaaMove
extends ArimaaBaseClass
implements Comparable {
    public long[] piece_bb = new long[12];
    public int steps;
    public int move_ordering_value;
    private static final String[] piece_text = new String[]{"R", "r", "C", "c", "D", "d", "H", "h", "M", "m", "E", "e"};
    private long low_compressed;
    private long high_compressed;
    private static final String[] col_text = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};

    public ArimaaMove() {
    }

    public int compareTo(Object o) {
        ArimaaMove that = (ArimaaMove)o;
        return that.move_ordering_value - this.move_ordering_value;
    }

    public void clear() {
        this.piece_bb[0] = 0L;
        this.piece_bb[1] = 0L;
        this.piece_bb[2] = 0L;
        this.piece_bb[3] = 0L;
        this.piece_bb[4] = 0L;
        this.piece_bb[5] = 0L;
        this.piece_bb[6] = 0L;
        this.piece_bb[7] = 0L;
        this.piece_bb[8] = 0L;
        this.piece_bb[9] = 0L;
        this.piece_bb[10] = 0L;
        this.piece_bb[11] = 0L;
        this.steps = 0;
        this.move_ordering_value = 0;
    }

    public void add(ArimaaMove one, ArimaaMove two) {
        for (int i = 0; i < 12; ++i) {
            this.piece_bb[i] = one.piece_bb[i] ^ two.piece_bb[i];
        }
        this.steps = one.steps + two.steps;
        this.move_ordering_value = one.move_ordering_value + two.move_ordering_value;
    }

    public void copy(ArimaaMove one) {
        for (int i = 0; i < 12; ++i) {
            this.piece_bb[i] = one.piece_bb[i];
        }
        this.steps = one.steps;
        this.move_ordering_value = one.move_ordering_value;
    }

    public void difference(GameState start, GameState end) {
        for (int i = 0; i < 12; ++i) {
            this.piece_bb[i] = start.piece_bb[i] ^ end.piece_bb[i];
        }
        this.steps = end.total_steps - start.total_steps;
        this.move_ordering_value = 0;
    }

    public String getPieceText(int index) {
        assert (index >= 0 && index <= 63);
        String result = " ";
        long piece_mask = 1L << index;
        for (int i = 0; i < 12; ++i) {
            if ((this.piece_bb[i] & piece_mask) != piece_mask) continue;
            result = piece_text[i];
            break;
        }
        return result;
    }

    public long getSetBits() {
        long result = 0L;
        for (int i = 0; i < 12; ++i) {
            result |= this.piece_bb[i];
        }
        return result;
    }

    public long getSetBits(int player) {
        assert (player == 0 || player == 1);
        long result = 0L;
        for (int i = player; i < 12; i += 2) {
            result |= this.piece_bb[i];
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArimaaMove)) {
            return false;
        }
        ArimaaMove that = (ArimaaMove)o;
        if (this.steps != that.steps) {
            return false;
        }
        for (int i = 0; i < 12; ++i) {
            if (this.piece_bb[i] == that.piece_bb[i]) continue;
            return false;
        }
        return true;
    }

    public String toBoardString() {
        String result = "";
        result = result + " \n +-----------------+\n";
        for (int row = 7; row >= 0; --row) {
            result = result + (row + 1) + "|";
            for (int col = 0; col <= 7; ++col) {
                int board_index = row * 8 + col;
                result = result + " " + this.getPieceText(board_index);
            }
            result = result + " |\n";
        }
        result = result + " +-----------------+\n";
        result = result + "   a b c d e f g h\n";
        return result;
    }

    public long getLowCompressed() {
        return this.low_compressed;
    }

    public long getHighCompressed() {
        return this.high_compressed;
    }

    public void computeCompressed() {
        this.low_compressed = 0L;
        this.high_compressed = 0L;
        long total_bits = 0L;
        for (int piece_type = 0; piece_type < 12; ++piece_type) {
            long temp_bb = this.piece_bb[piece_type];
            while (temp_bb != 0L) {
                long lsb_bb = temp_bb & (temp_bb ^ 0xFFFFFFFFFFFFFFFFL);
                temp_bb ^= lsb_bb;
                int index = Util.FirstOne(lsb_bb);
                if (total_bits < 6L) {
                    this.low_compressed |= (long)(piece_type << (int)(4L + 10L * total_bits));
                    this.low_compressed |= (long)(index << (int)(10L + 10L * total_bits));
                } else {
                    this.high_compressed |= (long)(piece_type << (int)(4L + 10L * (total_bits - 6L)));
                    this.high_compressed |= (long)(index << (int)(10L + 10L * (total_bits - 6L)));
                }
                ++total_bits;
            }
        }
        this.low_compressed |= total_bits;
        this.high_compressed |= (long)this.steps;
    }

    public void fromCompressed(long low_bits, long high_bits) {
        int index;
        int piece_type;
        int i;
        this.clear();
        this.steps = (int)(high_bits & 0xFL);
        int num_set_bits = (int)(low_bits & 0xFL);
        int low_words = num_set_bits <= 6 ? num_set_bits : 6;
        int high_words = num_set_bits <= 6 ? 0 : num_set_bits - 6;
        for (i = 0; i < low_words; ++i) {
            piece_type = (int)(low_bits >>> 4 + i * 10 & 0xFL);
            index = (int)(low_bits >>> 10 + i * 10 & 0x3FL);
            int n = piece_type;
            this.piece_bb[n] = this.piece_bb[n] | 1L << index;
        }
        for (i = 0; i < high_words; ++i) {
            piece_type = (int)(high_bits >>> 4 + i * 10 & 0xFL);
            index = (int)(high_bits >>> 10 + i * 10 & 0x3FL);
            int n = piece_type;
            this.piece_bb[n] = this.piece_bb[n] | 1L << index;
        }
    }

    public String toString() {
        String result = "{" + this.steps + "}";
        boolean is_pass_move = true;
        for (int i = 0; i < 12; ++i) {
            int index;
            if (this.piece_bb[i] == 0L) continue;
            is_pass_move = false;
            String temp = piece_text[i];
            for (long temp_bb = this.piece_bb[i]; temp_bb != 0L; temp_bb ^= 1L << index) {
                index = Util.FirstOne(temp_bb);
                temp = temp + ArimaaMove.getStringIndex(index);
            }
            result = result + temp + " ";
        }
        if (is_pass_move) {
            result = result + "pass";
        }
        return result;
    }

    public static int piece_type_from_text(String text) {
        int result = -1;
        for (int i = 0; i < piece_text.length; ++i) {
            if (!text.equals(piece_text[i])) continue;
            result = i;
            break;
        }
        assert (result != -1);
        return result;
    }

    public ArimaaMove(String move_text) {
        String move;
        this.clear();
        this.steps = 4;
        StringTokenizer tokenizer = new StringTokenizer(move_text);
        while (tokenizer.hasMoreTokens() && !(move = tokenizer.nextToken()).equals("pass")) {
            int piece_type = ArimaaMove.piece_type_from_text(move.substring(0, 1));
            assert (piece_type >= 0 && piece_type <= 11);
            String col_text = "abcdefgh";
            int col = col_text.indexOf(move.substring(1, 2));
            int row = Integer.parseInt(move.substring(2, 3)) - 1;
            String dir_text = "nsewx";
            int direction = dir_text.indexOf(move.substring(3, 4));
            if (direction == 4) {
                int index = row * 8 + col;
                int n = piece_type;
                this.piece_bb[n] = this.piece_bb[n] ^ 1L << index;
            }
            if (direction == 4) continue;
            int from_index = row * 8 + col;
            int[] dir_offset = new int[]{8, -8, 1, -1, 0};
            int to_index = from_index + dir_offset[direction];
            int n = piece_type;
            this.piece_bb[n] = this.piece_bb[n] ^ 1L << from_index;
            int n2 = piece_type;
            this.piece_bb[n2] = this.piece_bb[n2] ^ 1L << to_index;
        }
    }

    public static String getStringIndex(int index) {
        String result = "OB";
        if (index >= 0 && index <= 63) {
            int row = index / 8 + 1;
            int col = index % 8;
            result = col_text[col] + row;
        }
        return result;
    }

    public String getStringDirection(int from_index, int to_index) {
        String result = "";
        if (to_index - from_index == 1) {
            result = "e";
        } else if (to_index - from_index == -1) {
            result = "w";
        } else if (to_index - from_index == 8) {
            result = "n";
        } else if (to_index - from_index == -8) {
            result = "s";
        } else assert (false);
        return result;
    }

    public String toOfficialArimaaNotation(GameState gs) {
        String result = "";
        if (this.getSetBits() == 0L) {
            return "pass";
        }
        if (this.steps == 1) {
            long set_bits = this.getSetBits();
            result = result + this.calculate_step(gs, set_bits, gs.player);
        }
        if (this.steps == 2) {
            long enemy_bb;
            long player_bb = this.getSetBits(gs.player);
            long common_bb = player_bb & (enemy_bb = this.getSetBits(gs.enemy));
            if (common_bb == 0L) {
                common_bb = ArimaaMove.touching_bb(enemy_bb) & 0x240000240000L;
            }
            if ((common_bb & gs.colour_bb[gs.player]) != 0L) {
                result = result + this.calculate_step(gs, player_bb, gs.player);
                result = result + " " + this.calculate_step(gs, enemy_bb, gs.enemy);
            } else {
                result = result + this.calculate_step(gs, enemy_bb, gs.enemy);
                result = result + " " + this.calculate_step(gs, player_bb, gs.player);
            }
        }
        return result;
    }

    private String calculate_step(GameState gs, long set_bits, int colour) {
        String result = "";
        int num_set_bits = Util.PopCnt(set_bits);
        if (num_set_bits == 2) {
            int piece_type = gs.getPieceType(set_bits & (gs.empty_bb ^ 0xFFFFFFFFFFFFFFFFL), colour);
            int index1 = Util.FirstOne(set_bits);
            int index2 = Util.FirstOne(set_bits ^= 1L << index1);
            long test_bb = 1L << index2;
            int from_index = index1;
            int to_index = index2;
            if ((test_bb & gs.colour_bb[colour]) != 0L) {
                from_index = index2;
                to_index = index1;
            }
            result = result + piece_text[piece_type];
            result = result + ArimaaMove.getStringIndex(from_index);
            result = result + this.getStringDirection(from_index, to_index);
        } else if (num_set_bits == 1) {
            int from_index = Util.FirstOne(set_bits);
            int to_index = TRAP_INDEX[trap_number[from_index]];
            int piece_type = gs.getPieceType(set_bits, colour);
            result = result + piece_text[piece_type];
            result = result + ArimaaMove.getStringIndex(from_index);
            result = result + this.getStringDirection(from_index, to_index);
            result = result + " " + piece_text[piece_type];
            result = result + ArimaaMove.getStringIndex(to_index);
            result = result + "x";
        } else if (num_set_bits == 3) {
            long captured_bb = set_bits & 0x240000240000L;
            assert (Util.PopCnt(captured_bb) == 1);
            int piece_type = gs.getPieceType((set_bits ^= captured_bb) & (gs.empty_bb ^ 0xFFFFFFFFFFFFFFFFL), colour);
            int index1 = Util.FirstOne(set_bits);
            int index2 = Util.FirstOne(set_bits ^= 1L << index1);
            long test_bb = 1L << index2;
            int from_index = index1;
            int to_index = index2;
            if ((test_bb & gs.empty_bb) == 0L) {
                from_index = index2;
                to_index = index1;
            }
            result = result + piece_text[piece_type];
            result = result + ArimaaMove.getStringIndex(from_index);
            result = result + this.getStringDirection(from_index, to_index);
            int captured_piece_type = gs.getPieceType(captured_bb, colour);
            int captured_index = Util.FirstOne(captured_bb);
            result = result + " " + piece_text[captured_piece_type];
            result = result + ArimaaMove.getStringIndex(captured_index);
            result = result + "x";
        }
        return result;
    }

    public static void main(String[] args) {
        String[] tests = new String[]{"2w %13 +-----------------+%138| r r D   r r h r |%137| e e r R r   r   |%136|   D R d H       |%135|   e R M e     e |%134|       R         |%133|             M   |%132|             R   |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13TS: 16%13", "17b %13 +-----------------+%138| r r   c c r   r |%137|     r     d     |%136| r H             |%135|                 |%134|           E r   |%133| R H       R M d |%132|           e R r |%131|   R   R C h   R |%13 +-----------------+%13   a b c d e f g h%13", "26w %13 +-----------------+%138|   r r d H r r r |%137| r     c E R   r |%136|   h             |%135|                 |%134|     m           |%133|       r         |%132|     M e   R     |%131| R     R D   R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r         r   |%137| r R E   r   M r |%136| C m h     X E   |%135|   H   d c       |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   e r r r r |%137|       r r   r   |%136|     X C   X     |%135|     R           |%134|                 |%133|     X     X     |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r     r r r r |%137| e e r C r   r   |%136|   D R R   X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|     r r r r M r |%137| r         c r   |%136|       d d       |%135| h D c m         |%134|     E e         |%133|     r           |%132|   R h         H |%131| R R   H R R R R |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|         d r     |%137|   r     M r e   |%136|   d   c   R     |%135|       c   E   R |%134| r   H         r |%133| D h R   d   C   |%132| r D m   R   r C |%131| R R       R   R |%13 +-----------------+%13   a b c d e f g h%13", "31b %13 +-----------------+%138|   c   d     c   |%137|         d r     |%136|               C |%135|   r             |%134|             r h |%133|   M   R   r r R |%132| R h   m E e H   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "33b %13 +-----------------+%138|         d r     |%137|   r     M r e   |%136|   d   c     R   |%135|       c   E   R |%134| r   H         r |%133| D h R   d   r C |%132| r D m   C       |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13", "33w %13 +-----------------+%138|               H |%137| r         M e   |%136|   d   c     R   |%135|       c     E R |%134| r   H         r |%133| D h R   d   r C |%132| r D m         C |%131| R R     R   R R |%13 +-----------------+%13   a b c d e f g h%13", "2w %13 +-----------------+%138| r r   H r r r r |%137|   e   C r   r   |%136|   e X     X     |%135|   e R M e       |%134|       R         |%133|     X     X     |%132|                 |%131|       R       R |%13 +-----------------+%13   a b c d e f g h%13", "38b %13 +-----------------+%138| r   r   r d r r |%137| d           R   |%136|       E e       |%135|       R   m     |%134|     D R     R r |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "38w %13 +-----------------+%138| r r r r r r r r |%137| R R R R R   C h |%136|         H   e M |%135|               R |%134|           E     |%133|             D   |%132|                 |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "20w %13 +-----------------+%138|                 |%137|   r             |%136|   h   E M   r   |%135|   D d     H r   |%134|       H   c     |%133|       C     C   |%132| R r     D     R |%131| R R R     R R R |%13 +-----------------+%13   a b c d e f g h%13", "8b %13 +-----------------+%138| r   r   r d r r |%137| d           R   |%136|       E e       |%135|     D R   m     |%134|         R   R r |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "37w %13 +-----------------+%138| r   r   r d r r |%137| d           R   |%136|       E e       |%135|       R   m     |%134|     D R R     r |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "23b %13 +-----------------+%138| r r         r r |%137| r   r     r   r |%136|                 |%135|     m E   R     |%134|       C         |%133|         M   D   |%132|     e     H     |%131| R R       R R R |%13 +-----------------+%13   a b c d e f g h%13", "37b %13 +-----------------+%138| r   r   r d r r |%137| d           R   |%136|       E e       |%135|     R     m     |%134|     D   R   R r |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "36b %13 +-----------------+%138| r r     r d r r |%137| d           R r |%136|       E e       |%135|       R   m     |%134|     D R R       |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "37b %13 +-----------------+%138| r r     r d r r |%137|   d         R   |%136|       E e       |%135|       R   m r   |%134|     D   R   R   |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13", "37b %13 +-----------------+%138| r r     r d r r |%137|   d         R   |%136|       E e       |%135|     R     m r   |%134|     D   R   R   |%133|   R           R |%132| R               |%131|   C             |%13 +-----------------+%13   a b c d e f g h%13"};
        MoveList move_list = new MoveList(500);
        for (String text : tests) {
            GameState gs = new GameState(text);
            move_list.clear();
            gs.genDragMoves(move_list, -1L, -1L, -1L, -1L);
            System.out.println(gs.toBoardString());
            for (ArimaaMove move : move_list) {
                System.out.println(move);
                System.out.println(move.toOfficialArimaaNotation(gs));
            }
        }
    }
}

