/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import arimaa3.ArimaaBaseClass;
import arimaa3.GameState;
import java.util.Random;

public class FirstMove
extends ArimaaBaseClass {
    private Random random = null;
    private GameState position = null;

    public String getFirstMove(GameState start_position, long random_seed) {
        String result = "";
        this.random = new Random(random_seed);
        this.position = start_position;
        InternalClass temp = new InternalClass();
        if (this.position.getSideToMove() == 0) {
            result = temp.getFirstMoveWhite();
        }
        if (this.position.getSideToMove() == 1) {
            result = temp.getFirstMoveBlack();
        }
        return result;
    }

    public static void main(String[] args) {
        String[] text4 = new String[]{"1w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|                 |%132|                 |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "1b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|                 |%132| C D H M E H D C |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13", "1b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|                 |%132| C D H C R H D M |%131| R R R E R R R R |%13 +-----------------+%13   a b c d e f g h%13", "1b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|                 |%132| M D H C E H D C |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13", "1b %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|                 |%133|                 |%132| C M D H E D H C |%131| R R R R R R R R |%13 +-----------------+%13   a b c d e f g h%13"};
        FirstMove first_move = new FirstMove();
        for (String pos : text4) {
            GameState position = new GameState(pos);
            int seed = 1773;
            String result = first_move.getFirstMove(position, seed);
            System.out.println(position.toBoardString());
            System.out.println(result);
        }
    }

    class InternalClass {
        private final boolean F = false;
        private final boolean T = true;
        boolean[] first_elephant = new boolean[]{false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false};
        boolean[] first_camel = new boolean[]{false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false};
        boolean[] first_horse = new boolean[]{false, true, false, false, false, false, true, false, false, false, false, false, false, false, false, false};
        boolean[] first_dog = new boolean[]{false, false, true, true, true, true, false, false, false, false, false, true, true, false, false, false};
        boolean[] first_cat = new boolean[]{false, false, true, true, true, true, false, false, false, false, false, true, true, false, false, false};
        boolean[] first_rabbit = new boolean[]{true, false, true, true, true, true, false, true, true, true, true, true, true, true, true, true};
        boolean[][] first_all = new boolean[][]{this.first_elephant, this.first_camel, this.first_horse, this.first_dog, this.first_cat, this.first_rabbit};
        private final String[] col_text = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};

        InternalClass() {
        }

        private int getValidIndex(boolean[] valid_set) {
            int index = -1;
            while (index == -1) {
                int temp = FirstMove.this.random.nextInt(valid_set.length);
                if (!valid_set[temp]) continue;
                index = temp;
            }
            return index;
        }

        private void setIndexFalse(boolean[][] data, int column) {
            for (int i = 0; i < data.length; ++i) {
                boolean[] piece = data[i];
                piece[column] = false;
            }
        }

        private String getIndexText(int index, int colour) {
            assert (colour == 0 || colour == 1);
            assert (index >= 0 && index <= 15);
            String result = "";
            result = result + this.col_text[index % 8];
            if (colour == 0) {
                result = result + (index <= 7 ? "2" : "1");
            }
            if (colour == 1) {
                result = result + (index <= 7 ? "7" : "8");
            }
            return result;
        }

        private String getRabbitLocations(int colour) {
            String result = "";
            String rabbit_letter = colour == 0 ? "R" : "r";
            for (int i = 0; i < this.first_rabbit.length; ++i) {
                if (!this.first_rabbit[i]) continue;
                result = result + " " + rabbit_letter + this.getIndexText(i, colour);
            }
            return result;
        }

        private String getFirstMoveWhite() {
            String result = "";
            int column = this.getValidIndex(this.first_elephant);
            result = result + "E" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_camel);
            result = result + " M" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_horse);
            result = result + " H" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_horse);
            result = result + " H" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_dog);
            result = result + " D" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_dog);
            result = result + " D" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_cat);
            result = result + " C" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_cat);
            result = result + " C" + this.getIndexText(column, 0);
            this.setIndexFalse(this.first_all, column);
            result = result + this.getRabbitLocations(0);
            return result;
        }

        private int getWhiteElephantIndex() {
            int result = -1;
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 8; ++col) {
                    int piece_type = FirstMove.this.position.getPieceType(FirstMove.this.position.getIndex(row, col));
                    if (piece_type != 10) continue;
                    result = (1 - row) * 8 + col;
                }
            }
            return result;
        }

        private int getWhiteCamelIndex() {
            int result = -1;
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 8; ++col) {
                    int piece_type = FirstMove.this.position.getPieceType(FirstMove.this.position.getIndex(row, col));
                    if (piece_type != 8) continue;
                    result = (1 - row) * 8 + col;
                }
            }
            return result;
        }

        private int getWhiteHorseIndex1() {
            int result = -1;
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 8; ++col) {
                    int piece_type = FirstMove.this.position.getPieceType(FirstMove.this.position.getIndex(row, col));
                    if (piece_type != 6) continue;
                    result = (1 - row) * 8 + col;
                }
            }
            return result;
        }

        private int getWhiteHorseIndex2() {
            int result = -1;
            for (int row = 1; row >= 0; --row) {
                for (int col = 7; col >= 0; --col) {
                    int piece_type = FirstMove.this.position.getPieceType(FirstMove.this.position.getIndex(row, col));
                    if (piece_type != 6) continue;
                    result = (1 - row) * 8 + col;
                }
            }
            return result;
        }

        private String getFirstMoveBlack() {
            String result = "";
            int e1_index = this.getWhiteElephantIndex();
            int m1_index = this.getWhiteCamelIndex();
            int h1_index = this.getWhiteHorseIndex1();
            int h2_index = this.getWhiteHorseIndex2();
            if (e1_index <= 7) {
                this.first_elephant[e1_index] = false;
                this.first_camel[e1_index] = false;
            }
            int column = this.getValidIndex(this.first_elephant);
            result = result + "e" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_horse);
            result = result + " h" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_horse);
            result = result + " h" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_camel);
            result = result + " m" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_dog);
            result = result + " d" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_dog);
            result = result + " d" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_cat);
            result = result + " c" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            column = this.getValidIndex(this.first_cat);
            result = result + " c" + this.getIndexText(column, 1);
            this.setIndexFalse(this.first_all, column);
            result = result + this.getRabbitLocations(1);
            return result;
        }
    }
}

