/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import ai_util.RepetitionHashTable;
import ai_util.Util;
import arimaa3.ArimaaBaseClass;
import arimaa3.ArimaaMove;
import arimaa3.GameState;
import arimaa3.GenSteps;
import arimaa3.MoveList;

public class GenCaptures
extends ArimaaBaseClass {
    private final boolean createText = false;
    private MoveList[] move_list_stack = new MoveList[5];
    private GameState[] gs_stack = new GameState[5];
    private int stack_depth;
    private MoveList move_data;
    private GameState saved_initial_position;
    private RepetitionHashTable repetition;
    private GenSteps gen_steps;
    private long trap_precondition_calls;
    private long trap_precondition_false;
    private long gen_capture_calls;
    private boolean complete_turn;

    public GenCaptures() {
        int i;
        for (i = 0; i < this.gs_stack.length; ++i) {
            this.gs_stack[i] = new GameState();
        }
        for (i = 0; i < this.move_list_stack.length; ++i) {
            this.move_list_stack[i] = new MoveList(1000);
        }
        this.saved_initial_position = null;
        this.repetition = new RepetitionHashTable(19);
        this.gen_steps = new GenSteps();
        this.trap_precondition_calls = 0L;
        this.trap_precondition_false = 0L;
        this.gen_capture_calls = 0L;
    }

    public void genCaptures(GameState initial_position, MoveList move_list, boolean complete_turn) {
        this.complete_turn = complete_turn;
        initial_position.compute_tertiary_bitboards();
        this.move_data = move_list;
        ++this.gen_capture_calls;
        this.saved_initial_position = initial_position;
        this.stack_depth = -1;
        this.repetition.increaseAge();
        for (int i = 0; i < 4; ++i) {
            if (!this.test_trap_precondition(initial_position, i)) continue;
            this.test_trap(initial_position, i);
        }
    }

    public String getStats() {
        String result = "";
        result = result + "Gen capture calls: " + this.gen_capture_calls + "\n";
        result = result + Util.ProbStats("Trap Pre", this.trap_precondition_calls, this.trap_precondition_false);
        return result;
    }

    public void resetStats() {
        this.trap_precondition_calls = 0L;
        this.trap_precondition_false = 0L;
        this.gen_capture_calls = 0L;
    }

    private boolean test_trap_precondition(GameState game, int trap_id) {
        ++this.trap_precondition_calls;
        if ((TOUCH_TRAP[trap_id] & game.piece_bb[10 + game.enemy]) != 0L) {
            ++this.trap_precondition_false;
            return false;
        }
        long e_touch_bb = game.colour_bb[game.enemy] & TOUCH_TRAP[trap_id];
        int e_touch = Util.PopCnt(e_touch_bb);
        if (e_touch >= 3) {
            ++this.trap_precondition_false;
            return false;
        }
        long e_touch_non_dominated_bb = e_touch_bb & (game.dominated_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL);
        int e_touch_non_dominated = Util.PopCnt(e_touch_non_dominated_bb);
        if (e_touch_non_dominated >= 1 && e_touch >= 2) {
            ++this.trap_precondition_false;
            return false;
        }
        if (game.getStepsRemaining() <= 3) {
            if (e_touch == 0) {
                ++this.trap_precondition_false;
                return false;
            }
            if (e_touch >= 2) {
                ++this.trap_precondition_false;
                return false;
            }
            if (e_touch_non_dominated >= 1) {
                ++this.trap_precondition_false;
                return false;
            }
        }
        return true;
    }

    private void test_trap(GameState game, int trap_id) {
        long enemy_bb = game.colour_bb[game.enemy];
        long player_bb = game.colour_bb[game.player];
        int steps_available = game.getStepsRemaining();
        if ((enemy_bb & TRAP[trap_id]) != 0L) {
            int extra_steps;
            long e_touch_bb = game.colour_bb[game.enemy] & TOUCH_TRAP[trap_id];
            int e_touch = Util.PopCnt(e_touch_bb);
            if (steps_available >= e_touch * 2) {
                this.try_drag_moves(game, e_touch_bb, -1L, trap_id);
            }
            if ((extra_steps = steps_available - 2 * e_touch) >= 1) {
                assert (Util.PopCnt(e_touch_bb) == 1);
                assert ((enemy_bb & TRAP[trap_id]) != 0L);
                int e_piece_type = game.getPieceType(e_touch_bb);
                long p_dest_bb = GameState.touching_bb(e_touch_bb);
                long p_stronger_bb = game.stronger_enemy_bb[e_piece_type];
                this.try_two_steps(game, p_stronger_bb, p_dest_bb, trap_id, extra_steps);
            }
        } else if ((enemy_bb & TOUCH_TRAP[trap_id]) != 0L) {
            int extra_steps;
            long e_touch_bb = game.colour_bb[game.enemy] & TOUCH_TRAP[trap_id];
            int e_touch = Util.PopCnt(e_touch_bb);
            if (steps_available >= 2) {
                long e_start_bb = TOUCH_TRAP[trap_id];
                long e_dest_bb = TRAP[trap_id];
                this.try_drag_moves(game, e_start_bb, e_dest_bb, trap_id);
            }
            if ((extra_steps = steps_available - 2 * e_touch) >= 1) {
                assert (Util.PopCnt(e_touch_bb) == 1);
                assert ((enemy_bb & TRAP[trap_id]) == 0L);
                int e_piece_type = game.getPieceType(e_touch_bb);
                long p_dest_bb = GenCaptures.touching_bb(e_touch_bb);
                long p_stronger_bb = game.stronger_enemy_bb[e_piece_type];
                this.try_two_steps(game, p_stronger_bb, p_dest_bb, trap_id, extra_steps);
            }
        } else if ((enemy_bb & TOUCH2_TRAP[trap_id]) != 0L && steps_available >= 4) {
            long e_start_bb = TOUCH2_TRAP[trap_id];
            long e_dest_bb = TOUCH_TRAP[trap_id];
            this.try_drag_moves(game, e_start_bb, e_dest_bb, trap_id);
        }
    }

    private void try_two_steps(GameState initial_position, long p_start_bb, long p_dest_bb, int trap_id, int extra_steps) {
        ++this.stack_depth;
        assert (initial_position.getStepsRemaining() >= 3);
        assert (extra_steps == 1 || extra_steps == 2);
        this.move_list_stack[this.stack_depth].clear();
        if (extra_steps == 2) {
            this.gen_steps.genTwoStepNF(initial_position, this.move_list_stack[this.stack_depth], p_start_bb, p_dest_bb);
        } else {
            this.gen_steps.genOneStepNF(initial_position, this.move_list_stack[this.stack_depth], p_start_bb, p_dest_bb);
        }
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            assert (move.steps == 2 || move.steps == 1);
            GameState new_position = this.gs_stack[this.stack_depth];
            new_position.playFull(move, initial_position);
            this.test_trap(new_position, trap_id);
        }
        --this.stack_depth;
    }

    private void try_drag_moves(GameState initial_position, long e_start_bb, long e_dest_bb, int trap_id) {
        ++this.stack_depth;
        assert (initial_position.getStepsRemaining() >= 2);
        this.move_list_stack[this.stack_depth].clear();
        initial_position.genDragMoves(this.move_list_stack[this.stack_depth], -1L, -1L, e_start_bb, e_dest_bb);
        for (ArimaaMove move : this.move_list_stack[this.stack_depth]) {
            int steps_remaining;
            assert (move.steps == 2);
            GameState new_position = this.gs_stack[this.stack_depth];
            new_position.playFull(move, initial_position);
            if (new_position.is_enemy_piece_captured(initial_position)) {
                this.record_move(new_position);
            }
            if ((steps_remaining = this.saved_initial_position.getStepsRemaining() + this.saved_initial_position.total_steps - new_position.total_steps) < 2) continue;
            this.test_trap(new_position, trap_id);
        }
        --this.stack_depth;
    }

    private void record_move(GameState new_position) {
        long hash_code = new_position.getPositionHash();
        if (!this.repetition.isRepetition(hash_code)) {
            ArimaaMove move = this.move_data.getMove();
            move.difference(this.saved_initial_position, new_position);
            assert (move.steps <= this.saved_initial_position.getStepsRemaining());
            if (this.complete_turn) {
                move.steps = this.saved_initial_position.getStepsRemaining();
            }
            move.move_ordering_value = 1002;
        }
    }

    public static void main(String[] args) {
        String[] text = new String[]{"27b %13 +-----------------+%138| r r r       r r |%137| C   c r       D |%136|   m   d M     R |%135| C     R   E h   |%134| R       H e     |%133|       h         |%132|             R   |%131|           R     |%13 +-----------------+%13   a b c d e f g h%13"};
        GenCaptures test = new GenCaptures();
        MoveList move_data = new MoveList(1000);
        for (String pos_text : text) {
            GameState position = new GameState(pos_text);
            System.out.println(position);
            test.genCaptures(position, move_data, false);
            System.out.println("Total moves: " + move_data.size());
            GameState temp = new GameState();
            System.out.println(move_data);
        }
        System.out.println(test.getStats());
    }
}

