/*
 * Decompiled with CFR 0.152.
 */
package arimaa3;

import arimaa3.ArimaaBaseClass;
import arimaa3.ArimaaMove;
import arimaa3.GameState;
import arimaa3.MoveList;

public class GenSteps
extends ArimaaBaseClass {
    private static final boolean use_debug = false;
    private MoveList[] move_list_stack = new MoveList[5];
    private GameState[] gs_stack = new GameState[5];

    public GenSteps() {
        int i;
        for (i = 0; i < this.gs_stack.length; ++i) {
            this.gs_stack[i] = new GameState();
        }
        for (i = 0; i < this.move_list_stack.length; ++i) {
            this.move_list_stack[i] = new MoveList(1000);
        }
    }

    private long getBadTrapSquares(GameState position) {
        long bad_trap_bb = 0L;
        long player_bb = position.colour_bb[position.player];
        for (int i = 0; i <= 3; ++i) {
            long ptest_bb = TOUCH_TRAP[i] & player_bb;
            if (!GenSteps.atMostOneBitSet(ptest_bb)) continue;
            bad_trap_bb |= TRAP[i];
        }
        return bad_trap_bb;
    }

    public void genOneStep(GameState initial_position, MoveList move_list, long p_start_bb, long p_dest_bb) {
        p_dest_bb &= this.getBadTrapSquares(initial_position) ^ 0xFFFFFFFFFFFFFFFFL;
        initial_position.genSlideMoves(move_list, p_start_bb, p_dest_bb &= initial_position.empty_bb);
    }

    public void genOneStepNF(GameState initial_position, MoveList move_list, long p_start_bb, long p_dest_bb) {
        long lsb2_bb;
        initial_position.genSlideMovesF(move_list, p_start_bb, p_dest_bb, false);
        initial_position.compute_tertiary_bitboards();
        for (long temp_bb = p_start_bb & p_dest_bb & initial_position.frozen_pieces_bb; temp_bb != 0L; temp_bb ^= lsb2_bb) {
            lsb2_bb = temp_bb & -temp_bb;
            long help_dest_bb = GenSteps.touching_bb(lsb2_bb);
            this.genOneStep(initial_position, move_list, -1L, help_dest_bb);
        }
    }

    public void genTwoStep(GameState initial_position, MoveList move_list, long p_start_bb, long p_dest_bb) {
        long bad_trap_bb = this.getBadTrapSquares(initial_position);
        long temp_dest_bb = p_dest_bb & (bad_trap_bb ^ 0xFFFFFFFFFFFFFFFFL);
        move_list.clear();
        initial_position.genAllMoves(move_list, p_start_bb &= initial_position.colour_bb[initial_position.player], temp_dest_bb, temp_dest_bb, -1L);
        long dest2_bb = p_dest_bb & initial_position.empty_bb;
        long inbetween_bb = GenSteps.touching_bb(p_start_bb) & GenSteps.touching_bb(dest2_bb) & (bad_trap_bb ^ 0xFFFFFFFFFFFFFFFFL);
        long temp_start_bb = GenSteps.touching_bb(inbetween_bb) & p_start_bb;
        this.move_list_stack[0].clear();
        initial_position.genSlideMoves(this.move_list_stack[0], temp_start_bb, inbetween_bb);
        for (ArimaaMove move : this.move_list_stack[0]) {
            this.gs_stack[0].play(move, initial_position);
            long new_start_bb = move.getSetBits() & inbetween_bb;
            long illegal_dest_bb = move.getSetBits() & p_start_bb;
            long bad_trap_bb2 = this.getBadTrapSquares(this.gs_stack[0]);
            long td_bb = dest2_bb & (illegal_dest_bb ^ 0xFFFFFFFFFFFFFFFFL) & (bad_trap_bb2 ^ 0xFFFFFFFFFFFFFFFFL);
            this.move_list_stack[1].clear();
            this.gs_stack[0].genSlideMoves(this.move_list_stack[1], new_start_bb, td_bb);
            for (ArimaaMove move2 : this.move_list_stack[1]) {
                move_list.getMove().add(move, move2);
            }
        }
        long temp_dest2_bb = GenSteps.touching_bb(p_start_bb) & p_dest_bb;
        long temp_start2_bb = GenSteps.touching_bb(p_dest_bb) & p_start_bb;
        initial_position.compute_tertiary_bitboards();
        this.move_list_stack[0].clear();
        initial_position.genSlideMoves(this.move_list_stack[0], temp_dest2_bb, -1L);
        for (ArimaaMove move : this.move_list_stack[0]) {
            this.gs_stack[0].play(move, initial_position);
            long new_dest_bb = move.getSetBits() & (initial_position.empty_bb ^ 0xFFFFFFFFFFFFFFFFL);
            long new_start_bb = GenSteps.touching_bb(new_dest_bb) & p_start_bb;
            this.move_list_stack[1].clear();
            this.gs_stack[0].genSlideMoves(this.move_list_stack[1], new_start_bb, new_dest_bb);
            for (ArimaaMove move2 : this.move_list_stack[1]) {
                move_list.getMove().add(move, move2);
            }
        }
        long supportable_trap_bb = bad_trap_bb & temp_dest2_bb;
        long temp_dest3_bb = GenSteps.touching_bb(supportable_trap_bb);
        this.move_list_stack[0].clear();
        initial_position.genSlideMoves(this.move_list_stack[0], -1L, temp_dest3_bb);
        for (ArimaaMove move : this.move_list_stack[0]) {
            this.gs_stack[0].play(move, initial_position);
            long temp7_bb = move.getSetBits() & initial_position.empty_bb;
            long new_dest_bb = GenSteps.touching_bb(temp7_bb) & 0x240000240000L;
            long new_start_bb = GenSteps.touching_bb(new_dest_bb) & p_start_bb;
            this.move_list_stack[1].clear();
            this.gs_stack[0].genSlideMoves(this.move_list_stack[1], new_start_bb, new_dest_bb);
            for (ArimaaMove move2 : this.move_list_stack[1]) {
                move_list.getMove().add(move, move2);
            }
        }
        long temp_dest4_bb = p_dest_bb & initial_position.empty_bb;
        long temp_start4_bb = p_start_bb & GenSteps.touching_bb(temp_dest4_bb);
        long frozen_bb = temp_start2_bb & initial_position.frozen_pieces_bb;
        long support_dest_bb = GenSteps.touching_bb(frozen_bb) & initial_position.empty_bb;
        this.move_list_stack[0].clear();
        initial_position.genSlideMoves(this.move_list_stack[0], -1L, support_dest_bb);
        for (ArimaaMove move : this.move_list_stack[0]) {
            this.gs_stack[0].play(move, initial_position);
            long temp7_bb = move.getSetBits() & initial_position.empty_bb;
            long new_start_bb = GenSteps.touching_bb(temp7_bb) & frozen_bb;
            long new_dest_bb = p_dest_bb;
            this.move_list_stack[1].clear();
            this.gs_stack[0].genSlideMoves(this.move_list_stack[1], new_start_bb, new_dest_bb);
            for (ArimaaMove move2 : this.move_list_stack[1]) {
                move_list.getMove().add(move, move2);
            }
        }
    }

    public void genTwoStepNF(GameState initial_position, MoveList move_list, long p_start_bb, long p_dest_bb) {
        long lsb2_bb;
        initial_position.compute_tertiary_bitboards();
        for (long temp_bb = p_start_bb & p_dest_bb & initial_position.frozen_pieces_bb; temp_bb != 0L; temp_bb ^= lsb2_bb) {
            lsb2_bb = temp_bb & -temp_bb;
            long help_dest_bb = GenSteps.touching_bb(lsb2_bb);
            this.genTwoStep(initial_position, move_list, -1L, help_dest_bb);
        }
        GameState temp_gs = this.gs_stack[2];
        this.move_list_stack[2].clear();
        initial_position.genSlideMovesF(this.move_list_stack[2], p_start_bb, p_dest_bb, true);
        for (ArimaaMove move : this.move_list_stack[2]) {
            temp_gs.play(move, initial_position);
            long slide_dest_bb = move.getSetBits() & initial_position.empty_bb;
            long help_dest_bb = GenSteps.touching_bb(slide_dest_bb);
            this.move_list_stack[3].clear();
            this.genOneStep(temp_gs, this.move_list_stack[3], -1L, help_dest_bb);
            for (ArimaaMove move2 : this.move_list_stack[3]) {
                move_list.getMove().add(move, move2);
            }
            temp_gs.compute_tertiary_bitboards();
            long slide_start_bb = move.getSetBits() & (initial_position.empty_bb ^ 0xFFFFFFFFFFFFFFFFL);
            long help_start_bb = GenSteps.touching_bb(slide_start_bb) & (initial_position.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL) & temp_gs.frozen_pieces_bb & initial_position.colour_bb[initial_position.player];
            if (help_start_bb == 0L) continue;
            this.move_list_stack[3].clear();
            initial_position.genSlideMoves(this.move_list_stack[3], help_start_bb, help_dest_bb);
            GameState temp2_gs = this.gs_stack[3];
            for (ArimaaMove move6 : this.move_list_stack[3]) {
                temp2_gs.play(move6, initial_position);
                this.move_list_stack[4].clear();
                temp2_gs.genSlideMoves(this.move_list_stack[4], slide_start_bb, slide_dest_bb);
                for (ArimaaMove move7 : this.move_list_stack[4]) {
                    move_list.getMove().add(move6, move7);
                }
            }
        }
        this.move_list_stack[2].clear();
        this.genTwoStep(initial_position, this.move_list_stack[2], p_start_bb, p_dest_bb);
        for (ArimaaMove move : this.move_list_stack[2]) {
            temp_gs.play(move, initial_position);
            temp_gs.compute_tertiary_bitboards();
            if (((temp_gs.frozen_pieces_bb ^ 0xFFFFFFFFFFFFFFFFL) & p_dest_bb & move.getSetBits()) == 0L) continue;
            move_list.getMove().copy(move);
        }
    }

    public static void main(String[] args) {
        String[] text = new String[]{"16w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|     e   M       |%134|                 |%133|   R   R         |%132|         d       |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|     e   M       |%134|                 |%133|         R        |%132|        d       |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|     e   M       |%134|       H         |%133|       d          |%132|        R       |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|           R     |%133|       d          |%132|        R C d   |%131|                 |%13 +-----------------+%13   a b c d e f g h%13", "16w %13 +-----------------+%138|                 |%137|                 |%136|                 |%135|                 |%134|          R      |%133|       d          |%132|        R C     |%131|                 |%13 +-----------------+%13   a b c d e f g h%13"};
        GenSteps test = new GenSteps();
        MoveList move_data = new MoveList(100000);
        for (String pos_text : text) {
            GameState position = new GameState(pos_text);
            System.out.println(position);
            move_data.clear();
            test.genTwoStep(position, move_data, -1L, 0xFF0000L);
            System.out.println("Total moves: " + move_data.size());
            for (ArimaaMove move : move_data) {
                System.out.println(move);
            }
        }
    }
}

